/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.nio.ByteBuffer;
import tv.amwa.maj.exception.IllegalPropertyValueException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.TypeDefinitions;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.model.ConstantValue;
import tv.amwa.maj.model.ParameterDefinition;
import tv.amwa.maj.model.impl.ParameterImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=15616, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="ConstantValue", description="The ConstantValue class specifies a constant data value for an effect control value.", symbol="ConstantValue")
public class ConstantValueImpl
extends ParameterImpl
implements ConstantValue,
Serializable,
XMLSerializable,
Cloneable {
    private static final long serialVersionUID = -3320656372467708785L;
    private Serializable value;

    public ConstantValueImpl() {
    }

    public ConstantValueImpl(ParameterDefinition parameterDefinition, Object value) throws NullPointerException, ClassCastException {
        if (parameterDefinition == null) {
            throw new NullPointerException("Cannot create a new constant value from a null parameter definition.");
        }
        this.setParameterDefinition(parameterDefinition);
        this.setValue(this.getTypeDefinition().createValue(value));
    }

    @Override
    @MediaProperty(uuid1=87033095, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="Value", aliases={"ConstantValueValue"}, typeName="Indirect", optional=false, uniqueIdentifier=false, pid=19713, symbol="Value")
    public PropertyValue getValue() {
        return this.getTypeDefinition().createValue(this.value);
    }

    @Override
    @MediaPropertySetter(value="Value")
    public void setValue(PropertyValue value) throws NullPointerException, ClassCastException {
        if (value == null) {
            throw new NullPointerException("Cannot set the value of this constant value using a null value.");
        }
        if (value.getType().equals(TypeDefinitions.Indirect)) {
            value = (PropertyValue)value.getValue();
        }
        try {
            if (!value.getType().equals(this.getTypeDefinition())) {
                throw new ClassCastException("The given value cannot be cast to a value of the given type for this constant value.");
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (!(value.getValue() instanceof Serializable)) {
            throw new ClassCastException("The value must implement java.io.Serializable.");
        }
        this.value = (Serializable)value.getValue();
    }

    public static final PropertyValue initializeValue() {
        return TypeDefinitions.Rational.createValue("0/1");
    }

    @Override
    public ConstantValue clone() {
        return (ConstantValue)super.clone();
    }

    public byte[] getValuePersist() throws NullPointerException, IllegalPropertyValueException, InsufficientSpaceException {
        if (this.value == null) {
            return null;
        }
        PropertyValue valueAsProperty = this.getTypeDefinition().createValue(this.value);
        PropertyValue indirectValue = TypeDefinitions.Indirect.createValue(valueAsProperty);
        ByteBuffer buffer = ByteBuffer.allocate((int)TypeDefinitions.Indirect.lengthAsBytes(indirectValue));
        TypeDefinitions.Indirect.writeAsBytes(indirectValue, buffer);
        buffer.rewind();
        return buffer.array();
    }

    public void setValuePersist(byte[] value) {
        if (value == null) {
            this.value = null;
            return;
        }
        PropertyValue indirectValue = TypeDefinitions.Indirect.createFromBytes(ByteBuffer.wrap(value));
        PropertyValue typedValue = (PropertyValue)indirectValue.getValue();
        this.value = (Serializable)typedValue.getValue();
    }
}

