/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.union.impl;

import java.io.Serializable;
import tv.amwa.maj.integer.Int16;
import tv.amwa.maj.misctype.TrackID;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.union.MultiCreateItem;

public class MultiCreateItemImpl
implements MultiCreateItem,
Serializable,
Cloneable {
    private static final long serialVersionUID = 3510149117693668282L;
    private AUID mediaKind;
    @Int16
    private short subTrackNum;
    @TrackID
    private int trackID;
    private Rational sampleRate;

    public MultiCreateItemImpl(AUID mediaKind, @Int16 short subTrackNum, @TrackID int trackID, Rational sampleRate) throws NullPointerException, IllegalArgumentException {
        this.setMediaKind(mediaKind);
        this.setTrackID(trackID);
        this.setSampleRate(sampleRate);
        this.setSubTrackNum(subTrackNum);
    }

    @Override
    public AUID getMediaKind() {
        return this.mediaKind;
    }

    @Override
    public void setMediaKind(AUID mediaKind) throws NullPointerException {
        if (mediaKind == null) {
            throw new NullPointerException("The given media kind for this multi-create item is null.");
        }
        this.mediaKind = mediaKind.clone();
    }

    @Override
    public Rational getSampleRate() {
        return this.sampleRate;
    }

    @Override
    public void setSampleRate(Rational sampleRate) throws NullPointerException, IllegalArgumentException {
        if (sampleRate == null) {
            throw new NullPointerException("The given sample rate for this multi-create item is null.");
        }
        if (sampleRate.getDenominator() == 0) {
            throw new IllegalArgumentException("The given sample rate for this multi-create item has a zero denominator.");
        }
        if (sampleRate.getNumerator() < 0 ^ sampleRate.getDenominator() < 0) {
            throw new IllegalArgumentException("The given sample rate for this multi-create item is negative.");
        }
        this.sampleRate = sampleRate.clone();
    }

    @Override
    @TrackID
    public int getTrackID() {
        return this.trackID;
    }

    @Override
    public void setTrackID(@TrackID int trackID) throws IllegalArgumentException {
        if (trackID < 0) {
            throw new IllegalArgumentException("The given track id for this multi-create item is negative.");
        }
        this.trackID = trackID;
    }

    @Override
    @Int16
    public short getSubTrackNum() {
        return this.subTrackNum;
    }

    @Override
    public void setSubTrackNum(@Int16 short subTrackNum) {
        this.subTrackNum = subTrackNum;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiCreateItem)) {
            return false;
        }
        MultiCreateItem testItem = (MultiCreateItem)o;
        if (testItem.getTrackID() != this.trackID) {
            return false;
        }
        if (testItem.getSubTrackNum() != this.subTrackNum) {
            return false;
        }
        if (!this.sampleRate.equals(testItem.getSampleRate())) {
            return false;
        }
        return this.mediaKind.equals(testItem.getMediaKind());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(300);
        builder.append("<MultiCreateItem>\n");
        builder.append("  <MediaKind>" + this.mediaKind.toString() + "</MediaKind>\n");
        builder.append("  <TrackID>" + this.trackID + "</TrackID>\n");
        builder.append("  <SubTrackNum>" + this.subTrackNum + "</SubTrackNum>\n");
        builder.append("  <SampleRate>" + this.sampleRate + "</SampleRate>\n");
        builder.append("</MultiCreateItem>");
        return builder.toString();
    }

    public MultiCreateItemImpl clone() throws CloneNotSupportedException {
        return (MultiCreateItemImpl)super.clone();
    }

    public int hashCode() {
        return this.trackID ^ ~this.subTrackNum ^ this.mediaKind.hashCode() ^ ~this.sampleRate.hashCode();
    }
}

