/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.PositionOutOfRangeException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.MemoryResidentStream;
import tv.amwa.maj.industry.Stream;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.model.RIFFChunk;
import tv.amwa.maj.model.impl.InterchangeObjectImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=20224, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="RIFFChunk", description="Chunk of data as defined by the Resource Interchange File Format (RIFF).", symbol="RIFFChunk")
public class RIFFChunkImpl
extends InterchangeObjectImpl
implements RIFFChunk,
Serializable,
XMLSerializable,
Cloneable {
    private static final long serialVersionUID = 1923907225869841814L;
    private int chunkID;
    private int chunkLength = 0;
    private Stream chunkData;

    public RIFFChunkImpl() {
    }

    public RIFFChunkImpl(@UInt32 int chunkID) {
        this.setChunkID(chunkID);
    }

    @Override
    @MediaProperty(uuid1=0x4070400, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 8}, definedName="ChunkData", typeName="Stream", optional=false, uniqueIdentifier=false, pid=20227, symbol="ChunkData")
    public Stream getChunkData() {
        return this.chunkData.clone();
    }

    @Override
    @MediaPropertySetter(value="ChunkData")
    public void setChunkData(Stream chunkData) throws NullPointerException {
        if (chunkData == null) {
            throw new NullPointerException("Cannot set the chunk data of RIFF chunk with a null value.");
        }
        this.chunkData = chunkData.clone();
    }

    public static final Stream initializeChunkData() {
        return new MemoryResidentStream(0);
    }

    @Override
    @MediaProperty(uuid1=67504130, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 8}, definedName="ChunkID", typeName="UInt32", optional=false, uniqueIdentifier=false, pid=20225, symbol="ChunkID")
    public int getChunkID() {
        return this.chunkID;
    }

    @Override
    @MediaPropertySetter(value="ChunkID")
    public void setChunkID(int chunkID) {
        this.chunkID = chunkID;
    }

    public static final int initializeChunkID() {
        return 0;
    }

    @Override
    @MediaProperty(uuid1=67504387, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 8}, definedName="ChunkLength", typeName="UInt32", optional=false, uniqueIdentifier=false, pid=20226, symbol="ChunkLength")
    public int getLength() {
        try {
            this.chunkLength = (int)this.chunkData.getLength();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.chunkLength;
    }

    @MediaPropertySetter(value="ChunkLength")
    public void setChunkLength(long chunkLength) throws IllegalArgumentException {
        if (chunkLength > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The MAJ API does not support RIFF chunks greater than 2Gbs.");
        }
        if (chunkLength < 0L) {
            throw new IllegalArgumentException("Cannot set the chunk length to a negative value.");
        }
        this.chunkLength = (int)chunkLength;
    }

    public static final long initializeChunkLength() {
        return 0L;
    }

    @Override
    public long getPosition() throws IOException {
        return this.chunkData.getPosition();
    }

    @Override
    public void setPosition(long offset) throws PositionOutOfRangeException, IOException {
        if (offset >= this.chunkData.getLength() || offset < 0L) {
            throw new PositionOutOfRangeException("Cannot set the position before or beyond the end of the chunk data.");
        }
        this.chunkData.setPosition(offset);
    }

    @Override
    public ByteBuffer read(int numberOfBytes) throws IllegalArgumentException, EndOfDataException, IOException {
        if (numberOfBytes < 0) {
            throw new IllegalArgumentException("Cannot read a negative number of bytes from this RIFF chunk.");
        }
        return this.chunkData.read(numberOfBytes);
    }

    @Override
    public void write(ByteBuffer bytes) throws NullPointerException, EndOfDataException, IOException {
        if (bytes == null) {
            throw new NullPointerException("Cannot write to the RIFF chunk data using a null byte array.");
        }
        this.chunkData.write(bytes);
    }

    @Override
    public RIFFChunk clone() {
        return (RIFFChunk)super.clone();
    }

    @Override
    public String getComment() {
        return "local RIFF chunk persistent id: " + this.getPersistentID();
    }
}

