/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.meta.impl;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.enumeration.TypeCategory;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.IllegalPropertyValueException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.TypeDefinitions;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionRename;
import tv.amwa.maj.meta.impl.SingletonTypeDefinitionImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionImpl;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=0xD010101, uuid2=526, uuid3=0, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="TypeDefinitionRename", description="The TypeDefinitionRename class defines a property type that has the same structure and representation as its underlying type but has a different meaning.", symbol="TypeDefinitionRename")
public final class TypeDefinitionRenameImpl
extends SingletonTypeDefinitionImpl
implements TypeDefinitionRename,
Serializable,
Cloneable {
    private static final long serialVersionUID = -6856048217810442695L;
    private WeakReference<TypeDefinition> renamedType;

    protected TypeDefinitionRenameImpl() {
    }

    public TypeDefinitionRenameImpl(AUID identification, @AAFString String typeName, TypeDefinition baseType) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot create a new rename type definition using a null identification.");
        }
        if (baseType == null) {
            throw new NullPointerException("Cannot create a new rename type definition using a null renamed type value.");
        }
        this.setIdentification(identification);
        this.setName(typeName);
        this.setRenamedType(baseType);
    }

    @Override
    public PropertyValue createValueFromBaseValue(PropertyValue propertyValue) throws NullPointerException, IllegalPropertyValueException {
        if (propertyValue == null) {
            throw new NullPointerException("Cannot create a new renamed type property value from a null base property value.");
        }
        if (!this.renamedType.equals(propertyValue.getType())) {
            throw new IllegalPropertyValueException("The given property value is not compatable with the base type of this rename type definition.");
        }
        return new RenamedValue(this, propertyValue.getValue());
    }

    @Override
    @MediaProperty(uuid1=100729095, uuid2=4608, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="RenamedType", typeName="TypeDefinitionWeakReference", optional=false, uniqueIdentifier=false, pid=30, symbol="RenamedType")
    public TypeDefinition getBaseType() {
        return this.renamedType.getTarget();
    }

    @MediaPropertySetter(value="RenamedType")
    public void setRenamedType(TypeDefinition renamedType) throws NullPointerException {
        if (renamedType == null) {
            throw new NullPointerException("Cannot set the renamed type of a rename type definition to null.");
        }
        this.renamedType = new WeakReference<TypeDefinition>(renamedType);
    }

    public static final TypeDefinition initializeRenamedType() {
        return TypeDefinitions.UTF16String;
    }

    @Override
    public PropertyValue getBaseValue(PropertyValue propertyValue) throws NullPointerException, IllegalPropertyValueException {
        if (propertyValue == null) {
            throw new NullPointerException("Cannot extract the actual value from a null renamed type property value.");
        }
        if (!this.equals(propertyValue.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this type definition.");
        }
        Object renamedValue = ((RenamedValue)propertyValue).getValue();
        if (renamedValue == null) {
            return null;
        }
        return this.renamedType.getTarget().createValue(renamedValue);
    }

    @Override
    public PropertyValue createValue(Object javaValue) throws ClassCastException {
        PropertyValue renamedTypeValue = this.renamedType.getTarget().createValue(javaValue);
        return new RenamedValue(this, renamedTypeValue.getValue());
    }

    @Override
    public TypeCategory getTypeCategory() {
        return TypeCategory.Rename;
    }

    @Override
    public PropertyValue createFromBytes(ByteBuffer buffer) throws EndOfDataException {
        return this.createValueFromBaseValue(this.renamedType.getTarget().createFromBytes(buffer));
    }

    @Override
    public long lengthAsBytes(PropertyValue value) throws NullPointerException, IllegalPropertyValueException {
        super.lengthAsBytes(value);
        PropertyValue baseValue = this.getBaseValue(value);
        return baseValue.getType().lengthAsBytes(baseValue);
    }

    @Override
    public List<PropertyValue> writeAsBytes(PropertyValue value, ByteBuffer buffer) throws NullPointerException, IllegalPropertyValueException, InsufficientSpaceException {
        super.writeAsBytes(value, buffer);
        PropertyValue baseValue = this.getBaseValue(value);
        baseValue.getType().writeAsBytes(baseValue, buffer);
        return null;
    }

    @Override
    public String nameToAAFName(String name) {
        return "aaf" + super.nameToAAFName(name);
    }

    @Override
    public void appendMetadictXML(Node metadict, String namespace, String prefix) {
        Element typeElement = XMLBuilder.createChild(metadict, namespace, prefix, "TypeDefinitionRename");
        super.appendMetadictXML(typeElement, namespace, prefix);
        XMLBuilder.appendElement((Node)typeElement, namespace, prefix, "RenamedType", this.renamedType.getTarget().getName());
    }

    @Override
    public TypeDefinitionRename clone() {
        return (TypeDefinitionRename)super.clone();
    }

    public static class RenamedValue
    extends TypeDefinitionImpl.PropertyValueImpl
    implements PropertyValue {
        private TypeDefinitionRenameImpl type;
        private Object value;

        private RenamedValue(TypeDefinitionRenameImpl type, Object value) {
            this.type = type;
            this.setValue(value);
        }

        @Override
        public TypeDefinition getType() {
            return this.type;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        public boolean isDefinedType() {
            return true;
        }

        private void setValue(Object value) {
            this.value = value;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (o instanceof PropertyValue) {
                return this.getValue().equals(((PropertyValue)o).getValue());
            }
            return this.getValue().equals(o);
        }
    }
}

