/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.util;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import tv.amwa.maj.industry.Forge;
import tv.amwa.maj.industry.MediaEngine;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.meta.ExtensionScheme;
import tv.amwa.maj.meta.MetaDefinition;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionCharacter;
import tv.amwa.maj.meta.TypeDefinitionEnumeration;
import tv.amwa.maj.meta.TypeDefinitionExtendibleEnumeration;
import tv.amwa.maj.meta.TypeDefinitionFixedArray;
import tv.amwa.maj.meta.TypeDefinitionIndirect;
import tv.amwa.maj.meta.TypeDefinitionInteger;
import tv.amwa.maj.meta.TypeDefinitionOpaque;
import tv.amwa.maj.meta.TypeDefinitionRecord;
import tv.amwa.maj.meta.TypeDefinitionRename;
import tv.amwa.maj.meta.TypeDefinitionSet;
import tv.amwa.maj.meta.TypeDefinitionStream;
import tv.amwa.maj.meta.TypeDefinitionString;
import tv.amwa.maj.meta.TypeDefinitionStrongObjectReference;
import tv.amwa.maj.meta.TypeDefinitionVariableArray;
import tv.amwa.maj.meta.TypeDefinitionWeakObjectReference;
import tv.amwa.maj.meta.impl.ClassDefinitionImpl;
import tv.amwa.maj.util.GenerationCore;

public class ExtensionSchemeGenerator
extends GenerationCore {
    public static final ExtensionScheme generateExtensionScheme(Reader reader) throws IOException {
        GenerationCore.DictionaryContext context = null;
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = fact.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(reader));
            Element node = doc.getDocumentElement();
            context = ExtensionSchemeGenerator.processRoot(node);
        }
        catch (Exception e) {
            throw new IOException("Unable to read a meta dictionary due to a " + e.getClass().getName() + ": " + e.getMessage(), e);
        }
        ExtensionScheme extensionScheme = Forge.make(ExtensionScheme.class, "SchemeID", context.schemeID, "SchemeURI", context.schemeURI);
        if (context.preferredPrefix != null) {
            extensionScheme.setPreferredPrefix(context.preferredPrefix);
        }
        if (context.extensionDescription != null) {
            extensionScheme.setExtensionDescription(context.extensionDescription);
        }
        for (GenerationCore.ClassData classData : classList.values()) {
            ClassDefinition classDefinition = Forge.make(ClassDefinition.class, "MetaDefinitionIdentification", classData.identification, "MetaDefinitionName", classData.name, "ParentClass", Warehouse.lookForClass(classData.parentClass), "IsConcrete", classData.isConcrete);
            classDefinition.setSymbol(classData.symbol);
            if (classData.description != null) {
                classDefinition.setDescription(classData.description);
            }
            classDefinition.setJavaImplementation(classDefinition.getParent().getJavaImplementation());
            classDefinition.setNamespace(context.schemeURI);
            classDefinition.setPrefix(context.preferredPrefix);
            Warehouse.register(classDefinition);
            extensionScheme.addMetaDefinition(classDefinition);
        }
        ArrayList<GenerationCore.TypeData> orderedTypes = new ArrayList<GenerationCore.TypeData>(typeList.size());
        Collection typeValues = typeList.values();
        for (GenerationCore.TypeData typeData : typeValues) {
            if (!(typeData instanceof GenerationCore.TypeDataInteger)) continue;
            orderedTypes.add(typeData);
        }
        for (GenerationCore.TypeData typeData : typeValues) {
            if (!(typeData instanceof GenerationCore.TypeDataEnumeration)) continue;
            orderedTypes.add(typeData);
        }
        for (GenerationCore.TypeData typeData : typeValues) {
            if (!(typeData instanceof GenerationCore.TypeDataCharacter)) continue;
            orderedTypes.add(typeData);
        }
        for (GenerationCore.TypeData typeData : typeValues) {
            if (!(typeData instanceof GenerationCore.TypeDataString)) continue;
            orderedTypes.add(typeData);
        }
        for (GenerationCore.TypeData typeData : typeValues) {
            if (!(typeData instanceof GenerationCore.TypeDataExtendibleEnumeration)) continue;
            orderedTypes.add(typeData);
        }
        for (GenerationCore.TypeData typeData : typeValues) {
            if (!(typeData instanceof GenerationCore.TypeDataIndirect)) continue;
            orderedTypes.add(typeData);
        }
        for (GenerationCore.TypeData typeData : typeValues) {
            if (!(typeData instanceof GenerationCore.TypeDataOpaque)) continue;
            orderedTypes.add(typeData);
        }
        for (GenerationCore.TypeData typeData : typeValues) {
            if (!(typeData instanceof GenerationCore.TypeDataStream)) continue;
            orderedTypes.add(typeData);
        }
        for (GenerationCore.TypeData typeData : typeValues) {
            if (!(typeData instanceof GenerationCore.TypeDataFixedArray)) continue;
            orderedTypes.add(typeData);
        }
        for (GenerationCore.TypeData typeData : typeValues) {
            if (!(typeData instanceof GenerationCore.TypeDataRecord)) continue;
            orderedTypes.add(typeData);
        }
        for (GenerationCore.TypeData typeData : typeValues) {
            if (!(typeData instanceof GenerationCore.TypeDataWeakObjectReference)) continue;
            orderedTypes.add(typeData);
        }
        for (GenerationCore.TypeData typeData : typeValues) {
            if (!(typeData instanceof GenerationCore.TypeDataStrongObjectReference)) continue;
            orderedTypes.add(typeData);
        }
        for (GenerationCore.TypeData typeData : typeValues) {
            if (!(typeData instanceof GenerationCore.TypeDataSet)) continue;
            orderedTypes.add(typeData);
        }
        for (GenerationCore.TypeData typeData : typeValues) {
            if (!(typeData instanceof GenerationCore.TypeDataVariableArray)) continue;
            orderedTypes.add(typeData);
        }
        for (GenerationCore.TypeData typeData : typeValues) {
            if (!(typeData instanceof GenerationCore.TypeDataRename)) continue;
            orderedTypes.add(typeData);
        }
        for (GenerationCore.TypeData typeData : orderedTypes) {
            MetaDefinition typeDefinition = null;
            switch (typeData.getTypeCategory()) {
                case Character: {
                    typeDefinition = Forge.make(TypeDefinitionCharacter.class, "MetaDefinitionIdentification", typeData.identification, "MetaDefinitionName", typeData.name);
                    break;
                }
                case Enum: {
                    typeDefinition = Forge.make(TypeDefinitionEnumeration.class, "MetaDefinitionIdentification", typeData.identification, "MetaDefinitionName", typeData.name, "ElementType", Warehouse.lookForType(((GenerationCore.TypeDataEnumeration)typeData).elementType), "ElementNames", ((GenerationCore.TypeDataEnumeration)typeData).names, "ElementValues", ((GenerationCore.TypeDataEnumeration)typeData).values);
                    break;
                }
                case ExtEnum: {
                    typeDefinition = Forge.make(TypeDefinitionExtendibleEnumeration.class, "MetaDefinitionIdentification", typeData.identification, "MetaDefinitionName", typeData.name);
                    break;
                }
                case FixedArray: {
                    typeDefinition = Forge.make(TypeDefinitionFixedArray.class, "MetaDefinitionIdentification", typeData.identification, "MetaDefinitionName", typeData.name, "ElementCount", ((GenerationCore.TypeDataFixedArray)typeData).elementCount, "ElementType", Warehouse.lookForType(((GenerationCore.TypeDataFixedArray)typeData).elementType));
                    break;
                }
                case Indirect: {
                    typeDefinition = Forge.make(TypeDefinitionIndirect.class, "MetaDefinitionIdentification", typeData.identification, "MetaDefinitionName", typeData.name);
                    break;
                }
                case Int: {
                    typeDefinition = Forge.make(TypeDefinitionInteger.class, "MetaDefinitionIdentification", typeData.identification, "MetaDefinitionName", typeData.name, "Size", ((GenerationCore.TypeDataInteger)typeData).size, "IsSigned", ((GenerationCore.TypeDataInteger)typeData).isSigned);
                    break;
                }
                case Opaque: {
                    typeDefinition = Forge.make(TypeDefinitionOpaque.class, "MetaDefinitionIdentification", typeData.identification, "MetaDefinitionName", typeData.name);
                    break;
                }
                case Record: {
                    GenerationCore.TypeDataRecord recordType = (GenerationCore.TypeDataRecord)typeData;
                    ArrayList<TypeDefinition> memberTypes = new ArrayList<TypeDefinition>(recordType.memberTypes.size());
                    for (String memberName : recordType.memberTypes) {
                        memberTypes.add(Warehouse.lookForType(memberName));
                    }
                    typeDefinition = Forge.make(TypeDefinitionRecord.class, "MetaDefinitionIdentification", typeData.identification, "MetaDefinitionName", typeData.name, "MemberNames", recordType.memberNames, "MemberTypes", memberTypes);
                    break;
                }
                case Rename: {
                    typeDefinition = Forge.make(TypeDefinitionRename.class, "MetaDefinitionIdentification", typeData.identification, "MetaDefinitionName", typeData.name, "RenamedType", Warehouse.lookForType(((GenerationCore.TypeDataRename)typeData).renamedType));
                    break;
                }
                case Set: {
                    typeDefinition = Forge.make(TypeDefinitionSet.class, "MetaDefinitionIdentification", typeData.identification, "MetaDefinitionName", typeData.name, "ElementType", Warehouse.lookForType(((GenerationCore.TypeDataSet)typeData).elementType));
                    break;
                }
                case Stream: {
                    typeDefinition = Forge.make(TypeDefinitionStream.class, "MetaDefinitionIdentification", typeData.identification, "MetaDefinitionName", typeData.name);
                    break;
                }
                case String: {
                    typeDefinition = Forge.make(TypeDefinitionString.class, "MetaDefinitionIdentification", typeData.identification, "MetaDefinitionName", typeData.name, "StringElementType", Warehouse.lookForType(((GenerationCore.TypeDataString)typeData).elementType));
                    break;
                }
                case StrongObjRef: {
                    typeDefinition = Forge.make(TypeDefinitionStrongObjectReference.class, "MetaDefinitionIdentification", typeData.identification, "MetaDefinitionName", typeData.name, "ReferencedType", Warehouse.lookForClass(((GenerationCore.TypeDataStrongObjectReference)typeData).referencedType));
                    break;
                }
                case WeakObjRef: {
                    typeDefinition = Forge.make(TypeDefinitionWeakObjectReference.class, "MetaDefinitionIdentification", typeData.identification, "MetaDefinitionName", typeData.name, "ReferencedType", Warehouse.lookForClass(((GenerationCore.TypeDataWeakObjectReference)typeData).referencedType), "TargetList", ((GenerationCore.TypeDataWeakObjectReference)typeData).targetSet);
                }
                case VariableArray: {
                    typeDefinition = Forge.make(TypeDefinitionVariableArray.class, "MetaDefinitionIdentification", typeData.identification, "MetaDefinitionName", typeData.name, "VariableArrayElementType", Warehouse.lookForType(((GenerationCore.TypeDataVariableArray)typeData).elementType));
                    break;
                }
            }
            if (typeData.description != null) {
                typeDefinition.setDescription(typeData.description);
            }
            if (typeData.symbol != null) {
                typeDefinition.setSymbol(typeData.symbol);
            }
            Warehouse.register((TypeDefinition)typeDefinition, context.schemeURI, context.preferredPrefix);
            extensionScheme.addMetaDefinition(typeDefinition);
        }
        for (GenerationCore.PropertyData propertyData : propertyList.values()) {
            PropertyDefinition propertyDefinition = Forge.make(PropertyDefinition.class, "MetaDefinitionIdentification", propertyData.identification, "MetaDefinitionName", propertyData.name, "MemberOf", Warehouse.lookForClass(propertyData.memberOf), "IsOptional", propertyData.isOptional, "IsUniqueIdentifier", propertyData.isUniqueIdentifier, "PropertyType", ExtensionSchemeGenerator.typeByName((String)propertyData.type).identification, "LocalIdentification", propertyData.localIdentification > 0 ? propertyData.localIdentification : (short)0);
            if (propertyData.description != null) {
                propertyDefinition.setDescription(propertyData.description);
            }
            propertyDefinition.setNamespace(context.schemeURI);
            propertyDefinition.setPrefix(context.preferredPrefix);
            propertyDefinition.setSymbol(propertyData.symbol);
            Warehouse.register(propertyDefinition);
            extensionScheme.addMetaDefinition(propertyDefinition);
        }
        return extensionScheme;
    }

    public static final void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.exit(1);
        }
        MediaEngine.initializeAAF();
        FileReader fileReader = new FileReader(args[0]);
        ExtensionScheme scheme = ExtensionSchemeGenerator.generateExtensionScheme(fileReader);
        System.out.println(scheme.toString());
        System.out.println(Warehouse.lookForClass("PolyFileDescriptor").toString());
        System.out.println(Warehouse.lookForProperty(Forge.parseAUID("urn:uuid:45e12b0b-ac1d-43ae-9db4-36f065afc3eb")).toString());
        System.out.println(Warehouse.lookForType("Operation Group Strong Reference Variable Array").toString());
        ClassDefinition polyClass = Warehouse.lookForClass("PolyFileDescriptor");
        MetadataObject testing = ((ClassDefinitionImpl)polyClass).createInstance();
        System.out.println(testing.getClass().getCanonicalName());
        System.out.println(testing.toString());
    }
}

