/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.record.impl;

import java.io.Serializable;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import tv.amwa.maj.constant.CommonConstants;
import tv.amwa.maj.enumeration.RGBAComponentKind;
import tv.amwa.maj.integer.UInt8;
import tv.amwa.maj.io.xml.LocalHandler;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.record.RGBAComponent;

public final class RGBAComponentImpl
implements RGBAComponent,
Serializable,
XMLSerializable,
Cloneable,
CommonConstants {
    private static final long serialVersionUID = -1997649975507845926L;
    private RGBAComponentKind code;
    @UInt8
    private byte componentSize;
    private long persistentId;
    private static final Pattern codePattern = Pattern.compile("<\\w*\\:?Code\\>(\\w+)\\<\\/\\w*\\:?Code\\>");
    private static final Pattern componentSizePattern = Pattern.compile("<\\w*\\:?ComponentSize\\>(\\d{1,3})\\<\\/\\w*\\:?ComponentSize\\>");
    public static final String RGBACOMPONENT_TAG = "RGBAComponent";
    static final String CODE_TAG = "Code";
    static final String COMPONENTSIZE_TAG = "ComponentSize";
    public static final String MYSQL_COLUMN_DEFINITION = "VARCHAR(255) CHARACTER SET ascii COLLATE ascii_general_ci";

    public RGBAComponentImpl() {
        this.code = RGBAComponentKind.Null;
        this.componentSize = 0;
    }

    public RGBAComponentImpl(RGBAComponentKind code, @UInt8 byte size) throws NullPointerException, IllegalArgumentException {
        this.setComponentSize(size);
        this.setCode(code);
    }

    @Override
    public final RGBAComponentKind getCode() {
        return this.code;
    }

    @Override
    public final void setCode(RGBAComponentKind code) throws NullPointerException {
        if (code == null) {
            throw new NullPointerException("Cannot set the component kind of this RGBA component with a null value.");
        }
        this.code = code;
    }

    @Override
    @UInt8
    public final byte getComponentSize() {
        return this.componentSize;
    }

    @Override
    public final void setComponentSize(@UInt8 byte size) throws IllegalArgumentException {
        if (size < 0) {
            throw new IllegalArgumentException("Cannot set the size value of an RGBA component to a negative value.");
        }
        this.componentSize = size;
    }

    protected final long getId() {
        return this.persistentId;
    }

    protected final void setId(long id) {
        this.persistentId = id;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof RGBAComponent)) {
            return false;
        }
        RGBAComponent testComponent = (RGBAComponent)o;
        if (testComponent.getComponentSize() != this.componentSize) {
            return false;
        }
        return testComponent.getCode() == this.code;
    }

    @Override
    public final String toString() {
        return XMLBuilder.toXMLNonMetadata(this);
    }

    public static final RGBAComponentImpl parseFactory(String componentString) throws NullPointerException, ParseException {
        if (componentString == null) {
            throw new NullPointerException("Cannot create a RGBA component value from a null value.");
        }
        try {
            Matcher matcher = codePattern.matcher(componentString);
            RGBAComponentKind code = RGBAComponentKind.Null;
            if (matcher.find()) {
                String enumToken = matcher.group(1);
                if (enumToken.startsWith("Comp")) {
                    enumToken = enumToken.substring(4);
                }
                code = RGBAComponentKind.valueOf(enumToken);
            }
            matcher = componentSizePattern.matcher(componentString);
            byte componentSize = 0;
            if (matcher.find()) {
                componentSize = Byte.parseByte(matcher.group(1));
            }
            return new RGBAComponentImpl(code, componentSize);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Unable to parse the given RGBA component size value into a byte value.", 0);
        }
        catch (IllegalArgumentException iae) {
            throw new ParseException("Unable to parse the given RGBA component kind value into a known enumeration value of RGBA component kind.", 0);
        }
    }

    @Override
    public final RGBAComponent clone() {
        try {
            return (RGBAComponent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int hashCode() {
        return this.code.hashCode() ^ this.componentSize << 16;
    }

    @Override
    public void appendXMLChildren(Node parent) {
        Node rgbaComponentElement = parent instanceof DocumentFragment ? XMLBuilder.createChild(parent, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", RGBACOMPONENT_TAG) : parent;
        XMLBuilder.appendElement(rgbaComponentElement, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", CODE_TAG, "Comp" + this.code.name());
        XMLBuilder.appendElement(rgbaComponentElement, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", COMPONENTSIZE_TAG, this.componentSize);
    }

    @Override
    public String getComment() {
        return null;
    }

    public static final String toPersistentForm(RGBAComponent rgbaComponent) {
        if (rgbaComponent == null) {
            return null;
        }
        return rgbaComponent.toString();
    }

    public static final RGBAComponent fromPersistentForm(String rgbaComponent) {
        if (rgbaComponent == null) {
            return null;
        }
        try {
            return RGBAComponentImpl.parseFactory(rgbaComponent);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public static class XMLHandler
    extends LocalHandler {
        public static final String elementName = "RGBAComponent";
        public static final String[] dataElementNames = new String[]{"Code", "ComponentSize"};

        @Override
        protected Object createResult() throws Exception {
            String codeName = this.getElementData(RGBAComponentImpl.CODE_TAG);
            if (codeName.startsWith("Comp")) {
                codeName = codeName.substring(4);
            }
            return new RGBAComponentImpl(RGBAComponentKind.valueOf(codeName), Byte.parseByte(this.getElementData(RGBAComponentImpl.COMPONENTSIZE_TAG)));
        }
    }
}

