/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.aaf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.DocumentOutputStream;
import org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.poifs.filesystem.POIFSWriterEvent;
import org.apache.poi.poifs.filesystem.POIFSWriterListener;
import tv.amwa.maj.constant.CommonConstants;
import tv.amwa.maj.enumeration.TypeCategory;
import tv.amwa.maj.exception.BadParameterException;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.IllegalPropertyValueException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.extensions.avid.AvidFactory;
import tv.amwa.maj.industry.Forge;
import tv.amwa.maj.industry.MediaEngine;
import tv.amwa.maj.industry.MemoryResidentStream;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.Stream;
import tv.amwa.maj.industry.TypeDefinitions;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.industry.WeakReferenceTarget;
import tv.amwa.maj.io.aaf.AAFClassID;
import tv.amwa.maj.io.aaf.AAFConstants;
import tv.amwa.maj.io.aaf.AAFReader;
import tv.amwa.maj.io.aaf.AAFReaderEvent;
import tv.amwa.maj.io.aaf.AAFReaderListener;
import tv.amwa.maj.io.aaf.AAFWriterListener;
import tv.amwa.maj.io.aaf.ResolutionEntry;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.meta.ExtensionScheme;
import tv.amwa.maj.meta.MetaDefinition;
import tv.amwa.maj.meta.MetaDictionary;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionSet;
import tv.amwa.maj.meta.TypeDefinitionStrongObjectReference;
import tv.amwa.maj.meta.TypeDefinitionVariableArray;
import tv.amwa.maj.meta.TypeDefinitionWeakObjectReference;
import tv.amwa.maj.meta.impl.ClassDefinitionImpl;
import tv.amwa.maj.meta.impl.ExtensionSchemeImpl;
import tv.amwa.maj.meta.impl.PropertyDefinitionImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionObjectReferenceImpl;
import tv.amwa.maj.model.ApplicationPluginObject;
import tv.amwa.maj.model.InterchangeObject;
import tv.amwa.maj.model.Parameter;
import tv.amwa.maj.model.Preface;
import tv.amwa.maj.model.impl.ApplicationPluginObjectImpl;
import tv.amwa.maj.model.impl.PrefaceImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.impl.AUIDImpl;
import tv.amwa.maj.util.Utilities;

public class AAFBuilder
implements AAFConstants {
    static Map<Byte, String> structuredTypes = new HashMap<Byte, String>();
    static final char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final AUID MobRefClassID = new AUIDImpl(1712978144, -393, 4563, new byte[]{-96, -124, 0, 96, -108, -21, 117, -53});
    static Map<String, String> directoryNameTable = new HashMap<String, String>(directoryNameAliases.length / 2);

    public static final AAFReaderListener makeAAFEventReader() {
        return new LocalAAFEventReader();
    }

    public static final AAFWriterListener makeAAFWriterListener() {
        return new LocalAAFWriterListener();
    }

    private static final StringBuffer shortenName(PropertyDefinition property, short localID, int mangledLength) throws NullPointerException {
        int squeezedLength;
        if (property == null) {
            throw new NullPointerException("Cannot shorten to the AAF structured storage name of a null property definition.");
        }
        StringBuffer pathPartName = new StringBuffer(32);
        String propertyName = property.getName();
        if (directoryNameTable.containsKey(propertyName)) {
            propertyName = directoryNameTable.get(propertyName);
        }
        int propertyNameLength = propertyName.length();
        String localIDinHex = Integer.toHexString(localID);
        int localIDinHexLength = localIDinHex.length();
        if (localIDinHexLength > 4) {
            localIDinHex = localIDinHex.substring(localIDinHexLength - 4, localIDinHexLength);
            localIDinHexLength = 4;
        }
        if (propertyNameLength > (squeezedLength = mangledLength - localIDinHexLength - 2)) {
            int halfLength = squeezedLength / 2;
            pathPartName.append(propertyName.substring(0, halfLength));
            pathPartName.append('-');
            pathPartName.append(propertyName.substring(propertyNameLength - halfLength + 1));
        } else {
            pathPartName.append(propertyName);
        }
        pathPartName.append('-');
        pathPartName.append(localIDinHex);
        return pathPartName;
    }

    public static final String makeAAFPathPartName(PropertyDefinition property) throws NullPointerException {
        return AAFBuilder.shortenName(property, property.getLocalIdentification(), 32).toString();
    }

    public static final String makeAAFPathPartName(PropertyDefinition property, short localID) throws NullPointerException {
        return AAFBuilder.shortenName(property, localID, 32).toString();
    }

    public static final String makeAAFPathPartName(PropertyDefinition property, short localID, int index) throws NullPointerException, IllegalArgumentException {
        if (index < 0) {
            throw new IllegalArgumentException("Cannot create a shortenned name with a negative index value.");
        }
        StringBuffer pathPartName = AAFBuilder.shortenName(property, localID, 22);
        pathPartName.append('{');
        pathPartName.append(Integer.toHexString(index));
        pathPartName.append('}');
        return pathPartName.toString();
    }

    public static final String makeAAFPathPartReference(PropertyDefinition property, short localID) throws NullPointerException {
        return AAFBuilder.shortenName(property, localID, 22).toString();
    }

    public static final void generateAAFStructure(DirectoryEntry classDir, AAFWriterListener aafWriter, MetadataObject rootObject) throws IOException {
        ClassDefinition rootClass = MediaEngine.getClassDefinition(rootObject);
        String path = AAFBuilder.makePathForDirectory(classDir);
        classDir.setStorageClsid((ClassID)new AAFClassID(rootClass.getAUID()));
        Set<PropertyDefinition> properties = rootClass.getAllPropertyDefinitions();
        if (rootObject instanceof MetaDefinition) {
            ((MetaDefinition)rootObject).setAAFNamesInUse(true);
        }
        SortedMap<? extends PropertyDefinition, ? extends PropertyValue> valueMap = rootClass.getProperties(rootObject);
        if (rootObject instanceof MetaDefinition) {
            ((MetaDefinition)rootObject).setAAFNamesInUse(false);
        }
        int propertyCount = 0;
        int propertiesSize = 0;
        for (PropertyDefinition property : properties) {
            if (property.getIsOptional() && !valueMap.containsKey(property) || property.getAUID().equals(ObjectClassID) || property.getAUID().equals(MemberOfID)) continue;
            if (!valueMap.containsKey(property)) {
                System.err.println("Found a required property not in the value map for " + rootClass.getName() + "." + property.getName() + ".");
                System.err.println(rootObject.toString());
                continue;
            }
            TypeDefinition propertyType = property.getTypeDefinition();
            PropertyValue value = (PropertyValue)valueMap.get(property);
            if (propertyType.equals(TypeDefinitions.ApplicationPluginObjectStrongReferenceSet)) {
                Set<PropertyValue> setElements = ((TypeDefinitionSet)propertyType).getElements(value);
                if (setElements.size() == 1) {
                    PropertyValue theElement = null;
                    Iterator<PropertyValue> iterator = setElements.iterator();
                    while (iterator.hasNext()) {
                        PropertyValue item;
                        theElement = item = iterator.next();
                    }
                    ApplicationPluginObject plugin = (ApplicationPluginObject)theElement.getValue();
                    if (!plugin.getObjectClass().getAUID().equals(AAFConstants.ApplicationPluginObjectID)) {
                        classDir.setStorageClsid((ClassID)new AAFClassID(plugin.getObjectClass().getAUID()));
                    }
                }
                for (PropertyValue item : setElements) {
                    ApplicationPluginObject plugin;
                    if (!(item.getValue() instanceof ApplicationPluginObject) || (plugin = (ApplicationPluginObject)item.getValue()) == null) continue;
                    Set<AUID> extensionPropertyIDs = plugin.getExtensionPropertyIDs();
                    for (AUID extensionPropertyID : extensionPropertyIDs) {
                        PropertyDefinition extensionPropertyDefinition = Warehouse.lookForProperty(extensionPropertyID);
                        PropertyValue extensionPropertyValue = plugin.getExtensionProperty(extensionPropertyID);
                        if (extensionPropertyDefinition == null || extensionPropertyValue == null) continue;
                        ++propertyCount;
                        aafWriter.registerLocalID(extensionPropertyDefinition);
                        aafWriter.addProperty(path, extensionPropertyDefinition, extensionPropertyValue);
                        propertiesSize += AAFBuilder.processPropertyValue(extensionPropertyDefinition, extensionPropertyValue, classDir, aafWriter, path);
                    }
                }
                continue;
            }
            aafWriter.registerLocalID(property);
            aafWriter.addProperty(path, property, value);
            ++propertyCount;
            propertiesSize += AAFBuilder.processPropertyValue(property, value, classDir, aafWriter, path);
        }
        classDir.createDocument("properties", propertiesSize += 4 + 6 * propertyCount, (POIFSWriterListener)aafWriter);
    }

    static final int processPropertyValue(PropertyDefinition property, PropertyValue value, DirectoryEntry classDir, AAFWriterListener aafWriter, String path) throws IOException {
        int propertySize = 0;
        TypeDefinition propertyType = value.getType();
        String dirName = null;
        if (property.getAUID().equals(AAFConstants.ParametersID)) {
            List<PropertyValue> setElements = ((TypeDefinitionVariableArray)propertyType).getElements(value);
            dirName = AAFBuilder.makeAAFPathPartReference(property, aafWriter.getLocalID(property.getAUID()));
            propertySize += dirName.length() * 2 + 2;
            int elementCount = 0;
            int identificationSize = 16;
            classDir.createDocument(dirName + " index", 15 + (8 + identificationSize) * setElements.size(), (POIFSWriterListener)aafWriter);
            aafWriter.addIndexValue(path + File.separator + dirName + " index", value);
            for (PropertyValue setElement : setElements) {
                DirectoryEntry newSetDir = classDir.createDirectory(dirName + "{" + Integer.toHexString(elementCount) + "}");
                AAFBuilder.generateAAFStructure(newSetDir, aafWriter, (MetadataObject)setElement.getValue());
                ++elementCount;
            }
            return propertySize;
        }
        switch (propertyType.getTypeCategory()) {
            case WeakObjRef: {
                propertySize += 21;
                aafWriter.registerWeakType((TypeDefinitionWeakObjectReference)propertyType);
                break;
            }
            case StrongObjRef: {
                MetadataObject propertyValue = (MetadataObject)value.getValue();
                dirName = AAFBuilder.makeAAFPathPartName(property, aafWriter.getLocalID(property.getAUID()));
                propertySize += dirName.length() * 2 + 2;
                DirectoryEntry newDir = classDir.createDirectory(dirName);
                AAFBuilder.generateAAFStructure(newDir, aafWriter, propertyValue);
                break;
            }
            case Set: {
                Iterator<PropertyValue> findMeASample;
                TypeDefinition setRefType = ((TypeDefinitionSet)propertyType).getElementType();
                Set<PropertyValue> setElements = ((TypeDefinitionSet)propertyType).getElements(value);
                if (property.getAUID().equals(PropertiesID)) {
                    PropertyValue toRemove = null;
                    for (PropertyValue element : setElements) {
                        if (!((PropertyDefinition)element.getValue()).getAUID().equals(ApplicationPluginsID)) continue;
                        toRemove = element;
                        break;
                    }
                    if (toRemove != null) {
                        setElements.remove(toRemove);
                        aafWriter.setInterchangePath(path);
                    }
                }
                if (setRefType.getTypeCategory() != TypeCategory.StrongObjRef && setRefType.getTypeCategory() != TypeCategory.WeakObjRef) {
                    if (setElements.size() == 0) break;
                    PropertyValue sampleValue = null;
                    Iterator<PropertyValue> newSetDir = setElements.iterator();
                    if (newSetDir.hasNext()) {
                        findMeASample = newSetDir.next();
                        sampleValue = findMeASample;
                    }
                    propertySize = (int)((long)propertySize + (long)setElements.size() * setRefType.lengthAsBytes(sampleValue));
                    break;
                }
                dirName = AAFBuilder.makeAAFPathPartReference(property, aafWriter.getLocalID(property.getAUID()));
                propertySize += dirName.length() * 2 + 2;
                int elementCount = 0;
                if (setRefType.getTypeCategory() == TypeCategory.StrongObjRef) {
                    Object sampleValue = null;
                    findMeASample = setElements.iterator();
                    if (findMeASample.hasNext()) {
                        PropertyValue findMeASample2 = (PropertyValue)findMeASample.next();
                        sampleValue = findMeASample2;
                    }
                    ClassDefinition referencedValueClass = ((TypeDefinitionStrongObjectReference)setRefType).getObjectType();
                    int identificationSize = 0;
                    PropertyDefinition uniqueProperty = null;
                    if (setElements.size() > 0 && referencedValueClass.isUniquelyIdentified()) {
                        uniqueProperty = referencedValueClass.getUniqueIdentifierProperty();
                        PropertyValue sampleIDValue = uniqueProperty.getPropertyValue((MetadataObject)sampleValue.getValue());
                        identificationSize = (byte)uniqueProperty.getTypeDefinition().lengthAsBytes(sampleIDValue);
                    } else {
                        identificationSize = 0;
                    }
                    classDir.createDocument(dirName + " index", 15 + (8 + identificationSize) * setElements.size(), (POIFSWriterListener)aafWriter);
                    aafWriter.addIndexValue(path + File.separator + dirName + " index", value);
                }
                if (setRefType.getTypeCategory() == TypeCategory.WeakObjRef) {
                    classDir.createDocument(dirName + " index", 9 + 16 * setElements.size(), (POIFSWriterListener)aafWriter);
                    aafWriter.addIndexValue(path + File.separator + dirName + " index", value);
                }
                for (PropertyValue setElement : setElements) {
                    switch (setRefType.getTypeCategory()) {
                        case StrongObjRef: {
                            DirectoryEntry newSetDir = classDir.createDirectory(dirName + "{" + Integer.toHexString(elementCount) + "}");
                            AAFBuilder.generateAAFStructure(newSetDir, aafWriter, (MetadataObject)setElement.getValue());
                            break;
                        }
                        case WeakObjRef: {
                            aafWriter.registerWeakType((TypeDefinitionWeakObjectReference)setRefType);
                            break;
                        }
                    }
                    ++elementCount;
                }
                break;
            }
            case VariableArray: {
                TypeDefinition arrayRefType = ((TypeDefinitionVariableArray)propertyType).getType();
                List<PropertyValue> listElements = ((TypeDefinitionVariableArray)propertyType).getElements(value);
                if (arrayRefType.getTypeCategory() == TypeCategory.StrongObjRef) {
                    dirName = AAFBuilder.makeAAFPathPartReference(property, aafWriter.getLocalID(property.getAUID()));
                    propertySize += dirName.length() * 2 + 2;
                    classDir.createDocument(dirName + " index", 12 + 4 * listElements.size(), (POIFSWriterListener)aafWriter);
                    aafWriter.addIndexValue(path + File.separator + dirName + " index", value);
                }
                if (arrayRefType.getTypeCategory() == TypeCategory.WeakObjRef) {
                    dirName = AAFBuilder.makeAAFPathPartReference(property, aafWriter.getLocalID(property.getAUID()));
                    propertySize += dirName.length() * 2 + 2;
                    classDir.createDocument(dirName + " index", 9 + 16 * listElements.size(), (POIFSWriterListener)aafWriter);
                    aafWriter.addIndexValue(path + File.separator + dirName + " index", value);
                }
                block20: for (int x = 0; x < listElements.size(); ++x) {
                    PropertyValue listElement = listElements.get(x);
                    switch (arrayRefType.getTypeCategory()) {
                        case StrongObjRef: {
                            DirectoryEntry newArrayDir = classDir.createDirectory(dirName + "{" + Integer.toHexString(x) + "}");
                            AAFBuilder.generateAAFStructure(newArrayDir, aafWriter, (MetadataObject)listElement.getValue());
                            continue block20;
                        }
                        case WeakObjRef: {
                            aafWriter.registerWeakType((TypeDefinitionWeakObjectReference)arrayRefType);
                            continue block20;
                        }
                        case Character: {
                            propertySize += ((String)listElement.getValue()).length() * 2 + 2;
                            continue block20;
                        }
                        default: {
                            propertySize = (int)((long)propertySize + listElement.getType().lengthAsBytes(listElement));
                        }
                    }
                }
                break;
            }
            case Indirect: {
                propertySize = (int)((long)propertySize + (value.getType().lengthAsBytes(value) + 1L));
                break;
            }
            case Stream: {
                dirName = AAFBuilder.makeAAFPathPartName(property, aafWriter.getLocalID(property.getAUID()));
                Stream stream = (Stream)value.getValue();
                DocumentEntry streamDocument = classDir.createDocument(dirName, (int)stream.getLength(), (POIFSWriterListener)aafWriter);
                aafWriter.registerStreamDocument(streamDocument, stream);
                propertySize += dirName.length() * 2 + 2 + 1;
                break;
            }
            default: {
                if (property.getAUID().equals(ByteOrderPropertyID)) {
                    propertySize += 2;
                    break;
                }
                propertySize = (int)((long)propertySize + value.getType().lengthAsBytes(value));
            }
        }
        return propertySize;
    }

    public static final void generateMetaDictionary(DirectoryEntry metaDir, AAFWriterListener aafWriter, Preface preface) throws IOException {
        PropertyDefinitionImpl.initalizePropertyNameMap();
        ClassDefinitionImpl.initalizeClassNameMap();
        TypeDefinitionImpl.initalizeTypeNameMap();
        MetaDictionary metaDictionary = Forge.make(MetaDictionary.class, new Object[0]);
        metaDictionary.makeDynamic(preface);
        AAFBuilder.generateAAFStructure(metaDir, aafWriter, metaDictionary);
    }

    private static final String makePathForDirectory(DirectoryEntry dir) {
        StringBuffer fullPath = new StringBuffer(256);
        fullPath.append(File.separator);
        fullPath.append(dir.getName());
        DirectoryEntry parentDir = dir.getParent();
        while (!parentDir.getName().equals("Root Entry")) {
            fullPath.insert(0, parentDir.getName());
            fullPath.insert(0, File.separator);
            parentDir = parentDir.getParent();
        }
        return fullPath.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.exit(1);
        }
        String inputFilename = args[0];
        String outputFilename = args[1];
        AAFReader r = new AAFReader();
        LocalAAFEventReader eventReader = new LocalAAFEventReader();
        r.registerListener(eventReader);
        AvidFactory.registerAvidExtensions();
        FileInputStream fis = null;
        long startTime = System.nanoTime();
        try {
            fis = new FileInputStream(inputFilename);
            r.read(new FileInputStream(inputFilename));
            eventReader.resolveEntries();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
        long endTime = System.nanoTime();
        System.out.println("AAF file read in " + (endTime - startTime) + "ns.");
        ((PrefaceImpl)eventReader.getPreface()).setByteOrder(tv.amwa.maj.enumeration.ByteOrder.Big);
        System.out.println(eventReader.getPreface().getByteOrder());
        POIFSFileSystem outputFileSystem = new POIFSFileSystem();
        DirectoryNode rootDir = outputFileSystem.getRoot();
        AAFWriterListener aafWriter = AAFBuilder.makeAAFWriterListener();
        DirectoryEntry metaDictionaryDir = rootDir.createDirectory("MetaDictionary-1");
        DirectoryEntry prefaceDir = rootDir.createDirectory("Header-2");
        AAFBuilder.generateAAFStructure(prefaceDir, aafWriter, eventReader.getPreface());
        AAFBuilder.generateMetaDictionary(metaDictionaryDir, aafWriter, eventReader.getPreface());
        rootDir.createDocument("properties", 70, (POIFSWriterListener)aafWriter);
        rootDir.createDocument("referenced properties", aafWriter.getReferencedPropertiesSize(), (POIFSWriterListener)aafWriter);
        rootDir.setStorageClsid(new ClassID(rootEntryClassID, 0));
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outputFilename);
            outputFileSystem.writeFilesystem((OutputStream)fos);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
        RandomAccessFile fixFile = null;
        try (AbstractInterruptibleChannel fixChannel = null;){
            fixFile = new RandomAccessFile(outputFilename, "rw");
            fixChannel = fixFile.getChannel();
            ((FileChannel)fixChannel).position(8L);
            if (outputFileSystem.getBigBlockSize() == 4096) {
                ((FileChannel)fixChannel).write(ByteBuffer.wrap(AAFSignatureSSBin4KBytes));
            } else {
                ((FileChannel)fixChannel).write(ByteBuffer.wrap(AAFSignatureSSBinaryBytes));
            }
        }
    }

    static {
        structuredTypes.put((byte)-126, "SF_DATA                                  ");
        structuredTypes.put((byte)-46, "SF_DATA_VECTOR                           ");
        structuredTypes.put((byte)-38, "SF_DATA_SET                              ");
        structuredTypes.put((byte)66, "SF_DATA_STREAM                           ");
        structuredTypes.put((byte)34, "SF_STRONG_OBJECT_REFERENCE               ");
        structuredTypes.put((byte)50, "SF_STRONG_OBJECT_REFERENCE_VECTOR        ");
        structuredTypes.put((byte)58, "SF_STRONG_OBJECT_REFERENCE_SET           ");
        structuredTypes.put((byte)2, "SF_WEAK_OBJECT_REFERENCE                 ");
        structuredTypes.put((byte)18, "SF_WEAK_OBJECT_REFERENCE_VECTOR          ");
        structuredTypes.put((byte)26, "SF_WEAK_OBJECT_REFERENCE_SET             ");
        structuredTypes.put((byte)3, "SF_WEAK_OBJECT_REFERENCE_STORED_OBJECT_ID");
        structuredTypes.put((byte)-122, "SF_UNIQUE_OBJECT_ID                      ");
        structuredTypes.put((byte)64, "SF_OPAQUE_STREAM                         ");
        MediaEngine.initializeAAF();
        int tableSize = directoryNameAliases.length / 2;
        for (int x = 0; x < tableSize; ++x) {
            directoryNameTable.put(directoryNameAliases[2 * x + 1], directoryNameAliases[2 * x]);
        }
    }

    private static class LocalAAFWriterListener
    implements AAFWriterListener {
        private Map<String, SortedMap<PropertyDefinition, PropertyValue>> pathPropertyMap = new HashMap<String, SortedMap<PropertyDefinition, PropertyValue>>();
        private int refPropertyIndexCount = 0;
        private Map<TypeDefinitionWeakObjectReference, Integer> refPropertyMap = new HashMap<TypeDefinitionWeakObjectReference, Integer>();
        private Map<String, PropertyValue> indexMap = new HashMap<String, PropertyValue>();
        private String interchangeObjectPath = "";
        private Map<AUID, Short> localIDTable = new HashMap<AUID, Short>();
        private Map<String, Stream> streamMap = new HashMap<String, Stream>();
        private static short nextDynamicID = (short)-1;

        LocalAAFWriterListener() {
        }

        public void processPOIFSWriterEvent(POIFSWriterEvent event) {
            if (event.getName().equals("properties")) {
                this.encodeProperties(event);
                return;
            }
            if (event.getName().equals("referenced properties")) {
                this.encodeReferencedProperties(event);
                return;
            }
            if (event.getName().endsWith("index")) {
                this.encodeIndex(event);
                return;
            }
            String fullEventPath = event.getPath().toString() + File.separator + event.getName();
            if (this.streamMap.containsKey(fullEventPath)) {
                this.encodeStream(event, this.streamMap.get(fullEventPath));
                return;
            }
            System.err.println("Unhandled writer event " + fullEventPath + ".");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void encodeProperties(POIFSWriterEvent event) {
            DocumentOutputStream dos = event.getStream();
            if (event.getPath().toString().equals(File.separator)) {
                LocalAAFWriterListener.writeRootProperties(dos);
                return;
            }
            SortedMap<PropertyDefinition, PropertyValue> propertyMap = this.pathPropertyMap.get(event.getPath().toString());
            if (propertyMap == null) {
                System.err.println("Could not find information for " + event.getPath().toString() + File.separator + "properties.");
                try {
                    dos.write(66);
                    dos.write(32);
                    dos.write(0);
                    dos.write(0);
                }
                catch (IOException iOException) {
                }
                finally {
                    if (dos != null) {
                        dos.close();
                    }
                }
                return;
            }
            String propertyName = null;
            TypeDefinition propertyType = null;
            String referenceName = null;
            PropertyValue value = null;
            try {
                ByteBuffer buffer = ByteBuffer.allocate(event.getLimit());
                buffer.order(ByteOrder.BIG_ENDIAN);
                buffer.put((byte)66);
                buffer.put((byte)32);
                buffer.putShort((short)propertyMap.size());
                for (PropertyDefinition property : propertyMap.keySet()) {
                    this.registerLocalID(property);
                    buffer.putShort(this.getLocalID(property.getAUID()));
                    propertyType = property.getTypeDefinition();
                    referenceName = null;
                    value = null;
                    if (property.getAUID().equals(AAFConstants.ParametersID)) {
                        buffer.putShort((short)58);
                        referenceName = AAFBuilder.makeAAFPathPartReference(property, this.getLocalID(property.getAUID()));
                        buffer.putShort((short)(referenceName.length() * 2 + 2));
                        continue;
                    }
                    block5 : switch (propertyType.getTypeCategory()) {
                        case StrongObjRef: {
                            buffer.putShort((short)34);
                            referenceName = AAFBuilder.makeAAFPathPartName(property, this.getLocalID(property.getAUID()));
                            buffer.putShort((short)(referenceName.length() * 2 + 2));
                            break;
                        }
                        case WeakObjRef: {
                            buffer.putShort((short)2);
                            buffer.putShort((short)21);
                            break;
                        }
                        case VariableArray: {
                            TypeDefinition arrayRefType = ((TypeDefinitionVariableArray)propertyType).getType();
                            switch (arrayRefType.getTypeCategory()) {
                                case StrongObjRef: {
                                    buffer.putShort((short)50);
                                    referenceName = AAFBuilder.makeAAFPathPartReference(property, this.getLocalID(property.getAUID()));
                                    buffer.putShort((short)(referenceName.length() * 2 + 2));
                                    break block5;
                                }
                                case WeakObjRef: {
                                    buffer.putShort((short)18);
                                    referenceName = AAFBuilder.makeAAFPathPartReference(property, this.getLocalID(property.getAUID()));
                                    buffer.putShort((short)(referenceName.length() * 2 + 2));
                                    break block5;
                                }
                                case Character: {
                                    buffer.putShort((short)130);
                                    value = (PropertyValue)propertyMap.get(property);
                                    int stringArrayLength = 0;
                                    List<PropertyValue> stringElements = TypeDefinitions.UTF16StringArray.getElements(value);
                                    for (PropertyValue stringElement : stringElements) {
                                        stringArrayLength += ((String)stringElement.getValue()).length() * 2 + 2;
                                    }
                                    buffer.putShort((short)stringArrayLength);
                                    break block5;
                                }
                            }
                            buffer.putShort((short)130);
                            value = (PropertyValue)propertyMap.get(property);
                            int arrayLength = ((TypeDefinitionVariableArray)propertyType).getCount(value);
                            if (arrayLength == 0) {
                                buffer.putShort((short)0);
                                break;
                            }
                            PropertyValue exampleValue = ((TypeDefinitionVariableArray)propertyType).getElementValue(value, 0);
                            buffer.putShort((short)((long)arrayLength * arrayRefType.lengthAsBytes(exampleValue)));
                            break;
                        }
                        case Set: {
                            TypeDefinition setRefType = ((TypeDefinitionSet)propertyType).getElementType();
                            switch (setRefType.getTypeCategory()) {
                                case StrongObjRef: {
                                    buffer.putShort((short)58);
                                    referenceName = AAFBuilder.makeAAFPathPartReference(property, this.getLocalID(property.getAUID()));
                                    buffer.putShort((short)(referenceName.length() * 2 + 2));
                                    break block5;
                                }
                                case WeakObjRef: {
                                    buffer.putShort((short)26);
                                    referenceName = AAFBuilder.makeAAFPathPartReference(property, this.getLocalID(property.getAUID()));
                                    buffer.putShort((short)(referenceName.length() * 2 + 2));
                                    break block5;
                                }
                                case Character: {
                                    buffer.putShort((short)130);
                                    value = (PropertyValue)propertyMap.get(property);
                                    int stringArrayLength = 0;
                                    Iterator<PropertyValue> stringElements = TypeDefinitions.UTF16StringArray.getElements(value);
                                    Iterator<PropertyValue> exampleValue = stringElements.iterator();
                                    while (exampleValue.hasNext()) {
                                        PropertyValue stringElement = exampleValue.next();
                                        stringArrayLength += ((String)stringElement.getValue()).length() * 2 + 2;
                                    }
                                    buffer.putShort((short)stringArrayLength);
                                    break block5;
                                }
                            }
                            buffer.putShort((short)130);
                            value = (PropertyValue)propertyMap.get(property);
                            int setLength = ((TypeDefinitionSet)propertyType).getCount(value);
                            if (setLength == 0) {
                                buffer.putShort((short)0);
                                break;
                            }
                            PropertyValue exampleValue = null;
                            Iterator<Object> iterator = ((TypeDefinitionSet)propertyType).getElements(value).iterator();
                            if (iterator.hasNext()) {
                                PropertyValue candidateValue;
                                exampleValue = candidateValue = (PropertyValue)iterator.next();
                            }
                            buffer.putShort((short)((long)setLength * setRefType.lengthAsBytes(exampleValue)));
                            break;
                        }
                        case Indirect: {
                            buffer.putShort((short)130);
                            value = (PropertyValue)propertyMap.get(property);
                            buffer.putShort((short)(value.getType().lengthAsBytes(value) + 1L));
                            break;
                        }
                        case Stream: {
                            buffer.putShort((short)66);
                            referenceName = AAFBuilder.makeAAFPathPartName(property, this.getLocalID(property.getAUID()));
                            buffer.putShort((short)(referenceName.length() * 2 + 2 + 1));
                            break;
                        }
                        default: {
                            buffer.putShort((short)130);
                            if (property.getAUID().equals(AAFConstants.ByteOrderPropertyID)) {
                                buffer.putShort((short)2);
                                break;
                            }
                            value = (PropertyValue)propertyMap.get(property);
                            buffer.putShort((short)value.getType().lengthAsBytes(value));
                        }
                    }
                }
                buffer.mark();
                for (PropertyDefinition property : propertyMap.keySet()) {
                    propertyName = property.getMemberOf().getName() + "." + property.getName();
                    propertyType = property.getTypeDefinition();
                    referenceName = null;
                    value = null;
                    TypeDefinitionWeakObjectReference weakType = null;
                    if (property.getAUID().equals(AAFConstants.ParametersID)) {
                        referenceName = AAFBuilder.makeAAFPathPartReference(property, this.getLocalID(property.getAUID()));
                        value = TypeDefinitions.UTF16String.createValue(referenceName);
                        TypeDefinitions.UTF16String.writeAsStructuredStorageBytes(value, buffer);
                        continue;
                    }
                    block23 : switch (propertyType.getTypeCategory()) {
                        case StrongObjRef: {
                            referenceName = AAFBuilder.makeAAFPathPartName(property, this.getLocalID(property.getAUID()));
                            value = TypeDefinitions.UTF16String.createValue(referenceName);
                            TypeDefinitions.UTF16String.writeAsStructuredStorageBytes(value, buffer);
                            break;
                        }
                        case WeakObjRef: {
                            weakType = (TypeDefinitionWeakObjectReference)propertyType;
                            buffer.putShort(this.refPropertyMap.get(weakType).shortValue());
                            buffer.putShort(weakType.getObjectType().getUniqueIdentifierProperty().getLocalIdentification());
                            buffer.put((byte)16);
                            value = (PropertyValue)propertyMap.get(property);
                            AUID theReference = null;
                            theReference = value instanceof TypeDefinitionObjectReferenceImpl.ObjectReferenceValue ? ((TypeDefinitionObjectReferenceImpl.ObjectReferenceValue)value).getLocalReference() : ((TypeDefinitionObjectReferenceImpl.UnresolvedReferenceValue)value).getValue();
                            buffer.putInt(theReference.getData1());
                            buffer.putShort(theReference.getData2());
                            buffer.putShort(theReference.getData3());
                            buffer.put(theReference.getData4());
                            break;
                        }
                        case VariableArray: {
                            TypeDefinition arrayRefType = ((TypeDefinitionVariableArray)propertyType).getType();
                            switch (arrayRefType.getTypeCategory()) {
                                case StrongObjRef: 
                                case WeakObjRef: {
                                    referenceName = AAFBuilder.makeAAFPathPartReference(property, this.getLocalID(property.getAUID()));
                                    value = TypeDefinitions.UTF16String.createValue(referenceName);
                                    TypeDefinitions.UTF16String.writeAsStructuredStorageBytes(value, buffer);
                                    break;
                                }
                                case Character: {
                                    value = (PropertyValue)propertyMap.get(property);
                                    for (PropertyValue elementValue : ((TypeDefinitionVariableArray)propertyType).getElements(value)) {
                                        TypeDefinitions.UTF16String.writeAsStructuredStorageBytes(elementValue, buffer);
                                    }
                                    break block23;
                                }
                                default: {
                                    value = (PropertyValue)propertyMap.get(property);
                                    for (PropertyValue elementValue : ((TypeDefinitionVariableArray)propertyType).getElements(value)) {
                                        arrayRefType.writeAsStructuredStorageBytes(elementValue, buffer);
                                    }
                                    break block23;
                                }
                            }
                            break;
                        }
                        case Set: {
                            TypeDefinition setRefType = ((TypeDefinitionSet)propertyType).getElementType();
                            switch (setRefType.getTypeCategory()) {
                                case StrongObjRef: 
                                case WeakObjRef: {
                                    referenceName = AAFBuilder.makeAAFPathPartReference(property, this.getLocalID(property.getAUID()));
                                    value = TypeDefinitions.UTF16String.createValue(referenceName);
                                    TypeDefinitions.UTF16String.writeAsStructuredStorageBytes(value, buffer);
                                    break block23;
                                }
                            }
                            value = (PropertyValue)propertyMap.get(property);
                            for (PropertyValue elementValue : ((TypeDefinitionSet)propertyType).getElements(value)) {
                                setRefType.writeAsStructuredStorageBytes(elementValue, buffer);
                            }
                            break;
                        }
                        case Indirect: {
                            buffer.put((byte)66);
                            value = (PropertyValue)propertyMap.get(property);
                            value.getType().writeAsStructuredStorageBytes(value, buffer);
                            break;
                        }
                        case Stream: {
                            value = (PropertyValue)propertyMap.get(property);
                            Stream stream = (Stream)value.getValue();
                            if (stream.getByteOrder() == tv.amwa.maj.enumeration.ByteOrder.Little) {
                                buffer.put((byte)108);
                            } else {
                                buffer.put((byte)66);
                            }
                            referenceName = AAFBuilder.makeAAFPathPartName(property, this.getLocalID(property.getAUID()));
                            value = TypeDefinitions.UTF16String.createValue(referenceName);
                            TypeDefinitions.UTF16String.writeAsStructuredStorageBytes(value, buffer);
                            break;
                        }
                        default: {
                            value = (PropertyValue)propertyMap.get(property);
                            if (property.getAUID().equals(AAFConstants.ByteOrderPropertyID)) {
                                buffer.putShort((short)19789);
                                break;
                            }
                            if (property.getAUID().equals(AAFConstants.LocalIdentificationProperty)) {
                                PropertyValue idPropertyValue = null;
                                for (PropertyDefinition findIDProperty : propertyMap.keySet()) {
                                    if (!findIDProperty.getAUID().equals(AAFConstants.MetaDefinitionIDProperty)) continue;
                                    idPropertyValue = (PropertyValue)propertyMap.get(findIDProperty);
                                    break;
                                }
                                AUID propertyID = (AUID)idPropertyValue.getValue();
                                this.registerLocalID(propertyID, (Short)value.getValue());
                                buffer.putShort(this.getLocalID(propertyID));
                                break;
                            }
                            value.getType().writeAsStructuredStorageBytes(value, buffer);
                        }
                    }
                    buffer.mark();
                    buffer.limit(event.getLimit());
                }
                dos.write(buffer.array());
            }
            catch (InsufficientSpaceException ise) {
                System.err.println("Run out of space in buffer when writing " + event.getPath().toString() + "/properties : " + event.getLimit());
                System.err.println("Property is: " + propertyName);
                if (value != null) {
                    System.err.println(value.getValue().toString());
                }
            }
            catch (IOException ioe) {
                System.err.println("IO exception thrown when trying to write structured storage property values for path " + event.getPath().toString() + ": " + ioe.getMessage());
                ioe.printStackTrace();
            }
            finally {
                if (dos != null) {
                    dos.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void encodeReferencedProperties(POIFSWriterEvent event) {
            try (DocumentOutputStream dos = event.getStream();){
                ByteBuffer buffer = ByteBuffer.allocate(event.getLimit());
                buffer.order(ByteOrder.BIG_ENDIAN);
                buffer.put((byte)66);
                buffer.putShort((short)this.refPropertyMap.size());
                buffer.putInt((this.getReferencedPropertiesSize() - 7) / 2);
                for (int x = 0; x < this.refPropertyMap.size(); ++x) {
                    for (TypeDefinitionWeakObjectReference weakType : this.refPropertyMap.keySet()) {
                        if (this.refPropertyMap.get(weakType) != x) continue;
                        AUID[] targetSet = weakType.getTargetSet();
                        ClassDefinition parentType = null;
                        for (AUID target : targetSet) {
                            if (target.equals(AAFConstants.RootPrefaceProperty)) {
                                buffer.putShort((short)2);
                                parentType = Warehouse.lookForClass(Preface.class);
                                continue;
                            }
                            if (target.equals(AAFConstants.RootMetaDictionaryProperty)) {
                                buffer.putShort((short)1);
                                parentType = Warehouse.lookForClass(MetaDictionary.class);
                                continue;
                            }
                            try {
                                if (parentType == null) {
                                    System.err.println("++*: Target is " + target + " for weak type " + weakType.getName());
                                }
                                PropertyDefinition nextInLine = parentType.lookupPropertyDefinition(target);
                                buffer.putShort(nextInLine.getLocalIdentification());
                                if (nextInLine.getTypeDefinition().getTypeCategory() != TypeCategory.StrongObjRef) continue;
                                parentType = ((TypeDefinitionStrongObjectReference)nextInLine.getTypeDefinition()).getObjectType();
                            }
                            catch (BadParameterException bpe) {
                                System.err.println("Error making reference properties for target property " + target.toString() + ".");
                            }
                        }
                        buffer.putShort((short)0);
                    }
                }
                buffer.rewind();
                dos.write(buffer.array());
            }
        }

        private static final void writeRootProperties(DocumentOutputStream dos) {
            try {
                ByteBuffer buffer = ByteBuffer.allocate(70);
                buffer.order(ByteOrder.BIG_ENDIAN);
                buffer.put((byte)66);
                buffer.put((byte)32);
                buffer.putShort((short)2);
                buffer.putShort((short)1);
                buffer.putShort((short)34);
                buffer.putShort((short)("MetaDictionary-1".length() * 2 + 2));
                buffer.putShort((short)2);
                buffer.putShort((short)34);
                buffer.putShort((short)("Header-2".length() * 2 + 2));
                PropertyValue stringToWrite = TypeDefinitions.UTF16String.createValue("MetaDictionary-1");
                TypeDefinitions.UTF16String.writeAsStructuredStorageBytes(stringToWrite, buffer);
                stringToWrite = TypeDefinitions.UTF16String.createValue("Header-2");
                TypeDefinitions.UTF16String.writeAsStructuredStorageBytes(stringToWrite, buffer);
                buffer.rewind();
                dos.write(buffer.array());
            }
            catch (InsufficientSpaceException ise) {
                System.err.println("Insufficient space to write the root properties strucutre.");
                ise.printStackTrace();
            }
            catch (IOException ioe) {
                System.err.println("IO exception thrown when writing the root properties: " + ioe.getMessage());
                ioe.printStackTrace();
            }
            finally {
                if (dos != null) {
                    dos.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void encodeIndex(POIFSWriterEvent event) {
            int count = 0;
            try (DocumentOutputStream dos = event.getStream();){
                ByteBuffer buffer;
                block46: {
                    PropertyValue value;
                    block45: {
                        buffer = ByteBuffer.allocate(event.getLimit());
                        buffer.order(ByteOrder.BIG_ENDIAN);
                        value = this.indexMap.get(event.getPath().toString() + File.separator + event.getName());
                        if (value.getType().getTypeCategory() != TypeCategory.VariableArray || event.getName().startsWith("Parameters-b03")) break block45;
                        TypeDefinitionVariableArray variableArrayType = (TypeDefinitionVariableArray)value.getType();
                        TypeDefinition arrayRefType = variableArrayType.getType();
                        switch (arrayRefType.getTypeCategory()) {
                            case StrongObjRef: {
                                count = variableArrayType.getCount(value);
                                buffer.putInt(count);
                                buffer.putInt(count);
                                buffer.putInt(-1);
                                for (int x = 0; x < count; ++x) {
                                    buffer.putInt(x);
                                }
                                break block46;
                            }
                            case WeakObjRef: {
                                count = variableArrayType.getCount(value);
                                buffer.putInt(count);
                                buffer.putShort(this.refPropertyMap.get(arrayRefType).shortValue());
                                List<PropertyValue> elements = variableArrayType.getElements(value);
                                PropertyValue sampleValue = elements.get(0);
                                ClassDefinition referencedValueClass = ((TypeDefinitionWeakObjectReference)arrayRefType).getObjectType();
                                int identificationSize = 0;
                                PropertyDefinition uniqueProperty = null;
                                if (referencedValueClass.isUniquelyIdentified()) {
                                    uniqueProperty = referencedValueClass.getUniqueIdentifierProperty();
                                    buffer.putShort(uniqueProperty.getLocalIdentification());
                                    PropertyValue sampleIDValue = uniqueProperty.getPropertyValue((MetadataObject)sampleValue.getValue());
                                    identificationSize = (byte)uniqueProperty.getTypeDefinition().lengthAsBytes(sampleIDValue);
                                } else {
                                    System.err.println("Warning: When writing AAF, found an element of a weak reference vector that does not have an identifier: Type " + referencedValueClass.getName());
                                    buffer.putShort((short)0);
                                    identificationSize = 0;
                                }
                                buffer.put((byte)identificationSize);
                                for (PropertyValue elementValue : elements) {
                                    try {
                                        PropertyValue identityValue = uniqueProperty.getPropertyValue((MetadataObject)elementValue.getValue());
                                        identityValue.getType().writeAsStructuredStorageBytes(identityValue, buffer);
                                    }
                                    catch (Exception e) {
                                        for (int y = 0; y < identificationSize; ++y) {
                                            buffer.put((byte)0);
                                        }
                                    }
                                }
                                break block46;
                            }
                        }
                        break block46;
                    }
                    TypeDefinition setRefType = value.getType().getTypeCategory() == TypeCategory.VariableArray ? ((TypeDefinitionVariableArray)value.getType()).getType() : ((TypeDefinitionSet)value.getType()).getElementType();
                    switch (setRefType.getTypeCategory()) {
                        case StrongObjRef: {
                            Collection<PropertyValue> elements;
                            boolean isInterchange = this.interchangeObjectPath.equals(event.getPath().toString());
                            int n = count = value.getType().getTypeCategory() == TypeCategory.VariableArray ? ((TypeDefinitionVariableArray)value.getType()).getCount(value) : ((TypeDefinitionSet)value.getType()).getCount(value);
                            if (isInterchange) {
                                --count;
                            }
                            buffer.putInt(count);
                            buffer.putInt(count);
                            buffer.putInt(-1);
                            Collection<PropertyValue> collection = elements = value.getType().getTypeCategory() == TypeCategory.VariableArray ? ((TypeDefinitionVariableArray)value.getType()).getElements(value) : ((TypeDefinitionSet)value.getType()).getElements(value);
                            if (isInterchange) {
                                PropertyValue toRemove = null;
                                for (PropertyValue element : elements) {
                                    if (!((PropertyDefinition)element.getValue()).getAUID().equals(CommonConstants.ApplicationPluginsID)) continue;
                                    toRemove = element;
                                    break;
                                }
                                if (toRemove != null) {
                                    elements.remove(toRemove);
                                }
                            }
                            PropertyValue sampleValue = null;
                            Iterator<PropertyValue> referencedValueClass = elements.iterator();
                            if (referencedValueClass.hasNext()) {
                                PropertyValue findMeASample;
                                sampleValue = findMeASample = referencedValueClass.next();
                            }
                            referencedValueClass = ((TypeDefinitionStrongObjectReference)setRefType).getObjectType();
                            int identificationSize = 0;
                            PropertyDefinition uniqueProperty = null;
                            if (referencedValueClass.isUniquelyIdentified()) {
                                uniqueProperty = referencedValueClass.getUniqueIdentifierProperty();
                                buffer.putShort(uniqueProperty.getLocalIdentification());
                                if (sampleValue != null) {
                                    PropertyValue sampleIDValue = uniqueProperty.getPropertyValue((MetadataObject)sampleValue.getValue());
                                    identificationSize = (byte)uniqueProperty.getTypeDefinition().lengthAsBytes(sampleIDValue);
                                } else {
                                    identificationSize = uniqueProperty.getTypeDefinition().equals(TypeDefinitions.PackageIDType) ? 32 : 16;
                                }
                            } else if (sampleValue.getValue() instanceof Parameter) {
                                buffer.putShort((short)6913);
                                identificationSize = 16;
                            } else {
                                System.err.println("Warning: When writing AAF, found an element of a strong reference set that does not have an identifier: Type " + referencedValueClass.getName());
                                buffer.putShort((short)0);
                                identificationSize = 0;
                            }
                            buffer.put((byte)identificationSize);
                            int x = 0;
                            for (PropertyValue elementValue : elements) {
                                buffer.putInt(x);
                                buffer.putInt(1);
                                try {
                                    PropertyValue identityValue = null;
                                    identityValue = elementValue.getValue() instanceof Parameter ? TypeDefinitions.AUID.createValue(((Parameter)elementValue.getValue()).getParameterDefinitionReference()) : uniqueProperty.getPropertyValue((MetadataObject)elementValue.getValue());
                                    identityValue.getType().writeAsStructuredStorageBytes(identityValue, buffer);
                                }
                                catch (Exception e) {
                                    for (int y = 0; y < identificationSize; ++y) {
                                        buffer.put((byte)0);
                                    }
                                }
                                ++x;
                            }
                            break;
                        }
                        case WeakObjRef: {
                            TypeDefinitionSet setType = (TypeDefinitionSet)value.getType();
                            count = setType.getCount(value);
                            buffer.putInt(count);
                            buffer.putShort(this.refPropertyMap.get(setRefType).shortValue());
                            Set<PropertyValue> weakElements = setType.getElements(value);
                            PropertyValue weakSampleValue = null;
                            Iterator<PropertyValue> y = weakElements.iterator();
                            if (y.hasNext()) {
                                PropertyValue findASampleValue;
                                weakSampleValue = findASampleValue = y.next();
                            }
                            ClassDefinition weakReferencedValueClass = ((TypeDefinitionWeakObjectReference)setRefType).getObjectType();
                            int weakIdentificationSize = 0;
                            PropertyDefinition weakUniqueProperty = null;
                            if (weakReferencedValueClass.isUniquelyIdentified()) {
                                weakUniqueProperty = weakReferencedValueClass.getUniqueIdentifierProperty();
                                buffer.putShort(weakUniqueProperty.getLocalIdentification());
                                PropertyValue sampleIDValue = weakUniqueProperty.getPropertyValue((MetadataObject)weakSampleValue.getValue());
                                if (weakSampleValue != null) {
                                    weakIdentificationSize = (byte)weakUniqueProperty.getTypeDefinition().lengthAsBytes(sampleIDValue);
                                }
                            } else {
                                System.err.println("Warning: When writing AAF, found an element of a weak reference vector that does not have an identifier: Type " + weakReferencedValueClass.getName());
                                buffer.putShort((short)0);
                                weakIdentificationSize = 0;
                            }
                            buffer.put((byte)weakIdentificationSize);
                            for (PropertyValue elementValue : weakElements) {
                                try {
                                    PropertyValue identityValue = weakUniqueProperty.getPropertyValue((MetadataObject)elementValue.getValue());
                                    identityValue.getType().writeAsStructuredStorageBytes(identityValue, buffer);
                                }
                                catch (Exception e) {
                                    for (int y2 = 0; y2 < weakIdentificationSize; ++y2) {
                                        buffer.put((byte)0);
                                    }
                                }
                            }
                            buffer.rewind();
                            break;
                        }
                    }
                }
                buffer.rewind();
                dos.write(buffer.array());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void encodeStream(POIFSWriterEvent event, Stream stream) {
            try (DocumentOutputStream dos = event.getStream();){
                stream.setPosition(0L);
                for (long x = 2048L; x < stream.getLength(); x += 2048L) {
                    dos.write(stream.read(2048).array());
                }
                dos.write(stream.read((int)(stream.getLength() - stream.getPosition())).array());
            }
        }

        @Override
        public void addProperty(String path, PropertyDefinition propertyDefinition, PropertyValue propertyValue) throws NullPointerException, IllegalPropertyValueException {
            if (path == null) {
                throw new NullPointerException("Cannot add a property for AAF writing using a null path.");
            }
            if (propertyDefinition == null) {
                throw new NullPointerException("Cannot add a property for AAF writing using a null property definition.");
            }
            if (propertyValue == null) {
                throw new NullPointerException("Cannot add a property for AAF writing using a null property value.");
            }
            if (!this.pathPropertyMap.containsKey(path)) {
                TreeMap createdMap = new TreeMap();
                this.pathPropertyMap.put(path, createdMap);
            }
            SortedMap<PropertyDefinition, PropertyValue> mapToAddTo = this.pathPropertyMap.get(path);
            mapToAddTo.put(propertyDefinition, propertyValue);
        }

        @Override
        public synchronized int registerWeakType(TypeDefinitionWeakObjectReference weakType) {
            if (weakType == null) {
                throw new NullPointerException("Cannot register a weak type with an AAF writer using a null type definition.");
            }
            if (weakType.equals(TypeDefinitions.ExtensionSchemeWeakReference)) {
                return 0;
            }
            if (!this.refPropertyMap.containsKey(weakType)) {
                this.refPropertyMap.put(weakType, this.refPropertyIndexCount);
                ++this.refPropertyIndexCount;
            }
            return this.refPropertyMap.get(weakType);
        }

        @Override
        public int getReferencedPropertiesSize() {
            int regPropSize = 7;
            for (TypeDefinitionWeakObjectReference weakType : this.refPropertyMap.keySet()) {
                regPropSize += weakType.getTargetSet().length * 2 + 2;
            }
            return regPropSize;
        }

        @Override
        public void addIndexValue(String indexPath, PropertyValue value) throws NullPointerException {
            if (indexPath == null) {
                throw new NullPointerException("Cannot add a new index value using a null index path.");
            }
            if (value == null) {
                throw new NullPointerException("Cannot add a new index value using a null value.");
            }
            this.indexMap.put(indexPath, value);
        }

        @Override
        public void registerLocalID(PropertyDefinition property) {
            this.registerLocalID(property.getAUID(), property.getLocalIdentification());
        }

        @Override
        public synchronized void registerLocalID(AUID propertyID, short localID) {
            if (this.localIDTable.containsKey(propertyID)) {
                return;
            }
            if (localID <= 0) {
                short s = nextDynamicID;
                nextDynamicID = (short)(s - 1);
                localID = s;
            }
            this.localIDTable.put(propertyID, localID);
        }

        @Override
        public short getLocalID(AUID propertyID) {
            return this.localIDTable.get(propertyID);
        }

        @Override
        public void registerStreamDocument(DocumentEntry streamDocument, Stream stream) throws NullPointerException {
            if (streamDocument == null) {
                System.err.println("Cannot register a stream to write with a null stream document.");
            }
            if (stream == null) {
                System.err.println("Cannot register a stream to write with a null stream.");
            }
            String fullStreamPath = AAFBuilder.makePathForDirectory(streamDocument.getParent()) + File.separator + streamDocument.getName();
            this.streamMap.put(fullStreamPath, stream);
        }

        @Override
        public void setInterchangePath(String path) throws NullPointerException {
            if (path == null) {
                throw new NullPointerException("Cannot set the interchange object definition path using a null value.");
            }
            this.interchangeObjectPath = path;
        }
    }

    private static class LocalAAFEventReader
    implements AAFReaderListener {
        ClassDefinition likelyParent = null;
        List<ClassDefinition> classStack = new ArrayList<ClassDefinition>();
        Map<String, MetadataObject> pathMap = new HashMap<String, MetadataObject>();
        Map<String, ByteBuffer> indexMap = new HashMap<String, ByteBuffer>();
        List<ResolutionEntry> resolutions = new ArrayList<ResolutionEntry>();
        Map<Short, PropertyDefinition> extensionPropertyMap = new HashMap<Short, PropertyDefinition>();
        Map<String, Stream> streamMap = new HashMap<String, Stream>();
        String canonicalFilePath = null;
        boolean seenMetaDictionary = false;
        boolean seenPreface = false;
        boolean metaDictionaryResolved = false;
        Preface resolvedPreface = null;
        ExtensionScheme thisScheme = new ExtensionSchemeImpl();

        public LocalAAFEventReader() {
            this.thisScheme.setSchemeID(Forge.randomAUID());
            this.thisScheme.setSchemeURI(this.thisScheme.getSchemeID().toString());
            this.thisScheme.setPreferredPrefix("this");
            this.thisScheme.setExtensionDescription("Deafult AAF extension scheme.");
            Warehouse.register(this.thisScheme);
        }

        public void processPOIFSReaderEvent(POIFSReaderEvent event) {
        }

        @Override
        public void processPOIFSReaderEvent(AAFReaderEvent event) {
            if (!this.metaDictionaryResolved && event.getPath().length() > 0) {
                POIFSDocumentPath eventPath = event.getPath();
                if (eventPath.getComponent(0).equals("MetaDictionary-1")) {
                    this.seenMetaDictionary = true;
                }
                if (eventPath.getComponent(0).equals("Header-2")) {
                    this.seenPreface = true;
                }
                if (this.seenMetaDictionary && this.seenPreface) {
                    this.resolveMetaDictionary();
                    this.resolutions.clear();
                    this.pathMap.clear();
                    this.indexMap.clear();
                    this.metaDictionaryResolved = true;
                }
            }
            try {
                DocumentInputStream fromProperties;
                if (event.getProperty().isDirectory()) {
                    AUIDImpl classID = new AUIDImpl(event.getProperty().getStorageClsid().getBytes());
                    ClassDefinition theClass = ClassDefinitionImpl.forAUID(classID);
                    if (theClass != null) {
                        this.classStack.add(0, theClass);
                        this.likelyParent = theClass;
                    } else {
                        System.err.println("UNRECOGNISED CLASS " + classID.toString());
                        this.classStack.add(0, null);
                        this.likelyParent = this.classStack.size() > 1 ? this.classStack.get(1) : null;
                    }
                    return;
                }
                if (event.getName().equals("referenced properties")) {
                    return;
                }
                if (event.getName().endsWith("properties")) {
                    fromProperties = event.getStream();
                    byte[] data = new byte[fromProperties.available()];
                    fromProperties.read(data);
                    ByteBuffer buffer = ByteBuffer.wrap(data);
                    MetadataObject mdObject = this.decodeProperties(buffer, event.getPath().toString());
                    if (mdObject == null) {
                        return;
                    }
                    this.pathMap.put(event.getPath().toString(), mdObject);
                    if (mdObject instanceof Preface) {
                        this.resolvedPreface = (Preface)mdObject;
                    }
                    return;
                }
                if (event.getName().endsWith("index")) {
                    fromProperties = event.getStream();
                    byte[] data = new byte[fromProperties.available()];
                    fromProperties.read(data);
                    ByteBuffer buffer = ByteBuffer.wrap(data);
                    buffer.order(ByteOrder.LITTLE_ENDIAN);
                    this.indexMap.put(event.getPath().toString() + File.separator + event.getName(), buffer);
                    return;
                }
                fromProperties = event.getStream();
                byte[] data = new byte[fromProperties.available()];
                fromProperties.read(data);
                ByteBuffer buffer = ByteBuffer.wrap(data);
                this.streamMap.put(event.getPath().toString() + File.separator + event.getName(), new MemoryResidentStream(buffer));
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void processDirectoryEnd() {
            this.classStack.remove(0);
            this.likelyParent = this.classStack.size() > 0 ? this.classStack.get(0) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private MetadataObject decodeProperties(ByteBuffer buffer, String eventPath) {
            code = buffer.get();
            if (code == 76) {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                buffer.order(ByteOrder.BIG_ENDIAN);
            }
            formatVersion = buffer.get();
            count = buffer.getShort();
            if (this.likelyParent == null) {
                if (!eventPath.equals(File.separator)) {
                    System.err.println("Cannot decode null class definition for path " + eventPath + ".");
                }
                return null;
            }
            mdObject = this.likelyParent.createInstance();
            if (!Warehouse.lookForClass(mdObject.getClass()).getAUID().equals(this.likelyParent.getAUID())) {
                plugin = new ApplicationPluginObjectImpl();
                plugin.setApplicationPluginInstanceID(Forge.randomAUID());
                plugin.setBaseClass(Warehouse.lookForClass(mdObject.getClass()));
                plugin.setObjectClass(this.likelyParent);
                plugin.setApplicationScheme(Warehouse.lookupExtensionScheme(this.likelyParent.getNamespace()));
                if (mdObject instanceof InterchangeObject) {
                    ((InterchangeObject)mdObject).addApplicationPlugin(plugin);
                }
            }
            lengths = new int[count];
            properties = new PropertyDefinition[count];
            for (x = 0; x < count; ++x) {
                propertyID = buffer.getShort();
                storedForm = buffer.getShort();
                lengths[x] = buffer.getShort();
                property = null;
                try {
                    property = propertyID > 0 ? this.likelyParent.lookupPropertyDefinition(propertyID) : this.extensionPropertyMap.get(propertyID);
                    properties[x] = property;
                    continue;
                }
                catch (BadParameterException bpe) {
                    System.err.println("Encountered a non-existent property with code " + propertyID + " for class " + this.likelyParent.getName() + ".");
                }
            }
            localResolutions = new Vector<ResolutionEntry>();
            block28: for (x = 0; x < count; ++x) {
                buffer.limit(buffer.position() + lengths[x]);
                try {
                    if (properties[x] == null) {
                        System.err.println("Unexpetedly encountered a null property for class " + this.likelyParent.getName() + " index " + x + ".");
                        continue;
                    }
                    propertyType = properties[x].getTypeDefinition();
                    if (propertyType == null) {
                        System.err.println("Found an unknown type definition for property " + properties[x].getMemberOf().getName() + "." + properties[x].getName() + ".");
                        continue;
                    }
                    switch (1.$SwitchMap$tv$amwa$maj$enumeration$TypeCategory[propertyType.getTypeCategory().ordinal()]) {
                        case 2: {
                            weakReferenceValue = propertyType.createFromBytes(buffer);
                            localResolutions.add(new ResolutionEntry(properties[x], mdObject, (AUID)weakReferenceValue.getValue()));
                            ** break;
lbl55:
                            // 1 sources

                            continue block28;
                        }
                        case 4: {
                            arrayElementType = ((TypeDefinitionVariableArray)propertyType).getType();
                            switch (1.$SwitchMap$tv$amwa$maj$enumeration$TypeCategory[arrayElementType.getTypeCategory().ordinal()]) {
                                case 1: 
                                case 2: {
                                    referenceName = TypeDefinitions.UTF16String.createFromBytes(buffer).getValue().toString();
                                    localResolutions.add(new ResolutionEntry(properties[x], mdObject, eventPath + File.separator + referenceName));
                                    ** break;
lbl64:
                                    // 1 sources

                                    continue block28;
                                }
                                case 3: {
                                    stringElements = LocalAAFEventReader.bufferToStringList(buffer);
                                    stringListValue = propertyType.createValue(stringElements);
                                    properties[x].setPropertyValue(mdObject, stringListValue);
                                    ** break;
lbl70:
                                    // 1 sources

                                    continue block28;
                                }
                            }
                            arrayValues = new Vector<PropertyValue>();
                            while (buffer.hasRemaining()) {
                                arrayValues.add(arrayElementType.createFromBytes(buffer));
                            }
                            listValue = propertyType.createValue(arrayValues);
                            properties[x].setPropertyValue(mdObject, listValue);
                            ** break;
lbl79:
                            // 1 sources

                            continue block28;
                        }
                        case 5: {
                            setElementType = ((TypeDefinitionSet)propertyType).getElementType();
                            switch (1.$SwitchMap$tv$amwa$maj$enumeration$TypeCategory[setElementType.getTypeCategory().ordinal()]) {
                                case 1: 
                                case 2: {
                                    referenceName = TypeDefinitions.UTF16String.createFromBytes(buffer).getValue().toString();
                                    localResolutions.add(new ResolutionEntry(properties[x], mdObject, eventPath + File.separator + referenceName));
                                    ** break;
lbl88:
                                    // 1 sources

                                    continue block28;
                                }
                                case 3: {
                                    stringElements = LocalAAFEventReader.bufferToStringList(buffer);
                                    stringListValue = propertyType.createValue(stringElements);
                                    properties[x].setPropertyValue(mdObject, stringListValue);
                                    ** break;
lbl94:
                                    // 1 sources

                                    continue block28;
                                }
                            }
                            arrayValues = new HashSet<PropertyValue>();
                            while (buffer.hasRemaining()) {
                                arrayValues.add(setElementType.createFromBytes(buffer));
                            }
                            listValue = propertyType.createValue(arrayValues);
                            properties[x].setPropertyValue(mdObject, listValue);
                            ** break;
lbl103:
                            // 1 sources

                            continue block28;
                        }
                        case 1: {
                            referenceName = TypeDefinitions.UTF16String.createFromBytes(buffer).getValue().toString();
                            localResolutions.add(new ResolutionEntry(properties[x], mdObject, eventPath + File.separator + referenceName));
                            ** break;
lbl109:
                            // 1 sources

                            continue block28;
                        }
                        case 6: {
                            if (!buffer.hasRemaining()) {
                                System.err.println("Found a stream with no data at path " + eventPath + ".");
                                ** break;
lbl114:
                                // 1 sources

                                continue block28;
                            }
                            streamByteOrder = buffer.get() == 108 ? tv.amwa.maj.enumeration.ByteOrder.Little : tv.amwa.maj.enumeration.ByteOrder.Big;
                            streamReferenceName = eventPath + File.separator + TypeDefinitions.UTF16String.createFromBytes(buffer).getValue().toString();
                            this.resolutions.add(new ResolutionEntry(properties[x], mdObject, streamReferenceName, streamByteOrder));
                            ** break;
lbl120:
                            // 1 sources

                            continue block28;
                        }
                        case 7: {
                            localCode = buffer.get();
                            preserveOrder = buffer.order();
                            if (localCode == 76) {
                                buffer.order(ByteOrder.LITTLE_ENDIAN);
                            } else {
                                buffer.order(ByteOrder.BIG_ENDIAN);
                            }
                            indirectValue = TypeDefinitions.Indirect.createFromBytes(buffer);
                            buffer.order(preserveOrder);
                            properties[x].setPropertyValue(mdObject, indirectValue);
                            ** break;
lbl135:
                            // 1 sources

                            continue block28;
                        }
                        default: {
                            theValue = propertyType.createFromBytes(buffer);
                            properties[x].setPropertyValue(mdObject, theValue);
                            continue block28;
                        }
                    }
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (EndOfDataException e) {
                    e.printStackTrace();
                    continue;
                }
                finally {
                    buffer.position(buffer.limit());
                }
            }
            if (mdObject instanceof MetaDictionary) {
                return null;
            }
            if (mdObject instanceof MetaDefinition) {
                if (mdObject instanceof PropertyDefinition) {
                    propertyDefinition = (PropertyDefinition)mdObject;
                    if (!Warehouse.isKnownProperty(propertyDefinition)) {
                        propertyDefinition.setNamespace(this.thisScheme.getSchemeURI());
                        propertyDefinition.setPrefix(this.thisScheme.getPreferredPrefix());
                        propertyDefinition.setSymbol(Utilities.makeSymbol(propertyDefinition.getName()));
                        Warehouse.register(propertyDefinition);
                        this.thisScheme.addMetaDefinition(propertyDefinition);
                    }
                    this.addExtensionProperty((PropertyDefinition)mdObject);
                }
                if (mdObject instanceof ClassDefinition && Warehouse.lookForClass((classDefinition = (ClassDefinition)mdObject).getAUID()) == null) {
                    classDefinition.setNamespace(this.thisScheme.getSchemeURI());
                    classDefinition.setPrefix(this.thisScheme.getPreferredPrefix());
                    Warehouse.register(classDefinition);
                    this.thisScheme.addMetaDefinition(classDefinition);
                }
                if (mdObject instanceof TypeDefinition && Warehouse.lookForType((typeDefinition = (TypeDefinition)mdObject).getAUID()) == null) {
                    Warehouse.register(typeDefinition, this.thisScheme.getSchemeURI(), this.thisScheme.getPreferredPrefix());
                    this.thisScheme.addMetaDefinition(typeDefinition);
                }
            } else if (mdObject instanceof WeakReferenceTarget) {
                WeakReference.registerTarget((WeakReferenceTarget)mdObject);
            }
            this.resolutions.addAll(localResolutions);
            return mdObject;
        }

        private void addExtensionProperty(PropertyDefinition property) {
            short propertyPid = property.getLocalIdentification();
            if (propertyPid < 1 && Warehouse.isKnownProperty(property)) {
                this.extensionPropertyMap.put(propertyPid, ClassDefinitionImpl.globalPropertyIDLookup(property.getAUID()));
            }
        }

        private static String pad(int i, int space) {
            StringBuffer buffer = new StringBuffer(Integer.toHexString(i));
            while (buffer.length() < space) {
                buffer.insert(0, '0');
            }
            return buffer.toString();
        }

        private static final List<String> bufferToStringList(ByteBuffer buffer) {
            Vector<String> stringElements = new Vector<String>();
            StringBuffer stringElement = new StringBuffer();
            while (buffer.hasRemaining() && buffer.remaining() != 1) {
                char nextChar = buffer.getChar();
                if (nextChar == '\u0000') {
                    stringElements.add(stringElement.toString());
                    stringElement = new StringBuffer();
                    continue;
                }
                stringElement.append(nextChar);
            }
            return stringElements;
        }

        @Override
        public void resolveEntries() {
            if (this.resolvedPreface != null) {
                ByteOrder order = this.resolvedPreface.getByteOrder() == tv.amwa.maj.enumeration.ByteOrder.Big ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
                for (ByteBuffer indexBuffer : this.indexMap.values()) {
                    indexBuffer.order(order);
                }
            }
            for (ResolutionEntry resolvable : this.resolutions) {
                resolvable.resolve(this.pathMap, this.indexMap, this.streamMap);
            }
        }

        public void resolveMetaDictionary() {
            for (String path : this.pathMap.keySet()) {
                MetadataObject item = this.pathMap.get(path);
                if (item instanceof MetadataObject && !this.thisScheme.containsMetaDefinition((MetaDefinition)item)) continue;
                if (item instanceof PropertyDefinition) {
                    MetadataObject memberClassItem;
                    PropertyDefinition propertyDefinition = (PropertyDefinition)item;
                    int lastSlash = path.lastIndexOf(File.separatorChar);
                    if (lastSlash < 0 || (memberClassItem = this.pathMap.get(path.substring(0, lastSlash))) == null || !(memberClassItem instanceof ClassDefinition)) continue;
                    ClassDefinition memberClass = Warehouse.lookForClass(((ClassDefinition)memberClassItem).getAUID());
                    if (memberClass == null) {
                        memberClass = (ClassDefinition)memberClassItem;
                    }
                    if (this.thisScheme.containsMetaDefinition(memberClass)) {
                        ((ClassDefinitionImpl)memberClass).addPropertyDefinition(propertyDefinition);
                    }
                    try {
                        propertyDefinition.getMemberOf();
                    }
                    catch (PropertyNotPresentException pnpe) {
                        propertyDefinition.setMemberOf(memberClass);
                    }
                    continue;
                }
                if (!(item instanceof ClassDefinition)) continue;
                ClassDefinition classDefinition = (ClassDefinition)item;
                try {
                    classDefinition.getParent();
                }
                catch (NullPointerException nullPointerException) {
                    for (ResolutionEntry resolution : this.resolutions) {
                        if (!classDefinition.equals(resolution.getTarget()) || !resolution.getProperty().getAUID().equals(CommonConstants.ParentClassID)) continue;
                        resolution.resolve(this.pathMap, this.indexMap, this.streamMap);
                        classDefinition.setJavaImplementation(classDefinition.getParent().getJavaImplementation());
                    }
                }
            }
        }

        @Override
        public Preface getPreface() {
            return this.resolvedPreface;
        }

        @Override
        public ExtensionScheme getThisExtensionScheme() {
            return this.thisScheme;
        }

        @Override
        public void setFilePath(File filePath) throws NullPointerException, IOException {
            if (filePath == null) {
                throw new NullPointerException("Cannot set the file path using a null value.");
            }
            this.canonicalFilePath = filePath.getCanonicalPath();
        }
    }
}

