/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.enumeration.EdgeType;
import tv.amwa.maj.enumeration.FilmType;
import tv.amwa.maj.exception.BadLengthException;
import tv.amwa.maj.exception.BadSizeException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.misctype.PositionType;
import tv.amwa.maj.model.EdgeCodeSegment;
import tv.amwa.maj.model.impl.DataDefinitionImpl;
import tv.amwa.maj.model.impl.SegmentImpl;
import tv.amwa.maj.record.EdgeCodeValue;
import tv.amwa.maj.record.impl.EdgeCodeValueImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=1024, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="EdgeCode", description="The Edgecode class stores film edge code information.", symbol="EdgeCode")
public class EdgeCodeSegmentImpl
extends SegmentImpl
implements EdgeCodeSegment,
Serializable,
Cloneable {
    private static final long serialVersionUID = -7363833585850894685L;
    private FilmType edgeCodeFilmFormat;
    private EdgeType edgeCodeFormat;
    private long edgeCodeStart;
    private byte[] edgeCodeHeader = null;

    public EdgeCodeSegmentImpl() {
    }

    public EdgeCodeSegmentImpl(long length, EdgeCodeValue edgecode) throws NullPointerException, BadLengthException, BadSizeException {
        if (edgecode == null) {
            throw new NullPointerException("Cannot create a new edgecode segment from a null edgecode value.");
        }
        this.setComponentDataDefinition(DataDefinitionImpl.forIdentification(DataDefinitionImpl.Edgecode));
        this.setLengthPresent(true);
        this.setComponentLength(length);
        this.setEdgecode(edgecode);
    }

    @Override
    public EdgeCodeValue getEdgecode() {
        EdgeCodeValueImpl edgeCodeValue = new EdgeCodeValueImpl(this.edgeCodeStart, this.edgeCodeFilmFormat, this.edgeCodeFormat);
        if (this.edgeCodeHeader != null) {
            edgeCodeValue.setEdgeCodeHeader(this.edgeCodeHeader);
        }
        return edgeCodeValue;
    }

    void setEdgecode(EdgeCodeValue edgecode) throws NullPointerException, BadSizeException {
        if (edgecode == null) {
            throw new NullPointerException("Cannot set the edgecode value of this edgecode segment using a null value.");
        }
        try {
            if (edgecode.getEdgeCodeHeader().length > 8) {
                throw new BadSizeException("Cannot use an edgecode value with a header larger than 8 bytes.");
            }
            this.edgeCodeHeader = edgecode.getEdgeCodeHeader();
        }
        catch (PropertyNotPresentException pnpe) {
            this.edgeCodeHeader = null;
        }
        this.edgeCodeStart = edgecode.getEdgeCodeStart();
        this.edgeCodeFilmFormat = edgecode.getEdgeCodeFilmFormat();
        this.edgeCodeFormat = edgecode.getEdgeCodeFormat();
    }

    @Override
    @MediaProperty(uuid1=68157699, uuid2=265, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="EdgeCodeFilmFormat", aliases={"FilmKind", "FilmFormat"}, typeName="FilmType", optional=false, uniqueIdentifier=false, pid=1026, symbol="EdgeCodeFilmFormat")
    public FilmType getEdgeCodeFilmFormat() {
        return this.edgeCodeFilmFormat;
    }

    @MediaPropertySetter(value="EdgeCodeFilmFormat")
    public void setEdgeCodeFilmFormat(FilmType edgeCodeFilmFormat) throws NullPointerException {
        if (edgeCodeFilmFormat == null) {
            throw new NullPointerException("Cannot set the film kind of this edgecode segment with a null value.");
        }
        this.edgeCodeFilmFormat = edgeCodeFilmFormat;
    }

    public static final FilmType initializeEdgeCodeFilmFormat() {
        return FilmType.FtNull;
    }

    @Override
    @MediaProperty(uuid1=68157699, uuid2=258, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="EdgeCodeFormat", aliases={"CodeFormat"}, typeName="EdgeType", optional=false, uniqueIdentifier=false, pid=1027, symbol="EdgeCodeFormat")
    public EdgeType getEdgeCodeFormat() {
        return this.edgeCodeFormat;
    }

    @MediaPropertySetter(value="EdgeCodeFormat")
    public void setEdgeCodeFormat(EdgeType edgeCodeFormat) throws NullPointerException {
        if (edgeCodeFormat == null) {
            throw new NullPointerException("Cannot set the code format of this digital image descriptor to a null value.");
        }
        this.edgeCodeFormat = edgeCodeFormat;
    }

    public static final EdgeType initializeEdgeCodeFormat() {
        return EdgeType.Null;
    }

    @Override
    @MediaProperty(uuid1=16974337, uuid2=512, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="EdgeCodeHeader", aliases={"Header"}, typeName="DataValue", optional=true, uniqueIdentifier=false, pid=1028, symbol="EdgeCodeHeader")
    public byte[] getEdgeCodeHeader() throws PropertyNotPresentException {
        if (this.edgeCodeHeader == null) {
            throw new PropertyNotPresentException("The optional edge code header is not present for this edge code segment.");
        }
        return (byte[])this.edgeCodeHeader.clone();
    }

    @Override
    public String getEdgeCodeHeaderAsString() {
        return this.getEdgecode().getEdgeCodeHeaderAsString();
    }

    @MediaPropertySetter(value="EdgeCodeHeader")
    public void setEdgeCodeHeader(byte[] edgeCodeHeader) throws BadSizeException {
        if (edgeCodeHeader == null) {
            this.edgeCodeHeader = null;
            return;
        }
        if (edgeCodeHeader.length > 8) {
            throw new BadSizeException("An edgcode header can only contain a maximum of 8 bytes.");
        }
        this.edgeCodeHeader = (byte[])edgeCodeHeader.clone();
    }

    @MediaPropertyClear(value="EdgeCodeHeader")
    public void clearEdgeCodeHeader() {
        this.edgeCodeHeader = null;
    }

    @Override
    @MediaProperty(uuid1=17041665, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="EdgeCodeStart", aliases={"Start"}, typeName="PositionType", optional=false, uniqueIdentifier=false, pid=1025, symbol="EdgeCodeStart")
    public long getEdgeCodeStart() {
        return this.edgeCodeStart;
    }

    @MediaPropertySetter(value="EdgeCodeStart")
    public void setEdgeCodeStart(@PositionType long startFrame) {
        this.edgeCodeStart = startFrame;
    }

    public static final long initializeEdgeCodeStart() {
        return 0L;
    }

    @Override
    public EdgeCodeSegment clone() {
        return (EdgeCodeSegment)super.clone();
    }
}

