/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import tv.amwa.maj.enumeration.FadeType;
import tv.amwa.maj.exception.BadLengthException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.extensions.quantel.QCompositionPackage;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaListAppend;
import tv.amwa.maj.industry.MediaListGetAt;
import tv.amwa.maj.industry.MediaListPrepend;
import tv.amwa.maj.industry.MediaListRemoveAt;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.Stream;
import tv.amwa.maj.industry.StrongReferenceVector;
import tv.amwa.maj.integer.Int32;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.model.CompositionPackage;
import tv.amwa.maj.model.OperationGroup;
import tv.amwa.maj.model.Segment;
import tv.amwa.maj.model.impl.PackageImpl;
import tv.amwa.maj.record.PackageID;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.impl.PackageIDImpl;
import tv.amwa.maj.record.impl.RationalImpl;
import tv.amwa.maj.record.impl.TimeStampImpl;
import tv.amwa.maj.union.DefaultFade;
import tv.amwa.maj.union.impl.DefaultFadeImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=13568, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="CompositionPackage", aliases={"CompositionMob"}, description="The CompositionPackage class specifies how to combine essence elements into a sequence, how to modify essence elements, and how to synchronize essence elements.", symbol="CompositionPackage")
public class CompositionPackageImpl
extends PackageImpl
implements CompositionPackage,
QCompositionPackage,
Serializable,
Cloneable {
    private static final long serialVersionUID = -4329286298868156956L;
    private long defaultFadeLength = 0L;
    private FadeType defaultFadeType = null;
    private Rational defaultFadeEditUnit = null;
    private PackageID compositionRendering = null;
    private Integer clipFPS = null;
    private String clipType = null;
    private String clipProject = null;
    private Integer clipModifiedYears = null;
    private Integer clipModifiedMonths = null;
    private Integer clipModifiedDays = null;
    private Integer clipModifiedHours = null;
    private Integer clipModifiedMinutes = null;
    private Integer clipModifiedSeconds = null;
    private Integer clipModifiedMilliseconds = null;
    private Integer clipAudioTracks = null;
    private Integer archiveCompositionType = null;
    private Segment clipKeyRenderSequence = null;
    private List<OperationGroup> clipEffects = Collections.synchronizedList(new Vector());
    private Integer clipDropframe = null;
    private Integer clipDuration = null;
    private Integer clipWidth = null;
    private Integer clipHeight = null;
    private Integer clipVideoTracks = null;
    private Stream clipBlob = null;
    private PropertyValue clipColourGreen = null;
    private PropertyValue clipColourRed = null;
    private PropertyValue clipColourBlue = null;
    private Integer clipArchivedYears = null;
    private Integer clipArchivedMonths = null;
    private Integer clipArchivedDays = null;
    private Integer clipArchivedHours = null;
    private Integer clipArchivedMinutes = null;
    private Integer clipArchivedSeconds = null;
    private Integer clipArchivedMilliseconds = null;
    private Integer clipInPoint = null;
    private Integer clipOutPoint = null;
    private Segment clipRenderSequence = null;
    private Integer clipDestTC = null;
    private Integer archiveSetting = null;
    private Integer clipFlag1001 = null;
    private Integer archiveComposition = null;
    private String clipCategory = null;
    private String clipOwner = null;

    public CompositionPackageImpl() {
    }

    public CompositionPackageImpl(PackageID packageID, @AAFString String name) throws NullPointerException {
        if (packageID == null) {
            throw new NullPointerException("Cannot create a new composition package with a null package id.");
        }
        if (name == null) {
            throw new NullPointerException("Cannot create a new composition package with a null name.");
        }
        this.setPackageID(packageID);
        this.setPackageName(name);
        this.setPackageLastModified(new TimeStampImpl());
        this.setCreationTime(new TimeStampImpl());
    }

    @Override
    public DefaultFade getDefaultFade() throws PropertyNotPresentException {
        if (this.defaultFadeType == null || this.defaultFadeEditUnit == null) {
            throw new PropertyNotPresentException("The optional default fade properties are not present in this composition package.");
        }
        return new DefaultFadeImpl(this.defaultFadeLength, this.defaultFadeType, this.defaultFadeEditUnit);
    }

    @Override
    public void setDefaultFade(long fadeLength, FadeType fadeType, Rational fadeEditUnit) throws BadLengthException {
        if (fadeLength < 0L) {
            throw new BadLengthException("Cannot set the length of a fade to a negative value.");
        }
        this.defaultFadeLength = fadeLength;
        if (fadeType == null || fadeEditUnit == null) {
            this.defaultFadeType = null;
            this.defaultFadeEditUnit = null;
        } else {
            this.defaultFadeType = fadeType;
            this.defaultFadeEditUnit = fadeEditUnit.clone();
        }
    }

    @Override
    public void setDefaultFade(DefaultFade defaultFade) {
        if (defaultFade == null) {
            this.defaultFadeType = null;
            this.defaultFadeEditUnit = null;
            return;
        }
        this.defaultFadeLength = defaultFade.getFadeLength();
        this.defaultFadeType = defaultFade.getFadeType();
        this.defaultFadeEditUnit = defaultFade.getFadeEditUnit().clone();
    }

    @Override
    @MediaProperty(uuid1=117572097, uuid2=261, uuid3=256, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="DefaultFadeLength", aliases={"DefFadeLength"}, typeName="LengthType", optional=true, uniqueIdentifier=false, pid=17665, symbol="DefaultFadeLength")
    public long getDefaultFadeLength() throws PropertyNotPresentException {
        if (this.defaultFadeType == null || this.defaultFadeEditUnit == null) {
            throw new PropertyNotPresentException("The optional default fade properties are not present in this composition package.");
        }
        return this.defaultFadeLength;
    }

    @MediaPropertySetter(value="DefaultFadeLength")
    public void setDefaultFadeLength(Long defaultFadeLength) {
        if (defaultFadeLength == null) {
            this.defaultFadeType = null;
            return;
        }
        this.defaultFadeLength = defaultFadeLength;
    }

    @Override
    @MediaProperty(uuid1=87032321, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="DefaultFadeType", aliases={"DefFadeType"}, typeName="FadeType", optional=true, uniqueIdentifier=false, pid=17666, symbol="DefaultFadeType")
    public FadeType getDefaultFadeType() throws PropertyNotPresentException {
        if (this.defaultFadeType == null || this.defaultFadeEditUnit == null) {
            throw new PropertyNotPresentException("The optional default fade properties are not present in this composition package.");
        }
        return this.defaultFadeType;
    }

    @MediaPropertySetter(value="DefaultFadeType")
    public void setDefaultFadeType(FadeType defaultFadeType) {
        this.defaultFadeType = defaultFadeType;
    }

    @Override
    @MediaProperty(uuid1=87032835, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="DefaultFadeEditUnit", aliases={"DefFadeEditUnit"}, typeName="Rational", optional=true, uniqueIdentifier=false, pid=17667, symbol="DefaultFadeEditUnit")
    public Rational getDefaultFadeEditUnit() throws PropertyNotPresentException {
        if (this.defaultFadeType == null || this.defaultFadeEditUnit == null) {
            throw new PropertyNotPresentException("The optional default fade properties are not present in this composition package.");
        }
        return this.defaultFadeEditUnit.clone();
    }

    @MediaPropertySetter(value="DefaultFadeEditUnit")
    public void setDefaultFadeEditUnit(Rational defaultFadeEditUnit) {
        this.defaultFadeEditUnit = defaultFadeEditUnit == null ? null : defaultFadeEditUnit.clone();
    }

    @Override
    @MediaProperty(uuid1=100729092, uuid2=266, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 8}, definedName="CompositionRendering", aliases={"Rendering", "CompositionMobRendering"}, typeName="PackageIDType", optional=true, uniqueIdentifier=false, pid=17668, symbol="CompositionRendering")
    public PackageID getCompositionRendering() throws PropertyNotPresentException {
        if (this.compositionRendering == null) {
            throw new PropertyNotPresentException("The optional rendering property is not present in this composition package.");
        }
        return this.compositionRendering.clone();
    }

    @Override
    @MediaPropertySetter(value="CompositionRendering")
    public void setCompositionRendering(PackageID packageID) {
        this.compositionRendering = packageID == null ? null : packageID.clone();
    }

    @Override
    @MediaProperty(uuid1=-1581556734, uuid2=3756, uuid3=17263, uuid4={-106, -33, -7, 59, 21, 60, -16, 69}, definedName="Clip fps", symbol="Clip_fps", aliases={"Clip_fps"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipFPS() {
        if (this.clipFPS == null) {
            throw new PropertyNotPresentException("The optional clip FPS property is not present for this Quantel composition package.");
        }
        return this.clipFPS;
    }

    @Override
    @MediaPropertySetter(value="Clip fps")
    public void setClipFPS(@Int32 Integer clipFPS) {
        this.clipFPS = clipFPS;
    }

    @Override
    @MediaProperty(uuid1=-1389450491, uuid2=-13729, uuid3=19185, uuid4={-108, 38, -14, 55, 110, -48, -50, 61}, definedName="Clip type", symbol="Clip_type", aliases={"Clip_type"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public String getClipType() {
        if (this.clipType == null) {
            throw new PropertyNotPresentException("The optional clip type property is not present for this Quantel composition package.");
        }
        return this.clipType;
    }

    @Override
    @MediaPropertySetter(value="Clip type")
    public void setClipType(String clipType) {
        this.clipType = clipType;
    }

    @Override
    @MediaProperty(uuid1=-1474634740, uuid2=10516, uuid3=18197, uuid4={-107, -81, 29, -63, 11, -29, 89, 102}, definedName="Clip project", symbol="Clip_project", aliases={"Clip_project"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public String getClipProject() {
        if (this.clipProject == null) {
            throw new PropertyNotPresentException("The optional clip project property is not present for this Quantel composition package.");
        }
        return this.clipProject;
    }

    @Override
    @MediaPropertySetter(value="Clip project")
    public void setClipProject(String clipProject) {
        this.clipProject = clipProject;
    }

    @Override
    @MediaProperty(uuid1=576408084, uuid2=24356, uuid3=18628, uuid4={-69, -26, -95, 31, 0, 17, -111, -119}, definedName="Clip modified minutes", symbol="Clip_modified_minutes", aliases={"Clip_modified_minutes"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipModifiedMinutes() {
        if (this.clipModifiedMinutes == null) {
            throw new PropertyNotPresentException("The optional clip modified minutes property is not present for this Quantel composition package.");
        }
        return this.clipModifiedMinutes;
    }

    @Override
    @MediaPropertySetter(value="Clip modified minutes")
    public void setClipModifiedMinutes(@Int32 Integer clipModifiedMinutes) {
        this.clipModifiedMinutes = clipModifiedMinutes;
    }

    @Override
    @MediaProperty(uuid1=2039046687, uuid2=27182, uuid3=18081, uuid4={-93, 101, -94, -82, 86, 77, 12, 14}, definedName="Clip modified months", symbol="Clip_modified_months", aliases={"Clip_modified_months"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipModifiedMonths() {
        if (this.clipModifiedMonths == null) {
            throw new PropertyNotPresentException("The optional clip modified months property is not present for this Quantel composition package.");
        }
        return this.clipModifiedMonths;
    }

    @Override
    @MediaPropertySetter(value="Clip modified months")
    public void setClipModifiedMonths(@Int32 Integer clipModifiedMonths) {
        this.clipModifiedMonths = clipModifiedMonths;
    }

    @Override
    @MediaProperty(uuid1=2123909680, uuid2=-18718, uuid3=19766, uuid4={-72, 52, 83, 104, 119, 116, -90, -32}, definedName="Clip audio tracks", symbol="Clip_audio_tracks", aliases={"Clip_audio_tracks"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipAudioTracks() {
        if (this.clipAudioTracks == null) {
            throw new PropertyNotPresentException("The optional clip audio tracks property is not present for this Quantel composition package.");
        }
        return this.clipAudioTracks;
    }

    @Override
    @MediaPropertySetter(value="Clip audio tracks")
    public void setClipAudioTracks(@Int32 Integer clipAudioTracks) {
        this.clipAudioTracks = clipAudioTracks;
    }

    @Override
    @MediaProperty(uuid1=1569365553, uuid2=-10268, uuid3=19501, uuid4={-109, -67, 19, 15, -126, 14, -103, 44}, definedName="Archive composition type", symbol="Archive_composition_type", aliases={"Archive_composition_type"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getArchiveCompositionType() {
        if (this.archiveCompositionType == null) {
            throw new PropertyNotPresentException("The optional archive composition type property is not present for this Quantel composition package.");
        }
        return this.archiveCompositionType;
    }

    @Override
    @MediaPropertySetter(value="Archive composition type")
    public void setArchiveCompositionType(@Int32 Integer archiveCompositionType) {
        this.archiveCompositionType = archiveCompositionType;
    }

    @Override
    @MediaProperty(uuid1=-1450402759, uuid2=16903, uuid3=19212, uuid4={-75, -128, 77, 78, 108, -36, -1, -11}, definedName="Clip key render sequence", symbol="Clip_key_render_sequence", aliases={"Clip_key_render_sequence"}, typeName="SegmentStrongReference", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public Segment getClipKeyRenderSequence() {
        if (this.clipKeyRenderSequence == null) {
            throw new PropertyNotPresentException("The optional clip key render sequence property is not present for this Quantel composition package.");
        }
        return this.clipKeyRenderSequence;
    }

    @Override
    @MediaPropertySetter(value="Clip key render sequence")
    public void setClipKeyRenderSequence(Segment clipKeyRenderSequence) {
        this.clipKeyRenderSequence = clipKeyRenderSequence;
    }

    @Override
    @MediaProperty(uuid1=-1019497411, uuid2=4799, uuid3=19398, uuid4={-68, -19, 64, 71, -10, 26, 14, -119}, definedName="Clip effects", symbol="Clip_effects", aliases={"Clip_effects"}, typeName="OperationGroupStrongReferenceVariableArray", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public List<OperationGroup> getClipEffects() throws PropertyNotPresentException {
        if (this.clipEffects.size() == 0) {
            throw new PropertyNotPresentException("The optional clip effects property is not present for this Quantel composition package.");
        }
        return StrongReferenceVector.getOptionalList(this.clipEffects);
    }

    @Override
    @MediaListAppend(value="Clip effects")
    public void appendClipEffect(OperationGroup clipEffect) throws NullPointerException {
        if (clipEffect == null) {
            throw new NullPointerException("Cannot append a null clip effect to the list of clip effects of this Quantel composition package.");
        }
        StrongReferenceVector.append(this.clipEffects, clipEffect);
    }

    @Override
    @MediaListGetAt(value="Clip effects")
    public OperationGroup getClipEffectAt(int index) throws IndexOutOfBoundsException {
        return StrongReferenceVector.getAt(this.clipEffects, index);
    }

    @Override
    @MediaPropertyClear(value="Clip effects")
    public void clearClipEffects() {
        this.clipEffects.clear();
    }

    @Override
    @MediaPropertyCount(value="Clip effects")
    public int countClipEffects() {
        return this.clipEffects.size();
    }

    @Override
    @MediaListPrepend(value="Clip effects")
    public void prependClipEffect(OperationGroup clipEffect) {
        if (clipEffect == null) {
            throw new NullPointerException("Cannot append a null clip effect to the list of clip effects of this Quantel composition package.");
        }
        StrongReferenceVector.prepend(this.clipEffects, clipEffect);
    }

    @Override
    @MediaListRemoveAt(value="ClipEffects")
    public void removeClipEffectAt(int index) throws IndexOutOfBoundsException {
        StrongReferenceVector.remove(this.clipEffects, index);
    }

    @Override
    @MediaProperty(uuid1=209158207, uuid2=-12659, uuid3=17329, uuid4={-103, -9, 21, 110, -111, 3, 121, -67}, definedName="Clip modified hours", symbol="Clip_modified_hours", aliases={"Clip_modified_hours"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipModifiedHours() {
        if (this.clipModifiedHours == null) {
            throw new PropertyNotPresentException("The optional clip modified hours property is not present for this Quantel composition package.");
        }
        return this.clipModifiedHours;
    }

    @Override
    @MediaPropertySetter(value="Clip modified hours")
    public void setClipModifiedHours(@Int32 Integer clipModifiedHours) {
        this.clipModifiedHours = clipModifiedHours;
    }

    @Override
    @MediaProperty(uuid1=-778629298, uuid2=21522, uuid3=18470, uuid4={-88, -102, 53, 3, -69, 26, 117, 13}, definedName="Clip dropframe", symbol="Clip_dropframe", aliases={"Clip_dropframe"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipDropframe() {
        if (this.clipDropframe == null) {
            throw new PropertyNotPresentException("The optional clip dropframe property is not present for this Quantel composition package.");
        }
        return this.clipDropframe;
    }

    @Override
    @MediaPropertySetter(value="Clip dropframe")
    public void setClipDropframe(@Int32 Integer clipDropframe) {
        this.clipDropframe = clipDropframe;
    }

    @Override
    @MediaProperty(uuid1=-613852076, uuid2=13830, uuid3=18667, uuid4={-119, 36, 77, -126, 21, -31, 84, -79}, definedName="Clip duration", symbol="Clip_duration", aliases={"Clip_duration"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipDuration() {
        if (this.clipDuration == null) {
            throw new PropertyNotPresentException("The optional clip duration property is not present for this Quantel composition package.");
        }
        return this.clipDuration;
    }

    @Override
    @MediaPropertySetter(value="Clip durationClip duration")
    public void setClipDuration(@Int32 Integer clipDuration) {
        this.clipDuration = clipDuration;
    }

    @Override
    @MediaProperty(uuid1=-2079951781, uuid2=15040, uuid3=17378, uuid4={-108, -13, 95, -70, -94, 45, 8, 33}, definedName="Clip modified years", symbol="Clip_modified_years", aliases={"Clip_modified_years"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipModifiedYears() {
        if (this.clipModifiedYears == null) {
            throw new PropertyNotPresentException("The optional clip modified years property is not present for this Quantel composition package.");
        }
        return this.clipModifiedYears;
    }

    @Override
    @MediaPropertySetter(value="Clip modified years")
    public void setClipModifiedYears(@Int32 Integer clipModifiedYears) {
        this.clipModifiedYears = clipModifiedYears;
    }

    @Override
    @MediaProperty(uuid1=-1104073380, uuid2=28761, uuid3=18624, uuid4={-115, 43, 13, -48, 94, -126, 121, -61}, definedName="Clip modified milliseconds", symbol="Clip_modified_milliseconds", aliases={"Clip_modified_milliseconds"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipModifiedMilliseconds() {
        if (this.clipModifiedMilliseconds == null) {
            throw new PropertyNotPresentException("The optional clip modified milliseconds property is not present for this Quantel composition package.");
        }
        return this.clipModifiedMilliseconds;
    }

    @Override
    @MediaPropertySetter(value="Clip modified milliseconds")
    public void setClipModifiedMillseconds(@Int32 Integer clipModifiedMilliseconds) {
        this.clipModifiedMilliseconds = clipModifiedMilliseconds;
    }

    @Override
    @MediaProperty(uuid1=1035201637, uuid2=12400, uuid3=17510, uuid4={-102, 127, -114, 23, 69, -86, 74, 106}, definedName="Clip width", symbol="Clip_width", aliases={"Clip_width"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipWidth() {
        if (this.clipWidth == null) {
            throw new PropertyNotPresentException("The optional clip width property is not present for this Quantel composition package.");
        }
        return this.clipWidth;
    }

    @Override
    @MediaPropertySetter(value="Clip width")
    public void setClipWidth(@Int32 Integer clipWidth) {
        this.clipWidth = clipWidth;
    }

    @Override
    @MediaProperty(uuid1=460627814, uuid2=23282, uuid3=18160, uuid4={-126, -44, 7, -32, -97, 56, 79, -113}, definedName="Clip video tracks", symbol="Clip_video_tracks", aliases={"Clip_video_tracks"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipVideoTracks() {
        if (this.clipVideoTracks == null) {
            throw new PropertyNotPresentException("The optional clip video tracks property is not present for this Quantel composition package.");
        }
        return this.clipVideoTracks;
    }

    @Override
    @MediaPropertySetter(value="Clip video tracks")
    public void setClipVideoTracks(@Int32 Integer clipVideoTracks) {
        this.clipVideoTracks = clipVideoTracks;
    }

    @Override
    @MediaProperty(uuid1=1981868648, uuid2=-5355, uuid3=16478, uuid4={-114, -69, -29, -100, -120, -31, -91, -26}, definedName="Clip blob", symbol="Clip_blob", aliases={"Clip_blob"}, typeName="Stream", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public Stream getClipBlob() {
        if (this.clipBlob == null) {
            throw new PropertyNotPresentException("The optional clip blob property is not present for this Quantel composition package.");
        }
        return this.clipBlob;
    }

    @Override
    @MediaPropertySetter(value="Clip blob")
    public void setClipBlob(Stream clipBlob) {
        this.clipBlob = clipBlob;
    }

    @Override
    @MediaProperty(uuid1=1637900400, uuid2=26590, uuid3=18063, uuid4={-107, -67, -53, -20, -7, -79, 101, -35}, definedName="Clip colour green", symbol="Clip_colour_green", aliases={"Clip_colour_green"}, typeName="Indirect", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public PropertyValue getClipColourGreen() {
        if (this.clipColourGreen == null) {
            throw new PropertyNotPresentException("The optional clip colour green property is not present for this Quantel composition package.");
        }
        return this.clipColourGreen;
    }

    @Override
    @MediaPropertySetter(value="Clip colour green")
    public void setClipColourGreen(PropertyValue clipColourGreen) {
        this.clipColourGreen = clipColourGreen;
    }

    @Override
    @MediaProperty(uuid1=456269940, uuid2=-17444, uuid3=17404, uuid4={-103, 5, -85, -128, -58, -70, 1, -83}, definedName="Clip archived years", symbol="Clip_archived_years", aliases={"Clip_archived_years"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipArchivedYears() {
        if (this.clipArchivedYears == null) {
            throw new PropertyNotPresentException("The optional clip archived years property is not present for this Quantel composition package.");
        }
        return this.clipArchivedYears;
    }

    @Override
    @MediaPropertySetter(value="Clip archived years")
    public void setClipArchivedYears(@Int32 Integer clipArchivedYears) {
        this.clipArchivedYears = clipArchivedYears;
    }

    @Override
    @MediaProperty(uuid1=159516281, uuid2=-1679, uuid3=18243, uuid4={-79, -73, -89, -26, -62, -103, -47, 86}, definedName="Clip height", symbol="Clip_height", aliases={"Clip_height"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipHeight() {
        if (this.clipHeight == null) {
            throw new PropertyNotPresentException("The optional clip height property is not present for this Quantel composition package.");
        }
        return this.clipHeight;
    }

    @Override
    @MediaPropertySetter(value="Clip height")
    public void setClipHeight(@Int32 Integer clipHeight) {
        this.clipHeight = clipHeight;
    }

    @Override
    @MediaProperty(uuid1=-1753807224, uuid2=-12320, uuid3=18337, uuid4={-81, -63, 122, 56, 69, 70, 94, -76}, definedName="Clip in point", symbol="Clip_in_point", aliases={"Clip_in_point"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipInPoint() {
        if (this.clipInPoint == null) {
            throw new PropertyNotPresentException("The optional clip in point property is not present for this Quantel composition package.");
        }
        return this.clipInPoint;
    }

    @Override
    @MediaPropertySetter(value="Clip in point")
    public void setClipInPoint(@Int32 Integer clipInPoint) {
        this.clipInPoint = clipInPoint;
    }

    @Override
    @MediaProperty(uuid1=1263851673, uuid2=288, uuid3=19336, uuid4={-113, -19, 31, 92, 56, 48, 121, 52}, definedName="Clip archived hours", symbol="Clip_archived_hours", aliases={"Clip_archived_hours"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipArchivedHours() {
        if (this.clipArchivedHours == null) {
            throw new PropertyNotPresentException("The optional clip archived hours property is not present for this Quantel composition package.");
        }
        return this.clipArchivedHours;
    }

    @Override
    @MediaPropertySetter(value="Clip archived hours")
    public void setClipArchivedHours(@Int32 Integer clipArchivedHours) {
        this.clipArchivedHours = clipArchivedHours;
    }

    @Override
    @MediaProperty(uuid1=1719601825, uuid2=12999, uuid3=17809, uuid4={-80, -50, -35, 87, -14, 3, 72, 88}, definedName="Clip archived months", symbol="Clip_archived_months", aliases={"Clip_archived_months"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipArchivedMonths() {
        if (this.clipArchivedMonths == null) {
            throw new PropertyNotPresentException("The optional clipa archived months property is not present for this Quantel composition package.");
        }
        return this.clipArchivedMonths;
    }

    @Override
    @MediaPropertySetter(value="Clip archived months")
    public void setClipArchivedMonths(@Int32 Integer clipArchivedMonths) {
        this.clipArchivedMonths = clipArchivedMonths;
    }

    @Override
    @MediaProperty(uuid1=-1668525915, uuid2=20084, uuid3=18490, uuid4={-115, 19, 27, 116, 41, 66, 117, 63}, definedName="Clip render sequence", symbol="Clip_render_sequence", aliases={"Clip_render_sequence"}, typeName="SegmentStrongReference", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public Segment getClipRenderSequence() {
        if (this.clipRenderSequence == null) {
            throw new PropertyNotPresentException("The optional clip render sequence property is not present for this Quantel composition package.");
        }
        return this.clipRenderSequence;
    }

    @Override
    @MediaPropertySetter(value="Clip render sequence")
    public void setClipRenderSequence(Segment clipRenderSequence) {
        this.clipRenderSequence = clipRenderSequence;
    }

    @Override
    @MediaProperty(uuid1=1860221869, uuid2=-32293, uuid3=18813, uuid4={-65, 59, 90, 29, -54, -100, 101, -53}, definedName="Clip archived minutes", symbol="Clip_archived_minutes", aliases={"Clip_archived_minutes"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipArchivedMinutes() {
        if (this.clipArchivedMinutes == null) {
            throw new PropertyNotPresentException("The optional clip archived minutes property is not present for this Quantel composition package.");
        }
        return this.clipArchivedMinutes;
    }

    @Override
    @MediaPropertySetter(value="Clip archived minutes")
    public void setClipArchivedMinutes(@Int32 Integer clipArchivedMinutes) {
        this.clipArchivedMinutes = clipArchivedMinutes;
    }

    @Override
    @MediaProperty(uuid1=-401965137, uuid2=-19202, uuid3=17982, uuid4={-107, 7, 6, -57, -69, -77, 25, -108}, definedName="Clip colour red", symbol="Clip_colour_red", aliases={"Clip_colour_red"}, typeName="Indirect", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public PropertyValue getClipColourRed() {
        if (this.clipColourRed == null) {
            throw new PropertyNotPresentException("The optional clip colour red property is not present for this Quantel composition package.");
        }
        return this.clipColourRed;
    }

    @Override
    @MediaPropertySetter(value="Clip colour red")
    public void setClipColourRed(PropertyValue clipColourRed) {
        this.clipColourRed = clipColourRed;
    }

    @Override
    @MediaProperty(uuid1=-1875158083, uuid2=-24754, uuid3=20081, uuid4={-102, -65, 36, -100, 105, -103, -44, 117}, definedName="Clip modified days", symbol="Clip_modified_days", aliases={"Clip_modified_days"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipModifiedDays() {
        if (this.clipModifiedDays == null) {
            throw new PropertyNotPresentException("The optional clip modified days property is not present for this Quantel composition package.");
        }
        return this.clipModifiedDays;
    }

    @Override
    @MediaPropertySetter(value="Clip modified days")
    public void setClipModifiedDays(@Int32 Integer clipModifiedDays) {
        this.clipModifiedDays = clipModifiedDays;
    }

    @Override
    @MediaProperty(uuid1=114416585, uuid2=330, uuid3=20194, uuid4={-113, 32, 75, 49, 22, -65, -85, 21}, definedName="Clip modified seconds", symbol="Clip_modified_seconds", aliases={"Clip_modified_seconds"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipModifiedSeconds() {
        if (this.clipModifiedSeconds == null) {
            throw new PropertyNotPresentException("The optional clip modified seconds property is not present for this Quantel composition package.");
        }
        return this.clipModifiedSeconds;
    }

    @Override
    @MediaPropertySetter(value="Clip modified seconds")
    public void setClipModifiedSeconds(@Int32 Integer clipModifiedSeconds) {
        this.clipModifiedSeconds = clipModifiedSeconds;
    }

    @Override
    @MediaProperty(uuid1=-1097602103, uuid2=-14513, uuid3=18096, uuid4={-102, -31, 91, 60, -70, -3, 25, 103}, definedName="Clip dest tc", symbol="Clip_dest_tc", aliases={"Clip_dest_tc"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipDestTC() {
        if (this.clipDestTC == null) {
            throw new PropertyNotPresentException("The optional clip dest TC property is not present for this Quantel composition package.");
        }
        return this.clipDestTC;
    }

    @Override
    @MediaPropertySetter(value="Clip dest tc")
    public void setClipDestTC(@Int32 Integer clipDestTC) {
        this.clipDestTC = clipDestTC;
    }

    @Override
    @MediaProperty(uuid1=654856652, uuid2=-17038, uuid3=16901, uuid4={-121, 5, -43, -115, -21, -67, 25, -112}, definedName="Clip archived days", symbol="Clip_archived_days", aliases={"Clip_archived_days"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipArchivedDays() {
        if (this.clipArchivedDays == null) {
            throw new PropertyNotPresentException("The optional clip archived days property is not present for this Quantel composition package.");
        }
        return this.clipArchivedDays;
    }

    @Override
    @MediaPropertySetter(value="Clip archived days")
    public void setClipArchivedDays(@Int32 Integer clipArchivedDays) {
        this.clipArchivedDays = clipArchivedDays;
    }

    @Override
    @MediaProperty(uuid1=672861661, uuid2=-324, uuid3=18969, uuid4={-65, -26, 9, -36, 71, 84, 52, -112}, definedName="Clip colour blue", symbol="Clip_colour_blue", aliases={"Clip_colour_blue"}, typeName="Indirect", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public PropertyValue clipColourBlue() throws PropertyNotPresentException {
        if (this.clipColourBlue == null) {
            throw new PropertyNotPresentException("The optional clip colour blue property is not present for this Quantel composition package.");
        }
        return this.clipColourBlue;
    }

    @Override
    @MediaPropertySetter(value="Clip colour blue")
    public void setClipColourBlue(PropertyValue clipColourBlue) {
        this.clipColourBlue = clipColourBlue;
    }

    @Override
    @MediaProperty(uuid1=355409374, uuid2=-27114, uuid3=19778, uuid4={-76, 22, 69, -114, -76, 57, 102, 19}, definedName="Archive setting", symbol="Archive_setting", aliases={"Archive_setting"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getArchiveSetting() {
        if (this.archiveSetting == null) {
            throw new PropertyNotPresentException("The optional archive setting property is not present for this Quantel composition package.");
        }
        return this.archiveSetting;
    }

    @Override
    @MediaPropertySetter(value="Archive setting")
    public void setArchiveSetting(@Int32 Integer archiveSetting) {
        this.archiveSetting = archiveSetting;
    }

    @Override
    @MediaProperty(uuid1=-1476062751, uuid2=-408, uuid3=17464, uuid4={-65, -28, -22, 38, 120, -2, 50, 59}, definedName="Clip archived seconds", symbol="Clip_archived_seconds", aliases={"Clip_archived_seconds"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipArchivedSeconds() {
        if (this.clipArchivedSeconds == null) {
            throw new PropertyNotPresentException("The optional clip archived seconds property is not present for this Quantel composition package.");
        }
        return this.clipArchivedSeconds;
    }

    @Override
    @MediaPropertySetter(value="Clip archived seconds")
    public void setClipArchivedSeconds(@Int32 Integer clipArchivedSeconds) {
        this.clipArchivedSeconds = clipArchivedSeconds;
    }

    @Override
    @MediaProperty(uuid1=-429142044, uuid2=-19983, uuid3=18769, uuid4={-114, -5, -128, 115, 19, -27, -2, -65}, definedName="Clip out point", symbol="Clip_out_point", aliases={"Clip_out_point"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipOutPoint() {
        if (this.clipOutPoint == null) {
            throw new PropertyNotPresentException("The optional clip out point property is not present for this Quantel composition package.");
        }
        return this.clipOutPoint;
    }

    @Override
    @MediaPropertySetter(value="Clip out point")
    public void setClipOutPoint(@Int32 Integer clipOutPoint) {
        this.clipOutPoint = clipOutPoint;
    }

    @Override
    @MediaProperty(uuid1=-1980515865, uuid2=-28875, uuid3=18341, uuid4={-127, -102, -46, 18, -127, 64, -62, -69}, definedName="Clip flag1001", symbol="Clip_flag1001", aliases={"Clip_flag1001"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipFlag1001() {
        if (this.clipFlag1001 == null) {
            throw new PropertyNotPresentException("The optional clip flag 1001 property is not present for this Quantel composition package.");
        }
        return this.clipFlag1001;
    }

    @Override
    @MediaPropertySetter(value="Clip flag1001")
    public void setClipFlag1001(@Int32 Integer clipFlag1001) {
        this.clipFlag1001 = clipFlag1001;
    }

    @Override
    @MediaProperty(uuid1=632708080, uuid2=-30209, uuid3=18979, uuid4={-75, -40, 60, -126, -26, -4, -62, 58}, definedName="Clip archived milliseconds", symbol="Clip_archived_milliseconds", aliases={"Clip_archived_milliseconds"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getClipArchivedMilliseconds() {
        if (this.clipArchivedMilliseconds == null) {
            throw new PropertyNotPresentException("The optional clip archived milliseconds property is not present for this Quantel composition package.");
        }
        return this.clipArchivedMilliseconds;
    }

    @Override
    @MediaPropertySetter(value="Clip archived milliseconds")
    public void setClipArchivedMilliseconds(@Int32 Integer clipArchivedMilliseconds) {
        this.clipArchivedMilliseconds = clipArchivedMilliseconds;
    }

    @Override
    @MediaProperty(uuid1=1933828085, uuid2=-26685, uuid3=18144, uuid4={-100, -53, 84, 55, 72, 10, -82, 42}, definedName="Archive composition", symbol="Archive_composition", aliases={"Archive_composition"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getArchiveComposition() {
        if (this.archiveComposition == null) {
            throw new PropertyNotPresentException("The optional archive composition property is not present for this Quantel composition package.");
        }
        return this.archiveComposition;
    }

    @Override
    @MediaPropertySetter(value="Archive composition")
    public void setArchiveComposition(@Int32 Integer archiveComposition) {
        this.archiveComposition = archiveComposition;
    }

    @Override
    @MediaProperty(uuid1=675586806, uuid2=-2467, uuid3=20109, uuid4={-72, -36, 113, -41, 45, 64, -117, 117}, definedName="Clip category", symbol="Clip_category", aliases={"Clip_category"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public String getClipCategory() {
        if (this.clipCategory == null) {
            throw new PropertyNotPresentException("The optional clip category property is not present for this Quantel composition package.");
        }
        return this.clipCategory;
    }

    @Override
    @MediaPropertySetter(value="Clip category")
    public void setClipCategory(String clipCategory) {
        this.clipCategory = clipCategory;
    }

    @Override
    @MediaProperty(uuid1=1100851452, uuid2=31503, uuid3=19082, uuid4={-73, 6, -54, -76, 76, 104, -69, 62}, definedName="Clip owner", symbol="Clip_owner", aliases={"Clip_owner"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    public String getClipOwner() {
        if (this.clipOwner == null) {
            throw new PropertyNotPresentException("The optional clip owner property is not present for this Quantel composition package.");
        }
        return this.clipOwner;
    }

    @Override
    @MediaPropertySetter(value="Clip owner")
    public void setClipOwner(String clipOwner) {
        this.clipOwner = clipOwner;
    }

    @Override
    public CompositionPackage clone() {
        return (CompositionPackage)super.clone();
    }

    public String getDefaultFadeEditUnitString() {
        return RationalImpl.toPersistentForm(this.defaultFadeEditUnit);
    }

    public void setDefaultFadeEditUnitString(String fadeEditUnit) {
        this.defaultFadeEditUnit = RationalImpl.fromPersistentForm(fadeEditUnit);
    }

    public String getCompositionRenderingString() {
        return PackageIDImpl.toPersistentForm(this.compositionRendering);
    }

    public void setCompositionRenderingString(String compositionRendering) {
        this.compositionRendering = PackageIDImpl.fromPersistentForm(compositionRendering);
    }
}

