/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.constant.CommonConstants;
import tv.amwa.maj.industry.Forge;
import tv.amwa.maj.industry.MediaEngine;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.meta.MetaDefinition;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.impl.MetaDictionaryImpl;
import tv.amwa.maj.model.Preface;

public class AAFElement
implements MetadataObject,
XMLSerializable,
CommonConstants {
    private Preface preface;
    private Element aafElement = null;
    public static final String AAF_TAG = "AAF";
    public static final String AAF_VERSION = "1.1";
    public static final String EXTENSIONS_TAG = "Extensions";
    public static final String EXTENSION_TAG = "Extension";
    public static final String IDENTIFICATION_TAG = "Identification";
    public static final String SYMBOLSPACE_TAG = "Symbolspace";
    public static final String PREFERREDPREFIX_TAG = "PreferredPrefix";
    public static final String DESCRIPTION_TAG = "Description";
    public static final String DEFINITIONS_TAG = "Definitions";

    public AAFElement(Preface preface) {
        this.preface = preface;
    }

    @Override
    public void appendXMLChildren(Node parent) {
        Document document = parent.getOwnerDocument();
        Comment majComment = document.createComment("Generated by the Media Authoring with Java API (MAJ API)");
        parent.appendChild(majComment);
        this.aafElement = XMLBuilder.createChild(parent, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", AAF_TAG);
        XMLBuilder.setAttribute(this.aafElement, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", "version", AAF_VERSION);
        Element extensions = XMLBuilder.createChild(this.aafElement, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", EXTENSIONS_TAG);
        HashMap<String, List<MetaDefinition>> extensionMap = new HashMap<String, List<MetaDefinition>>();
        AAFElement.addExtensions(this.preface, extensionMap);
        for (String namespace : extensionMap.keySet()) {
            List namespaceDefinitions = (List)extensionMap.get(namespace);
            Element extension = XMLBuilder.createChild(extensions, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", EXTENSION_TAG);
            String likelyPrefix = "this";
            for (MetaDefinition metaDefinition : namespaceDefinitions) {
                if (metaDefinition instanceof TypeDefinition) continue;
                likelyPrefix = metaDefinition.getPrefix();
            }
            XMLBuilder.appendElement((Node)extension, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", IDENTIFICATION_TAG, Forge.randomAUID().toString());
            XMLBuilder.appendElement((Node)extension, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", SYMBOLSPACE_TAG, namespace);
            XMLBuilder.appendElement((Node)extension, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", PREFERREDPREFIX_TAG, likelyPrefix);
            XMLBuilder.appendElement((Node)extension, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", DESCRIPTION_TAG, "Extensions for namespace " + namespace);
            Element definitions = XMLBuilder.createChild(extension, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", DEFINITIONS_TAG);
            for (MetaDefinition metaDefinition : namespaceDefinitions) {
                metaDefinition.appendMetadictXML(definitions, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf");
            }
        }
        XMLBuilder.appendObject(this.aafElement, this.preface);
    }

    private static final void addExtensions(Preface preface, Map<String, List<MetaDefinition>> extensionMap) {
        MetaDictionaryImpl metaDictionary = new MetaDictionaryImpl();
        metaDictionary.makeDynamic(preface);
        for (ClassDefinition classDefinition : metaDictionary.getClassDefinitions()) {
            AAFElement.addExtensionToMap(extensionMap, classDefinition, classDefinition.getNamespace());
            for (PropertyDefinition propertyDefinition : classDefinition.getPropertyDefinitions()) {
                AAFElement.addExtensionToMap(extensionMap, propertyDefinition, propertyDefinition.getNamespace());
            }
        }
        for (TypeDefinition typeDefinition : metaDictionary.getTypeDefinitions()) {
            AAFElement.addExtensionToMap(extensionMap, typeDefinition, typeDefinition.getNamespace());
        }
    }

    private static final void addExtensionToMap(Map<String, List<MetaDefinition>> extensionMap, MetaDefinition candidateDefinition, String namespace) {
        if (!MediaEngine.isBaseline(candidateDefinition)) {
            if (namespace == null) {
                namespace = candidateDefinition.getNamespace();
            }
            if (namespace == null || namespace.length() == 0) {
                namespace = "this";
            }
            List<Object> namespaceDefinitions = null;
            if (!extensionMap.containsKey(namespace)) {
                namespaceDefinitions = new Vector();
                extensionMap.put(namespace, namespaceDefinitions);
            } else {
                namespaceDefinitions = extensionMap.get(namespace);
            }
            namespaceDefinitions.add(candidateDefinition);
        }
    }

    public Document getDocument() {
        if (this.aafElement == null) {
            return null;
        }
        return this.aafElement.getOwnerDocument();
    }

    @Override
    public String getComment() {
        return " SMPTE-2001 Reg-XML generated by the MAJ API. ";
    }
}

