/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.industry;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.industry.Forge;
import tv.amwa.maj.industry.MediaEngine;
import tv.amwa.maj.industry.Stream;
import tv.amwa.maj.io.xml.XMLBuilder;

public class MemoryResidentStream
implements Stream,
Cloneable {
    private ByteBuffer memoryStream;
    private String localStreamID = Forge.randomAUID().toString();
    private long persistentID = 0L;

    public MemoryResidentStream(int capacity) throws IllegalArgumentException {
        if (capacity < 0) {
            throw new IllegalArgumentException("Cannot create a memory-resident stream of negative size.");
        }
        this.memoryStream = ByteBuffer.allocate(capacity);
        MediaEngine.getStreamResolver().cacheStream(this);
    }

    public MemoryResidentStream(ByteBuffer existingBuffer) throws NullPointerException {
        if (existingBuffer == null) {
            throw new NullPointerException("Cannot create a memory-resident stream using a null byte buffer.");
        }
        this.memoryStream = existingBuffer.duplicate();
        this.memoryStream.rewind();
        MediaEngine.getStreamResolver().cacheStream(this);
    }

    @Override
    public ByteBuffer read(int bytes) throws EndOfDataException, IOException, IllegalArgumentException {
        if (bytes < 0) {
            throw new IllegalArgumentException("Cannot read a negative number of bytes from a memory-resident stream.");
        }
        if (bytes > this.memoryStream.remaining()) {
            throw new EndOfDataException("Insufficient bytes remaining in memory resident stream buffer.");
        }
        ByteBuffer partialBuffer = ByteBuffer.allocate(bytes);
        while (partialBuffer.hasRemaining()) {
            partialBuffer.put(this.memoryStream.get());
        }
        return partialBuffer;
    }

    @Override
    public long getPosition() throws IOException {
        return this.memoryStream.position();
    }

    @Override
    public void setPosition(long position) throws IllegalArgumentException, IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("Cannot set a stream position to a negative value.");
        }
        if (position > (long)this.memoryStream.limit()) {
            throw new IllegalArgumentException("Cannot set the position beyond the end of the limit for the stream.");
        }
        this.memoryStream.position((int)position);
    }

    @Override
    public int write(ByteBuffer bytes) throws EndOfDataException, IOException {
        int remaining = bytes.remaining();
        if (bytes.remaining() > this.memoryStream.remaining()) {
            throw new EndOfDataException("Not enough space to write the given buffer into this memory-resident stream at the current position.");
        }
        while (bytes.hasRemaining()) {
            this.memoryStream.put(bytes.get());
        }
        return remaining;
    }

    public long getStart() {
        return 0L;
    }

    @Override
    public long getLimit() {
        return this.memoryStream.limit();
    }

    @Override
    public long getLength() {
        return this.memoryStream.limit();
    }

    public long getPersistentID() {
        return this.persistentID;
    }

    @Override
    public void close() {
    }

    public void finalize() {
        this.close();
    }

    @Override
    public MemoryResidentStream clone() {
        try {
            return (MemoryResidentStream)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.getMessage());
        }
    }

    @Override
    public void setLimit(long limit) throws IllegalArgumentException {
        if (limit < 0L) {
            throw new IllegalArgumentException("Cannot set the limit to a position before the start.");
        }
        if (limit > (long)this.memoryStream.capacity()) {
            throw new IllegalArgumentException("Cannot set the limit to a position beyond the capacity of the memory-resident buffer.");
        }
        this.memoryStream.limit((int)limit);
    }

    public int getCapacity() {
        return this.memoryStream.capacity();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof MemoryResidentStream)) {
            return false;
        }
        MemoryResidentStream testValue = (MemoryResidentStream)o;
        if (this.getCapacity() == 0 && testValue.getCapacity() == 0) {
            return true;
        }
        return this.memoryStream.equals(testValue);
    }

    public int hashCode() {
        return this.memoryStream.hashCode();
    }

    public static final void generateStreamORM(Node parent, String namespace, String prefix) {
        Element entity = XMLBuilder.createChild(parent, namespace, prefix, "entity");
        XMLBuilder.setAttribute(entity, namespace, prefix, "class", MemoryResidentStream.class.getCanonicalName());
        XMLBuilder.setAttribute(entity, namespace, prefix, "access", "FIELD");
        Element attributes = XMLBuilder.createChild(entity, namespace, prefix, "attributes");
        Element fileName = XMLBuilder.createChild(attributes, namespace, prefix, "basic");
        XMLBuilder.setAttribute(fileName, namespace, prefix, "name", "fileName");
        Element fileNameColumn = XMLBuilder.createChild(fileName, namespace, prefix, "column");
        XMLBuilder.setAttribute(fileNameColumn, namespace, prefix, "name", "FileName");
        XMLBuilder.setAttribute(fileNameColumn, namespace, prefix, "nullable", "false");
        Element persistentID = XMLBuilder.createChild(attributes, namespace, prefix, "id");
        XMLBuilder.setAttribute(persistentID, namespace, prefix, "name", "persistentID");
        XMLBuilder.createChild(persistentID, namespace, prefix, "generated-id");
        Element persistentIDColumn = XMLBuilder.createChild(persistentID, namespace, prefix, "column");
        XMLBuilder.setAttribute(persistentIDColumn, namespace, prefix, "name", "PersistentID");
        Element start = XMLBuilder.createChild(attributes, namespace, prefix, "basic");
        XMLBuilder.setAttribute(start, namespace, prefix, "name", "start");
        Element startColumn = XMLBuilder.createChild(start, namespace, prefix, "column");
        XMLBuilder.setAttribute(startColumn, namespace, prefix, "name", "Start");
        XMLBuilder.setAttribute(startColumn, namespace, prefix, "nullable", "false");
        Element limit = XMLBuilder.createChild(attributes, namespace, prefix, "basic");
        XMLBuilder.setAttribute(limit, namespace, prefix, "name", "limit");
        Element limitColumn = XMLBuilder.createChild(start, namespace, prefix, "column");
        XMLBuilder.setAttribute(limitColumn, namespace, prefix, "name", "Limit");
        XMLBuilder.setAttribute(limitColumn, namespace, prefix, "nullable", "false");
    }

    @Override
    public URI getStreamURI() {
        return URI.create(this.localStreamID);
    }

    @Override
    public tv.amwa.maj.enumeration.ByteOrder getByteOrder() {
        if (this.memoryStream.order() == ByteOrder.BIG_ENDIAN) {
            return tv.amwa.maj.enumeration.ByteOrder.Big;
        }
        return tv.amwa.maj.enumeration.ByteOrder.Little;
    }

    public void setByteOrder(tv.amwa.maj.enumeration.ByteOrder byteOrder) {
        if (byteOrder == tv.amwa.maj.enumeration.ByteOrder.Big) {
            this.memoryStream.order(ByteOrder.BIG_ENDIAN);
        } else {
            this.memoryStream.order(ByteOrder.LITTLE_ENDIAN);
        }
    }
}

