/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.exception.BadLengthException;
import tv.amwa.maj.exception.BadPropertyException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.extensions.quantel.QAAFFileDescriptor;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.integer.Int32;
import tv.amwa.maj.model.AAFFileDescriptor;
import tv.amwa.maj.model.CodecDefinition;
import tv.amwa.maj.model.ContainerDefinition;
import tv.amwa.maj.model.impl.EssenceDescriptorImpl;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.impl.RationalImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=9472, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="FileDescriptor", aliases={"AAFFileDescriptor"}, description="The FileDescriptor class describes an essence source that is directly manipulated by an AAF application.", symbol="FileDescriptor", isConcrete=false)
public class AAFFileDescriptorImpl
extends EssenceDescriptorImpl
implements AAFFileDescriptor,
QAAFFileDescriptor,
Serializable,
Cloneable {
    private static final long serialVersionUID = 8332673437313654280L;
    private Rational sampleRate = new RationalImpl(-1, -1);
    private Long essenceLength = null;
    private boolean describesStaticEssence = false;
    private WeakReference<CodecDefinition> codec = null;
    private WeakReference<ContainerDefinition> containerFormat = null;
    private Integer linkedTrackID = null;
    private Integer twentyFourBitAudio = null;

    @Override
    @MediaProperty(uuid1=100729092, uuid2=259, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="Codec", aliases={"CodecDefinition", "FileDescriptorCodecDefinition"}, typeName="CodecDefinitionWeakReference", optional=true, uniqueIdentifier=false, pid=12293, symbol="Codec")
    public CodecDefinition getCodec() throws PropertyNotPresentException {
        if (this.codec == null) {
            throw new PropertyNotPresentException("The optional codec definition property is not present for this file descriptor.");
        }
        return this.codec.getTarget();
    }

    @Override
    @MediaPropertySetter(value="Codec")
    public void setCodec(CodecDefinition codec) {
        if (codec == null) {
            this.codec = null;
            return;
        }
        this.codec = new WeakReference<CodecDefinition>(codec);
    }

    @Override
    @MediaProperty(uuid1=100729092, uuid2=258, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, aliases={"EssenceContainer"}, definedName="ContainerFormat", typeName="ContainerDefinitionWeakReference", optional=true, uniqueIdentifier=false, pid=12292, symbol="ContainerFormat")
    public ContainerDefinition getContainerFormat() throws PropertyNotPresentException {
        if (this.containerFormat == null) {
            throw new PropertyNotPresentException("The optional container format property is not present in this file descriptor.");
        }
        return this.containerFormat.getTarget();
    }

    @Override
    @MediaPropertySetter(value="ContainerFormat")
    public void setContainerFormat(ContainerDefinition format) {
        this.containerFormat = format == null ? null : new WeakReference<ContainerDefinition>(format);
    }

    @Override
    @MediaProperty(uuid1=67502338, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="EssenceLength", aliases={"Length", "FileDescriptorLength"}, typeName="LengthType", optional=true, uniqueIdentifier=false, pid=12290, symbol="EssenceLength")
    public long getEssenceLength() throws BadPropertyException, PropertyNotPresentException {
        if (this.essenceLength == null) {
            throw new PropertyNotPresentException("The optional essence length property is not present for this file descriptor.");
        }
        if (this.describesStaticEssence) {
            throw new BadPropertyException("The length property is not present for the static essence described by this file descriptor.");
        }
        return this.essenceLength;
    }

    @Override
    public void setEssenceLength(Long essenceLength) throws BadPropertyException, BadLengthException {
        if (essenceLength == null) {
            this.essenceLength = null;
            return;
        }
        if (this.describesStaticEssence) {
            throw new BadPropertyException("The length property is not present for the static essence described by this file descriptor.");
        }
        if (essenceLength < 0L) {
            throw new BadLengthException("The length of the described material cannot be negative.");
        }
        this.essenceLength = essenceLength;
    }

    @MediaPropertySetter(value="EssenceLength")
    public void setEssenceLengthFromStream(long essenceLength) throws BadLengthException {
        if (essenceLength < 0L) {
            throw new BadLengthException("The length of the described material cannot be negative.");
        }
        this.describesStaticEssence = false;
        this.essenceLength = essenceLength;
    }

    public static final long initializeEssenceLength() {
        return 0L;
    }

    @Override
    @MediaProperty(uuid1=67502337, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="SampleRate", aliases={"FileDescriptorSampleRate"}, typeName="Rational", optional=false, uniqueIdentifier=false, pid=12289, symbol="SampleRate")
    public Rational getSampleRate() throws BadPropertyException {
        if (this.describesStaticEssence) {
            throw new BadPropertyException("The sample rate property is not present as the file descriptor describes static essence.");
        }
        return this.sampleRate.clone();
    }

    @Override
    public void setSampleRate(Rational rate) throws NullPointerException, BadPropertyException {
        if (this.describesStaticEssence) {
            throw new BadPropertyException("Cannot set the sample rate for this file descriptor as it describes static essence.");
        }
        if (rate == null) {
            throw new NullPointerException("Cannot set the sample rate for this file descriptor using a null value.");
        }
        this.sampleRate = rate.clone();
    }

    public static final Rational initializeSampleRate() {
        return new RationalImpl(1, 1);
    }

    @MediaPropertySetter(value="SampleRate")
    public void setSampleRateFromStream(Rational rate) {
        this.describesStaticEssence = false;
        if (rate == null) {
            throw new NullPointerException("Cannot set the sample rate for this file descriptor using a null value.");
        }
        this.sampleRate = rate.clone();
    }

    public boolean describesStaticEssence() {
        return this.describesStaticEssence;
    }

    public void setDescribesStaticEssence() {
        this.describesStaticEssence = true;
    }

    public void setDescribesTimeVaryingEssence(Rational sampleRate, long length) throws NullPointerException, BadLengthException {
        this.describesStaticEssence = false;
        try {
            this.setEssenceLength(length);
            this.setSampleRate(sampleRate);
        }
        catch (BadPropertyException badPropertyException) {
            // empty catch block
        }
    }

    @Override
    @MediaProperty(uuid1=100729091, uuid2=1280, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="LinkedTrackID", aliases={"LinkedSlotID"}, typeName="UInt32", optional=true, uniqueIdentifier=false, pid=12294, symbol="LinkedTrackID")
    public int getLinkedTrackID() throws PropertyNotPresentException {
        if (this.linkedTrackID == null) {
            throw new PropertyNotPresentException("The optional linked track id property is not present in this file descriptor.");
        }
        return this.linkedTrackID;
    }

    @Override
    @MediaPropertySetter(value="LinkedTrackID")
    public void setLinkedTrackID(Integer linkedTrackID) throws IllegalArgumentException {
        if (linkedTrackID == null) {
            this.linkedTrackID = null;
            return;
        }
        if (linkedTrackID < 0) {
            throw new IllegalArgumentException("The linked track id cannot be a negative value.");
        }
        this.linkedTrackID = linkedTrackID;
    }

    @Override
    @MediaProperty(uuid1=2078938896, uuid2=-9719, uuid3=18915, uuid4={-98, 120, -3, 45, -85, 22, 110, -94}, definedName="24 bit audio", symbol="_24_bit_audio", aliases={"_4_bit_audio", "_24_bit_audio", "twentyFourBitAudio"}, typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, prefix="q", namespace="http://www.quantel.com/genQ/extensions")
    @Int32
    public int getTwentyFourBitAudio() throws PropertyNotPresentException {
        if (this.twentyFourBitAudio == null) {
            throw new PropertyNotPresentException("The optional 24 bit audio property is not predent in this Quantel file descriptor.");
        }
        return this.twentyFourBitAudio;
    }

    @Override
    @MediaPropertySetter(value="24 bit audio")
    public void setTwentyFourBitAudio(@Int32 Integer twentyFourBitAudio) {
        this.twentyFourBitAudio = twentyFourBitAudio;
    }

    @Override
    public AAFFileDescriptor clone() {
        return (AAFFileDescriptor)super.clone();
    }

    public String getSampleRateString() {
        return RationalImpl.toPersistentForm(this.sampleRate);
    }

    public void setSampleRateString(String sampleRate) {
        this.sampleRate = RationalImpl.fromPersistentForm(sampleRate);
    }
}

