/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.meta.impl;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Vector;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.IllegalPropertyValueException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.HiddenClass;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.industry.WeakReferenceTarget;
import tv.amwa.maj.io.mxf.FixedLengthPack;
import tv.amwa.maj.io.mxf.MXFBuilder;
import tv.amwa.maj.io.mxf.UL;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionObjectReference;
import tv.amwa.maj.meta.TypeDefinitionStrongObjectReference;
import tv.amwa.maj.meta.impl.SingletonTypeDefinitionImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.impl.AUIDImpl;

@HiddenClass
public abstract class TypeDefinitionObjectReferenceImpl
extends SingletonTypeDefinitionImpl
implements TypeDefinitionObjectReference,
XMLSerializable,
Serializable,
Cloneable {
    private static final long serialVersionUID = 9088016822594218143L;
    private WeakReference<ClassDefinition> referencedType;

    @Override
    public PropertyValue createValue(Object object) throws ClassCastException {
        if (object == null) {
            return new ObjectReferenceValue(this, null);
        }
        if (object instanceof UnresolvedReferenceValue) {
            return (UnresolvedReferenceValue)object;
        }
        try {
            Class<?> c = this.referencedType.getTarget().getJavaImplementation();
            if (!this.referencedType.getTarget().getJavaImplementation().isInstance(object)) {
                throw new ClassCastException("Cannot cast the given object to a value that can be referenced from this object reference type definition.");
            }
        }
        catch (PropertyNotPresentException e) {
            throw new ClassCastException("The referenced type implementation does not have an associated Java implementation so it is not possible to check if the given object is compatable.");
        }
        return new ObjectReferenceValue(this, object);
    }

    @Override
    public Object getObject(PropertyValue propertyValue) throws NullPointerException, IllegalPropertyValueException {
        if (propertyValue == null) {
            throw new NullPointerException("Cannot return the referenced value of a null object reference property value.");
        }
        if (!this.equals(propertyValue.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this type definition.");
        }
        return propertyValue.getValue();
    }

    @Override
    public ClassDefinition getObjectType() {
        return this.referencedType.getTarget();
    }

    void setReferencedType(ClassDefinition referencedType) {
        if (referencedType == null) {
            throw new NullPointerException("Cannot set the referenced type of a value of an object reference type definition to a null value.");
        }
        this.referencedType = new WeakReference<ClassDefinition>(referencedType);
    }

    @Override
    public void setObject(PropertyValue propertyValue, Object object) throws NullPointerException, IllegalPropertyValueException, ClassCastException {
        if (propertyValue == null) {
            throw new NullPointerException("Cannot set the referenced value of a null object reference property value.");
        }
        if (!this.equals(propertyValue.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this type definition.");
        }
        if (object == null) {
            ((ObjectReferenceValue)propertyValue).setValue(null);
            return;
        }
        try {
            if (!this.referencedType.getTarget().getJavaImplementation().isInstance(object)) {
                throw new ClassCastException("Cannot use the given value as the target of an object reference because it cannot be cast to the referenced type of this object refernce type definition.");
            }
        }
        catch (PropertyNotPresentException e) {
            throw new ClassCastException("The referenced type implementation does not have an associated Java implementation so it is not possible to check if the given object is compatable.");
        }
        ((ObjectReferenceValue)propertyValue).setValue(object);
    }

    @Override
    public PropertyValue createFromBytes(ByteBuffer buffer) throws NullPointerException, EndOfDataException {
        super.createFromBytes(buffer);
        if (FixedLengthPack.class.isAssignableFrom(this.getObjectType().getJavaImplementation())) {
            return this.createValue(MXFBuilder.readFixedLengthPack(this.getObjectType().getAUID(), buffer));
        }
        if (buffer.remaining() < 16) {
            throw new EndOfDataException("Cannot create a reference from a buffer containing less than 16 bytes.");
        }
        if (buffer.remaining() == 21) {
            buffer.position(buffer.position() + 5);
            int data1 = buffer.getInt();
            short data2 = buffer.getShort();
            short data3 = buffer.getShort();
            byte[] data4 = new byte[8];
            buffer.get(data4);
            return new UnresolvedReferenceValue(this, new AUIDImpl(data1, data2, data3, data4));
        }
        byte[] refBytes = new byte[16];
        buffer.get(refBytes);
        return new UnresolvedReferenceValue(this, new AUIDImpl(refBytes));
    }

    @Override
    public long lengthAsBytes(PropertyValue value) throws NullPointerException, IllegalPropertyValueException {
        super.lengthAsBytes(value);
        return 16L;
    }

    @Override
    public List<PropertyValue> writeAsBytes(PropertyValue value, ByteBuffer buffer) throws NullPointerException, IllegalPropertyValueException, InsufficientSpaceException {
        super.writeAsBytes(value, buffer);
        if (buffer.remaining() < 16) {
            throw new InsufficientSpaceException("Insufficient space in buffer to write a 16 byte reference.");
        }
        AUID reference = TypeDefinitionObjectReferenceImpl.getLocalReference(value);
        if (reference.isUniversalLabel()) {
            buffer.put(((UL)reference).getUniversalLabel());
        } else {
            buffer.put(reference.getAUIDValue());
        }
        Vector<PropertyValue> singleReference = new Vector<PropertyValue>(1);
        if (this instanceof TypeDefinitionStrongObjectReference) {
            singleReference.add(value);
        }
        return singleReference;
    }

    public static final AUID getLocalReference(PropertyValue value) throws NullPointerException, IllegalPropertyValueException {
        if (value == null) {
            throw new NullPointerException("Cannot find the local reference for a null property value.");
        }
        if (!(value instanceof ObjectReferenceValue) && !(value instanceof UnresolvedReferenceValue)) {
            throw new IllegalPropertyValueException("Cannot resolve a local reference from the wrong kind  of property value: " + value.getClass().getName());
        }
        AUID reference = null;
        reference = value instanceof UnresolvedReferenceValue ? ((UnresolvedReferenceValue)value).getValue() : ((ObjectReferenceValue)value).getLocalReference();
        return reference;
    }

    @Override
    public TypeDefinitionObjectReference clone() {
        return (TypeDefinitionObjectReference)super.clone();
    }

    public static class UnresolvedReferenceValue
    extends TypeDefinitionImpl.PropertyValueImpl
    implements PropertyValue {
        private TypeDefinitionObjectReferenceImpl type;
        private AUID value;

        UnresolvedReferenceValue(TypeDefinitionObjectReferenceImpl type, AUID reference) {
            this.type = type;
            this.setValue(reference);
        }

        @Override
        public TypeDefinition getType() {
            return this.type;
        }

        @Override
        public AUID getValue() {
            return this.value;
        }

        public boolean isDefinedType() {
            return true;
        }

        private void setValue(AUID value) {
            this.value = value;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof UnresolvedReferenceValue) {
                return this.value.equals(((UnresolvedReferenceValue)o).getValue());
            }
            return this.value.equals(o);
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static class ObjectReferenceValue
    extends TypeDefinitionImpl.PropertyValueImpl
    implements PropertyValue {
        private TypeDefinitionObjectReferenceImpl type;
        private Object value;
        private AUID localReference;

        ObjectReferenceValue(TypeDefinitionObjectReferenceImpl type, Object value) {
            this.type = type;
            this.setValue(value);
        }

        @Override
        public TypeDefinition getType() {
            return this.type;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        public boolean isDefinedType() {
            return true;
        }

        void setValue(Object value) {
            this.value = value;
            this.localReference = value instanceof WeakReferenceTarget ? ((WeakReferenceTarget)value).getAUID() : AUIDImpl.randomAUID();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof ObjectReferenceValue) {
                return this.value.equals(((ObjectReferenceValue)o).getValue());
            }
            return this.value.equals(o);
        }

        @Override
        public int hashCode() {
            if (this.value == null) {
                System.err.println("Asked for a null hashcode.");
                return 0;
            }
            return this.value.hashCode();
        }

        public AUID getLocalReference() {
            return this.localReference;
        }
    }
}

