/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.model.ContainerDefinition;
import tv.amwa.maj.model.DataEssenceDescriptor;
import tv.amwa.maj.model.impl.AAFFileDescriptorImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.impl.AUIDImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=17152, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="DataEssenceDescriptor", description="Specifies that a file source package is associated with data essence.", symbol="DataEssenceDescriptor")
public class DataEssenceDescriptorImpl
extends AAFFileDescriptorImpl
implements DataEssenceDescriptor,
Serializable,
XMLSerializable,
Cloneable {
    private static final long serialVersionUID = 739654857146965078L;
    private AUID dataEssenceCoding = null;

    public DataEssenceDescriptorImpl() {
    }

    public DataEssenceDescriptorImpl(ContainerDefinition containerFormat) throws NullPointerException {
        this.setContainerFormat(containerFormat);
    }

    @Override
    @MediaProperty(uuid1=67306242, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 3}, definedName="DataEssenceCoding", typeName="AUID", optional=true, uniqueIdentifier=false, pid=15873, symbol="DataEssenceCoding")
    public AUID getDataEssenceCoding() throws PropertyNotPresentException {
        if (this.dataEssenceCoding == null) {
            throw new PropertyNotPresentException("The optional data essence coding property is not present in this data essence descriptor.");
        }
        return this.dataEssenceCoding.clone();
    }

    @Override
    @MediaPropertySetter(value="DataEssenceCoding")
    public void setDataEssenceCoding(AUID dataEssenceCoding) {
        this.dataEssenceCoding = dataEssenceCoding == null ? null : dataEssenceCoding.clone();
    }

    @Override
    public DataEssenceDescriptor clone() {
        return (DataEssenceDescriptor)super.clone();
    }

    public String getDataEssenceCodingString() {
        return AUIDImpl.toPersistentForm(this.dataEssenceCoding);
    }

    public void setDataEssenceCodingString(String dataEssenceCoding) {
        this.dataEssenceCoding = AUIDImpl.fromPersistentForm(dataEssenceCoding);
    }
}

