/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.model.Segment;
import tv.amwa.maj.model.StaticTrack;
import tv.amwa.maj.model.impl.TrackImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=14848, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="StaticTrack", aliases={"StaticMobSlot"}, description="The StaticTrack describes essence data that has no relationship to time, such as a static image.", symbol="StaticTrack")
public class StaticTrackImpl
extends TrackImpl
implements StaticTrack,
Serializable,
Cloneable {
    private static final long serialVersionUID = 8350113256771243987L;

    public StaticTrackImpl() {
    }

    public StaticTrackImpl(@UInt32 int trackID, Segment segment) throws NullPointerException, IllegalArgumentException {
        if (segment == null) {
            throw new NullPointerException("Cannot create a new static track with a null segment.");
        }
        if (trackID < 0) {
            throw new IllegalArgumentException("Cannot create a new static track with a negative track id.");
        }
        this.setTrackSegment(segment);
        this.setTrackID(trackID);
    }

    @Override
    public void setTrackSegment(Segment segment) {
        segment.setLengthPresent(false);
        super.setTrackSegment(segment);
    }

    @Override
    public StaticTrack clone() {
        return (StaticTrack)super.clone();
    }
}

