/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.meta.impl;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.enumeration.TypeCategory;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.IllegalPropertyValueException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.exception.InvalidParameterException;
import tv.amwa.maj.exception.TypeNotFoundException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.TypeDefinitions;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.meta.MetaDictionary;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionOpaque;
import tv.amwa.maj.meta.impl.TypeDefinitionImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionIndirectImpl;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.impl.AUIDImpl;

@MediaClass(uuid1=0xD010101, uuid2=546, uuid3=0, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="TypeDefinitionOpaque", description="The TypeDefinitionOpaque class defines a property type that has a value whose type is specified in each instance.", symbol="TypeDefinitionOpaque")
public final class TypeDefinitionOpaqueImpl
extends TypeDefinitionIndirectImpl
implements TypeDefinitionOpaque,
Serializable,
Cloneable {
    private static final long serialVersionUID = -8999815866650774149L;
    private transient MetaDictionary resolutionDictionary = null;

    protected TypeDefinitionOpaqueImpl() {
    }

    public TypeDefinitionOpaqueImpl(AUID identification, @AAFString String typeName) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot create a new opaque type definition with a null indentification.");
        }
        this.setIdentification(identification);
        this.setName(typeName);
    }

    @Override
    public final PropertyValue createValueFromHandle(ByteBuffer initData) throws NullPointerException, IllegalArgumentException {
        if (initData == null) {
            throw new NullPointerException("Cannot create a new opaque value from null initial data.");
        }
        if (initData.limit() < 16) {
            throw new IllegalArgumentException("Cannot create a new opaque value from a handle of less than 16 bytes.");
        }
        return new OpaqueValue(this, initData);
    }

    @Override
    public final AUIDImpl getActualTypeID(PropertyValue opaqueProperty) throws NullPointerException, IllegalPropertyValueException {
        if (opaqueProperty == null) {
            throw new NullPointerException("Cannot retrieve a type id from a null property value.");
        }
        if (!this.equals(opaqueProperty.getType())) {
            throw new IllegalPropertyValueException("The given property value does not match this opaque type definition.");
        }
        byte[] auidValue = new byte[16];
        ByteBuffer keyAndValue = ((OpaqueValue)opaqueProperty).getValue();
        keyAndValue.rewind();
        keyAndValue.get(auidValue);
        return new AUIDImpl(auidValue);
    }

    @Override
    public final ByteBuffer getHandle(PropertyValue opaqueProperty) throws NullPointerException, IllegalPropertyValueException {
        if (opaqueProperty == null) {
            throw new NullPointerException("Cannot retrieve the handle from a null opaque property.");
        }
        if (!this.equals(opaqueProperty.getType())) {
            throw new IllegalPropertyValueException("The given property value is of a type that does not match this opaque type definition.");
        }
        return ((OpaqueValue)opaqueProperty).getValue();
    }

    @Override
    public final void setHandle(PropertyValue opaqueProperty, ByteBuffer handle) throws NullPointerException, IllegalPropertyValueException, IllegalArgumentException {
        if (opaqueProperty == null) {
            throw new NullPointerException("Cannot set a handle for a null property value.");
        }
        if (handle == null) {
            throw new NullPointerException("Cannot set the handle of an opaque property value using a null value.");
        }
        if (!this.equals(opaqueProperty.getType())) {
            throw new IllegalPropertyValueException("The given property value is of a type that does not match this opaque type definition.");
        }
        if (handle.limit() < 16) {
            throw new IllegalArgumentException("Cannot use a handle with less than 16 bytes to the value of an opaque property.");
        }
        ((OpaqueValue)opaqueProperty).setValue(handle);
    }

    public final PropertyValue createValueFromActualData(AUID actualTypeId, byte[] initData) throws NullPointerException {
        return this.createValueFromActualData(actualTypeId, initData, tv.amwa.maj.enumeration.ByteOrder.Big);
    }

    public final PropertyValue createValueFromActualData(AUID actualTypeId, byte[] initData, tv.amwa.maj.enumeration.ByteOrder byteOrder) throws NullPointerException {
        if (actualTypeId == null) {
            throw new NullPointerException("Cannot create an opaque property with a null actual type id.");
        }
        if (initData == null) {
            throw new NullPointerException("Cannot create an opaque property with a null initial data value.");
        }
        if (byteOrder == null) {
            throw new NullPointerException("Cannot create an opaque property with an unspecified byte order.");
        }
        ByteBuffer handle = ByteBuffer.allocate(initData.length + 16);
        if (byteOrder == tv.amwa.maj.enumeration.ByteOrder.Little) {
            handle.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            handle.order(ByteOrder.BIG_ENDIAN);
        }
        handle.put(actualTypeId.getAUIDValue());
        handle.put(initData);
        handle.rewind();
        return new OpaqueValue(this, handle);
    }

    @Override
    public final PropertyValue createValueFromActualData(TypeDefinition type, byte[] initData) throws NullPointerException {
        if (type == null) {
            throw new NullPointerException("Cannot create an opaque property with a null type definition.");
        }
        return this.createValueFromActualData(type.getAUID(), initData);
    }

    @Override
    public final byte[] getActualData(PropertyValue opaqueProperty) throws NullPointerException, IllegalPropertyValueException {
        if (opaqueProperty == null) {
            throw new NullPointerException("Cannot retrieve the actual data from a null opaque property.");
        }
        if (!this.equals(opaqueProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this opaque type definition.");
        }
        ByteBuffer handle = ((OpaqueValue)opaqueProperty).getValue();
        byte[] actualData = new byte[handle.limit() - 16];
        handle.position(16);
        handle.get(actualData);
        return actualData;
    }

    @Override
    public final int getActualSize(PropertyValue opaqueProperty) throws NullPointerException, IllegalPropertyValueException {
        if (opaqueProperty == null) {
            throw new NullPointerException("Cannot retrieve the actual data length from a null opaque property.");
        }
        if (!this.equals(opaqueProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property value does not match this opaque type definition.");
        }
        return ((OpaqueValue)opaqueProperty).getValue().limit() - 16;
    }

    public final void setDictionary(MetaDictionary dictionary) throws NullPointerException {
        if (dictionary == null) {
            throw new NullPointerException("Cannot set the dictionary to use for type resolution from a null value.");
        }
        this.resolutionDictionary = dictionary;
    }

    @Override
    public final TypeDefinition getActualType(PropertyValue opaqueProperty) throws NullPointerException, IllegalPropertyValueException, TypeNotFoundException {
        if (opaqueProperty == null) {
            throw new NullPointerException("Cannot retrieve the actual type of a null opaque property.");
        }
        if (!this.equals(opaqueProperty.getType())) {
            throw new IllegalPropertyValueException("The type of the given property does not match this opaque type definition.");
        }
        AUIDImpl actualTypeId = this.getActualTypeID(opaqueProperty);
        TypeDefinition actualType = Warehouse.lookForType(actualTypeId);
        try {
            if (actualType == null && this.resolutionDictionary != null) {
                actualType = this.resolutionDictionary.lookupOpaqueTypeDefinition(actualTypeId);
            }
        }
        catch (ClassCastException e) {
            actualType = null;
        }
        catch (InvalidParameterException e) {
            actualType = null;
        }
        if (actualType == null) {
            throw new TypeNotFoundException("A type matching the handle of this type definition has not been found.");
        }
        return actualType;
    }

    @Override
    public final PropertyValue getActualValue(PropertyValue opaqueProperty) throws NullPointerException, IllegalPropertyValueException, TypeNotFoundException, ClassCastException {
        TypeDefinition actualType = this.getActualType(opaqueProperty);
        byte[] bytes = this.getActualData(opaqueProperty);
        return actualType.createFromBytes(ByteBuffer.wrap(bytes));
    }

    @Override
    public final PropertyValue createValueFromActualValue(PropertyValue propertyValue) throws NullPointerException, NotSerializableException {
        if (propertyValue == null) {
            throw new NullPointerException("Cannot create a new opaque property value from a null value.");
        }
        PropertyValue indirectValue = TypeDefinitions.Indirect.createValue(propertyValue);
        ByteBuffer opaqueBuffer = ByteBuffer.allocate((int)indirectValue.getType().lengthAsBytes(indirectValue));
        try {
            indirectValue.getType().writeAsBytes(indirectValue, opaqueBuffer);
        }
        catch (IllegalPropertyValueException e) {
            e.printStackTrace();
            throw new InternalError("Should never get here.");
        }
        catch (InsufficientSpaceException e) {
            e.printStackTrace();
            throw new InternalError("Should never get here.");
        }
        opaqueBuffer.rewind();
        return new OpaqueValue(this, opaqueBuffer);
    }

    @Override
    public final PropertyValue createValue(Object javaValue) throws ClassCastException {
        if (javaValue == null) {
            throw new ClassCastException("Cannot create a new opaque value from a null value.");
        }
        if (javaValue instanceof byte[]) {
            javaValue = ByteBuffer.wrap((byte[])javaValue);
        }
        if (javaValue instanceof ByteBuffer) {
            try {
                return this.createValueFromHandle((ByteBuffer)javaValue);
            }
            catch (RuntimeException e) {
                throw new ClassCastException("Cannot create an opaque property from the given byte array as it has insufficient bytes.");
            }
        }
        if (javaValue instanceof PropertyValue) {
            try {
                return this.createValueFromActualValue((PropertyValue)javaValue);
            }
            catch (NotSerializableException e) {
                throw new ClassCastException("The given property value cannot be serialized to a byte stream to make an opaque property value.");
            }
            catch (NullPointerException e) {
                throw new ClassCastException("Unexpected null pointer exception: " + e.getMessage());
            }
        }
        throw new ClassCastException("Cannot cast the given java object to an opaque property value.");
    }

    @Override
    public final TypeCategory getTypeCategory() {
        return TypeCategory.Opaque;
    }

    @Override
    public PropertyValue createFromBytes(ByteBuffer buffer) throws NullPointerException, EndOfDataException {
        if (buffer == null) {
            throw new NullPointerException("Cannot create a value from a null byte buffer.");
        }
        return this.createValueFromHandle(buffer);
    }

    @Override
    public List<PropertyValue> writeAsBytes(PropertyValue value, ByteBuffer buffer) throws NullPointerException, IllegalPropertyValueException, InsufficientSpaceException {
        if (value == null) {
            throw new NullPointerException("Cannot write a null property value to a byte stream.");
        }
        if (buffer == null) {
            throw new NullPointerException("Cannot write a value to a null byte buffer.");
        }
        if (!value.getType().equals(this)) {
            throw new IllegalPropertyValueException("The given property value to write a bytes is not the same as this type. " + value.getType().getName() + " != " + this.getName() + ".");
        }
        ByteBuffer valueBuffer = ((OpaqueValue)value).getValue();
        int preservePosition = valueBuffer.position();
        valueBuffer.rewind();
        if (valueBuffer.remaining() > buffer.remaining()) {
            valueBuffer.position(preservePosition);
            throw new InsufficientSpaceException("Cannot write the given source opaque value into the given target buffer as the target is too small.");
        }
        buffer.put(valueBuffer);
        valueBuffer.position(preservePosition);
        return null;
    }

    @Override
    public long lengthAsBytes(PropertyValue value) throws NullPointerException, IllegalPropertyValueException {
        if (value == null) {
            throw new NullPointerException("Cannot provide the length in bytes of a null value.");
        }
        if (!value.getType().equals(this)) {
            throw new IllegalPropertyValueException("The given property value to find the serialized length of is not the same as this type. " + value.getType().getName() + " != " + this.getName() + ".");
        }
        return ((OpaqueValue)value).getValue().limit();
    }

    @Override
    public void appendMetadictXML(Node metadict, String namespace, String prefix) {
        Element typeElement = XMLBuilder.createChild(metadict, namespace, prefix, "TypeDefinitionOpaque");
        super.appendMetadictXML(typeElement, namespace, prefix);
    }

    @Override
    public TypeDefinitionOpaque clone() {
        return (TypeDefinitionOpaque)super.clone();
    }

    public static class OpaqueValue
    extends TypeDefinitionImpl.PropertyValueImpl
    implements PropertyValue {
        private TypeDefinitionOpaqueImpl type;
        private ByteBuffer value;

        private OpaqueValue(TypeDefinitionOpaqueImpl type, ByteBuffer value) {
            this.type = type;
            this.setValue(value);
        }

        @Override
        public TypeDefinitionImpl getType() {
            return this.type;
        }

        @Override
        public ByteBuffer getValue() {
            return this.value.duplicate();
        }

        public boolean isDefinedType() {
            return true;
        }

        private void setValue(ByteBuffer value) {
            this.value = value.duplicate();
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertyValue)) {
                return false;
            }
            PropertyValue testValue = (PropertyValue)o;
            if (!this.getType().equals(testValue.getType())) {
                return false;
            }
            if (this.getValue() == null && testValue.getValue() == null) {
                return true;
            }
            return Arrays.equals(this.value.array(), ((OpaqueValue)testValue).getValue().array());
        }
    }
}

