/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.mxf.impl;

import java.io.Serializable;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.integer.UInt64;
import tv.amwa.maj.io.mxf.MXFConstants;
import tv.amwa.maj.io.mxf.RandomIndexItem;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.meta.impl.TypeDefinitionRecordImpl;

public class RandomIndexItemImpl
implements XMLSerializable,
Cloneable,
Serializable,
Comparable<RandomIndexItem>,
RandomIndexItem,
MXFConstants {
    private static final long serialVersionUID = -6518630576255869590L;
    @UInt32
    private int bodySID;
    @UInt64
    private long byteOffset;
    public static final String RANDOMINDEXITEM_TAG = "RandomIndexItem";
    public static final String BODYSID_TAG = "BodySID";
    public static final String BYTEOFFSET_TAG = "ByteOffset";

    public RandomIndexItemImpl(@UInt32 int bodySID, @UInt64 long byteOffset) throws IllegalArgumentException {
        this.setBodySID(bodySID);
        this.setByteOffset(byteOffset);
    }

    @Override
    @UInt32
    public int getBodySID() {
        return this.bodySID;
    }

    @Override
    public void setBodySID(@UInt32 int bodySID) throws IllegalArgumentException {
        if (bodySID < 0) {
            throw new IllegalArgumentException("A body stream identifier cannot be a negative value.");
        }
        this.bodySID = bodySID;
    }

    @Override
    @UInt64
    public long getByteOffset() {
        return this.byteOffset;
    }

    @Override
    public void setByteOffset(@UInt64 long byteOffset) throws IllegalArgumentException {
        if (byteOffset < 0L) {
            throw new IllegalArgumentException("A byte offset from the begginning of a file cannot be a negative value.");
        }
        this.byteOffset = byteOffset;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof RandomIndexItem)) {
            return false;
        }
        RandomIndexItem compareTo = (RandomIndexItem)o;
        if (compareTo.getBodySID() != this.bodySID) {
            return false;
        }
        return compareTo.getByteOffset() == this.byteOffset;
    }

    public int hashCode() {
        return this.bodySID ^ Long.valueOf(this.byteOffset).hashCode();
    }

    public String toString() {
        return XMLBuilder.toXMLNonMetadata(this);
    }

    @Override
    public void appendXMLChildren(Node parent) {
        Node randomIndexItemNode = null;
        randomIndexItemNode = parent instanceof DocumentFragment ? XMLBuilder.createChild(parent, "http://www.smpte-ra.org/rp210", "mxf", RANDOMINDEXITEM_TAG) : parent;
        XMLBuilder.appendElement(randomIndexItemNode, "http://www.smpte-ra.org/rp210", "mxf", BODYSID_TAG, this.bodySID);
        XMLBuilder.appendElement(randomIndexItemNode, "http://www.smpte-ra.org/rp210", "mxf", BYTEOFFSET_TAG, this.byteOffset);
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public int compareTo(RandomIndexItem o) {
        if (this.byteOffset < o.getByteOffset()) {
            return -1;
        }
        if (this.byteOffset > o.getByteOffset()) {
            return 1;
        }
        return 0;
    }

    @Override
    public RandomIndexItem clone() {
        try {
            return (RandomIndexItem)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.getMessage());
        }
    }

    static {
        TypeDefinitionRecordImpl.registerInterfaceMapping(RandomIndexItem.class, RandomIndexItemImpl.class);
    }
}

