/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.util;

import java.util.Hashtable;

@Deprecated
public final class LookupTable {
    static final Hashtable<String, TypeItem> table = new Hashtable();
    static final Hashtable<String, TypeItem> reverseTable = new Hashtable();

    private static final void makeReverseTable() {
        for (String key : table.keySet()) {
            String[] cNames;
            TypeItem item = table.get(key);
            for (String cName : cNames = item.getCNames()) {
                reverseTable.put(cName, item);
            }
        }
    }

    public static final Strategy lookupMAJTypeStrategy(String aafName) throws NullPointerException {
        if (aafName == null) {
            throw new NullPointerException("Cannot lookup a strategy kind using a null value.");
        }
        TypeItem item = table.get(aafName);
        if (item == null) {
            item = table.get(aafName + "Type");
        }
        if (item == null) {
            return null;
        }
        return item.getKind();
    }

    public static final String lookupMAJType(String aafName) throws NullPointerException {
        if (aafName == null) {
            throw new NullPointerException("Cannot lookup a MAJ API Java type representation using a null value.");
        }
        TypeItem item = table.get(aafName);
        if (item == null) {
            item = table.get(aafName + "Type");
        }
        if (item == null) {
            return null;
        }
        return item.getJavaBaseType();
    }

    public static final String lookupAAFTypeForCType(String cTypeName) throws NullPointerException {
        TypeItem item;
        if (cTypeName == null) {
            throw new NullPointerException("Cannot lookup an AAF data type name using a null value.");
        }
        if (cTypeName.endsWith("_e") || cTypeName.endsWith("_t")) {
            cTypeName = cTypeName.substring(0, cTypeName.length() - 2);
        }
        if (cTypeName.endsWith("_constref")) {
            cTypeName = cTypeName.substring(0, cTypeName.length() - 9);
        }
        if ((item = reverseTable.get(cTypeName)) == null) {
            item = reverseTable.get("aaf" + cTypeName);
        }
        if (item == null) {
            return null;
        }
        return item.getAAFName();
    }

    public static final String lookupMAJTypeForCType(String cTypeName) throws NullPointerException {
        return LookupTable.lookupMAJType(LookupTable.lookupAAFTypeForCType(cTypeName));
    }

    private LookupTable() {
    }

    static {
        table.put("AlphaTransparencyType", new TypeItem("AlphaTransparencyType", "AlphaTransparencyType", Strategy.Enumeration, new String[]{"aafAlphaTransparency"}));
        table.put("AppendOption", new TypeItem("AppendOption", "AppendOption", Strategy.Enumeration, new String[]{"aafAppendOption"}));
        table.put("ArgIDType", new TypeItem("ArgIDType", "AUID", Strategy.Annotation, new String[]{"aafArgIDType", "aafArgID"}));
        table.put("AttributeKind", new TypeItem("AttributeKind", "AttributeKind", Strategy.Enumeration, new String[]{"aafAttributeKind"}));
        table.put("AudioSample", new TypeItem("AudioSample", "AudioSample", Strategy.Enumeration, new String[]{"aafAudioSampleType", "aafAudioSample"}));
        table.put("Boolean", new TypeItem("Boolean", "boolean", Strategy.Annotation, new String[]{"aafBool", "aafBoolean"}));
        table.put("ByteOrder", new TypeItem("ByteOrder", "ByteOrder", Strategy.Enumeration, new String[]{"aafByteOrder"}));
        table.put("Char", new TypeItem("Char", "char", Strategy.Annotation, new String[]{"aafCharacter", "wchar", "WChar", "wChar"}));
        table.put("ClassID", new TypeItem("ClassID", "AUID", Strategy.Annotation, new String[]{"aafClassID"}));
        table.put("CodecID", new TypeItem("CodecID", "AUID", Strategy.Annotation, new String[]{"aafCodecID"}));
        table.put("ColorSitingType", new TypeItem("ColorSitingType", "ColorSitingType", Strategy.Enumeration, new String[]{"aafColorSiting"}));
        table.put("ColorSpace", new TypeItem("ColorSpace", "ColorSpace", Strategy.Enumeration, new String[]{"aafColorSpace"}));
        table.put("CompCodeArray", new TypeItem("CompCodeArray", "RGBAComponent[]", Strategy.Annotation, new String[]{"aafCompArray"}));
        table.put("CompressEnable", new TypeItem("CompressEnable", "CompressEnable", Strategy.Enumeration, new String[]{"aafCompressEnable"}));
        table.put("CompSizeArray", new TypeItem("CompSizeArray", "byte[]", Strategy.Annotation, new String[]{"aafCompSizeArray"}));
        table.put("CriteriaType", new TypeItem("CriteriaType", "CriteriaType", Strategy.Enumeration, new String[]{"aafCriteriaType"}));
        table.put("DataBuffer", new TypeItem("DataBuffer", "byte[]", Strategy.Annotation, new String[]{"aafDataBuffer"}));
        table.put("DataDefinitionMatch", new TypeItem("DataDefinitionMatch", "DataDefinitionMatch", Strategy.Enumeration, new String[]{"aafDataDefinitionMatch", "DataDefinitionMatch"}));
        table.put("DataValue", new TypeItem("DataValue", "byte[]", Strategy.Annotation, new String[]{"aafDataValue"}));
        table.put("DateStruct", new TypeItem("DateStruct", "DateStruct", Strategy.Class, new String[]{"aafDateStruct"}));
        table.put("DefaultFade", new TypeItem("DefaultFade", "DefaultFade", Strategy.Class, new String[]{"aafDefaultFade"}));
        table.put("DefinitionCrit", new TypeItem("DefinitionCrit", "DefinitionCrit", Strategy.AbstractUnion, new String[]{"aafDefinitionCrit"}));
        table.put("DefinitionCriteriaType", new TypeItem("DefinitionCriteriaType", "DefinitionCriteriaType", Strategy.Enumeration, new String[]{"aafDefinitionCritType"}));
        table.put("DefinitionKind", new TypeItem("DefinitionKind", "DefinitionKind", Strategy.Enumeration, new String[]{"aafDefinitionKind"}));
        table.put("Depend", new TypeItem("Depend", "Depend", Strategy.Enumeration, new String[]{"aafDepend"}));
        table.put("DirectionCode", new TypeItem("DirectionCode", "DirectionCode", Strategy.Enumeration, new String[]{"aafDirectionCode"}));
        table.put("Edgecode", new TypeItem("Edgecode", "EdgecodeValue", Strategy.Class, new String[]{"aafEdgecode"}));
        table.put("EdgecodeHeader", new TypeItem("EdgecodeHeader", "byte[]", Strategy.Annotation, new String[]{"aafEdgecodeHeader"}));
        table.put("EdgeType", new TypeItem("EdgeType", "EdgeType", Strategy.Enumeration, new String[]{"aafEdgeType"}));
        table.put("EditHintType", new TypeItem("EditHintType", "EditHintType", Strategy.Enumeration, new String[]{"aafEditHint"}));
        table.put("ElectroSpatialFormulation", new TypeItem("ElectroSpatialFormulation", "ElectroSpatialFormulation", Strategy.Enumeration, new String[]{"aafElectroSpatialFormulation"}));
        table.put("Engine", new TypeItem("Engine", "AUID", Strategy.Annotation, new String[]{"aafEngine"}));
        table.put("FadeType", new TypeItem("FadeType", "FadeType", Strategy.Enumeration, new String[]{"aafFadeType"}));
        table.put("FieldDom", new TypeItem("FieldDom", "FieldDom", Strategy.Enumeration, new String[]{"aafFieldDom"}));
        table.put("FieldNumber", new TypeItem("FieldNumber", "FieldNumber", Strategy.Enumeration, new String[]{"aafFieldNumber"}));
        table.put("FieldTop", new TypeItem("FieldTop", "FieldTop", Strategy.Enumeration, new String[]{"aafFieldTop"}));
        table.put("FileAccess", new TypeItem("FileAccess", "FileAccess", Strategy.Enumeration, new String[]{"aafFileAccess"}));
        table.put("FileExistence", new TypeItem("FileExistence", "FileExistence", Strategy.Enumeration, new String[]{"aafFileExistence"}));
        table.put("FileFormat", new TypeItem("FileFormat", "FileFormat", Strategy.Enumeration, new String[]{"aafFileFormat"}));
        table.put("FileRev", new TypeItem("FileRev", "FileRev", Strategy.Enumeration, new String[]{"aafFileRev"}));
        table.put("FilmType", new TypeItem("FilmType", "FilmType", Strategy.Enumeration, new String[]{"aafFilmType"}));
        table.put("FrameLength", new TypeItem("FrameLength", "long", Strategy.Annotation, new String[]{"aafFrameLength"}));
        table.put("FrameOffset", new TypeItem("FrameOffset", "long", Strategy.Annotation, new String[]{"aafFrameOffset"}));
        table.put("HardwarePlatform", new TypeItem("HardwarePlatform", "AUID", Strategy.Annotation, new String[]{"aafHardwarePlatform"}));
        table.put("IdentificationCriteria", new TypeItem("IdentificationCriteria", "IdentificationCriteria", Strategy.AbstractUnion, new String[]{"aafIdentificationCrit"}));
        table.put("IdentificationCriteriaType", new TypeItem("IdentificationCriteriaType", "IdentificationCriteriaType", Strategy.Enumeration, new String[]{"aafIdentificationCritType"}));
        table.put("IncludedMedia", new TypeItem("IncludedMedia", "IncludedMedia", Strategy.Enumeration, new String[]{"aafIncMedia"}));
        table.put("IndexType", new TypeItem("IndexType", "IndexType", Strategy.Enumeration, new String[]{"aafIndexType"}));
        table.put("Int16", new TypeItem("Int16", "short", Strategy.Annotation, new String[]{"aafInt16"}));
        table.put("Int16Array", new TypeItem("Int16Array", "short[]", Strategy.Annotation, new String[]{"aafInt16 *"}));
        table.put("Int32", new TypeItem("Int32", "int", Strategy.Annotation, new String[]{"aafInt32"}));
        table.put("Int32Array", new TypeItem("Int32Array", "int[]", Strategy.Annotation, new String[]{"aafInt32 *"}));
        table.put("Int64", new TypeItem("Int64", "long", Strategy.Annotation, new String[]{"aafInt64"}));
        table.put("Int64Array", new TypeItem("Int64Array", "long[]", Strategy.Annotation, new String[]{"aafInt64 *"}));
        table.put("Int8", new TypeItem("Int8", "byte", Strategy.Annotation, new String[]{"aafInt8"}));
        table.put("Int8Array", new TypeItem("Int8Array", "byte[]", Strategy.Annotation, new String[]{"aafInt8 *"}));
        table.put("InterpolationKind", new TypeItem("InterpolationKind", "InterpolationKind", Strategy.Enumeration, new String[]{"aafInterpKind"}));
        table.put("JPEGComponent", new TypeItem("JPEGComponent", "JPEGComponent", Strategy.Enumeration, new String[]{"aafJPEGcomponent"}));
        table.put("JPEGTableIDType", new TypeItem("JPEGTableIDType", "int", Strategy.Annotation, new String[]{"aafJPEGTableID"}));
        table.put("LayoutType", new TypeItem("LayoutType", "LayoutType", Strategy.Enumeration, new String[]{"aafLayoutType", "aafFrameLayout"}));
        table.put("LengthType", new TypeItem("LengthType", "long", Strategy.Annotation, new String[]{"aafLength"}));
        table.put("MediaCriteria", new TypeItem("MediaCriteria", "MediaCriteria", Strategy.Class, new String[]{"aafMediaCriteria"}));
        table.put("MediaOpenMode", new TypeItem("MediaOpenMode", "MediaOpenMode", Strategy.Enumeration, new String[]{"aafMediaOpenMode"}));
        table.put("MultiCreateItem", new TypeItem("MultiCreateItem", "MultiCreateItem", Strategy.Class, new String[]{"aafmMultiCreate"}));
        table.put("NumSlots", new TypeItem("NumSlots", "int", Strategy.Annotation, new String[]{"aafNumSlots"}));
        table.put("OperationChoice", new TypeItem("OperationChoice", "OperationChoice", Strategy.Enumeration, new String[]{"aafOperationChoice"}));
        table.put("PhaseFrameType", new TypeItem("PhaseFrameType", "int", Strategy.Annotation, new String[]{"aafPhaseFrame"}));
        table.put("PixelFormat", new TypeItem("PixelFormat", "PixelFormat", Strategy.Enumeration, new String[]{"aafPixelFormat"}));
        table.put("PluginAPI", new TypeItem("PluginAPI", "AUID", Strategy.Annotation, new String[]{"aafPluginAPI"}));
        table.put("PositionType", new TypeItem("PositionType", "long", Strategy.Annotation, new String[]{"aafPosition"}));
        table.put("ProductIdentification", new TypeItem("ProductIdentification", "ProductIdentification", Strategy.Class, new String[]{"aafProductIdentification"}));
        table.put("ProductReleaseType", new TypeItem("ProductReleaseType", "ProductReleaseType", Strategy.Enumeration, new String[]{"aafProductReleaseType"}));
        table.put("ProductVersion", new TypeItem("ProductVersion", "ProductVersion", Strategy.Class, new String[]{"aafProductVersion"}));
        table.put("PropertyOpt", new TypeItem("PropertyOpt", "PropertyOpt", Strategy.Enumeration, new String[]{"aafPropertyOpt"}));
        table.put("PulldownDirectionType", new TypeItem("PulldownDirectionType", "PulldownDirectionType", Strategy.Enumeration, new String[]{"aafPulldownDir"}));
        table.put("PulldownKindType", new TypeItem("PulldownKindType", "PulldownKindType", Strategy.Enumeration, new String[]{"aafPulldownKind"}));
        table.put("Rational", new TypeItem("Rational", "Rational", Strategy.Class, new String[]{"aafRational"}));
        table.put("Rectangle", new TypeItem("Rectangle", "Rectangle", Strategy.Class, new String[]{"aafRect"}));
        table.put("ReferenceType", new TypeItem("ReferenceType", "ReferenceType", Strategy.Enumeration, new String[]{"aafReferenceType"}));
        table.put("RGBAComponent", new TypeItem("RGBAComponent", "RGBAComponent", Strategy.Class, new String[]{"aafRGBAComponent"}));
        table.put("RGBALayout", new TypeItem("RGBALayout", "RGBAComponent[]", Strategy.Annotation, new String[]{"aafRGBAComponent *"}));
        table.put("RGBAComponentKind", new TypeItem("RGBAComponentKind", "RGBAComponentKind", Strategy.Enumeration, new String[]{"aafRGBAComponentKind"}));
        table.put("ScanningDirectionType", new TypeItem("ScanningDirectionType", "ScanningDirectionType", Strategy.Enumeration, new String[]{"aafScanningDirection"}));
        table.put("SearchDictionaryTag", new TypeItem("SearchDictionaryTag", "SearchDictionaryTag", Strategy.Enumeration, new String[]{"aafSearchDictionaryTag"}));
        table.put("SearchTag", new TypeItem("SearchTag", "SearchTag", Strategy.Enumeration, new String[]{"aafSearchTag"}));
        table.put("SignalStandardType", new TypeItem("SignalStandardType", "SignalStandardType", Strategy.Enumeration, new String[]{"aafSignalStandard"}));
        table.put("SlotID", new TypeItem("SlotID", "int", Strategy.Annotation, new String[]{"aafSlotID"}));
        table.put("SourceReference", new TypeItem("SourceReference", "SourceReferenceValue", Strategy.Class, new String[]{"aafSourceRef"}));
        table.put("MobIDType", new TypeItem("MobIDType", "MobID", Strategy.Class, new String[]{"aafMobID"}));
        table.put("String", new TypeItem("String", "String", Strategy.Annotation, new String[]{"aafString"}));
        table.put("SwapNeeded", new TypeItem("SwapNeeded", "SwapNeeded", Strategy.Enumeration, new String[]{"aafSwapNeeded"}));
        table.put("TapeCaseType", new TypeItem("TapeCaseType", "TapeCaseType", Strategy.Enumeration, new String[]{"aafTapeCaseType"}));
        table.put("TapeFormatType", new TypeItem("TapeFormatType", "TapeFormatType", Strategy.Enumeration, new String[]{"aafTapeFormatType"}));
        table.put("TCSource", new TypeItem("TCSource", "TCSource", Strategy.Enumeration, new String[]{"aafTCSource", "aafTimecodeSource"}));
        table.put("Timecode", new TypeItem("Timecode", "TimecodeValue", Strategy.Class, new String[]{"aafTimecode"}));
        table.put("TimeStamp", new TypeItem("TimeStamp", "TimeStamp", Strategy.Class, new String[]{"aafTimeStamp"}));
        table.put("TimeStruct", new TypeItem("TimeStruct", "TimeStruct", Strategy.Class, new String[]{"aafTimeStruct"}));
        table.put("TypeCategory", new TypeItem("TypeCategory", "TypeCategory", Strategy.Enumeration, new String[]{"aafTypeCategory"}));
        table.put("AUID", new TypeItem("AUID", "AUID", Strategy.Class, new String[]{"aafUID"}));
        table.put("AUIDArray", new TypeItem("AUIDArray", "AUID[]", Strategy.Annotation, new String[]{"aafUID_constptr"}));
        table.put("UInt16", new TypeItem("UInt16", "short", Strategy.Annotation, new String[]{"aafUInt16"}));
        table.put("UInt16Array", new TypeItem("UInt16Array", "short[]", Strategy.Annotation, new String[]{"aafUInt16 *"}));
        table.put("UInt32", new TypeItem("UInt32", "int", Strategy.Annotation, new String[]{"aafUInt32"}));
        table.put("UInt32Array", new TypeItem("UInt32Array", "int[]", Strategy.Annotation, new String[]{"aafUInt32 *"}));
        table.put("UInt32Set", new TypeItem("UInt32Set", "java.util.Set<Integer>", Strategy.Annotation, new String[0]));
        table.put("UInt64", new TypeItem("UInt64", "long", Strategy.Annotation, new String[]{"aafUInt64"}));
        table.put("UInt64Array", new TypeItem("UInt64Array", "long[]", Strategy.Annotation, new String[]{"aafUInt64 *"}));
        table.put("UInt8", new TypeItem("UInt8", "byte[]", Strategy.Annotation, new String[]{"aafUInt8"}));
        table.put("UInt8Array", new TypeItem("UInt8Array", "byte", Strategy.Annotation, new String[]{"aafUInt8 *"}));
        table.put("VersionType", new TypeItem("VersionType", "VersionType", Strategy.Class, new String[]{"aafVersionType"}));
        table.put("VideoLineMap", new TypeItem("VideoLineMap", "int[]", Strategy.Annotation, new String[]{"aafVideoLineMap"}));
        table.put("VideoSignalType", new TypeItem("VideoSignalType", "VideoSignalType", Strategy.Enumeration, new String[]{"aafVideoSignalType"}));
        table.put("MultiResultItem", new TypeItem("MultiResultItem", "MultiResultItem", Strategy.Class, new String[]{"aafmMultiResult"}));
        table.put("MultiXferItem", new TypeItem("MultiXferItem", "MultiXferItem", Strategy.Class, new String[]{"aafmMultiXfer"}));
        table.put("StrongReference", new TypeItem("StrongReference", "InterchangeObject", Strategy.Annotation, new String[0]));
        table.put("StrongReferenceVector", new TypeItem("StrongReferenceVector", "java.util.List<InterchangeObject>", Strategy.Annotation, new String[0]));
        table.put("StrongReferenceSet", new TypeItem("StrongReferenceSet", "java.util.Set<InterchangeObject>", Strategy.Annotation, new String[0]));
        table.put("WeakReference", new TypeItem("WeakReference", "InterchangeObject", Strategy.Annotation, new String[0]));
        table.put("WeakReferenceVector", new TypeItem("WeakReferenceVector", "java.util.List<InterchangeObject>", Strategy.Annotation, new String[0]));
        table.put("WeakReferenceSet", new TypeItem("WeakReferenceSet", "java.util.Set<InterchangeObject>", Strategy.Annotation, new String[0]));
        table.put("CodingEquationsType", new TypeItem("CodingEquationsType", "AUID", Strategy.Annotation, new String[0]));
        table.put("ColorPrimariesType", new TypeItem("ColorPrimariesType", "AUID", Strategy.Annotation, new String[0]));
        table.put("TransferCharacteristicType", new TypeItem("TransferCharacteristicType", "AUID", Strategy.Annotation, new String[0]));
        table.put("UsageType", new TypeItem("UsageType", "AUID", Strategy.Annotation, new String[0]));
        LookupTable.makeReverseTable();
    }

    static final class TypeItem {
        private String specName;
        private String javaBaseType;
        private Strategy kind;
        private String[] cNames;

        public TypeItem(String specName, String javaBaseType, Strategy kind, String[] names) {
            this.specName = specName;
            this.javaBaseType = javaBaseType;
            this.kind = kind;
            this.cNames = names;
        }

        public String[] getCNames() {
            return this.cNames;
        }

        public String getJavaBaseType() {
            return this.javaBaseType;
        }

        public String getAAFName() {
            return this.specName;
        }

        public Strategy getKind() {
            return this.kind;
        }
    }

    public static enum Strategy {
        Enumeration,
        Class,
        Annotation,
        AbstractUnion;

    }
}

