/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import tv.amwa.maj.constant.DataDefinitionConstant;
import tv.amwa.maj.enumeration.AppendOption;
import tv.amwa.maj.enumeration.Depend;
import tv.amwa.maj.enumeration.IncludedMedia;
import tv.amwa.maj.enumeration.MaterialType;
import tv.amwa.maj.exception.AdjacentTransitionException;
import tv.amwa.maj.exception.BadLengthException;
import tv.amwa.maj.exception.BadPropertyException;
import tv.amwa.maj.exception.EventSemanticsException;
import tv.amwa.maj.exception.InsufficientTransitionMaterialException;
import tv.amwa.maj.exception.InvalidDataDefinitionException;
import tv.amwa.maj.exception.LeadingTransitionException;
import tv.amwa.maj.exception.ObjectNotFoundException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.exception.TimecodeNotFoundException;
import tv.amwa.maj.exception.TrackExistsException;
import tv.amwa.maj.exception.TrackNotFoundException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaListAppend;
import tv.amwa.maj.industry.MediaListGetAt;
import tv.amwa.maj.industry.MediaListInsertAt;
import tv.amwa.maj.industry.MediaListPrepend;
import tv.amwa.maj.industry.MediaListRemoveAt;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertyRemove;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.StrongReferenceVector;
import tv.amwa.maj.industry.TypeDefinitions;
import tv.amwa.maj.integer.Int64;
import tv.amwa.maj.misctype.TrackID;
import tv.amwa.maj.model.AAFFile;
import tv.amwa.maj.model.DataDefinition;
import tv.amwa.maj.model.KLVData;
import tv.amwa.maj.model.Package;
import tv.amwa.maj.model.Segment;
import tv.amwa.maj.model.Sequence;
import tv.amwa.maj.model.TaggedValue;
import tv.amwa.maj.model.TimelineTrack;
import tv.amwa.maj.model.Track;
import tv.amwa.maj.model.impl.DataDefinitionImpl;
import tv.amwa.maj.model.impl.EventTrackImpl;
import tv.amwa.maj.model.impl.FillerImpl;
import tv.amwa.maj.model.impl.InterchangeObjectImpl;
import tv.amwa.maj.model.impl.SourceClipImpl;
import tv.amwa.maj.model.impl.StaticTrackImpl;
import tv.amwa.maj.model.impl.TaggedValueImpl;
import tv.amwa.maj.model.impl.TimelineTrackImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.InstanceNumberGeneration;
import tv.amwa.maj.record.MaterialNumberGeneration;
import tv.amwa.maj.record.PackageID;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.TimeStamp;
import tv.amwa.maj.record.impl.AUIDImpl;
import tv.amwa.maj.record.impl.PackageIDImpl;
import tv.amwa.maj.record.impl.RationalImpl;
import tv.amwa.maj.record.impl.TimeStampImpl;
import tv.amwa.maj.record.impl.TimecodeValueImpl;
import tv.amwa.maj.union.SourceReferenceValue;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=13312, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="Package", aliases={"Mob"}, description="Specifies a package, which can describe a composition, essence, or physical media.", symbol="Package", isConcrete=false)
public class PackageImpl
extends InterchangeObjectImpl
implements Package,
tv.amwa.maj.extensions.avid.Package,
Serializable,
Cloneable {
    private static final long serialVersionUID = -1772171014938118040L;
    private PackageID packageID;
    private String packageName = null;
    private List<Track> packageTracks = Collections.synchronizedList(new Vector());
    private TimeStamp packageLastModified;
    private TimeStamp creationTime;
    private List<TaggedValue> packageUserComments = Collections.synchronizedList(new Vector());
    private List<TaggedValue> packageAttributes = Collections.synchronizedList(new Vector());
    private List<KLVData> packageKLVData = Collections.synchronizedList(new Vector());
    private AUID packageUsage = null;
    private Boolean convertFrameRate = null;
    private List<TaggedValue> mobAttributeList = Collections.synchronizedList(new Vector());
    @Int64
    private Long subclipFullLength = null;
    @Int64
    private Long subclipBegin = null;

    @MediaProperty(uuid1=50397712, uuid2=1792, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 7}, definedName="PackageAttributes", aliases={"Attributes", "MobAttributes"}, typeName="TaggedValueStrongReferenceVector", optional=true, uniqueIdentifier=false, pid=17417, symbol="PackageAttributes")
    public List<TaggedValue> getPackageAttributes() throws PropertyNotPresentException {
        if (this.packageAttributes.size() == 0) {
            throw new PropertyNotPresentException("The optional attributes property is not present in this package.");
        }
        return StrongReferenceVector.getOptionalList(this.packageAttributes);
    }

    @Override
    public void appendPackageAttribute(String name, String value) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("Cannot create and append a new attribute to the list of attributes for this package with a null name value.");
        }
        if (value == null) {
            throw new NullPointerException("Cannot create and append a new attribute to the list of attributes for this package with a null value.");
        }
        TaggedValueImpl taggedValue = new TaggedValueImpl(name, TypeDefinitions.UTF16String, (Serializable)((Object)value));
        StrongReferenceVector.appendNoClone(this.packageAttributes, taggedValue);
    }

    @Override
    @MediaListAppend(value="PackageAttributes")
    public void appendPackageAttribute(TaggedValue packageAttribute) throws NullPointerException {
        if (packageAttribute == null) {
            throw new NullPointerException("Cannot append a null attribute to the attributes of this package.");
        }
        StrongReferenceVector.append(this.packageAttributes, packageAttribute);
    }

    @MediaListPrepend(value="PackageAttributes")
    public void prependPackageAttribute(TaggedValue packageAttribute) throws NullPointerException {
        if (packageAttribute == null) {
            throw new NullPointerException("Cannot prepend a null attribute to the attributes of this package.");
        }
        StrongReferenceVector.prepend(this.packageAttributes, packageAttribute);
    }

    @Override
    @MediaPropertyCount(value="PackageAttributes")
    public int countPackageAttributes() {
        return this.packageAttributes.size();
    }

    @Override
    @MediaPropertyClear(value="PackageAttributes")
    public void clearPackageAttributes() {
        this.packageAttributes = Collections.synchronizedList(new Vector());
    }

    @Override
    @MediaPropertyRemove(value="PackageAttributes")
    public void removePackageAttribute(TaggedValue packageAttribute) throws NullPointerException, PropertyNotPresentException, ObjectNotFoundException {
        if (packageAttribute == null) {
            throw new NullPointerException("Cannot remove an attribute from the list of attributes of this package using a null value.");
        }
        if (this.packageAttributes.size() == 0) {
            throw new PropertyNotPresentException("The optional attributes property is not present in this package.");
        }
        if (!this.packageAttributes.contains(packageAttribute)) {
            throw new ObjectNotFoundException("Canoot remove the given attribute from the list of attributes of this package as it is not currently contained.");
        }
        StrongReferenceVector.remove(this.packageAttributes, packageAttribute);
    }

    @MediaProperty(uuid1=50462978, uuid2=3072, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="PackageUserComments", aliases={"UserComments", "MobUserComments"}, typeName="TaggedValueStrongReferenceVector", optional=true, uniqueIdentifier=false, pid=17414, symbol="PackageUserComments")
    public List<TaggedValue> getPackageUserComments() throws PropertyNotPresentException {
        if (this.packageUserComments.size() == 0) {
            throw new PropertyNotPresentException("The optional user comments property is not present in this package.");
        }
        return StrongReferenceVector.getOptionalList(this.packageUserComments);
    }

    @Override
    public void appendPackageUserComment(String category, String comment) throws NullPointerException {
        if (category == null) {
            throw new NullPointerException("Cannot create and append a new user comment for this package will a null category name value.");
        }
        if (comment == null) {
            throw new NullPointerException("Cannot create and append a new user comment for this package with a null comment value.");
        }
        TaggedValueImpl taggedValue = new TaggedValueImpl(category, TypeDefinitions.UTF16String, (Serializable)((Object)comment));
        StrongReferenceVector.appendNoClone(this.packageUserComments, taggedValue);
    }

    @Override
    @MediaListAppend(value="PackageUserComments")
    public void appendPackageUserComment(TaggedValue packageUserComment) throws NullPointerException {
        if (packageUserComment == null) {
            throw new NullPointerException("Cannot append a new user comment with a null tagged value to this package.");
        }
        StrongReferenceVector.append(this.packageUserComments, packageUserComment);
    }

    @MediaListPrepend(value="PackageUserComments")
    public void prependPackageUserComment(TaggedValue comment) throws NullPointerException {
        if (comment == null) {
            throw new NullPointerException("Cannot prepend a new user comment with a null tagged value to this package.");
        }
        StrongReferenceVector.prepend(this.packageUserComments, comment);
    }

    @Override
    @MediaPropertyCount(value="PackageUserComments")
    public int countPackageUserComments() {
        return this.packageUserComments.size();
    }

    @Override
    @MediaPropertyClear(value="PackageUserComments")
    public void clearPackageUserComments() {
        this.packageUserComments = Collections.synchronizedList(new Vector());
    }

    @Override
    @MediaPropertyRemove(value="PackageUserComments")
    public void removePackageUserComment(TaggedValue packageUserComment) throws NullPointerException, PropertyNotPresentException, ObjectNotFoundException {
        if (packageUserComment == null) {
            throw new NullPointerException("Cannot remove the given comment from the user comments of this package as it is null.");
        }
        if (this.packageUserComments.size() == 0) {
            throw new PropertyNotPresentException("The optional user comments property is not present in this package.");
        }
        if (!this.packageUserComments.contains(packageUserComment)) {
            throw new ObjectNotFoundException("Cannot remove the given comment for the user comments of this package as it is not currently contained.");
        }
        StrongReferenceVector.remove(this.packageUserComments, packageUserComment);
    }

    @MediaProperty(uuid1=50397712, uuid2=768, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="PackageKLVData", aliases={"MobKLVData", "KLVData"}, typeName="KLVDataStrongReferenceVector", optional=true, uniqueIdentifier=false, pid=17415, symbol="PackageKLVData")
    public List<KLVData> getPackageKLVData() throws PropertyNotPresentException {
        if (this.packageKLVData.size() == 0) {
            throw new PropertyNotPresentException("No KLV data values are present in this package.");
        }
        return StrongReferenceVector.getOptionalList(this.packageKLVData);
    }

    @Override
    @MediaListAppend(value="PackageKLVData")
    public void appendPackageKLVData(KLVData packageKLVdata) throws NullPointerException {
        if (packageKLVdata == null) {
            throw new NullPointerException("Cannot append a null klv data item to the list of klv data items of this package.");
        }
        StrongReferenceVector.append(this.packageKLVData, packageKLVdata);
    }

    @MediaListPrepend(value="PackageKLVData")
    public void prependPackageKLVData(KLVData packageKLVdata) throws NullPointerException {
        if (packageKLVdata == null) {
            throw new NullPointerException("Cannot prepend a null klv data item to the list of klv data items of this package.");
        }
        StrongReferenceVector.prepend(this.packageKLVData, packageKLVdata);
    }

    @Override
    @MediaPropertyCount(value="PackageKLVData")
    public int countPackageKLVData() {
        return this.packageKLVData.size();
    }

    @Override
    @MediaPropertyClear(value="PackageKLVData")
    public void clearPackageKLVData() {
        this.packageKLVData = Collections.synchronizedList(new Vector());
    }

    @Override
    @MediaPropertyRemove(value="PackageKLVData")
    public void removePackageKLVData(KLVData packageKLVdata) throws NullPointerException, ObjectNotFoundException {
        if (packageKLVdata == null) {
            throw new NullPointerException("Cannot remove a null value from the list of klv data items of this package.");
        }
        if (!this.packageKLVData.contains(packageKLVdata)) {
            throw new ObjectNotFoundException("Cannot remove the given klv data item from the list of klv data items of this package as it is not currently contained.");
        }
        StrongReferenceVector.remove(this.packageKLVData, packageKLVdata);
    }

    @MediaProperty(uuid1=100729092, uuid2=1541, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="PackageTracks", aliases={"Slots", "MobSlots"}, typeName="TrackStrongReferenceVector", optional=false, uniqueIdentifier=false, pid=17411, symbol="PackageTracks")
    public List<Track> getPackageTracks() {
        return StrongReferenceVector.getRequiredList(this.packageTracks);
    }

    public static final List<Track> initializePackageTracks() {
        ArrayList<Track> initialTracks = new ArrayList<Track>(1);
        FillerImpl filler = new FillerImpl(DataDefinitionImpl.forName("Unknown"), 0L);
        TimelineTrackImpl firstTrack = new TimelineTrackImpl(1, filler, new RationalImpl(1, 1), 0L);
        initialTracks.add(firstTrack);
        return initialTracks;
    }

    @Override
    public EventTrackImpl appendNewEventTrack(Rational editRate, Segment segment, int trackID, String trackName) throws NullPointerException, IllegalArgumentException, TrackExistsException {
        EventTrackImpl createdTrack = new EventTrackImpl(trackID, segment, editRate);
        createdTrack.setTrackName(trackName);
        this.appendPackageTrack(createdTrack);
        return createdTrack;
    }

    @Override
    public StaticTrackImpl appendNewStaticTrack(Segment segment, int trackID, String trackName) throws NullPointerException, IllegalArgumentException, TrackExistsException {
        StaticTrackImpl createdTrack = new StaticTrackImpl(trackID, segment);
        createdTrack.setTrackName(trackName);
        this.appendPackageTrack(createdTrack);
        return createdTrack;
    }

    @Override
    public TimelineTrackImpl appendNewTimelineTrack(Rational editRate, Segment segment, @TrackID int trackID, String trackName, long origin) throws NullPointerException, IllegalArgumentException, TrackExistsException {
        TimelineTrackImpl createdTrack = new TimelineTrackImpl(trackID, segment, editRate, origin);
        createdTrack.setTrackName(trackName);
        this.appendPackageTrack(createdTrack);
        return createdTrack;
    }

    @Override
    @MediaListAppend(value="PackageTracks")
    public void appendPackageTrack(Track track) throws NullPointerException, TrackExistsException {
        if (track == null) {
            throw new NullPointerException("Cannot append a null track to the list of tracks for this package.");
        }
        if (this.packageTracks.size() == 1 && this.packageTracks.get(0) instanceof TimelineTrackImpl && ((TimelineTrack)this.packageTracks.get(0)).getDataDefinition().equals(DataDefinitionImpl.forAUID(DataDefinitionConstant.Unknown)) && ((TimelineTrack)this.packageTracks.get(0)).getEditRate().equals(new RationalImpl(1, 1))) {
            this.clearPackageTracks();
        }
        int givenTrackID = track.getTrackID();
        for (Track trackItem : this.packageTracks) {
            if (trackItem.getTrackID() != givenTrackID) continue;
            throw new TrackExistsException("A track with track id " + givenTrackID + " is already contained in this package.");
        }
        StrongReferenceVector.append(this.packageTracks, track);
    }

    @Override
    @MediaPropertyCount(value="PackageTracks")
    public int countPackageTracks() {
        return this.packageTracks.size();
    }

    @Override
    @MediaListGetAt(value="PackageTracks")
    public Track getPackageTrackAt(int index) throws IndexOutOfBoundsException {
        return StrongReferenceVector.getAt(this.packageTracks, index);
    }

    @Override
    @MediaListInsertAt(value="PackageTracks")
    public void insertPackageTrackAt(int index, Track track) throws NullPointerException, IndexOutOfBoundsException, TrackExistsException {
        if (track == null) {
            throw new NullPointerException("Cannot insert a null-valued track into the list of tracks of this package.");
        }
        if (this.packageTracks.size() == 1 && this.packageTracks.get(0) instanceof TimelineTrackImpl && ((TimelineTrack)this.packageTracks.get(0)).getDataDefinition().equals(DataDefinitionImpl.forAUID(DataDefinitionConstant.Unknown)) && ((TimelineTrack)this.packageTracks.get(0)).getEditRate().equals(new RationalImpl(1, 1))) {
            this.clearPackageTracks();
        }
        int givenTrackId = track.getTrackID();
        for (Track trackItem : this.packageTracks) {
            if (trackItem.getTrackID() != givenTrackId) continue;
            throw new TrackExistsException("The given track id of " + givenTrackId + " is already used to identify a track contained in this package.");
        }
        StrongReferenceVector.insert(this.packageTracks, index, track);
    }

    @Override
    public Track lookupPackageTrack(int trackID) throws TrackNotFoundException {
        if (trackID < 0) {
            throw new TrackNotFoundException("Cannot lookup a track with a negative track number from the list of tracks of this package.");
        }
        for (Track track : this.packageTracks) {
            if (track.getTrackID() != trackID) continue;
            return track;
        }
        throw new TrackNotFoundException("Could not find a track with the given track id in the list of tracks of this package.");
    }

    @Override
    @MediaListPrepend(value="PackageTracks")
    public void prependPackageTrack(Track track) throws NullPointerException, TrackExistsException {
        if (track == null) {
            throw new NullPointerException("Cannot prepend a null track to the list of tracks for this package.");
        }
        if (this.packageTracks.size() == 1 && this.packageTracks.get(0) instanceof TimelineTrackImpl && ((TimelineTrack)this.packageTracks.get(0)).getDataDefinition().equals(DataDefinitionImpl.forAUID(DataDefinitionConstant.Unknown)) && ((TimelineTrack)this.packageTracks.get(0)).getEditRate().equals(new RationalImpl(1, 1))) {
            this.clearPackageTracks();
        }
        int givenTrackId = track.getTrackID();
        for (Track trackItem : this.packageTracks) {
            if (trackItem.getTrackID() != givenTrackId) continue;
            throw new TrackExistsException("The given track id of " + givenTrackId + " is already used to identify a track contained in this package.");
        }
        StrongReferenceVector.prepend(this.packageTracks, track);
    }

    @Override
    @MediaListRemoveAt(value="PackageTracks")
    public void removePackageTrackAt(int index) throws IndexOutOfBoundsException {
        StrongReferenceVector.remove(this.packageTracks, index);
    }

    @Override
    @MediaPropertyClear(value="PackageTracks")
    public void clearPackageTracks() {
        this.packageTracks = Collections.synchronizedList(new Vector());
    }

    @Override
    @MediaProperty(uuid1=117571856, uuid2=259, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="CreationTime", aliases={"CreateTime", "CreationDate"}, typeName="TimeStamp", optional=false, uniqueIdentifier=false, pid=17413, symbol="CreationTime")
    public TimeStamp getCreationTime() {
        return this.creationTime.clone();
    }

    @Override
    @MediaPropertySetter(value="CreationTime")
    public void setCreationTime(TimeStamp createTime) throws NullPointerException {
        if (createTime == null) {
            throw new NullPointerException("Cannot set the required creation time property of this package with a null value.");
        }
        this.creationTime = createTime.clone();
    }

    public static final TimeStamp initializeCreationTime() {
        return new TimeStampImpl();
    }

    @Override
    @MediaProperty(uuid1=0x1011510, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="PackageID", aliases={"MobID"}, typeName="PackageIDType", optional=false, uniqueIdentifier=true, pid=17409, symbol="PackageID")
    public PackageID getPackageID() {
        return this.packageID.clone();
    }

    @Override
    @MediaPropertySetter(value="PackageID")
    public void setPackageID(PackageID packageID) throws NullPointerException {
        if (packageID == null) {
            throw new NullPointerException("Canoot set the package id of this package using a null value.");
        }
        this.packageID = packageID.clone();
    }

    public static final PackageID initializePackageID() {
        return PackageIDImpl.umidFactory(MaterialType.NotIdentified, MaterialNumberGeneration.UUID_UL, InstanceNumberGeneration.NotDefined, AUIDImpl.randomAUID().getAUIDValue());
    }

    @Override
    @MediaProperty(uuid1=117571856, uuid2=517, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="PackageLastModified", aliases={"LastModified", "MobLastModified", "ModificationDate"}, typeName="TimeStamp", optional=false, uniqueIdentifier=false, pid=17412, symbol="PackageLastModified")
    public TimeStamp getPackageLastModified() {
        return this.packageLastModified.clone();
    }

    @Override
    @MediaPropertySetter(value="PackageLastModified")
    public void setPackageLastModified(TimeStamp modTime) throws NullPointerException {
        if (modTime == null) {
            throw new NullPointerException("Cannot set the last modificaiton value of this package with a null value.");
        }
        this.packageLastModified = modTime.clone();
    }

    public static final TimeStamp initializePackageLastModified() {
        return new TimeStampImpl();
    }

    @Override
    @MediaProperty(uuid1=16974594, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="PackageName", aliases={"Name", "MobName"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=17410, symbol="PackageName")
    public String getPackageName() throws PropertyNotPresentException {
        if (this.packageName == null) {
            throw new PropertyNotPresentException("The optional name property is not present in this package.");
        }
        return this.packageName;
    }

    @Override
    @MediaPropertySetter(value="PackageName")
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    @MediaProperty(uuid1=83951880, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 7}, definedName="PackageUsage", aliases={"UsageCode"}, typeName="UsageType", optional=true, uniqueIdentifier=false, pid=17416, symbol="PackageUsage")
    public AUID getPackageUsage() throws PropertyNotPresentException {
        if (this.packageUsage == null) {
            throw new PropertyNotPresentException("The optional package usage property is not present in this package.");
        }
        return this.packageUsage;
    }

    @Override
    @MediaPropertySetter(value="PackageUsage")
    public void setPackageUsage(AUID packageUsage) {
        this.packageUsage = packageUsage == null ? null : packageUsage.clone();
    }

    @Override
    public TimecodeValueImpl offsetToPackageTimecode(Segment tcSeg, long offset) throws NullPointerException, TimecodeNotFoundException {
        return null;
    }

    @Override
    public void changeReference(PackageID oldPackageID, PackageID newPackageID) throws NullPointerException {
    }

    @Override
    public Package cloneExternal(Depend resolveDependencies, IncludedMedia includedMedia, AAFFile file) {
        return null;
    }

    @Override
    public Package copy(String destMobName) throws NullPointerException {
        return null;
    }

    void addPhysicalSourceReference(AppendOption addType, Rational editRate, int trackId, DataDefinition essenceKind, SourceReferenceValue reference, long sourceReferenceLength) throws NullPointerException, InvalidDataDefinitionException, BadLengthException, TrackExistsException {
        SourceClipImpl sourceClip = new SourceClipImpl(essenceKind, sourceReferenceLength, reference);
        Track track = null;
        try {
            track = this.lookupPackageTrack(trackId);
        }
        catch (TrackNotFoundException trackNotFoundException) {
            // empty catch block
        }
        if (track != null) {
            switch (addType) {
                case ForceOverwrite: {
                    track.setTrackSegment(sourceClip);
                    break;
                }
                case Append: {
                    Segment trackSegment = track.getTrackSegment();
                    Sequence sequence = trackSegment.generateSequence();
                    try {
                        sequence.appendComponentObject(sourceClip);
                    }
                    catch (LeadingTransitionException leadingTransitionException) {
                    }
                    catch (EventSemanticsException eventSemanticsException) {
                    }
                    catch (BadPropertyException e) {
                        e.printStackTrace();
                    }
                    catch (BadLengthException e) {
                        e.printStackTrace();
                    }
                    catch (AdjacentTransitionException adjacentTransitionException) {
                    }
                    catch (InsufficientTransitionMaterialException insufficientTransitionMaterialException) {
                        // empty catch block
                    }
                    track.setTrackSegment(sequence);
                    break;
                }
            }
        } else {
            this.appendNewTimelineTrack(editRate, sourceClip, trackId, null, 0L);
        }
    }

    @Override
    public Package clone() {
        return (Package)super.clone();
    }

    @Override
    @MediaProperty(uuid1=-735822892, uuid2=322, uuid3=17813, uuid4={-88, -13, -14, -21, -91, 66, 68, -34}, definedName="ConvertFrameRate", typeName="Boolean", optional=true, uniqueIdentifier=false, pid=0, symbol="ConvertFrameRate", namespace="http://www.amwa.tv/is03/extensions/avid", prefix="avid")
    public boolean getConvertFrameRate() throws PropertyNotPresentException {
        if (this.convertFrameRate == null) {
            throw new PropertyNotPresentException("The optional convert frame rate property is not present for this package.");
        }
        return this.convertFrameRate;
    }

    @Override
    @MediaPropertySetter(value="ConvertFrameRate")
    public void setConvertFrameRate(Boolean convertFrameRate) {
        this.convertFrameRate = convertFrameRate;
    }

    @MediaProperty(uuid1=1620410755, uuid2=18353, uuid3=4564, uuid4={-96, 28, 0, 4, -84, -106, -97, 80}, definedName="MobAttributeList", typeName="TaggedValueStrongReferenceVector", optional=true, uniqueIdentifier=false, pid=0, symbol="MobAttributeList", namespace="http://www.amwa.tv/is03/extensions/avid", prefix="avid")
    public List<TaggedValue> getMobAttributeList() throws PropertyNotPresentException {
        if (this.mobAttributeList.size() == 0) {
            throw new PropertyNotPresentException("The optional mob attribute list property is not present for this package.");
        }
        return StrongReferenceVector.getOptionalList(this.mobAttributeList);
    }

    @Override
    @MediaListAppend(value="MobAttributeList")
    public void appendMobAttributeItem(TaggedValue mobAttributeItem) throws NullPointerException {
        if (mobAttributeItem == null) {
            throw new NullPointerException("Cannot append to the mob attribute list of this package using a null value.");
        }
        StrongReferenceVector.append(this.mobAttributeList, mobAttributeItem);
    }

    @Override
    @MediaListPrepend(value="MobAttributeList")
    public void prependMobAttributeItem(TaggedValue mobAttributeItem) throws NullPointerException {
        if (mobAttributeItem == null) {
            throw new NullPointerException("Cannot prepend to the mob attribute list of this package using a null value.");
        }
        StrongReferenceVector.prepend(this.mobAttributeList, mobAttributeItem);
    }

    @Override
    @MediaListInsertAt(value="MobAttributeList")
    public void insertMobAttributeItem(int index, TaggedValue mobAttributeItem) throws NullPointerException, IndexOutOfBoundsException {
        if (mobAttributeItem == null) {
            throw new NullPointerException("Cannot insert into the mob attribute list of this package using a null value.");
        }
        StrongReferenceVector.insert(this.mobAttributeList, index, mobAttributeItem);
    }

    @Override
    @MediaPropertyCount(value="MobAttributeList")
    public int countMobAttributeList() {
        return this.mobAttributeList.size();
    }

    @Override
    @MediaPropertyClear(value="MobAttributeList")
    public void clearMobAttributeList() {
        this.mobAttributeList.clear();
    }

    @Override
    @MediaListGetAt(value="MobAttributeList")
    public TaggedValue getMobAttributeItemAt(int index) throws IndexOutOfBoundsException {
        return StrongReferenceVector.getAt(this.mobAttributeList, index);
    }

    @Override
    @MediaListRemoveAt(value="MobAttributeList")
    public void removeMobAttributeItemAt(int index) throws IndexOutOfBoundsException {
        StrongReferenceVector.remove(this.mobAttributeList, index);
    }

    @Override
    @MediaProperty(uuid1=308461435, uuid2=-798, uuid3=19966, uuid4={-96, -10, -50, -20, 4, 124, -128, -86}, definedName="SubclipFullLength", typeName="Int64", optional=true, uniqueIdentifier=false, pid=0, symbol="SubclipFullLength1", namespace="http://www.amwa.tv/is03/extensions/avid", prefix="avid")
    @Int64
    public long getSubclipFullLength() throws PropertyNotPresentException {
        if (this.subclipFullLength == null) {
            throw new PropertyNotPresentException("The optional subclip full length property is not present for this package.");
        }
        return this.subclipFullLength;
    }

    @Override
    @MediaPropertySetter(value="SubclipFullLength")
    public void setSubclipFullLength(@Int64 Long subclipFullLength) {
        this.subclipFullLength = subclipFullLength;
    }

    @Override
    @MediaProperty(uuid1=-1440434601, uuid2=-837, uuid3=18721, uuid4={-107, 29, 58, 32, 56, 57, 103, 34}, definedName="SubclipBegin", typeName="Int64", optional=true, uniqueIdentifier=false, pid=0, symbol="SubclipBegin", namespace="http://www.amwa.tv/is03/extensions/avid", prefix="avid")
    @Int64
    public long getSubclipBegin() throws PropertyNotPresentException {
        if (this.subclipBegin == null) {
            throw new PropertyNotPresentException("The optional subclip begin property is not present for this package.");
        }
        return this.subclipBegin;
    }

    @Override
    @MediaPropertySetter(value="SubclipBegin")
    public void setSubclipBegin(@Int64 Long subclipBegin) {
        this.subclipBegin = subclipBegin;
    }

    public String getPackageUsageString() {
        return AUIDImpl.toPersistentForm(this.packageUsage);
    }

    public void setPackageUsageString(String packageUsage) {
        this.packageUsage = AUIDImpl.fromPersistentForm(packageUsage);
    }

    public String getPackageLastModifiedString() {
        return TimeStampImpl.toPersistentForm(this.packageLastModified);
    }

    public void setPackageLastModifiedString(String packageLastModified) {
        this.packageLastModified = TimeStampImpl.fromPersistentForm(packageLastModified);
    }

    public String getCreationTimeString() {
        return TimeStampImpl.toPersistentForm(this.creationTime);
    }

    public void setCreationTimeString(String creationTime) {
        this.creationTime = TimeStampImpl.fromPersistentForm(creationTime);
    }

    public String getPackageIDString() {
        return PackageIDImpl.toPersistentForm(this.packageID);
    }

    public void setPackageIDString(String packageID) {
        this.packageID = PackageIDImpl.fromPersistentForm(packageID);
    }

    @Override
    public String getWeakTargetReference() {
        return "PackageWeakReference";
    }

    @Override
    public AUID getAUID() {
        return this.packageID.getMaterial();
    }
}

