/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import tv.amwa.maj.constant.ContainerConstant;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaListAppend;
import tv.amwa.maj.industry.MediaListGetAt;
import tv.amwa.maj.industry.MediaListInsertAt;
import tv.amwa.maj.industry.MediaListPrepend;
import tv.amwa.maj.industry.MediaListRemoveAt;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.StrongReferenceVector;
import tv.amwa.maj.misctype.LengthType;
import tv.amwa.maj.model.AAFFileDescriptor;
import tv.amwa.maj.model.DataEssenceDescriptor;
import tv.amwa.maj.model.MultipleDescriptor;
import tv.amwa.maj.model.impl.AAFFileDescriptorImpl;
import tv.amwa.maj.model.impl.ContainerDefinitionImpl;
import tv.amwa.maj.model.impl.DataEssenceDescriptorImpl;
import tv.amwa.maj.record.Rational;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=17408, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="MultipleDescriptor", description="Describes the format of the content data associated with a file source package containing multiple tracks of essence.", symbol="MultipleDescriptor")
public class MultipleDescriptorImpl
extends AAFFileDescriptorImpl
implements MultipleDescriptor,
Serializable,
Cloneable {
    private static final long serialVersionUID = -1248555207364210775L;
    private List<AAFFileDescriptor> fileDescriptors = Collections.synchronizedList(new Vector());

    public MultipleDescriptorImpl() {
        this.setDescribesStaticEssence();
    }

    public MultipleDescriptorImpl(Rational sampleRate, @LengthType long length) throws NullPointerException, IllegalArgumentException {
        if (sampleRate == null) {
            throw new NullPointerException("Cannot set the sample rate for a multiple descriptor using a null rational value.");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("Cannot set the length of a multiple descriptor using a negative value.");
        }
        this.setDescribesTimeVaryingEssence(sampleRate, length);
    }

    @MediaProperty(uuid1=100729092, uuid2=1547, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 4}, definedName="FileDescriptors", typeName="FileDescriptorStrongReferenceVector", optional=false, uniqueIdentifier=false, pid=16129, symbol="FileDescriptors")
    public List<AAFFileDescriptor> getFileDescriptors() {
        return StrongReferenceVector.getRequiredList(this.fileDescriptors);
    }

    public static final List<AAFFileDescriptor> initializeFileDescriptors() {
        ArrayList<AAFFileDescriptor> initialDescriptors = new ArrayList<AAFFileDescriptor>(1);
        initialDescriptors.add(new DataEssenceDescriptorImpl(ContainerDefinitionImpl.forName("External")));
        return initialDescriptors;
    }

    @Override
    @MediaListAppend(value="FileDescriptors")
    public void appendFileDescriptor(AAFFileDescriptor fileDescriptor) throws NullPointerException {
        if (fileDescriptor == null) {
            throw new NullPointerException("Cannot append a null file descriptor to the list of file descriptors of this multiple descriptor.");
        }
        this.removeInitialDescriptor();
        StrongReferenceVector.append(this.fileDescriptors, fileDescriptor);
    }

    void removeInitialDescriptor() {
        if (this.fileDescriptors.size() != 1) {
            return;
        }
        AAFFileDescriptor isItTheDefaultDescriptor = this.fileDescriptors.get(0);
        if (!(isItTheDefaultDescriptor instanceof DataEssenceDescriptor)) {
            return;
        }
        if (!isItTheDefaultDescriptor.getContainerFormat().getAUID().equals(ContainerConstant.External)) {
            return;
        }
        this.clearFileDescriptors();
    }

    @Override
    @MediaPropertyCount(value="FileDescriptors")
    public int countFileDescriptors() {
        return this.fileDescriptors.size();
    }

    @Override
    @MediaListGetAt(value="FileDescriptors")
    public AAFFileDescriptor getFileDescriptorAt(int index) throws IndexOutOfBoundsException {
        return StrongReferenceVector.getAt(this.fileDescriptors, index);
    }

    @Override
    @MediaListInsertAt(value="FileDescriptors")
    public void insertFileDescriptorAt(int index, AAFFileDescriptor fileDescriptor) throws NullPointerException, IndexOutOfBoundsException {
        if (fileDescriptor == null) {
            throw new NullPointerException("Cannot insert a null file descriptor into the list of file descriptors of this multiple descriptor.");
        }
        this.removeInitialDescriptor();
        StrongReferenceVector.insert(this.fileDescriptors, index, fileDescriptor);
    }

    @Override
    @MediaListPrepend(value="FileDescriptors")
    public void prependFileDescriptor(AAFFileDescriptor fileDescriptor) throws NullPointerException {
        if (fileDescriptor == null) {
            throw new NullPointerException("Cannot prepend a null file descriptor to the list of file descriptors of this multiple descriptor.");
        }
        this.removeInitialDescriptor();
        StrongReferenceVector.prepend(this.fileDescriptors, fileDescriptor);
    }

    @Override
    @MediaListRemoveAt(value="FileDescriptors")
    public void removeFileDescriptorAt(int index) throws IndexOutOfBoundsException {
        StrongReferenceVector.remove(this.fileDescriptors, index);
    }

    @MediaPropertyClear(value="FileDescriptors")
    public void clearFileDescriptors() {
        this.fileDescriptors = Collections.synchronizedList(new Vector());
    }

    @Override
    public MultipleDescriptor clone() {
        return (MultipleDescriptor)super.clone();
    }
}

