/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.aaf;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import tv.amwa.maj.enumeration.ByteOrder;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.industry.MemoryResidentStream;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.industry.Stream;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.industry.WeakReferenceSet;
import tv.amwa.maj.industry.WeakReferenceVector;
import tv.amwa.maj.io.aaf.AAFConstants;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.TypeDefinitionSet;
import tv.amwa.maj.meta.TypeDefinitionVariableArray;
import tv.amwa.maj.meta.TypeDefinitionWeakObjectReference;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.impl.AUIDImpl;

public class ResolutionEntry {
    private PropertyDefinition property;
    private MetadataObject target;
    private Object reference;
    private ByteOrder byteOrder = null;

    public ResolutionEntry(PropertyDefinition property, MetadataObject target, String path) {
        this.property = property;
        this.target = target;
        this.reference = path;
    }

    public ResolutionEntry(PropertyDefinition property, MetadataObject target, String path, ByteOrder byteOrder) {
        this.property = property;
        this.target = target;
        this.reference = path;
        this.byteOrder = byteOrder;
    }

    public ResolutionEntry(PropertyDefinition property, MetadataObject target, AUID reference) {
        this.property = property;
        this.target = target;
        this.reference = reference;
    }

    public MetadataObject getTarget() {
        return this.target;
    }

    public PropertyDefinition getProperty() {
        return this.property;
    }

    public void resolve(Map<String, MetadataObject> pathMap, Map<String, ByteBuffer> indexMap, Map<String, Stream> streamMap) {
        TypeDefinition propertyType = this.property.getTypeDefinition();
        if (this.property.getAUID().equals(AAFConstants.ParametersID)) {
            this.handleParametersSpecialCase(pathMap, indexMap, propertyType);
            return;
        }
        block9 : switch (propertyType.getTypeCategory()) {
            case WeakObjRef: {
                AUID referenceID = null;
                if (!(this.reference instanceof AUID)) {
                    System.err.println("Unexpected " + this.reference.getClass().getName() + " reference value for weak reference property " + this.property.getMemberOf().getName() + "." + this.property.getName() + ".");
                    break;
                }
                referenceID = (AUID)this.reference;
                Class<?> baseClassImplementation = ((TypeDefinitionWeakObjectReference)propertyType).getObjectType().getJavaImplementation();
                WeakReference weakReference = new WeakReference(baseClassImplementation, referenceID);
                try {
                    Field injectionPoint = ResolutionEntry.findInjectionPoint(this.property);
                    injectionPoint.setAccessible(true);
                    injectionPoint.set(this.target, weakReference);
                }
                catch (Exception e) {
                    System.err.println("Could not inject a value into property " + this.property.getName() + ".");
                    this.property.setPropertyValue(this.target, propertyType.createValue(weakReference.getTarget()));
                }
                break;
            }
            case StrongObjRef: {
                MetadataObject referenceTarget = null;
                if (this.reference instanceof String) {
                    referenceTarget = pathMap.get(this.reference);
                }
                if (referenceTarget == null) {
                    System.err.println("Unable to resolve reference " + this.reference + " for property " + this.property.getMemberOf().getName() + "." + this.property.getName());
                    break;
                }
                try {
                    Field injectionPoint = ResolutionEntry.findInjectionPoint(this.property);
                    injectionPoint.setAccessible(true);
                    injectionPoint.set(this.target, referenceTarget);
                }
                catch (Exception e) {
                    System.err.println("Unable to use injection for property " + this.property.getName() + ".");
                    this.property.setPropertyValue(this.target, propertyType.createValue(referenceTarget));
                }
                break;
            }
            case VariableArray: {
                TypeDefinition arrayReferencedType = ((TypeDefinitionVariableArray)propertyType).getType();
                String arrayCollectionPath = (String)this.reference;
                switch (arrayReferencedType.getTypeCategory()) {
                    case StrongObjRef: {
                        ByteBuffer arrayIndexBuffer = indexMap.get(arrayCollectionPath + " index");
                        arrayIndexBuffer.rewind();
                        int entryCount = arrayIndexBuffer.getInt();
                        int firstFree = arrayIndexBuffer.getInt();
                        int lastFree = arrayIndexBuffer.getInt();
                        Vector<MetadataObject> elements = new Vector<MetadataObject>(entryCount);
                        for (int x = 0; x < entryCount; ++x) {
                            String arrayElementPath = arrayCollectionPath + "{" + Integer.toHexString(arrayIndexBuffer.getInt()) + "}";
                            elements.add(pathMap.get(arrayElementPath));
                        }
                        try {
                            Field injectionPoint = ResolutionEntry.findInjectionPoint(this.property);
                            injectionPoint.setAccessible(true);
                            injectionPoint.set(this.target, elements);
                        }
                        catch (Exception e) {
                            System.err.println("Unable to use injection for property " + this.property.getName() + ".");
                            this.property.setPropertyValue(this.target, propertyType.createValue(elements));
                        }
                        break block9;
                    }
                    case WeakObjRef: {
                        ByteBuffer weakArrayIndexBuffer = indexMap.get(arrayCollectionPath + " index");
                        int weakEntryCount = weakArrayIndexBuffer.getInt();
                        short referencedPropertyTag = weakArrayIndexBuffer.getShort();
                        short identificationPid = weakArrayIndexBuffer.getShort();
                        byte identificationSize = weakArrayIndexBuffer.get();
                        WeakReferenceVector weakArray = new WeakReferenceVector();
                        for (int x = 0; x < weakEntryCount; ++x) {
                            try {
                                AUID reference = AUIDImpl.createFromBuffer(weakArrayIndexBuffer);
                                weakArray.append(new WeakReference(((TypeDefinitionWeakObjectReference)arrayReferencedType).getObjectType().getJavaImplementation(), reference));
                                continue;
                            }
                            catch (EndOfDataException eode) {
                                System.err.println("Error reading data from a weak reference vector.");
                            }
                        }
                        try {
                            Field injectionPoint = ResolutionEntry.findInjectionPoint(this.property);
                            injectionPoint.setAccessible(true);
                            injectionPoint.set(this.target, weakArray);
                        }
                        catch (Exception e) {
                            System.err.println("Unable to use injection for property " + this.property.getName() + ".");
                            this.property.setPropertyValue(this.target, propertyType.createValue(weakArray));
                        }
                        break block9;
                    }
                }
                break;
            }
            case Set: {
                TypeDefinition setReferencedType = ((TypeDefinitionSet)propertyType).getElementType();
                String setCollectionPath = (String)this.reference;
                switch (setReferencedType.getTypeCategory()) {
                    case StrongObjRef: {
                        ByteBuffer setIndexBuffer = indexMap.get(setCollectionPath + " index");
                        int entryCount = setIndexBuffer.getInt();
                        int firstFreeKey = setIndexBuffer.getInt();
                        int lastFreeKey = setIndexBuffer.getInt();
                        short identificationPid = setIndexBuffer.getShort();
                        byte identificationSize = setIndexBuffer.get();
                        HashSet<MetadataObject> setElements = new HashSet<MetadataObject>(entryCount);
                        for (int x = 0; x < entryCount; ++x) {
                            int localKey = setIndexBuffer.getInt();
                            int referenceCount = setIndexBuffer.getInt();
                            byte[] identification = new byte[identificationSize];
                            setIndexBuffer.get(identification);
                            String setElementPath = setCollectionPath + "{" + Integer.toHexString(localKey) + "}";
                            setElements.add(pathMap.get(setElementPath));
                        }
                        try {
                            Field injectionPoint = ResolutionEntry.findInjectionPoint(this.property);
                            injectionPoint.setAccessible(true);
                            injectionPoint.set(this.target, setElements);
                        }
                        catch (Exception e) {
                            System.err.println("Unable to use injection for property " + this.property.getName() + ".");
                            this.property.setPropertyValue(this.target, propertyType.createValue(setElements));
                        }
                        break block9;
                    }
                    case WeakObjRef: {
                        ByteBuffer weakArrayIndexBuffer = indexMap.get(setCollectionPath + " index");
                        int weakEntryCount = weakArrayIndexBuffer.getInt();
                        short referencedPropertyTag = weakArrayIndexBuffer.getShort();
                        short weakIdentificationPid = weakArrayIndexBuffer.getShort();
                        byte weakIdentificationSize = weakArrayIndexBuffer.get();
                        WeakReferenceSet weakSet = new WeakReferenceSet();
                        for (int x = 0; x < weakEntryCount; ++x) {
                            try {
                                AUID reference = AUIDImpl.createFromBuffer(weakArrayIndexBuffer);
                                weakSet.add(new WeakReference(((TypeDefinitionWeakObjectReference)setReferencedType).getObjectType().getJavaImplementation(), reference));
                                continue;
                            }
                            catch (EndOfDataException eode) {
                                System.err.println("Error reading data from a weak reference vector.");
                            }
                        }
                        try {
                            Field injectionPoint = ResolutionEntry.findInjectionPoint(this.property);
                            injectionPoint.setAccessible(true);
                            injectionPoint.set(this.target, weakSet);
                        }
                        catch (Exception e) {
                            System.err.println("Unable to use injection for property " + this.property.getName() + ".");
                            this.property.setPropertyValue(this.target, propertyType.createValue(weakSet));
                        }
                        break block9;
                    }
                }
                break;
            }
            case Stream: {
                Stream referencedStream = null;
                if (this.reference instanceof String) {
                    referencedStream = streamMap.get(this.reference);
                }
                if (referencedStream instanceof MemoryResidentStream) {
                    ((MemoryResidentStream)referencedStream).setByteOrder(this.byteOrder);
                }
                if (referencedStream == null) {
                    System.err.println("Unable to resolve stream reference " + this.reference + " for property " + this.property.getMemberOf().getName() + "." + this.property.getName());
                    break;
                }
                try {
                    Field injectionPoint = ResolutionEntry.findInjectionPoint(this.property);
                    injectionPoint.setAccessible(true);
                    injectionPoint.set(this.target, referencedStream);
                }
                catch (Exception e) {
                    System.err.println("Unable to use injection for property " + this.property.getName() + ".");
                    this.property.setPropertyValue(this.target, propertyType.createValue(referencedStream));
                }
                break;
            }
        }
    }

    private void handleParametersSpecialCase(Map<String, MetadataObject> pathMap, Map<String, ByteBuffer> indexMap, TypeDefinition propertyType) {
        String setCollectionPath = (String)this.reference;
        ByteBuffer setIndexBuffer = indexMap.get(setCollectionPath + " index");
        int entryCount = setIndexBuffer.getInt();
        int firstFreeKey = setIndexBuffer.getInt();
        int lastFreeKey = setIndexBuffer.getInt();
        short identificationPid = setIndexBuffer.getShort();
        byte identificationSize = setIndexBuffer.get();
        Vector<MetadataObject> setElements = new Vector<MetadataObject>(entryCount);
        for (int x = 0; x < entryCount; ++x) {
            int localKey = setIndexBuffer.getInt();
            int referenceCount = setIndexBuffer.getInt();
            byte[] identification = new byte[identificationSize];
            setIndexBuffer.get(identification);
            String setElementPath = setCollectionPath + "{" + Integer.toHexString(localKey) + "}";
            setElements.add(pathMap.get(setElementPath));
        }
        try {
            Field injectionPoint = ResolutionEntry.findInjectionPoint(this.property);
            injectionPoint.setAccessible(true);
            injectionPoint.set(this.target, setElements);
        }
        catch (Exception e) {
            System.err.println("Could not inject a value into property " + this.property.getName() + ".");
            this.property.setPropertyValue(this.target, propertyType.createValue(setElements));
        }
    }

    private static final Field findInjectionPoint(PropertyDefinition property) {
        try {
            ClassDefinition memberOf = property.getMemberOf();
            Class<?> memberClass = memberOf.getJavaImplementation();
            return memberClass.getDeclaredField(Character.toLowerCase(property.getName().charAt(0)) + property.getName().substring(1));
        }
        catch (NoSuchFieldException nsfe) {
            return null;
        }
    }
}

