/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.mxf;

import java.nio.ByteBuffer;
import tv.amwa.maj.integer.Int32;
import tv.amwa.maj.integer.Int64;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.integer.UInt8Array;
import tv.amwa.maj.io.mxf.GenericContainerElementKind;
import tv.amwa.maj.io.mxf.MXFLength;
import tv.amwa.maj.io.mxf.MXFPosition;
import tv.amwa.maj.io.mxf.UL;
import tv.amwa.maj.io.mxf.impl.MXFFileImpl;

public class KLVObject {
    private KLVInfo source = new KLVInfo();
    private KLVInfo destination = new KLVInfo();
    private UL theUL = null;
    @MXFLength
    private long valueLength = 0L;
    private ByteBuffer data = null;
    @Int64
    private long dataBaseOffset = 0L;

    public KLVObject() {
    }

    public KLVObject(UL theUL) {
        if (theUL == null) {
            theUL = null;
        } else {
            this.theUL = theUL.clone();
        }
    }

    public void setSource(MXFFileImpl file, @Int64 long location) throws NullPointerException {
        if (file == null) {
            throw new NullPointerException("Cannot set the source of this KLV object to be a null value.");
        }
        this.source.valid = true;
        this.source.file = file;
        this.source.offset = location < 0L ? file.tell() : location;
        if (!this.destination.valid) {
            this.destination = this.source;
        }
    }

    public void setSource(MXFFileImpl file) throws NullPointerException {
        this.setSource(file, -1L);
    }

    public void setDestination(MXFFileImpl file, @Int64 long location) throws NullPointerException {
        if (file == null) {
            throw new NullPointerException("Cannot set the destination for this KLV object to be a null value.");
        }
        if (this.destination == this.source) {
            this.destination = new KLVInfo();
        }
        this.destination.valid = true;
        this.destination.file = file;
        this.destination.offset = location < 0L ? file.tell() : location;
    }

    public void setDestination(MXFFileImpl file) throws NullPointerException {
        this.setDestination(file, -1L);
    }

    public UL getUL() {
        if (this.theUL == null) {
            return null;
        }
        return this.theUL.clone();
    }

    public void setUL(UL newUL) {
        this.theUL = newUL == null ? null : newUL.clone();
    }

    @Int64
    public long getLocation() {
        return this.source.offset;
    }

    public String describeSource() {
        if (this.source.file != null) {
            return this.source.file.getName();
        }
        return "memory buffer";
    }

    public String describeSourceLocation() {
        if (this.source.file == null) {
            return "KLVObject created in memory.";
        }
        return "0x" + Long.toHexString(this.getLocation()) + " in " + this.describeSource();
    }

    @Int32
    public int getKLSize() {
        return this.source.klSize >= 0 ? this.source.klSize : this.destination.klSize;
    }

    public void setKLSize(@Int32 int klSize) {
        this.destination.klSize = klSize;
    }

    public GenericContainerElementKind getGCElementKind() {
        return null;
    }

    @UInt32
    public int getGCTrackNumber() {
        return 0;
    }

    @Int64
    public long getDataBaseOffset() {
        return this.dataBaseOffset;
    }

    public void setDataBaseOffset(@Int64 long dataBaseOffset) {
        this.dataBaseOffset = dataBaseOffset;
    }

    @Int32
    public int readKL() {
        return this.baseReadKL();
    }

    @Int32
    int baseReadKL() {
        return 0;
    }

    @Int32
    public int readData(@Int32 int size) {
        return 0;
    }

    public int readDataFrom(@MXFPosition long offset, int size) {
        return this.baseReadDataFrom(offset, size);
    }

    public int readDataFrom(@MXFPosition long offset) {
        return this.readDataFrom(offset, -1);
    }

    int baseReadDataFrom(@MXFPosition long offset, int size) {
        return this.baseReadDataFrom(this.data, offset, size);
    }

    int baseReadDataFrom(@Int64 long offset) {
        return this.baseReadDataFrom(this.data, offset, -1);
    }

    @Int32
    int baseReadDataFrom(ByteBuffer buffer, @MXFPosition long position, int size) throws NullPointerException {
        return 0;
    }

    @Int32
    int baseReadDataFrom(ByteBuffer buffer, @MXFPosition long position) {
        return this.baseReadDataFrom(buffer, position, -1);
    }

    @Int32
    public int writeKL(@Int32 int lengthSize) {
        return this.baseWriteKL(lengthSize);
    }

    @Int32
    public int writeKL() {
        return this.baseWriteKL(0);
    }

    @Int32
    int baseWriteKL(@Int32 int lengthSize, @MXFLength long newLength) {
        return 0;
    }

    @Int32
    int baseWriteKL(@Int32 int lengthSize) {
        return this.baseWriteKL(lengthSize, -1L);
    }

    public int writeData(int size) {
        return this.writeDataFromTo(0L, 0L, size);
    }

    public int writeData() {
        return this.writeDataFromTo(0L, 0L, -1);
    }

    public int writeDataFrom(@MXFPosition long start, int size) {
        return this.writeDataFromTo(0L, start, size);
    }

    public int writeDataFrom(@MXFPosition long start) {
        return this.writeDataFromTo(0L, start, -1);
    }

    public int writeDataTo(@MXFPosition long offset, int size) {
        return this.writeDataFromTo(offset, 0L, size);
    }

    public int writeDataTo(@MXFPosition long offset) {
        return this.writeDataFromTo(offset, 0L, -1);
    }

    public int writeDataFromTo(@MXFPosition long offset, @MXFPosition long start, int size) {
        long bytesToWrite = (long)this.data.capacity() - start;
        if (size > 0 && (long)size < bytesToWrite) {
            bytesToWrite = size;
        }
        if (bytesToWrite > Integer.MAX_VALUE) {
            System.err.println("Tried to write > 2GBs and this platform can only handle <= 2Gb chunks.");
            return 0;
        }
        if (this.data.hasArray()) {
            return this.baseWriteDataTo(this.data.array(), start, offset, size);
        }
        byte[] dataToWrite = new byte[this.data.capacity()];
        this.data.get(dataToWrite);
        return this.baseWriteDataTo(dataToWrite, start, offset, (int)bytesToWrite);
    }

    public int writeDataFromTo(@MXFPosition long offset, @MXFPosition long start) {
        return this.writeDataFromTo(offset, start, -1);
    }

    public int writeDataTo(@UInt8Array byte[] buffer, @MXFPosition long start, @MXFPosition long offset, int size) {
        return this.baseWriteDataTo(buffer, start, offset, size);
    }

    int baseWriteDataTo(@UInt8Array byte[] buffer, @MXFPosition long start, @MXFPosition long offset, int size) {
        return 0;
    }

    @MXFLength
    public long getLength() {
        return this.valueLength;
    }

    public void setLength(@MXFLength long length) {
        this.valueLength = length;
        this.destination.outerLength = length;
        this.source.outerLength = length;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    class KLVInfo {
        MXFFileImpl file;
        @Int64
        long offset = -1L;
        @MXFLength
        long outerLength = 0L;
        @Int32
        int klSize = -1;
        boolean valid = false;

        KLVInfo() {
        }
    }

    public static enum LengthFormat {
        LEN_NONE,
        LEN_1_BYTE,
        LEN_2_BYTE,
        LEN_4_BYTE,
        LEN_BER;

    }

    public static enum KeyFormat {
        KEY_NONE,
        KEY_1_BYTE,
        KEY_2_BYTE,
        KEY_AUTO,
        KEY_4_BYTE;

    }
}

