/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.meta.impl;

import java.io.Serializable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.enumeration.TypeCategory;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.meta.TypeDefinitionStrongObjectReference;
import tv.amwa.maj.meta.impl.TypeDefinitionObjectReferenceImpl;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.model.NetworkLocator;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=0xD010101, uuid2=517, uuid3=0, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="TypeDefinitionStrongObjectReference", description="The TypeDefinitionStrongObjectReference class defines a property type that defines an object relationship where the target of the strong reference is owned by the object with the property with the TypeDefinitionStrongObjectReference type.", symbol="TypeDefinitionStrongObjectReference")
public final class TypeDefinitionStrongObjectReferenceImpl
extends TypeDefinitionObjectReferenceImpl
implements TypeDefinitionStrongObjectReference,
Serializable,
Cloneable {
    private static final long serialVersionUID = 7393102643260496960L;

    protected TypeDefinitionStrongObjectReferenceImpl() {
    }

    public TypeDefinitionStrongObjectReferenceImpl(AUID identification, @AAFString String typeName, ClassDefinition referencedType) throws NullPointerException {
        if (identification == null) {
            throw new NullPointerException("Cannot create a new strong object reference type definition with a null identification.");
        }
        if (referencedType == null) {
            throw new NullPointerException("Cannot create a new string object reference type definition with a null referenced type value.");
        }
        this.setIdentification(identification);
        this.setName(typeName);
        this.setReferencedType(referencedType);
    }

    @MediaProperty(uuid1=100729095, uuid2=2304, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ReferencedType", aliases={"StrongReferencedType"}, typeName="ClassDefinitionWeakReference", optional=false, uniqueIdentifier=false, pid=17, symbol="ReferencedType")
    public final ClassDefinition getReferencedType() {
        return this.getObjectType();
    }

    @Override
    @MediaPropertySetter(value="ReferencedType")
    public void setReferencedType(ClassDefinition referencedType) {
        super.setReferencedType(referencedType);
    }

    public static final ClassDefinition initializeReferencedType() {
        return Warehouse.lookForClass(NetworkLocator.class);
    }

    @Override
    public final TypeCategory getTypeCategory() {
        return TypeCategory.StrongObjRef;
    }

    @Override
    public String nameToAAFName(String name) {
        return "kAAFTypeID_" + super.nameToAAFName(name);
    }

    @Override
    public void appendMetadictXML(Node metadict, String namespace, String prefix) {
        Element typeElement = XMLBuilder.createChild(metadict, namespace, prefix, "TypeDefinitionStrongObjectReference");
        super.appendMetadictXML(typeElement, namespace, prefix);
        XMLBuilder.appendElement((Node)typeElement, namespace, prefix, "ReferencedType", this.getReferencedType().getName());
    }

    @Override
    public TypeDefinitionStrongObjectReference clone() {
        return (TypeDefinitionStrongObjectReference)super.clone();
    }
}

