/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import tv.amwa.maj.exception.InvalidParameterException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaEngine;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaSetAdd;
import tv.amwa.maj.industry.MetadataObject;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.StrongReferenceSet;
import tv.amwa.maj.io.aaf.AAFConstants;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.meta.ClassDefinition;
import tv.amwa.maj.meta.PropertyDefinition;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.meta.impl.TypeDefinitionIndirectImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionSetImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionVariableArrayImpl;
import tv.amwa.maj.model.ApplicationObject;
import tv.amwa.maj.model.CodecDefinition;
import tv.amwa.maj.model.ContainerDefinition;
import tv.amwa.maj.model.DataDefinition;
import tv.amwa.maj.model.DefinitionObject;
import tv.amwa.maj.model.Dictionary;
import tv.amwa.maj.model.InterpolationDefinition;
import tv.amwa.maj.model.KLVDataDefinition;
import tv.amwa.maj.model.OperationDefinition;
import tv.amwa.maj.model.ParameterDefinition;
import tv.amwa.maj.model.PluginDefinition;
import tv.amwa.maj.model.TaggedValueDefinition;
import tv.amwa.maj.model.impl.DataDefinitionImpl;
import tv.amwa.maj.model.impl.InterchangeObjectImpl;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=8704, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="Dictionary", description="The Dictionary class has DefinitionObject objects.", symbol="Dictionary")
public class DictionaryImpl
extends InterchangeObjectImpl
implements Dictionary,
Serializable,
XMLSerializable,
Cloneable {
    private static final long serialVersionUID = 7981177320341108556L;
    private transient Map<AUID, DefinitionObject> idsToDefinitions = Collections.synchronizedMap(new HashMap());
    private Set<CodecDefinition> codecDefinitions = Collections.synchronizedSet(new HashSet());
    private Set<ContainerDefinition> containerDefinitions = Collections.synchronizedSet(new HashSet());
    private Set<DataDefinition> dataDefinitions = Collections.synchronizedSet(new HashSet());
    private Set<InterpolationDefinition> interpolationDefinitions = Collections.synchronizedSet(new HashSet());
    private Set<KLVDataDefinition> kLVDataDefinitions = Collections.synchronizedSet(new HashSet());
    private Set<OperationDefinition> operationDefinitions = Collections.synchronizedSet(new HashSet());
    private Set<ParameterDefinition> parameterDefinitions = Collections.synchronizedSet(new HashSet());
    private Set<PluginDefinition> pluginDefinitions = Collections.synchronizedSet(new HashSet());
    private Set<TaggedValueDefinition> taggedValueDefinitions = Collections.synchronizedSet(new HashSet());

    @Override
    @MediaPropertyCount(value="CodecDefinitions")
    public int countCodecDefinitions() {
        return this.codecDefinitions.size();
    }

    @Override
    @MediaPropertyCount(value="ContainerDefinitions")
    public int countContainerDefinitions() {
        return this.containerDefinitions.size();
    }

    @Override
    @MediaPropertyCount(value="DataDefinitions")
    public int countDataDefinitions() {
        return this.dataDefinitions.size();
    }

    @Override
    @MediaPropertyCount(value="InterpolationDefinitions")
    public int countInterpolationDefinitions() {
        return this.interpolationDefinitions.size();
    }

    @Override
    @MediaPropertyCount(value="KLVDataDefinitions")
    public int countKLVDataDefinitions() {
        return this.kLVDataDefinitions.size();
    }

    @Override
    @MediaPropertyCount(value="OperationDefinitions")
    public int countOperationDefinitions() {
        return this.operationDefinitions.size();
    }

    @Override
    @MediaPropertyCount(value="ParameterDefinitions")
    public int countParameterDefinitions() {
        return this.parameterDefinitions.size();
    }

    @Override
    @MediaPropertyCount(value="PluginDefinitions")
    public int countPluginDefinitions() {
        return this.pluginDefinitions.size();
    }

    @Override
    @MediaPropertyCount(value="TaggedValueDefinitions")
    public int countTaggedValueDefinitions() {
        return this.taggedValueDefinitions.size();
    }

    @MediaPropertyClear(value="CodecDefinitions")
    public void clearCodecDefinitions() {
        this.codecDefinitions = Collections.synchronizedSet(new HashSet());
    }

    @MediaPropertyClear(value="ContainerDefinitions")
    public void clearContainerDefinitions() {
        this.containerDefinitions = Collections.synchronizedSet(new HashSet());
    }

    @MediaPropertyClear(value="DataDefinitions")
    public void clearDataDefinitions() {
        this.dataDefinitions = Collections.synchronizedSet(new HashSet());
    }

    @MediaPropertyClear(value="InterpolationDefinitions")
    public void clearInterpolationDefinitions() {
        this.interpolationDefinitions = Collections.synchronizedSet(new HashSet());
    }

    @MediaPropertyClear(value="KLVDataDefinitions")
    public void clearKLVDataDefinitions() {
        this.kLVDataDefinitions = Collections.synchronizedSet(new HashSet());
    }

    @MediaPropertyClear(value="OperationDefinitions")
    public void clearOperationDefinitions() {
        this.operationDefinitions = Collections.synchronizedSet(new HashSet());
    }

    @MediaPropertyClear(value="ParameterDefinitions")
    public void clearParameterDefinitions() {
        this.parameterDefinitions = Collections.synchronizedSet(new HashSet());
    }

    @MediaPropertyClear(value="PluginDefinitions")
    public void clearPluginDefinitions() {
        this.pluginDefinitions = Collections.synchronizedSet(new HashSet());
    }

    @MediaPropertyClear(value="TaggedValueDefinitions")
    public void clearTaggedValueDefinitions() {
        this.taggedValueDefinitions = Collections.synchronizedSet(new HashSet());
    }

    @MediaProperty(uuid1=100729092, uuid2=1287, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="CodecDefinitions", typeName="CodecDefinitionStrongReferenceSet", optional=true, uniqueIdentifier=false, pid=9735, symbol="CodecDefinitions")
    public Set<CodecDefinition> getCodecDefinitions() throws PropertyNotPresentException {
        return StrongReferenceSet.getOptionalSet(this.codecDefinitions);
    }

    @MediaProperty(uuid1=100729092, uuid2=1288, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ContainerDefinitions", typeName="ContainerDefinitionStrongReferenceSet", optional=true, uniqueIdentifier=false, pid=9736, symbol="ContainerDefinitions")
    public Set<ContainerDefinition> getContainerDefinitions() throws PropertyNotPresentException {
        return StrongReferenceSet.getOptionalSet(this.containerDefinitions);
    }

    @MediaProperty(uuid1=100729092, uuid2=1285, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="DataDefinitions", typeName="DataDefinitionStrongReferenceSet", optional=true, uniqueIdentifier=false, pid=9733, symbol="DataDefinitions")
    public Set<DataDefinition> getDataDefinitions() throws PropertyNotPresentException {
        return StrongReferenceSet.getOptionalSet(this.dataDefinitions);
    }

    @MediaProperty(uuid1=100729092, uuid2=1289, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="InterpolationDefinitions", typeName="InterpolationDefinitionStrongReferenceSet", optional=true, uniqueIdentifier=false, pid=9737, symbol="InterpolationDefinitions")
    public Set<InterpolationDefinition> getInterpolationDefinitions() throws PropertyNotPresentException {
        return StrongReferenceSet.getOptionalSet(this.interpolationDefinitions);
    }

    @MediaProperty(uuid1=100729092, uuid2=1290, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 7}, definedName="KLVDataDefinitions", typeName="KLVDataDefinitionStrongReferenceSet", optional=true, uniqueIdentifier=false, pid=9738, symbol="KLVDataDefinitions")
    public Set<KLVDataDefinition> getKLVDataDefinitions() throws PropertyNotPresentException {
        return StrongReferenceSet.getOptionalSet(this.kLVDataDefinitions);
    }

    @MediaProperty(uuid1=100729092, uuid2=1284, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="ParameterDefinitions", typeName="ParameterDefinitionStrongReferenceSet", optional=true, uniqueIdentifier=false, pid=9732, symbol="ParameterDefinitions")
    public Set<ParameterDefinition> getParameterDefinitions() throws PropertyNotPresentException {
        return StrongReferenceSet.getOptionalSet(this.parameterDefinitions);
    }

    @MediaProperty(uuid1=100729092, uuid2=1283, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="OperationDefinitions", typeName="OperationDefinitionStrongReferenceSet", optional=true, uniqueIdentifier=false, pid=9731, symbol="OperationDefinitions")
    public Set<OperationDefinition> getOperationDefinitions() throws PropertyNotPresentException {
        return StrongReferenceSet.getOptionalSet(this.operationDefinitions);
    }

    @MediaProperty(uuid1=100729092, uuid2=1286, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="PluginDefinitions", typeName="PluginDefinitionStrongReferenceSet", optional=true, uniqueIdentifier=false, pid=9734, symbol="PluginDefinitions")
    public Set<PluginDefinition> getPluginDefinitions() throws PropertyNotPresentException {
        return StrongReferenceSet.getOptionalSet(this.pluginDefinitions);
    }

    @MediaProperty(uuid1=100729092, uuid2=1291, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 7}, definedName="TaggedValueDefinitions", typeName="TaggedValueDefinitionStrongReferenceSet", optional=true, uniqueIdentifier=false, pid=9739, symbol="TaggedValueDefinitions")
    public Set<TaggedValueDefinition> getTaggedValueDefinitions() throws PropertyNotPresentException {
        return StrongReferenceSet.getOptionalSet(this.taggedValueDefinitions);
    }

    DefinitionObject lookupDefinition(Set<? extends DefinitionObject> lookMeUpAndDown, AUID id, String aTypeName) throws NullPointerException, InvalidParameterException {
        if (id == null) {
            throw new NullPointerException("Cannot lookup " + aTypeName + " with a null value.");
        }
        this.rebuildTables();
        if (!this.idsToDefinitions.containsKey(id)) {
            throw new InvalidParameterException("A definition matching the given id cannot be found in the dictionary.");
        }
        DefinitionObject definition = this.idsToDefinitions.get(id);
        if (!lookMeUpAndDown.contains(definition)) {
            throw new InvalidParameterException("The definition in the dictionary matching the given id is not " + aTypeName + ".");
        }
        return definition;
    }

    @Override
    public DataDefinition lookupAuxiliaryDataDefinition() {
        return DataDefinitionImpl.forIdentification(DataDefinitionImpl.Auxiliary);
    }

    @Override
    public CodecDefinition lookupCodecDefinition(AUID codecId) throws NullPointerException, InvalidParameterException {
        return (CodecDefinition)this.lookupDefinition(this.codecDefinitions, codecId, "a codec definition");
    }

    @Override
    public ContainerDefinition lookupContainerDefinition(AUID containerId) throws NullPointerException, InvalidParameterException {
        return (ContainerDefinition)this.lookupDefinition(this.containerDefinitions, containerId, "a container definition");
    }

    @Override
    public DataDefinition lookupDataDefinition(AUID dataDefinitionId) throws NullPointerException, InvalidParameterException {
        return (DataDefinition)this.lookupDefinition(this.dataDefinitions, dataDefinitionId, "a data definition");
    }

    @Override
    public DataDefinition lookupDescriptiveMedadataDataDefinition() {
        return DataDefinitionImpl.forIdentification(DataDefinitionImpl.DescriptiveMetadata);
    }

    @Override
    public DataDefinition lookupEdgecodeDataDefinition() {
        return DataDefinitionImpl.forIdentification(DataDefinitionImpl.Edgecode);
    }

    @Override
    public InterpolationDefinition lookupInterpoliationDefinition(AUID interpolationId) throws NullPointerException, InvalidParameterException {
        return (InterpolationDefinition)this.lookupDefinition(this.interpolationDefinitions, interpolationId, "an interpolation definition");
    }

    @Override
    public KLVDataDefinition lookupKLVDataDefinition(AUID klvDataDefinitionId) throws NullPointerException, InvalidParameterException {
        return (KLVDataDefinition)this.lookupDefinition(this.kLVDataDefinitions, klvDataDefinitionId, "a KLV data definition");
    }

    @Override
    public DataDefinition lookupLegacyPictureDataDefinition() {
        return DataDefinitionImpl.forIdentification(DataDefinitionImpl.LegacyPicture);
    }

    @Override
    public DataDefinition lookupLegacySoundDataDefinition() {
        return DataDefinitionImpl.forIdentification(DataDefinitionImpl.LegacySound);
    }

    @Override
    public DataDefinition lookupLegacyTimecodeDataDefinition() {
        return DataDefinitionImpl.forIdentification(DataDefinitionImpl.LegacyTimecode);
    }

    @Override
    public DataDefinition lookupMatteDataDefinition() {
        return DataDefinitionImpl.forIdentification(DataDefinitionImpl.Matte);
    }

    @Override
    public OperationDefinition lookupOperationDefinition(AUID operationId) throws NullPointerException, InvalidParameterException {
        return (OperationDefinition)this.lookupDefinition(this.operationDefinitions, operationId, "an operation definition");
    }

    @Override
    public ParameterDefinition lookupParameterDefinition(AUID parameterId) throws NullPointerException, InvalidParameterException {
        return (ParameterDefinition)this.lookupDefinition(this.parameterDefinitions, parameterId, "a parameter definition");
    }

    @Override
    public DataDefinition lookupPictureDataDefinition() {
        return DataDefinitionImpl.forIdentification(DataDefinitionImpl.Picture);
    }

    @Override
    public DataDefinition lookupPictureWithMatteDataDefinition() {
        return DataDefinitionImpl.forIdentification(DataDefinitionImpl.PictureWithMatte);
    }

    @Override
    public PluginDefinition lookupPluginDefinition(AUID pluginId) throws NullPointerException, InvalidParameterException {
        return (PluginDefinition)this.lookupDefinition(this.pluginDefinitions, pluginId, "a plugin definition");
    }

    @Override
    public DataDefinition lookupSoundDataDefinition() {
        return DataDefinitionImpl.forIdentification(DataDefinitionImpl.Sound);
    }

    @Override
    public DataDefinition lookupTimecodeDataDefinition() {
        return DataDefinitionImpl.forIdentification(DataDefinitionImpl.Timecode);
    }

    @Override
    public TaggedValueDefinition lookupTaggedValueDefinition(AUID taggedValueDefinitionId) throws NullPointerException, InvalidParameterException {
        return (TaggedValueDefinition)this.lookupDefinition(this.taggedValueDefinitions, taggedValueDefinitionId, "a tagged value definition");
    }

    void checkRegistration(Set<? extends DefinitionObject> setToBeGrown, DefinitionObject definition, String aTypeName) throws NullPointerException, InvalidParameterException {
        if (definition == null) {
            throw new NullPointerException("Cannot register a null value as " + aTypeName + ".");
        }
        if (setToBeGrown.contains(definition)) {
            throw new InvalidParameterException("The given definition to register as " + aTypeName + " is already registered.");
        }
    }

    void addToSharedTables(DefinitionObject definition, String canonicalName) {
        AUID definitionId = definition.getAUID();
        this.idsToDefinitions.put(definitionId, definition);
    }

    @Override
    @MediaSetAdd(value="CodecDefinitions")
    public void registerCodecDefinition(CodecDefinition codecDefinition) throws NullPointerException, InvalidParameterException {
        this.checkRegistration(this.codecDefinitions, codecDefinition, "a codec definition");
        StrongReferenceSet.add(this.codecDefinitions, codecDefinition);
        this.addToSharedTables(codecDefinition, "CodecDefinition");
    }

    @Override
    @MediaSetAdd(value="ContainerDefinitions")
    public void registerContainerDefinition(ContainerDefinition containerDefinition) throws NullPointerException, InvalidParameterException {
        this.checkRegistration(this.containerDefinitions, containerDefinition, "a container definition");
        StrongReferenceSet.add(this.containerDefinitions, containerDefinition);
        this.addToSharedTables(containerDefinition, "ContainerDefinition");
    }

    @Override
    @MediaSetAdd(value="DataDefinitions")
    public void registerDataDefinition(DataDefinition dataDefinition) throws NullPointerException, InvalidParameterException {
        this.checkRegistration(this.dataDefinitions, dataDefinition, "a data definition");
        StrongReferenceSet.add(this.dataDefinitions, dataDefinition);
        this.addToSharedTables(dataDefinition, "DataDefinition");
    }

    @Override
    @MediaSetAdd(value="InterpolationDefinitions")
    public void registerInterpolationDefinition(InterpolationDefinition interpolationDefinition) throws NullPointerException, InvalidParameterException {
        this.checkRegistration(this.interpolationDefinitions, interpolationDefinition, "a interpolation definition");
        StrongReferenceSet.add(this.interpolationDefinitions, interpolationDefinition);
        this.addToSharedTables(interpolationDefinition, "InterpolationDefinition");
    }

    @Override
    @MediaSetAdd(value="KLVDataDefinitions")
    public void registerKLVDataDefinition(KLVDataDefinition klvDataDefinition) throws NullPointerException, InvalidParameterException {
        this.checkRegistration(this.kLVDataDefinitions, klvDataDefinition, "a KLV data definition");
        StrongReferenceSet.add(this.kLVDataDefinitions, klvDataDefinition);
        this.addToSharedTables(klvDataDefinition, "KLVDataDefinition");
    }

    @Override
    @MediaSetAdd(value="OperationDefinitions")
    public void registerOperationDefinition(OperationDefinition operationDefinition) throws NullPointerException, InvalidParameterException {
        this.checkRegistration(this.operationDefinitions, operationDefinition, "an operation definition");
        StrongReferenceSet.add(this.operationDefinitions, operationDefinition);
        this.addToSharedTables(operationDefinition, "OperationDefinition");
    }

    @Override
    @MediaSetAdd(value="ParameterDefinitions")
    public void registerParameterDefinition(ParameterDefinition parameterDefinition) throws NullPointerException, InvalidParameterException {
        this.checkRegistration(this.parameterDefinitions, parameterDefinition, "a parameter definition");
        StrongReferenceSet.add(this.parameterDefinitions, parameterDefinition);
        this.addToSharedTables(parameterDefinition, "ParameterDefinition");
    }

    @Override
    @MediaSetAdd(value="PluginDefinitions")
    public void registerPluginDefinition(PluginDefinition pluginDefinition) throws NullPointerException, InvalidParameterException {
        this.checkRegistration(this.pluginDefinitions, pluginDefinition, "a plugin definition");
        StrongReferenceSet.add(this.pluginDefinitions, pluginDefinition);
        this.addToSharedTables(pluginDefinition, "PluginDefinition");
    }

    @Override
    @MediaSetAdd(value="TaggedValueDefinitions")
    public void registerTaggedValueDefinition(TaggedValueDefinition taggedValueDefinition) throws NullPointerException, InvalidParameterException {
        this.checkRegistration(this.taggedValueDefinitions, taggedValueDefinition, "a tagged value definition");
        StrongReferenceSet.add(this.taggedValueDefinitions, taggedValueDefinition);
        this.addToSharedTables(taggedValueDefinition, "TaggedValueDefinition");
    }

    @Override
    public Dictionary clone() {
        return (Dictionary)super.clone();
    }

    private void rebuildTables() {
        if (this.idsToDefinitions.size() >= 0) {
            return;
        }
        this.idsToDefinitions.clear();
        for (CodecDefinition codecDefinition : this.codecDefinitions) {
            this.addToSharedTables(codecDefinition, "CodecDefinition");
        }
        for (ContainerDefinition containerDefinition : this.containerDefinitions) {
            this.addToSharedTables(containerDefinition, "ContainerDefinition");
        }
        for (DataDefinition dataDefinition : this.dataDefinitions) {
            this.addToSharedTables(dataDefinition, "DataDefinition");
        }
        for (InterpolationDefinition interpolationDefinition : this.interpolationDefinitions) {
            this.addToSharedTables(interpolationDefinition, "InterpolationDefinition");
        }
        for (KLVDataDefinition klvDataDefinition : this.kLVDataDefinitions) {
            this.addToSharedTables(klvDataDefinition, "KLVDataDefinition");
        }
        for (OperationDefinition operationDefinition : this.operationDefinitions) {
            this.addToSharedTables(operationDefinition, "OperationDefinition");
        }
        for (ParameterDefinition parameterDefinition : this.parameterDefinitions) {
            this.addToSharedTables(parameterDefinition, "ParameterDefinition");
        }
        for (PluginDefinition pluginDefinition : this.pluginDefinitions) {
            this.addToSharedTables(pluginDefinition, "PluginDefinition");
        }
        for (TaggedValueDefinition taggedValueDefinition : this.taggedValueDefinitions) {
            this.addToSharedTables(taggedValueDefinition, "TaggedValueDefinition");
        }
    }

    @Override
    public boolean addDefinitions(MetadataObject mdObject) {
        if (mdObject == this) {
            return true;
        }
        boolean success = true;
        if (mdObject == null) {
            return false;
        }
        if (mdObject instanceof DefinitionObject) {
            success &= this.addDefinition((DefinitionObject)mdObject);
        }
        SortedMap<? extends PropertyDefinition, ? extends PropertyValue> values = null;
        if (mdObject instanceof ApplicationObject) {
            values = ((ApplicationObject)mdObject).getProperties();
        } else {
            ClassDefinition targetClass = MediaEngine.getClassDefinition(mdObject);
            values = targetClass.getProperties(mdObject);
        }
        block7: for (PropertyDefinition propertyDefinition : values.keySet()) {
            TypeDefinition type;
            if (propertyDefinition.getAUID().equals(AAFConstants.ObjectClassID) || (type = propertyDefinition.getTypeDefinition()) == null) continue;
            PropertyValue value = null;
            switch (type.getTypeCategory()) {
                case WeakObjRef: 
                case StrongObjRef: {
                    value = (PropertyValue)values.get(propertyDefinition);
                    success &= this.addDefinitions((MetadataObject)value.getValue());
                    break;
                }
                case VariableArray: {
                    Iterator listItem;
                    value = (PropertyValue)values.get(propertyDefinition);
                    Object list = ((TypeDefinitionVariableArrayImpl.VariableArrayValue)value).getValue();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        listItem = iterator.next();
                        if (!(listItem instanceof MetadataObject)) continue;
                        success &= this.addDefinitions((MetadataObject)((Object)listItem));
                    }
                    continue block7;
                }
                case Set: {
                    value = (PropertyValue)values.get(propertyDefinition);
                    Object elements = ((TypeDefinitionSetImpl.SetValue)value).getValue();
                    Iterator listItem = elements.iterator();
                    while (listItem.hasNext()) {
                        Object element = listItem.next();
                        if (!(element instanceof MetadataObject)) continue;
                        success &= this.addDefinitions((MetadataObject)element);
                    }
                    continue block7;
                }
                case FixedArray: {
                    break;
                }
                case Indirect: {
                    value = (PropertyValue)values.get(propertyDefinition);
                    PropertyValue indirectValue = ((TypeDefinitionIndirectImpl.IndirectValue)value).getValue();
                    if (!(indirectValue.getValue() instanceof MetadataObject)) break;
                    success &= this.addDefinitions((MetadataObject)indirectValue.getValue());
                    break;
                }
            }
        }
        return success;
    }

    @Override
    public boolean addDefinition(DefinitionObject definition) {
        if (definition == null) {
            return false;
        }
        try {
            switch (definition.getClass().getSimpleName().charAt(0)) {
                case 'C': {
                    if (definition instanceof CodecDefinition) {
                        this.registerCodecDefinition((CodecDefinition)definition);
                        return true;
                    }
                    if (definition instanceof ContainerDefinition) {
                        this.registerContainerDefinition((ContainerDefinition)definition);
                        return true;
                    }
                    return false;
                }
                case 'D': {
                    if (definition instanceof DataDefinition) {
                        this.registerDataDefinition((DataDefinition)definition);
                        return true;
                    }
                    return false;
                }
                case 'I': {
                    if (definition instanceof InterpolationDefinition) {
                        this.registerInterpolationDefinition((InterpolationDefinition)definition);
                        return true;
                    }
                    return false;
                }
                case 'K': {
                    if (definition instanceof KLVDataDefinition) {
                        this.registerInterpolationDefinition((InterpolationDefinition)definition);
                        return true;
                    }
                    return false;
                }
                case 'O': {
                    if (definition instanceof OperationDefinition) {
                        this.registerOperationDefinition((OperationDefinition)definition);
                        return true;
                    }
                    return false;
                }
                case 'P': {
                    if (definition instanceof ParameterDefinition) {
                        this.registerParameterDefinition((ParameterDefinition)definition);
                        return true;
                    }
                    if (definition instanceof PluginDefinition) {
                        this.registerPluginDefinition((PluginDefinition)definition);
                        return true;
                    }
                    return false;
                }
                case 'T': {
                    if (definition instanceof TaggedValueDefinition) {
                        this.registerTaggedValueDefinition((TaggedValueDefinition)definition);
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }
        catch (InvalidParameterException ipe) {
            return true;
        }
    }

    @Override
    public String getComment() {
        return "local dictionary persistent id: " + this.getPersistentID();
    }
}

