/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.union.impl;

import java.io.Serializable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.misctype.PackageIDType;
import tv.amwa.maj.misctype.PositionType;
import tv.amwa.maj.misctype.TrackID;
import tv.amwa.maj.record.PackageID;
import tv.amwa.maj.record.impl.PackageIDImpl;
import tv.amwa.maj.union.SourceReferenceValue;

public class SourceReferenceValueImpl
implements SourceReferenceValue,
Serializable,
XMLSerializable,
Cloneable {
    private static final long serialVersionUID = -1301646346927365235L;
    private PackageID sourcePackageID = null;
    @TrackID
    private int sourceTrackID;
    @PositionType
    private Long startPosition;
    static final String SOURCEREFERENCEVALUE_TAG = "SourceReferenceValue";
    static final String SOURCEPACKAGEID_TAG = "SourcePackageID";
    static final String SOURCETRACK_ID = "SourceTrackID";
    static final String STARTPOSITION_TAG = "StartPosition";

    public SourceReferenceValueImpl(@PackageIDType PackageID sourcePackageID, @TrackID int sourceTrackID, @PositionType Long startPosition) throws IllegalArgumentException {
        this.setStartPosition(startPosition);
        this.setSourceTrackID(sourceTrackID);
        this.setSourcePackageID(sourcePackageID);
    }

    public static final SourceReferenceValueImpl originalSource() {
        return new SourceReferenceValueImpl(PackageIDImpl.getZeroPackageID(), 0, 0L);
    }

    public static final SourceReferenceValueImpl inContextReference(@TrackID int sourceTrackID) throws IllegalArgumentException {
        return new SourceReferenceValueImpl(null, sourceTrackID, null);
    }

    public static final SourceReferenceValueImpl inContextReference(@TrackID int sourceTrackID, @PositionType Long startPosition) throws IllegalArgumentException {
        return new SourceReferenceValueImpl(null, sourceTrackID, startPosition);
    }

    @Override
    @PackageIDType
    public PackageID getSourcePackageID() throws PropertyNotPresentException {
        if (this.sourcePackageID == null) {
            throw new PropertyNotPresentException("The optional source ID property is not present in this source reference value, indicating that this is an in content reference.");
        }
        return this.sourcePackageID.clone();
    }

    @Override
    public void setSourcePackageID(@PackageIDType PackageID sourcePackageID) {
        if (sourcePackageID == null) {
            this.sourcePackageID = null;
            return;
        }
        this.sourcePackageID = sourcePackageID.clone();
        this.applyZeroConstraint();
    }

    @Override
    @TrackID
    public int getSourceTrackID() {
        return this.sourceTrackID;
    }

    @Override
    public void setSourceTrackID(@TrackID int sourceTrackID) throws IllegalArgumentException {
        if (sourceTrackID < 0) {
            throw new IllegalArgumentException("Cannot set a source track id value to a negative value.");
        }
        if (this.sourcePackageID != null && this.sourcePackageID.isZero() && sourceTrackID != 0) {
            throw new IllegalArgumentException("Cannot set a non-zero value for source track id for this source reference when the source id is the zero package id.");
        }
        this.sourceTrackID = sourceTrackID;
        this.applyZeroConstraint();
    }

    @Override
    @PositionType
    public long getStartPosition() throws PropertyNotPresentException {
        if (this.startPosition == null) {
            throw new PropertyNotPresentException("The optional start time property is not present in this source reference value.");
        }
        return this.startPosition;
    }

    @Override
    public void setStartPosition(@PositionType Long startPosition) throws IllegalArgumentException {
        if (this.sourcePackageID != null && startPosition != null && this.sourcePackageID.isZero() && startPosition != 0L) {
            throw new IllegalArgumentException("Cannot set a non-zero value for start time for this source reference value when the source id is the zero package id.");
        }
        this.startPosition = startPosition;
    }

    private void applyZeroConstraint() {
        if (this.sourcePackageID == null) {
            return;
        }
        if (this.sourcePackageID.isZero()) {
            this.sourceTrackID = 0;
            if (this.startPosition != null) {
                this.startPosition = 0L;
            }
        }
    }

    @Override
    public boolean isOriginalSource() {
        if (this.sourcePackageID == null) {
            return false;
        }
        return this.sourcePackageID.isZero();
    }

    @Override
    public boolean isContextual() {
        return this.sourcePackageID == null;
    }

    public boolean equals(Object o) {
        SourceReferenceValue testValue;
        block10: {
            block9: {
                if (this == o) {
                    return true;
                }
                if (o == null) {
                    return false;
                }
                if (!(o instanceof SourceReferenceValue)) {
                    return false;
                }
                testValue = (SourceReferenceValue)o;
                try {
                    if (!testValue.getSourcePackageID().equals(this.sourcePackageID)) {
                        return false;
                    }
                }
                catch (PropertyNotPresentException pnpe) {
                    if (this.sourcePackageID == null) break block9;
                    return false;
                }
            }
            try {
                if (!Long.valueOf(testValue.getStartPosition()).equals(this.startPosition)) {
                    return false;
                }
            }
            catch (PropertyNotPresentException e) {
                if (this.startPosition == null) break block10;
                return false;
            }
        }
        return this.sourceTrackID == testValue.getSourceTrackID();
    }

    public String toString() {
        return XMLBuilder.toXMLNonMetadata(this);
    }

    public int hashCode() {
        if (this.sourcePackageID == null) {
            return this.sourceTrackID;
        }
        if (this.sourcePackageID.isZero()) {
            return Integer.MAX_VALUE;
        }
        return this.sourcePackageID.hashCode() ^ (this.startPosition == null ? 0 : this.startPosition.hashCode()) ^ this.sourceTrackID;
    }

    public SourceReferenceValue clone() {
        try {
            return (SourceReferenceValue)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
            return null;
        }
    }

    @Override
    public void appendXMLChildren(Node parent) {
        XMLBuilder.appendComment(parent, "The SourceReferenceValue tag is not valid AAF XML.");
        Element referenceElement = XMLBuilder.createChild(parent, "http://www.amwa.tv/projects/maj", "maj", SOURCEREFERENCEVALUE_TAG);
        if (this.sourcePackageID != null) {
            XMLBuilder.appendElement((Node)referenceElement, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", SOURCEPACKAGEID_TAG, this.sourcePackageID.toString());
        }
        XMLBuilder.appendElement((Node)referenceElement, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", SOURCETRACK_ID, this.sourceTrackID);
        if (this.startPosition != null) {
            XMLBuilder.appendElement((Node)referenceElement, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", STARTPOSITION_TAG, this.startPosition);
        }
    }

    @Override
    public String getComment() {
        return null;
    }
}

