/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.io.mxf.impl;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.integer.Int8;
import tv.amwa.maj.integer.UInt32Array;
import tv.amwa.maj.integer.UInt64;
import tv.amwa.maj.integer.UInt8;
import tv.amwa.maj.io.mxf.EditUnitFlag;
import tv.amwa.maj.io.mxf.IndexEntry;
import tv.amwa.maj.io.mxf.IndexTableSegment;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.meta.impl.TypeDefinitionRecordImpl;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.impl.RationalImpl;

public class IndexEntryImpl
implements IndexEntry,
Cloneable,
Serializable,
XMLSerializable {
    private static final long serialVersionUID = -3909304731192434103L;
    @Int8
    private byte temporalOffset = 0;
    @Int8
    private byte keyFrameOffset = 0;
    @EditUnitFlag
    private byte flags = (byte)-128;
    @UInt64
    private long streamOffset;
    @UInt32Array
    private int[] sliceOffset = null;
    private Rational[] posTable = null;
    private transient byte[] unresolvedBytes = null;
    public static final String INDEXENTRY_TAG = "IndexEntry";
    public static final String TEMPORALOFFSET_TAG = "TemporalOffset";
    public static final String KEYFRANEOFFST_TAG = "KeyFrameOffset";
    public static final String FLAGS_TAG = "Flags";
    public static final String STREAMOFFSET_TAG = "StreamOffset";
    public static final String SLICEOFFSET_TAG = "SliceOffset";
    public static final String POSTABLE_TAG = "PosTable";

    public IndexEntryImpl() {
    }

    public IndexEntryImpl(@UInt64 long streamOffset) throws IllegalArgumentException {
        this.setStreamOffset(streamOffset);
    }

    public IndexEntryImpl(@Int8 byte temporalOffset, @Int8 byte keyFrameOffset, @EditUnitFlag byte flags, @UInt64 long streamOffset) throws IllegalArgumentException {
        this.setTemporalOffset(temporalOffset);
        this.setKeyFrameOffset(keyFrameOffset);
        this.setFlags(flags);
        this.setStreamOffset(streamOffset);
    }

    IndexEntryImpl(@Int8 byte temporalOffset, @Int8 byte keyFrameOffset, @UInt8 byte flags, @UInt64 long streamOffset, byte[] unresolvedBytes) {
        this.setTemporalOffset(temporalOffset);
        this.setKeyFrameOffset(keyFrameOffset);
        this.setFlags(flags);
        this.setStreamOffset(streamOffset);
        this.unresolvedBytes = unresolvedBytes;
    }

    @Override
    @Int8
    public byte getTemporalOffset() {
        return this.temporalOffset;
    }

    @Override
    public void setTemporalOffset(@Int8 byte temporalOffset) {
        this.temporalOffset = temporalOffset;
    }

    @Override
    @Int8
    public byte getKeyFrameOffset() {
        return this.keyFrameOffset;
    }

    @Override
    public void setKeyFrameOffset(@Int8 byte keyFrameOffset) {
        this.keyFrameOffset = keyFrameOffset;
    }

    @Override
    @EditUnitFlag
    public byte getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(@EditUnitFlag byte flags) {
        this.flags = flags;
    }

    @Override
    @UInt64
    public long getStreamOffset() {
        return this.streamOffset;
    }

    @Override
    public void setStreamOffset(@UInt64 long streamOffset) throws IllegalArgumentException {
        if (streamOffset < 0L) {
            throw new IllegalArgumentException("Cannot set the stream offset to a negative value.");
        }
        this.streamOffset = streamOffset;
    }

    @Override
    @UInt32Array
    public int[] getSliceOffset() {
        if (this.sliceOffset == null) {
            return new int[0];
        }
        return (int[])this.sliceOffset.clone();
    }

    @Override
    public void setSliceOffset(@UInt32Array int[] sliceOffset) throws IllegalArgumentException {
        if (sliceOffset == null || sliceOffset.length == 0) {
            this.sliceOffset = null;
        }
        for (int i : sliceOffset) {
            if (i >= 0) continue;
            throw new IllegalArgumentException("Cannot set a slice offset to a negative value.");
        }
        this.sliceOffset = (int[])sliceOffset.clone();
    }

    @Override
    public Rational[] getPosTable() {
        if (this.posTable == null) {
            return new Rational[0];
        }
        return IndexEntryImpl.cloneRationalTable(this.posTable);
    }

    @Override
    public void setPosTable(Rational[] posTable) throws NullPointerException {
        if (posTable == null || posTable.length == 0) {
            this.posTable = null;
        }
        this.posTable = IndexEntryImpl.cloneRationalTable(posTable);
    }

    private static final Rational[] cloneRationalTable(Rational[] source) throws NullPointerException {
        if (source == null) {
            return null;
        }
        Rational[] clonedTable = new Rational[source.length];
        for (int x = 0; x < source.length; ++x) {
            if (source[x] == null) {
                throw new NullPointerException("Cannot create a position table with null elements.");
            }
            clonedTable[x] = source[x].clone();
        }
        return clonedTable;
    }

    public boolean equals(Object o) {
        Rational[] testPosTable;
        int[] testSliceOffset;
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexEntryImpl)) {
            return false;
        }
        IndexEntry testEntry = (IndexEntry)o;
        if (this.streamOffset != testEntry.getStreamOffset()) {
            return false;
        }
        if (this.temporalOffset != testEntry.getTemporalOffset()) {
            return false;
        }
        if (this.keyFrameOffset != testEntry.getKeyFrameOffset()) {
            return false;
        }
        if (this.flags != testEntry.getFlags()) {
            return false;
        }
        int slicesPresent = 0;
        if (this.sliceOffset != null && this.sliceOffset.length > 0) {
            ++slicesPresent;
        }
        if ((testSliceOffset = testEntry.getSliceOffset()) != null && testSliceOffset.length > 0) {
            ++slicesPresent;
        }
        if (slicesPresent == 1) {
            return false;
        }
        if (slicesPresent == 2) {
            if (this.sliceOffset.length != testSliceOffset.length) {
                return false;
            }
            for (int x = 0; x < this.sliceOffset.length; ++x) {
                if (this.sliceOffset[x] == testSliceOffset[x]) continue;
                return false;
            }
        }
        int posTablesPresent = 0;
        if (this.posTable != null && this.posTable.length > 0) {
            ++posTablesPresent;
        }
        if ((testPosTable = testEntry.getPosTable()) != null && testPosTable.length > 0) {
            ++posTablesPresent;
        }
        if (posTablesPresent == 1) {
            return false;
        }
        if (posTablesPresent == 2) {
            if (this.posTable.length != testPosTable.length) {
                return false;
            }
            for (int x = 0; x < testPosTable.length; ++x) {
                if (this.posTable[x].equals(testPosTable[x])) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashcode = this.temporalOffset << 24 ^ this.keyFrameOffset << 16 & this.flags << 8;
        hashcode ^= Long.valueOf(this.streamOffset).hashCode();
        if (this.sliceOffset != null) {
            hashcode ^= this.sliceOffset.hashCode();
        }
        if (this.posTable != null) {
            hashcode ^= this.posTable.hashCode();
        }
        return hashcode;
    }

    @Override
    public IndexEntry clone() {
        try {
            return (IndexEntry)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.getMessage());
        }
    }

    @Override
    public void resolveBytes(IndexTableSegment parentSegment) throws NullPointerException, EndOfDataException {
        if (this.unresolvedBytes == null) {
            return;
        }
        if (parentSegment == null) {
            throw new NullPointerException("Cannot resolve bytes using a null parent index table segment.");
        }
        ByteBuffer unresolvedBuffer = ByteBuffer.wrap(this.unresolvedBytes);
        int sliceCount = 0;
        try {
            sliceCount = parentSegment.getSliceCount();
        }
        catch (PropertyNotPresentException propertyNotPresentException) {
            // empty catch block
        }
        int posTableCount = 0;
        try {
            parentSegment.getPosTableCount();
        }
        catch (PropertyNotPresentException propertyNotPresentException) {
            // empty catch block
        }
        if (unresolvedBuffer.remaining() < sliceCount * 4 + posTableCount * 8) {
            throw new EndOfDataException("Insufficient bytes to resolve remaining bytes to a position table entry.");
        }
        if (sliceCount == 0) {
            this.sliceOffset = null;
        } else {
            this.sliceOffset = new int[sliceCount];
            for (int x = 0; x < sliceCount; ++x) {
                this.sliceOffset[x] = unresolvedBuffer.getInt();
            }
        }
        if (posTableCount == 0) {
            this.posTable = null;
        } else {
            this.posTable = new Rational[posTableCount];
            for (int x = 0; x < posTableCount; ++x) {
                this.posTable[x] = new RationalImpl(unresolvedBuffer.getInt(), unresolvedBuffer.getInt());
            }
        }
        this.unresolvedBytes = null;
    }

    @Override
    public void appendXMLChildren(Node parent) {
        Node indexEntryElement = parent instanceof DocumentFragment ? XMLBuilder.createChild(parent, "http://www.smpte-ra.org/rp210", "mxf", INDEXENTRY_TAG) : parent;
        XMLBuilder.appendElement(indexEntryElement, "http://www.smpte-ra.org/rp210", "mxf", TEMPORALOFFSET_TAG, this.temporalOffset);
        XMLBuilder.appendElement(indexEntryElement, "http://www.smpte-ra.org/rp210", "mxf", KEYFRANEOFFST_TAG, this.keyFrameOffset);
        XMLBuilder.appendElement(indexEntryElement, "http://www.smpte-ra.org/rp210", "mxf", FLAGS_TAG, this.flags);
        XMLBuilder.appendElement(indexEntryElement, "http://www.smpte-ra.org/rp210", "mxf", STREAMOFFSET_TAG, this.streamOffset);
        if (this.sliceOffset != null && this.sliceOffset.length > 0) {
            Element sliceOffsetElement = XMLBuilder.createChild(indexEntryElement, "http://www.smpte-ra.org/rp210", "mxf", SLICEOFFSET_TAG);
            for (int offset : this.sliceOffset) {
                XMLBuilder.appendElement((Node)sliceOffsetElement, "http://www.smpte-ra.org/rp210", "mxf", "UInt32", offset);
            }
        }
        if (this.posTable != null && this.posTable.length > 0) {
            Element posTableElement = XMLBuilder.createChild(indexEntryElement, "http://www.smpte-ra.org/rp210", "mxf", POSTABLE_TAG);
            for (Rational pos : this.posTable) {
                XMLBuilder.appendElement((Node)posTableElement, "http://www.smpte-ra.org/rp210", "mxf", "Rational", pos.toString());
            }
        }
    }

    @Override
    public String getComment() {
        return null;
    }

    public String toString() {
        return XMLBuilder.toXMLNonMetadata(this);
    }

    public static final IndexEntry createFromBuffer(ByteBuffer buffer) throws NullPointerException, EndOfDataException {
        if (buffer == null) {
            throw new NullPointerException("Cannot create an index entry from a null value.");
        }
        if (buffer.remaining() < 11) {
            throw new EndOfDataException("Insufficient bytes remaining in the buffer to read an index entry.");
        }
        byte temporalOffset = buffer.get();
        byte keyFrameOffset = buffer.get();
        byte flags = buffer.get();
        long streamOffset = buffer.getLong();
        byte[] unresolvedBytes = null;
        if (buffer.hasRemaining()) {
            unresolvedBytes = new byte[buffer.remaining()];
            buffer.get(unresolvedBytes);
        }
        return new IndexEntryImpl(temporalOffset, keyFrameOffset, flags, streamOffset, unresolvedBytes);
    }

    static {
        TypeDefinitionRecordImpl.registerInterfaceMapping(IndexEntry.class, IndexEntryImpl.class);
    }
}

