/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model;

import java.util.List;
import tv.amwa.maj.enumeration.Depend;
import tv.amwa.maj.enumeration.IncludedMedia;
import tv.amwa.maj.exception.ObjectNotFoundException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.exception.TimecodeNotFoundException;
import tv.amwa.maj.exception.TrackExistsException;
import tv.amwa.maj.exception.TrackNotFoundException;
import tv.amwa.maj.industry.WeakReferenceTarget;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.misctype.NumTracks;
import tv.amwa.maj.misctype.PackageIDType;
import tv.amwa.maj.misctype.PositionType;
import tv.amwa.maj.misctype.TrackID;
import tv.amwa.maj.model.AAFFile;
import tv.amwa.maj.model.EventTrack;
import tv.amwa.maj.model.InterchangeObject;
import tv.amwa.maj.model.KLVData;
import tv.amwa.maj.model.Segment;
import tv.amwa.maj.model.StaticTrack;
import tv.amwa.maj.model.TaggedValue;
import tv.amwa.maj.model.TimelineTrack;
import tv.amwa.maj.model.Track;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.PackageID;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.TimeStamp;
import tv.amwa.maj.record.TimecodeValue;

public interface Package
extends InterchangeObject,
WeakReferenceTarget {
    @PackageIDType
    public PackageID getPackageID();

    public void setPackageID(@PackageIDType PackageID var1) throws NullPointerException;

    public void setPackageName(@AAFString String var1);

    @AAFString
    public String getPackageName() throws PropertyNotPresentException;

    @NumTracks
    public int countPackageTracks();

    public void appendPackageTrack(Track var1) throws NullPointerException, TrackExistsException;

    public void prependPackageTrack(Track var1) throws NullPointerException, TrackExistsException;

    public void insertPackageTrackAt(@UInt32 int var1, Track var2) throws NullPointerException, IndexOutOfBoundsException, TrackExistsException;

    public void removePackageTrackAt(@UInt32 int var1) throws IndexOutOfBoundsException;

    public Track getPackageTrackAt(@UInt32 int var1) throws IndexOutOfBoundsException;

    public List<? extends Track> getPackageTracks();

    public TimeStamp getPackageLastModified();

    public void setPackageLastModified(TimeStamp var1) throws NullPointerException;

    public TimeStamp getCreationTime();

    public void setCreationTime(TimeStamp var1) throws NullPointerException;

    public void appendPackageUserComment(@AAFString String var1, @AAFString String var2) throws NullPointerException;

    public void appendPackageUserComment(TaggedValue var1) throws NullPointerException;

    @UInt32
    public int countPackageUserComments();

    public void clearPackageUserComments();

    public void clearPackageTracks();

    public List<? extends TaggedValue> getPackageUserComments() throws PropertyNotPresentException;

    public void removePackageUserComment(TaggedValue var1) throws NullPointerException, PropertyNotPresentException, ObjectNotFoundException;

    public TimelineTrack appendNewTimelineTrack(Rational var1, Segment var2, @TrackID int var3, @AAFString String var4, @PositionType long var5) throws NullPointerException, IllegalArgumentException, TrackExistsException;

    public TimecodeValue offsetToPackageTimecode(Segment var1, @PositionType long var2) throws NullPointerException, TimecodeNotFoundException;

    public Track lookupPackageTrack(@TrackID int var1) throws TrackNotFoundException;

    public void changeReference(PackageID var1, PackageID var2) throws NullPointerException;

    public Package cloneExternal(Depend var1, IncludedMedia var2, AAFFile var3) throws NullPointerException;

    public Package copy(@AAFString String var1) throws NullPointerException;

    public void appendPackageKLVData(KLVData var1) throws NullPointerException;

    @UInt32
    public int countPackageKLVData();

    public void clearPackageKLVData();

    public List<? extends KLVData> getPackageKLVData() throws PropertyNotPresentException;

    public void removePackageKLVData(KLVData var1) throws NullPointerException, PropertyNotPresentException, ObjectNotFoundException;

    public void appendPackageAttribute(@AAFString String var1, @AAFString String var2) throws NullPointerException;

    public void appendPackageAttribute(TaggedValue var1) throws NullPointerException;

    @UInt32
    public int countPackageAttributes();

    public void clearPackageAttributes();

    public List<? extends TaggedValue> getPackageAttributes() throws PropertyNotPresentException;

    public void removePackageAttribute(TaggedValue var1) throws NullPointerException, PropertyNotPresentException, ObjectNotFoundException;

    public void setPackageUsage(AUID var1) throws NullPointerException;

    public AUID getPackageUsage() throws PropertyNotPresentException;

    public StaticTrack appendNewStaticTrack(Segment var1, @TrackID int var2, @AAFString String var3) throws NullPointerException, IllegalArgumentException, TrackExistsException;

    public EventTrack appendNewEventTrack(Rational var1, Segment var2, @TrackID int var3, @AAFString String var4) throws NullPointerException, IllegalArgumentException, TrackExistsException;

    @Override
    public Package clone();
}

