/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.meta.impl;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.constant.CommonConstants;
import tv.amwa.maj.enumeration.ByteOrder;
import tv.amwa.maj.enumeration.TypeCategory;
import tv.amwa.maj.exception.BadSizeException;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.IllegalPropertyValueException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.integer.UInt8;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.meta.TypeDefinitionInteger;
import tv.amwa.maj.meta.impl.SingletonTypeDefinitionImpl;
import tv.amwa.maj.meta.impl.TypeDefinitionImpl;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.misctype.Bool;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=0xD010101, uuid2=516, uuid3=0, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="TypeDefinitionInteger", description="The TypeDefinitionInteger class defines a property type that is an integer with the specified number of bytes.", symbol="TypeDefinitionInteger")
public final class TypeDefinitionIntegerImpl
extends SingletonTypeDefinitionImpl
implements TypeDefinitionInteger,
Serializable,
CommonConstants,
Cloneable {
    private static final long serialVersionUID = -9133561212939801341L;
    private byte size;
    private boolean isSigned;

    protected TypeDefinitionIntegerImpl() {
    }

    public TypeDefinitionIntegerImpl(AUID identification, @AAFString String typeName, @UInt8 byte intSize, @Bool boolean isSigned) throws NullPointerException, IllegalArgumentException {
        if (identification == null) {
            throw new NullPointerException("Cannot create a new integer type definition for a null identification.");
        }
        this.setIdentification(identification);
        this.setName(typeName);
        this.setSize(intSize);
        this.setIsSigned(isSigned);
    }

    @Override
    public PropertyValue createValueFromNumber(Number value) throws NullPointerException, IllegalArgumentException, BadSizeException {
        if (value == null) {
            throw new NullPointerException("Cannot create an integer property value using a null value.");
        }
        if (value.longValue() < this.minValue() || value.longValue() > this.maxValue()) {
            throw new IllegalArgumentException("The given number is outside the acceptable range for a " + (this.isSigned ? "signed" : "unsigned") + " integer value of " + this.size + " byte(s).");
        }
        switch (this.size) {
            case 1: {
                return new ByteValue(this, value.byteValue());
            }
            case 2: {
                return new ShortValue(this, value.shortValue());
            }
            case 4: {
                return new IntegerValue(this, value.intValue());
            }
            case 8: {
                return new LongValue(this, value.longValue());
            }
        }
        throw new BadSizeException("Unexpectedly, the size in bytes of the representation of an integer type is not supported in this implementation.");
    }

    private long maxValue() {
        if (this.isSigned) {
            switch (this.size) {
                case 1: {
                    return 127L;
                }
                case 4: {
                    return Integer.MAX_VALUE;
                }
                case 2: {
                    return 32767L;
                }
            }
            return Long.MAX_VALUE;
        }
        switch (this.size) {
            case 1: {
                return 128L;
            }
            case 4: {
                return 0x80000000L;
            }
            case 2: {
                return 32768L;
            }
        }
        return Long.MAX_VALUE;
    }

    private long minValue() {
        switch (this.size) {
            case 1: {
                return -128L;
            }
            case 4: {
                return Integer.MIN_VALUE;
            }
            case 2: {
                return -32768L;
            }
        }
        return Long.MIN_VALUE;
    }

    @Override
    public Number getInteger(PropertyValue integerProperty) throws NullPointerException, IllegalPropertyValueException {
        if (integerProperty == null) {
            throw new NullPointerException("Cannot extract an integer value from a null integer property.");
        }
        if (!this.equals(integerProperty.getType())) {
            throw new IllegalPropertyValueException("The given integer property does not match this kind of integer type definition.");
        }
        return (Number)integerProperty.getValue();
    }

    @Override
    @MediaProperty(uuid1=50397699, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="Size", typeName="UInt8", optional=false, uniqueIdentifier=false, pid=15, symbol="Size")
    public byte getSize() {
        return this.size;
    }

    @MediaPropertySetter(value="Size")
    public void setSize(byte intSize) throws IllegalArgumentException {
        if (intSize != 1 && intSize != 2 && intSize != 4 && intSize != 8) {
            throw new IllegalArgumentException("This implementation does not support the given number of bytes per integer value.");
        }
        this.size = intSize;
    }

    public static final byte initializeSize() {
        return 1;
    }

    @Override
    public boolean isSigned() {
        return this.isSigned;
    }

    @MediaProperty(uuid1=50397699, uuid2=512, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="IsSigned", typeName="Boolean", optional=false, uniqueIdentifier=false, pid=16, symbol="IsSigned")
    public boolean getIsSigned() {
        return this.isSigned;
    }

    @MediaPropertySetter(value="IsSigned")
    public void setIsSigned(boolean isSigned) {
        this.isSigned = isSigned;
    }

    public static final boolean initializeIsSigned() {
        return true;
    }

    @Override
    public void setInteger(PropertyValue integerProperty, Number value) throws NullPointerException, BadSizeException, IllegalPropertyValueException, IllegalArgumentException {
        if (integerProperty == null) {
            throw new NullPointerException("Cannot set the integer value of a null property.");
        }
        if (value == null) {
            throw new NullPointerException("Cannot set the integer value of the given property using a null value.");
        }
        if (!this.equals(integerProperty.getType())) {
            throw new IllegalPropertyValueException("The given integer property does not match this integer type definition.");
        }
        if (value.longValue() < this.minValue() || value.longValue() > this.maxValue()) {
            throw new IllegalArgumentException("The given number is outside the acceptable range for a " + (this.isSigned ? "signed" : "unsigned") + " integer value of " + this.size + " bytes.");
        }
        switch (this.size) {
            case 1: {
                ((ByteValue)integerProperty).setValue(value.byteValue());
                return;
            }
            case 2: {
                ((ShortValue)integerProperty).setValue(value.shortValue());
                return;
            }
            case 4: {
                ((IntegerValue)integerProperty).setValue(value.intValue());
                return;
            }
            case 8: {
                ((LongValue)integerProperty).setValue(value.longValue());
                return;
            }
        }
        throw new IllegalArgumentException("Unexpectedly, the size in bytes of the representation of an integer type is not supported in this implementation.");
    }

    @Override
    public TypeCategory getTypeCategory() {
        return TypeCategory.Int;
    }

    @Override
    public PropertyValue createValue(Object javaValue) throws ClassCastException {
        if (javaValue == null) {
            throw new ClassCastException("Cannot cast a null value to an integer property value.");
        }
        if (javaValue instanceof ByteOrder) {
            javaValue = ((ByteOrder)javaValue).getAAFByteOrderCode();
        }
        if (javaValue instanceof String) {
            try {
                String stringValue = (String)javaValue;
                javaValue = Long.valueOf(stringValue);
            }
            catch (NumberFormatException e) {
                throw new ClassCastException("The given string does not represent an appropriate " + this.getName() + " value.");
            }
        }
        if (javaValue instanceof PropertyValue) {
            PropertyValue value = (PropertyValue)javaValue;
            try {
                return this.createValueFromNumber((Number)value.getValue());
            }
            catch (Exception e) {
                throw new ClassCastException("Problem creating an integer property value from the given property value: " + e.getMessage());
            }
        }
        if (!(javaValue instanceof Number)) {
            throw new ClassCastException("Cannot cast a non java.lang.Number value to an integer property value.");
        }
        try {
            return this.createValueFromNumber((Number)javaValue);
        }
        catch (Exception bse) {
            throw new ClassCastException("Exception thrown when creating an integer value: " + bse.getClass().getName() + ": " + bse.getMessage());
        }
    }

    @Override
    public final boolean deepEquals(Object o) {
        if (!super.deepEquals(o)) {
            return false;
        }
        if (!(o instanceof TypeDefinitionInteger)) {
            return false;
        }
        TypeDefinitionInteger testDefinition = (TypeDefinitionInteger)o;
        if (testDefinition.getSize() != this.size) {
            return false;
        }
        return testDefinition.isSigned() == this.isSigned;
    }

    @Override
    public PropertyValue createFromBytes(ByteBuffer buffer) throws NullPointerException, EndOfDataException {
        super.createFromBytes(buffer);
        if (buffer.remaining() < this.size) {
            throw new EndOfDataException("Not enough bytes in the given buffer to read a " + this.getName() + " value.");
        }
        switch (this.size) {
            case 1: {
                return this.createValueFromNumber(buffer.get());
            }
            case 2: {
                return this.createValueFromNumber(buffer.getShort());
            }
            case 4: {
                return this.createValueFromNumber(buffer.getInt());
            }
            case 8: {
                return this.createValueFromNumber(buffer.getLong());
            }
        }
        return null;
    }

    @Override
    public List<PropertyValue> writeAsBytes(PropertyValue value, ByteBuffer buffer) throws NullPointerException, IllegalPropertyValueException, InsufficientSpaceException {
        super.writeAsBytes(value, buffer);
        if (buffer.remaining() < this.size) {
            throw new InsufficientSpaceException("Insufficient space remaining in the given buffer to write a " + this.getName() + " value.");
        }
        switch (this.size) {
            case 1: {
                buffer.put(((ByteValue)value).getValue());
                return null;
            }
            case 2: {
                buffer.putShort(((ShortValue)value).getValue());
                return null;
            }
            case 4: {
                buffer.putInt(((IntegerValue)value).getValue());
                return null;
            }
            case 8: {
                buffer.putLong(((LongValue)value).getValue());
                return null;
            }
        }
        return null;
    }

    @Override
    public long lengthAsBytes(PropertyValue value) throws NullPointerException, IllegalPropertyValueException {
        super.lengthAsBytes(value);
        return this.size;
    }

    @Override
    public void appendMetadictXML(Node metadict, String namespace, String prefix) {
        Element typeElement = XMLBuilder.createChild(metadict, namespace, prefix, "TypeDefinitionInteger");
        super.appendMetadictXML(typeElement, namespace, prefix);
        XMLBuilder.appendElement((Node)typeElement, namespace, prefix, "Size", this.size);
        XMLBuilder.appendElement((Node)typeElement, namespace, prefix, "IsSigned", this.isSigned);
    }

    @Override
    public TypeDefinitionInteger clone() {
        return (TypeDefinitionInteger)super.clone();
    }

    public static class LongValue
    extends BaseIntegerValue
    implements PropertyValue {
        private Long value;

        private LongValue(TypeDefinitionIntegerImpl type, Long value) throws IllegalArgumentException {
            this.setType(type);
            this.setValue(value);
        }

        @Override
        public Long getValue() {
            return this.value;
        }

        private void setValue(Long value) throws IllegalArgumentException {
            if (!this.getType().getIsSigned() && value < 0L) {
                throw new IllegalArgumentException("Cannot set a negative value for an unsigned UInt64/long type.");
            }
            this.value = value;
        }
    }

    public static class IntegerValue
    extends BaseIntegerValue
    implements PropertyValue {
        private Integer value;

        private IntegerValue(TypeDefinitionIntegerImpl type, Integer value) throws IllegalArgumentException {
            this.setType(type);
            this.setValue(value);
        }

        private void setValue(Integer value) throws IllegalArgumentException {
            this.value = value;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }
    }

    public static class ShortValue
    extends BaseIntegerValue
    implements PropertyValue {
        private Short value;

        public ShortValue(TypeDefinitionIntegerImpl type, Short value) throws IllegalArgumentException {
            this.setType(type);
            this.setValue(value);
        }

        @Override
        public Short getValue() {
            return this.value;
        }

        public void setValue(short value) throws IllegalArgumentException {
            this.value = value;
        }
    }

    public static class ByteValue
    extends BaseIntegerValue
    implements PropertyValue {
        private Byte value;

        private ByteValue(TypeDefinitionIntegerImpl type, Byte value) throws IllegalArgumentException {
            this.setType(type);
            this.setValue(value);
        }

        @Override
        public Byte getValue() {
            return this.value;
        }

        private void setValue(Byte value) throws IllegalArgumentException {
            this.value = value;
        }
    }

    public static abstract class BaseIntegerValue
    extends TypeDefinitionImpl.PropertyValueImpl
    implements PropertyValue {
        private TypeDefinitionIntegerImpl type;

        @Override
        public TypeDefinitionIntegerImpl getType() {
            return this.type;
        }

        protected void setType(TypeDefinitionIntegerImpl type) {
            this.type = type;
        }

        public boolean isDefinedType() {
            return true;
        }
    }
}

