/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.union.impl;

import java.io.Serializable;
import java.util.Arrays;
import tv.amwa.maj.integer.Int16;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.misctype.DataBuffer;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.union.MultiXferItem;

public class MultiXferItemImpl
implements MultiXferItem,
Serializable,
Cloneable {
    private static final long serialVersionUID = 738803789994372035L;
    private AUID mediaKind;
    @Int16
    private short subTrackNum;
    @UInt32
    private int numSamples;
    @DataBuffer
    private byte[] buffer;

    public MultiXferItemImpl(AUID mediaKind, @Int16 short subTrackNum, @UInt32 int numSamples, byte[] buffer) throws NullPointerException, IllegalArgumentException {
        this.setMediaKind(mediaKind);
        this.setBuffer(buffer);
        this.setNumSamples(numSamples);
        this.setSubTrackNum(subTrackNum);
    }

    @Override
    @DataBuffer
    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public void setBuffer(@DataBuffer byte[] buffer) throws NullPointerException {
        if (buffer == null) {
            throw new NullPointerException("The given data buffer for this multi transfer item is null.");
        }
        this.buffer = buffer;
    }

    @Override
    @Deprecated
    @UInt32
    public int getBuflen() {
        return this.buffer.length;
    }

    @Override
    @Deprecated
    public void setBuflen(@UInt32 int buflen) {
    }

    @Override
    public AUID getMediaKind() {
        return this.mediaKind;
    }

    @Override
    public void setMediaKind(AUID mediaKind) throws NullPointerException {
        if (mediaKind == null) {
            throw new NullPointerException("The given media kind for this multi-transfer item is null.");
        }
        this.mediaKind = mediaKind.clone();
    }

    @Override
    @UInt32
    public int getNumSamples() {
        return this.numSamples;
    }

    @Override
    public void setNumSamples(@UInt32 int numSamples) throws IllegalArgumentException {
        if (numSamples < 0) {
            throw new IllegalArgumentException("The given number of samples for this multi-transfer item is negative.");
        }
        this.numSamples = numSamples;
    }

    @Override
    @Int16
    public short getSubTrackNum() {
        return this.subTrackNum;
    }

    @Override
    public void setSubTrackNum(@Int16 short subTrackNum) {
        this.subTrackNum = subTrackNum;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiXferItem)) {
            return false;
        }
        MultiXferItem testItem = (MultiXferItem)o;
        if (testItem.getNumSamples() != this.numSamples) {
            return false;
        }
        if (testItem.getSubTrackNum() != this.subTrackNum) {
            return false;
        }
        if (!this.mediaKind.equals(testItem.getMediaKind())) {
            return false;
        }
        if (this.buffer.length != testItem.getBuffer().length) {
            return false;
        }
        return Arrays.equals(this.buffer, testItem.getBuffer());
    }

    public String toString() {
        return "<MultiTransferItem bufferLength=\"" + this.buffer.length + "\">\n  <MediaKind>" + this.mediaKind.toString() + "</MediaKind>\n  <NumSamples>" + this.numSamples + "</NumSamples>\n  <SubTrackNum>" + this.subTrackNum + "</SubTrackNum>\n</MultiTransferItem>";
    }

    public MultiXferItemImpl clone() throws CloneNotSupportedException {
        return (MultiXferItemImpl)super.clone();
    }

    public int hashCode() {
        return this.numSamples ^ ~this.subTrackNum ^ this.mediaKind.hashCode() ^ Arrays.hashCode(this.buffer);
    }
}

