/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.enumeration.ElectroSpatialFormulation;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.model.ContainerDefinition;
import tv.amwa.maj.model.SoundDescriptor;
import tv.amwa.maj.model.impl.AAFFileDescriptorImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.impl.AUIDImpl;
import tv.amwa.maj.record.impl.RationalImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=16896, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="SoundDescriptor", description="The SoundDescriptor class specifies that a File SourcePackage is associated with audio essence.", symbol="SoundDescriptor")
public class SoundDescriptorImpl
extends AAFFileDescriptorImpl
implements SoundDescriptor,
Serializable,
Cloneable {
    private static final long serialVersionUID = 6777932901589723444L;
    private Rational audioSampleRate;
    private Boolean locked = null;
    private Byte audioReferenceLevel = null;
    private ElectroSpatialFormulation electrospatialFormulation = null;
    private int channelCount;
    private int quantizationBits;
    private Byte dialNorm = null;
    private AUID soundCompression = null;

    public SoundDescriptorImpl() {
    }

    public SoundDescriptorImpl(ContainerDefinition containerFormat, Rational audioSampleRate, @UInt32 int channels, @UInt32 int quantizationBits) throws NullPointerException, IllegalArgumentException {
        if (audioSampleRate == null) {
            throw new NullPointerException("Cannot create a new sound descriptor using a null audio sampling rate.");
        }
        if (channels < 0) {
            throw new IllegalArgumentException("Cannot create a new sound descriptor with a negative number of channels.");
        }
        if (quantizationBits < 0) {
            throw new IllegalArgumentException("Cannot create a new sound descriptor with a negative value for quantization bits.");
        }
        this.setContainerFormat(containerFormat);
        this.setAudioSampleRate(audioSampleRate);
        this.setChannelCount(channels);
        this.setQuantizationBits(quantizationBits);
    }

    @Override
    @MediaProperty(uuid1=67240193, uuid2=768, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="AudioReferenceLevel", aliases={"AudioRefLevel"}, typeName="Int8", optional=true, uniqueIdentifier=false, pid=15620, symbol="AudioReferenceLevel")
    public byte getAudioReferenceLevel() throws PropertyNotPresentException {
        if (this.audioReferenceLevel == null) {
            throw new PropertyNotPresentException("The optional audio reference level is not present in this sound descriptor.");
        }
        return this.audioReferenceLevel;
    }

    @Override
    @MediaPropertySetter(value="AudioReferenceLevel")
    public void setAudioReferenceLevel(Byte audioReferenceLevel) {
        this.audioReferenceLevel = audioReferenceLevel;
    }

    @Override
    @MediaProperty(uuid1=67240705, uuid2=257, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="AudioSampleRate", aliases={"AudioSamplingRate"}, typeName="Rational", optional=false, uniqueIdentifier=false, pid=15619, symbol="AudioSampleRate")
    public Rational getAudioSampleRate() {
        return this.audioSampleRate.clone();
    }

    @Override
    @MediaPropertySetter(value="AudioSampleRate")
    public void setAudioSampleRate(Rational rate) throws NullPointerException {
        if (rate == null) {
            throw new NullPointerException("Cannot set the audio sampling rate of this sound descriptor using a null value.");
        }
        this.audioSampleRate = rate.clone();
    }

    public static final Rational initializeAudioSampleRate() {
        return new RationalImpl(1, 1);
    }

    @Override
    @MediaProperty(uuid1=67240193, uuid2=1024, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="ChannelCount", aliases={"Channels"}, typeName="UInt32", optional=false, uniqueIdentifier=false, pid=15623, symbol="ChannelCount")
    public int getChannelCount() {
        return this.channelCount;
    }

    @Override
    @MediaPropertySetter(value="ChannelCount")
    public void setChannelCount(int channelCount) throws IllegalArgumentException {
        if (channelCount < 0) {
            throw new IllegalArgumentException("Cannot set the channel count for a sound descriptor to a negative value.");
        }
        this.channelCount = channelCount;
    }

    public static final int initializeChannelCount() {
        return 1;
    }

    @Override
    @MediaProperty(uuid1=0x4020402, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="SoundCompression", aliases={"Compression", "SoundDescriptorCompression"}, typeName="AUID", optional=true, uniqueIdentifier=false, pid=15622, symbol="SoundCompression")
    public AUID getSoundCompression() throws PropertyNotPresentException {
        if (this.soundCompression == null) {
            throw new PropertyNotPresentException("The optional compression property is not present in this sound descriptor, indicating that the associated sound data is not compressed.");
        }
        return this.soundCompression.clone();
    }

    @Override
    @MediaPropertySetter(value="SoundCompression")
    public void setSoundCompression(AUID soundCompression) {
        if (soundCompression == null) {
            this.soundCompression = null;
            return;
        }
        this.soundCompression = soundCompression.clone();
    }

    @Override
    @MediaProperty(uuid1=67241729, uuid2=0, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="DialNorm", typeName="Int8", optional=true, uniqueIdentifier=false, pid=15628, symbol="DialNorm")
    public byte getDialNorm() throws PropertyNotPresentException {
        if (this.dialNorm == null) {
            throw new PropertyNotPresentException("The optional dial normalization property is not present in this sound descriptor.");
        }
        return this.dialNorm;
    }

    @Override
    @MediaPropertySetter(value="DialNorm")
    public void setDialNorm(Byte dialNorm) {
        this.dialNorm = dialNorm;
    }

    @Override
    @MediaProperty(uuid1=67240193, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="ElectrospatialFormulation", aliases={"ElectroSpatial", "ElectroSpatialFormulation"}, typeName="ElectroSpatialFormulation", optional=true, uniqueIdentifier=false, pid=15621, symbol="ElectrospatialFormulation")
    public ElectroSpatialFormulation getElectrospatialFormulation() throws PropertyNotPresentException {
        if (this.electrospatialFormulation == null) {
            throw new PropertyNotPresentException("The optional electro spatial formulation property is not present in this sound descriptor.");
        }
        return this.electrospatialFormulation;
    }

    @Override
    @MediaPropertySetter(value="ElectrospatialFormulation")
    public void setElectrospatialFormulation(ElectroSpatialFormulation formulation) {
        this.electrospatialFormulation = formulation;
    }

    @Override
    @MediaProperty(uuid1=67240707, uuid2=1024, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 4}, definedName="QuantizationBits", typeName="UInt32", optional=false, uniqueIdentifier=false, pid=15617, symbol="QuantizationBits")
    public int getQuantizationBits() {
        return this.quantizationBits;
    }

    @Override
    @MediaPropertySetter(value="QuantizationBits")
    public void setQuantizationBits(int bitsCount) throws IllegalArgumentException {
        if (bitsCount < 0) {
            throw new IllegalArgumentException("The number of quantization bits cannot be negative.");
        }
        this.quantizationBits = bitsCount;
    }

    public static final int initializeQuantizationBits() {
        return 0;
    }

    @Override
    public boolean isLocked() throws PropertyNotPresentException {
        if (this.locked == null) {
            throw new PropertyNotPresentException("The optional locked property is not present for this sound descriptor.");
        }
        return this.locked;
    }

    @Override
    @MediaProperty(uuid1=67240705, uuid2=1024, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 4}, definedName="Locked", typeName="Boolean", optional=true, uniqueIdentifier=false, pid=15618, symbol="Locked")
    public boolean getLocked() throws PropertyNotPresentException {
        return this.isLocked();
    }

    @Override
    @MediaPropertySetter(value="Locked")
    public void setIsLocked(Boolean locked) {
        this.locked = locked;
    }

    @Override
    public SoundDescriptor clone() {
        return (SoundDescriptor)super.clone();
    }

    public String getAudioSampleRateString() {
        return RationalImpl.toPersistentForm(this.audioSampleRate);
    }

    public void setAudioSampleRateString(String audioSampleRate) {
        this.audioSampleRate = RationalImpl.fromPersistentForm(audioSampleRate);
    }

    public String getSoundCompressionString() {
        return AUIDImpl.toPersistentForm(this.soundCompression);
    }

    public void setSoundCompressionString(String soundCompression) {
        this.soundCompression = AUIDImpl.fromPersistentForm(soundCompression);
    }
}

