/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.nio.ByteBuffer;
import tv.amwa.maj.exception.NotValidKeyException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.misctype.DataBuffer;
import tv.amwa.maj.model.KLVData;
import tv.amwa.maj.model.impl.InterchangeObjectImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.impl.AUIDImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=16384, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="KLVData", description="The KLVData class contains user data specified with a key (SMPTE label), length, and value.", symbol="KLVData")
public class KLVDataImpl
extends InterchangeObjectImpl
implements KLVData,
Serializable,
XMLSerializable,
Cloneable {
    private ByteBuffer klvDataValue;
    private static final long serialVersionUID = -5267669350070637395L;

    public KLVDataImpl() {
    }

    public KLVDataImpl(AUID key, @DataBuffer ByteBuffer value) throws NullPointerException, NotValidKeyException {
        if (key == null) {
            throw new NullPointerException("Cannot set the value of a KLV data item from a null key.");
        }
        if (value == null) {
            throw new NullPointerException("Cannot set the value of a KLV data item from a null value.");
        }
        this.klvDataValue = ByteBuffer.allocate(value.limit() + 16);
        this.klvDataValue.put(key.getAUIDValue());
        value.rewind();
        this.klvDataValue.put(value);
        this.klvDataValue.order(value.order());
    }

    public KLVDataImpl(@DataBuffer ByteBuffer keyAndValue) throws NullPointerException, IllegalArgumentException {
        if (keyAndValue == null) {
            throw new NullPointerException("Cannot set the value of a KLV data item from a null key and value.");
        }
        if (keyAndValue.limit() < 16) {
            throw new IllegalArgumentException("A KLV data value must include a 16 byte key and the given array is too short.");
        }
        this.klvDataValue = keyAndValue.duplicate();
        this.klvDataValue.rewind();
    }

    @Override
    public AUID getKey() {
        byte[] keyBytes = new byte[16];
        this.klvDataValue.rewind();
        this.klvDataValue.get(keyBytes);
        return new AUIDImpl(keyBytes);
    }

    @Override
    public int getLength() {
        return this.klvDataValue.limit();
    }

    @Override
    @MediaProperty(uuid1=50397712, uuid2=512, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="KLVDataValue", aliases={"Value"}, typeName="Opaque", optional=false, uniqueIdentifier=false, pid=20737, symbol="KLVDataValue")
    public ByteBuffer getValue() {
        ByteBuffer resultBuffer = this.klvDataValue.duplicate();
        resultBuffer.rewind();
        return resultBuffer;
    }

    @Override
    @MediaPropertySetter(value="KLVDataValue")
    public void setValue(ByteBuffer keyAndValue) throws NullPointerException, IllegalArgumentException {
        if (keyAndValue == null) {
            throw new NullPointerException("Canoot set the value of this KLV data to null.");
        }
        if (keyAndValue.limit() < 16) {
            throw new IllegalArgumentException("Cannot set the value of a KLV data item with less than 16-bytes as this is missing a valid key.");
        }
        this.klvDataValue = keyAndValue.duplicate();
    }

    public static final ByteBuffer initializeKLVDataValue() {
        return ByteBuffer.allocate(16);
    }

    @Override
    public KLVData clone() {
        return (KLVData)super.clone();
    }

    @Override
    public String getComment() {
        return "local KLV data persistent id: " + this.getPersistentID();
    }

    public byte[] getKLVDataValuePersist() {
        if (this.klvDataValue == null) {
            return null;
        }
        return this.klvDataValue.array();
    }

    public void setKLVDataValuePersist(byte[] klvDataValue) {
        if (klvDataValue == null) {
            this.klvDataValue = null;
            return;
        }
        this.klvDataValue = ByteBuffer.wrap(klvDataValue);
    }
}

