/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.enumeration.FilmType;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.model.FilmDescriptor;
import tv.amwa.maj.model.impl.EssenceDescriptorImpl;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.impl.RationalImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=11520, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="FilmDescriptor", description="The FilmDescriptor class describes film media.", symbol="FilmDescriptor")
public class FilmDescriptorImpl
extends EssenceDescriptorImpl
implements FilmDescriptor,
Serializable,
Cloneable {
    private static final long serialVersionUID = 6661560948065288922L;
    private FilmType filmFormat = null;
    private Integer frameRate = null;
    private Byte perforationsPerFrame = null;
    private Rational filmAspectRatio = null;
    private String filmStockManufacturer = null;
    private String filmStockKind = null;
    private String filmFormatName = null;
    private String filmBatchNumber = null;

    @Override
    @MediaProperty(uuid1=68157699, uuid2=515, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="FilmAspectRatio", typeName="Rational", optional=true, uniqueIdentifier=false, pid=14596, symbol="FilmAspectRatio")
    public Rational getFilmAspectRatio() throws PropertyNotPresentException {
        if (this.filmAspectRatio == null) {
            throw new PropertyNotPresentException("The optional film aspect ratio property is not present for this film descriptor.");
        }
        return this.filmAspectRatio.clone();
    }

    @Override
    @MediaPropertySetter(value="FilmAspectRatio")
    public void setFilmAspectRatio(Rational aspectRatio) {
        this.filmAspectRatio = aspectRatio == null ? null : aspectRatio.clone();
    }

    @Override
    @MediaProperty(uuid1=68157699, uuid2=264, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="FilmFormat", typeName="FilmType", optional=true, uniqueIdentifier=false, pid=14593, symbol="FilmFormat")
    public FilmType getFilmFormat() throws PropertyNotPresentException {
        if (this.filmFormat == null) {
            throw new PropertyNotPresentException("The optional film format property is not present for this film descriptor.");
        }
        return this.filmFormat;
    }

    @Override
    @MediaPropertySetter(value="FilmFormat")
    public void setFilmFormat(FilmType filmFormat) {
        this.filmFormat = filmFormat;
    }

    @Override
    @MediaProperty(uuid1=68157699, uuid2=262, uuid3=256, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="FilmStockManufacturer", aliases={"Manufacturer", "FilmDescriptorManufacturer"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=14597, symbol="FilmStockManufacturer")
    public String getFilmStockManufacturer() throws PropertyNotPresentException {
        if (this.filmStockManufacturer == null) {
            throw new PropertyNotPresentException("The optional manufacturer property is not present for this film descriptor.");
        }
        return this.filmStockManufacturer;
    }

    @Override
    @MediaPropertySetter(value="FilmStockManufacturer")
    public void setFilmStockManufacturer(String filmStockManufacturer) {
        this.filmStockManufacturer = filmStockManufacturer;
    }

    @Override
    @MediaProperty(uuid1=68157699, uuid2=261, uuid3=256, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="FilmStockKind", aliases={"Model", "FilmDescriptorModel"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=14598, symbol="FilmStockKind")
    public String getFilmStockKind() throws PropertyNotPresentException {
        if (this.filmStockKind == null) {
            throw new PropertyNotPresentException("The optional film stock kind property is not present for this film descriptor.");
        }
        return this.filmStockKind;
    }

    @Override
    @MediaPropertySetter(value="FilmStockKind")
    public void setFilmStockKind(String filmStockKind) {
        this.filmStockKind = filmStockKind;
    }

    @Override
    @MediaProperty(uuid1=67176450, uuid2=768, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="FrameRate", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=14594, symbol="FrameRate")
    public int getFrameRate() throws PropertyNotPresentException {
        if (this.frameRate == null) {
            throw new PropertyNotPresentException("The optional frame rate property is not present in this film descriptor.");
        }
        return this.frameRate;
    }

    @Override
    @MediaPropertySetter(value="FrameRate")
    public void setFrameRate(Integer rate) throws IllegalArgumentException {
        if (rate == null) {
            this.frameRate = null;
            return;
        }
        if (rate < 0) {
            throw new IllegalArgumentException("Cannot set the frame rate of this film descriptor to a negative value.");
        }
        this.frameRate = rate;
    }

    @Override
    @MediaProperty(uuid1=68157699, uuid2=259, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="PerforationsPerFrame", typeName="UInt8", optional=true, uniqueIdentifier=false, pid=14595, symbol="PerforationsPerFrame")
    public byte getPerfortionsPerFrame() throws PropertyNotPresentException {
        if (this.perforationsPerFrame == null) {
            throw new PropertyNotPresentException("The optional perforations per frame property is not present for this film descriptor.");
        }
        return this.perforationsPerFrame;
    }

    @Override
    @MediaPropertySetter(value="PerforationsPerFrame")
    public void setPerforationsPerFrame(Byte perforationsPerFrame) throws IllegalArgumentException {
        if (perforationsPerFrame == null) {
            this.perforationsPerFrame = null;
            return;
        }
        if (perforationsPerFrame < 0) {
            throw new IllegalArgumentException("Cannot set the number of perforations per frame to a negative value for this film descriptor.");
        }
        this.perforationsPerFrame = perforationsPerFrame;
    }

    @Override
    @MediaProperty(uuid1=68157699, uuid2=263, uuid3=256, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="FilmBatchNumber", typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=14600, symbol="FilmBatchNumber")
    public String getFilmBatchNumber() throws PropertyNotPresentException {
        if (this.filmBatchNumber == null) {
            throw new PropertyNotPresentException("The optional film batch number is not present for this film descriptor.");
        }
        return this.filmBatchNumber;
    }

    @Override
    @MediaPropertySetter(value="FilmBatchNumber")
    public void setFilmBatchNumber(String filmBatchNumber) {
        this.filmBatchNumber = filmBatchNumber;
    }

    @Override
    @MediaProperty(uuid1=68157699, uuid2=260, uuid3=256, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="FilmFormatName", aliases={"FilmGaugeFormat"}, typeName="UTF16String", optional=true, uniqueIdentifier=false, pid=14599, symbol="FilmFormatName")
    public String getFilmFormatName() throws PropertyNotPresentException {
        if (this.filmFormatName == null) {
            throw new PropertyNotPresentException("The optional film gauge format property is not present for this film descriptor.");
        }
        return this.filmFormatName;
    }

    @Override
    @MediaPropertySetter(value="FilmFormatName")
    public void setFilmFormatName(String filmFormatName) {
        this.filmFormatName = filmFormatName;
    }

    @Override
    public FilmDescriptor clone() {
        return (FilmDescriptor)super.clone();
    }

    public String getFilmAspectRatioString() {
        return RationalImpl.toPersistentForm(this.filmAspectRatio);
    }

    public void setFilmAspectRatioString(String filmAspectRatio) {
        this.filmAspectRatio = RationalImpl.fromPersistentForm(filmAspectRatio);
    }
}

