/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.industry;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.industry.WeakReferenceTarget;

public class WeakReferenceSet<T extends WeakReferenceTarget> {
    private Set<WeakReference<T>> set = Collections.synchronizedSet(new HashSet());
    private long persistentID = 0L;

    public void add(T item) throws NullPointerException {
        if (item == null) {
            throw new NullPointerException("Cannot add a null item to a set of weak references.");
        }
        this.set.add(new WeakReference<T>(item));
    }

    public void add(WeakReference<T> reference) throws NullPointerException {
        if (reference == null) {
            throw new NullPointerException("Cannot add a null item to a set of weak references.");
        }
        this.set.add(reference);
    }

    public boolean contains(T item) throws NullPointerException {
        if (item == null) {
            throw new NullPointerException("Cannot check for containment of an item in a set using a null value.");
        }
        return this.set.contains(item);
    }

    public boolean remove(T item) throws NullPointerException {
        if (item == null) {
            throw new NullPointerException("Cannot remove an item from a set using a null value.");
        }
        return this.set.remove(item);
    }

    public void clear() {
        this.set.clear();
    }

    public int count() {
        return this.set.size();
    }

    public Set<T> getOptionalSet() throws PropertyNotPresentException {
        if (this.set.size() == 0) {
            throw new PropertyNotPresentException("The optional weak reference set property is not present.");
        }
        return this.getRequiredSet();
    }

    public Set<T> getRequiredSet() {
        HashSet<T> unpackedList = new HashSet<T>(this.set.size());
        for (WeakReference<T> weakReference : this.set) {
            unpackedList.add(weakReference.getTarget());
        }
        return unpackedList;
    }
}

