/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.WeakReference;
import tv.amwa.maj.meta.ExtensionScheme;
import tv.amwa.maj.model.ApplicationPluginObject;
import tv.amwa.maj.model.ApplicationReferencedObject;
import tv.amwa.maj.model.impl.ApplicationObjectImpl;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=25088, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="ApplicationReferencedObject", symbol="ApplicationReferencedObject", description="Representation of any object connected by strong reference to an application plugin object, whether directly or indirectly.")
public class ApplicationReferencedObjectImpl
extends ApplicationObjectImpl
implements ApplicationReferencedObject,
Cloneable,
Serializable {
    private static final long serialVersionUID = -3612154664539896315L;
    private WeakReference<ApplicationPluginObject> linkedApplicationPlugin = null;

    @Override
    @MediaProperty(uuid1=85985025, uuid2=2816, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 12}, definedName="LinkedApplicationPluginInstanceID", typeName="AUID", optional=false, uniqueIdentifier=false, pid=0, symbol="LinkedApplicationPluginInstanceID", description="Identifier of the application plugin object that strongly references this application referenced object.")
    public AUID getLinkedApplicationPluginInstanceID() {
        return this.linkedApplicationPlugin.getIdentifier();
    }

    @Override
    @MediaPropertySetter(value="LinkedApplicationPluginInstanceID")
    public void setLinkedApplicationPluginInstanceID(AUID linkedApplicationPluginInstanceID) throws NullPointerException {
        if (linkedApplicationPluginInstanceID == null) {
            throw new NullPointerException("Cannot set the application plugin object identifier using a null value.");
        }
        this.linkedApplicationPlugin = new WeakReference<ApplicationPluginObject>(ApplicationPluginObject.class, linkedApplicationPluginInstanceID);
    }

    @Override
    public void setLinkedApplicationPluginInstanceID(ApplicationPluginObject linkedApplicationPluginInstance) throws NullPointerException {
        if (linkedApplicationPluginInstance == null) {
            throw new NullPointerException("Cannot set the application plugin object identifier using a null value.");
        }
        WeakReference.registerTarget(linkedApplicationPluginInstance);
        this.linkedApplicationPlugin = new WeakReference<ApplicationPluginObject>(linkedApplicationPluginInstance);
    }

    @Override
    public ExtensionScheme getApplicationScheme() {
        return this.linkedApplicationPlugin.getTarget().getApplicationScheme();
    }

    @Override
    public ApplicationReferencedObject clone() {
        return (ApplicationReferencedObject)super.clone();
    }
}

