---
layout: post
title: Resources
---

- [DVRescue GitHub repository](https://github.com/mipops/dvrescue)
- [DVRescue Daily builds](https://mediaarea.net/DVRescue)
- [Current DVRescue working documentation](https://drive.google.com/drive/u/1/folders/14sKKGQ3pr5g43Po5PNwBOTKINGqHETF-)
- [Digital Video Commander GitHub repository](https://github.com/mipops/digividcommander)
- [Final Digital Video Commander documentation](https://mipops.github.io/digividcommander/)
- [MIPoPS DVRescue project page](https://www.mipops.org/dvrescue/)
- [MIPoPS Blog](https://mipops.tumblr.com/)

# Articles

# Bibliography
- __[On the Preservation of the EastSide Arts Alliance DV Collection](https://bavc.org/on-the-preservation-of-the-east-side-arts-alliance-dv-collection/)__ by Tim Lake, May 2022

This paper presents experiences and lessons learned at Bay Area Video Coalition when using DVRescue tools to process a collection of DV tapes.

- __[MiniDV Tape Data Migration to a Digital File with DVRescue: User Documentation](https://drive.google.com/file/d/1BiOejlu-5tCFOWPtM40yYAdv-Y4Kic0v/view?usp=share_link)__ by David I. Griess, Fall 2020

This paper was compiled by a second-year graduate student in New York University's Moving Image Archives Preservation program documenting their experience capturing MiniDV tape with a home step up using the information the DVRescue team provided during a classroom lecture and DVRescue documentation online.

- __[MIPoPS Participating Institutions Processing Manual](https://drive.google.com/open?id=1nQLxMCqJXAirf780B__ra9pXVRKKNCtm)__ by Libby Hopfauf & MIPoPS, 2014-2022

MIPoPS has created and maintains several living documents (manuals) that combine information from several outside sources with simple instructions to aid in training for processing magnetic media. The content is tailored to reflect purpose and implementation unique to the MIPoPS setting and includes written instructions as well as images to address as many learning styles as possible. 

- __[Digitization Software Obsolescence, Too?](http://dericed.com/papers/digitization-software-obsolescence-too/)__ by Dave Rice, October 2015

This paper presents findings on the obsolescence risks affecting the software used to either digitize or migrate content from audiovisual tapes. This article also advocates for archival communities to collaborate to foster, create, and control their own tools to facilitate preservation of videotape contents. 

- __[DV Analyzer Sample: STTS Fluctuation](https://archive.org/details/DvAnalyzerSampleSttsFluctuation)__ by Dave Rice and Angelo Sacerdote, November 2, 2009

This article presents research conducted by Dave Rice with Bay Area Video Coalition on faults with a digitization process for DV where the software covers dropped frames by extending the duration of certain frames. This article presents how this issue was discovered and incorporated into DV Analyzer. 

- __[Barcode Scanners, MiniDV Decks, and the Migration of Digital Information from Analog Surfaces](https://www.avpreserve.com/wp-content/uploads/2017/07/Migration-of-Digital-Information-from-Analog-Surfaces.pdf)__ by Dave Rice and Stefan Elnabli, October 2010

This paper reports on the opportunities of the DV standards and DV parity data within preservation. This paper includes research from experiments at controlled damage and compromises to DV tapes and hardware and analysis of the performance of various software and hardware options. 

- __[Digital Tape Preservation Strategy: Preserving Data Or Video](https://www.weareavp.com/digital-tape-preservation-strategy-preserving-data-video/)__ by Dave Rice and Chris Lacinak, December 2, 2009

This paper presents research and conclusions about the preservation of digital videotape with a significant focus on DV videotapes. The paper recommends that content on DV videotapes be preserved with a data migration approach rather than a traditional audiovisual digitization approach as would be more appropriate with analog videotapes. 

- __[DV Analyzer Sample: DV Video Error Concealment](https://archive.org/details/DvAnalyzerSampleDvVideoErrorConcealment)__ by Dave Rice, October 7, 2009

This article covers the impact of DV video error concealment, one of the most common and most addressable issues affecting DV transfers. 

- __[Dv Analyzer Sample: DIF Incoherency](https://archive.org/details/DvAnalyzerSampleDIFIncoherency_748)__ by Dave Rice, September 10, 2009

This article describes use cases and risks associated with DV structural incoherencies and details how a compromised DV transfer impacted a news broadcast. 

- __[DV Analyzer Sample: DV Audio Errors](https://archive.org/details/DvAnalyzerSampleDvAudioErrors)__ by Dave Rice, September 3, 2009

This article documents the results of audio errors in DV transfers. This issue is similar to video error concealment in that the parity data of the corresponding DIF block read is invalid; however here the audio is replaced with an audio error that plays as silence instead of offering a concealment. 
