/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.validation;

import com.portalmedia.embarc.validation.IValidationRule;
import com.portalmedia.embarc.validation.ValidationRuleBase;
import org.dizitart.no2.Document;
import org.dizitart.no2.mapper.Mappable;
import org.dizitart.no2.mapper.NitriteMapper;

public class IsValidRegexRule
extends ValidationRuleBase
implements IValidationRule,
Mappable {
    private static final long serialVersionUID = 1L;
    String rule = "Generic Regex Rule";
    private String regexExpression;

    public IsValidRegexRule(String regexExpression) {
        this.regexExpression = regexExpression;
    }

    public String getRegexExpression() {
        return this.regexExpression;
    }

    @Override
    public boolean isValid(String value) {
        return value.trim().matches(this.regexExpression);
    }

    @Override
    public void read(NitriteMapper mapper, Document document) {
        if (document != null) {
            this.setRule((String)document.get("rule"));
            this.setRegexExpression((String)document.get("regexExpression"));
        }
    }

    public void setRegexExpression(String regexExpression) {
        this.regexExpression = regexExpression;
    }

    @Override
    public Document write(NitriteMapper mapper) {
        Document document = new Document();
        document.put("rule", (Object)this.getRule());
        document.put("regexExpression", (Object)this.getRegexExpression());
        return document;
    }
}

