/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.validation;

import com.portalmedia.embarc.validation.IValidationRule;
import com.portalmedia.embarc.validation.ValidationRuleBase;
import org.dizitart.no2.Document;
import org.dizitart.no2.mapper.Mappable;
import org.dizitart.no2.mapper.NitriteMapper;

public class IsValidByteRangeRule
extends ValidationRuleBase
implements IValidationRule,
Mappable {
    private static final long serialVersionUID = 1L;
    String rule = "Generic Byte Range Rule";
    int min;
    int max;

    public IsValidByteRangeRule(byte min, byte max) {
        this.min = min & 0xFF;
        this.max = max & 0xFF;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    @Override
    public boolean isValid(String value) {
        try {
            if (value.length() == 0) {
                return true;
            }
            byte v = Byte.parseByte(value);
            if (v >= this.min && v <= this.max && v >= 0) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void read(NitriteMapper mapper, Document document) {
        if (document != null) {
            this.setRule((String)document.get("rule"));
            this.setMin((Integer)document.get("min"));
            this.setMax((Integer)document.get("max"));
        }
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void setMin(int min) {
        this.min = min;
    }

    @Override
    public Document write(NitriteMapper mapper) {
        Document document = new Document();
        document.put("rule", (Object)this.getRule());
        document.put("min", (Object)this.getMin());
        document.put("max", (Object)this.getMax());
        return document;
    }
}

