/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.system;

import com.portalmedia.embarc.database.DBService;
import com.portalmedia.embarc.parser.dpx.DPXDataTemplate;
import com.portalmedia.embarc.system.UserPreferences;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;
import java.util.HashMap;
import java.util.List;

public class UserPreferencesService {
    DBService<UserPreferences> dbService = new DBService<UserPreferences>(UserPreferences.class);
    UserPreferences userPreferences = this.getUserPreferences();

    public HashMap<String, DPXDataTemplate> getDPXDataTemplates() {
        return this.userPreferences.getDPXDataTemplates();
    }

    public void addDpxDataTemplate(DPXDataTemplate template) {
        this.userPreferences.addOrUpdateDPXDataTemplate(template);
        this.dbService.update(this.userPreferences);
    }

    public void addHiddenDPXColumn(String columnName) {
        this.userPreferences.addHiddenDPXColumn(columnName);
        this.dbService.update(this.userPreferences);
    }

    public void addRuleSet(ValidationRuleSetEnum ruleSet) {
        this.userPreferences.addRuleSet(ruleSet);
        this.dbService.update(this.userPreferences);
    }

    public List<String> getHiddenDPXColumns() {
        return this.userPreferences.getHiddenDPXColumns();
    }

    public String getImageChecksumReportPath() {
        return this.userPreferences.getImageChecksumReportPath();
    }

    public String getImageChecksumValidationReportPath() {
        return this.userPreferences.getImageChecksumValidationReportPath();
    }

    public List<ValidationRuleSetEnum> getRuleSets() {
        return this.userPreferences.getRuleSets();
    }

    public boolean getSaveImageChecksums() {
        return this.userPreferences.isSaveImageChecksums();
    }

    public String getSaveToPath() {
        return this.userPreferences.getSaveToPath();
    }

    public boolean getSaveToSeparateDirectory() {
        return this.userPreferences.getSaveToSeparateDirectory();
    }

    private UserPreferences getUserPreferences() {
        UserPreferences userPreferences = this.dbService.get(1);
        if (userPreferences == null) {
            userPreferences = new UserPreferences();
            this.dbService.add(userPreferences);
        }
        return userPreferences;
    }

    public String getValidationReportPath() {
        return this.userPreferences.getValidationReportPath();
    }

    public boolean getWriteOnlyEditedFiles() {
        return this.userPreferences.isWriteOnlyEditedFiles();
    }

    public void removeDpxDataTemplate(String templateName) {
        this.userPreferences.removeDPXDataTemplate(templateName);
        this.dbService.update(this.userPreferences);
    }

    public void removeHiddenDPXColumn(String columnName) {
        this.userPreferences.removeHiddenDPXColumn(columnName);
        this.dbService.update(this.userPreferences);
    }

    public void removeRuleSet(ValidationRuleSetEnum ruleSet) {
        this.userPreferences.removeRuleSet(ruleSet);
        this.dbService.update(this.userPreferences);
    }

    public void setImageChecksumReportPath(String imageChecksumReportPath) {
        this.userPreferences.setImageChecksumReportPath(imageChecksumReportPath);
        this.dbService.update(this.userPreferences);
    }

    public void setImageChecksumValidationReportPath(String value) {
        this.userPreferences.setImageChecksumValidationReportPath(value);
        this.dbService.update(this.userPreferences);
    }

    public void setRuleSets(List<ValidationRuleSetEnum> ruleSets) {
        this.userPreferences.setRuleSets(ruleSets);
        this.dbService.update(this.userPreferences);
    }

    public void setSaveImageChecksums(boolean value) {
        this.userPreferences.setSaveImageChecksums(value);
        this.dbService.update(this.userPreferences);
    }

    public void setSaveToPath(String value) {
        this.userPreferences.setSaveToPath(value);
        this.dbService.update(this.userPreferences);
    }

    public void setSaveToSeparateDirectory(boolean value) {
        this.userPreferences.setSaveToSeparateDirectory(value);
        this.dbService.update(this.userPreferences);
    }

    public void setValidationReportPath(String path) {
        this.userPreferences.setValidationReportPath(path);
        this.dbService.update(this.userPreferences);
    }

    public void setWriteOnlyEditedFiles(boolean value) {
        this.userPreferences.setWriteOnlyEditedFiles(value);
        this.dbService.update(this.userPreferences);
    }
}

