/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.parser.mxf;

import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.Project;
import uk.gov.nationalarchives.droid.core.BinarySignatureIdentifier;
import uk.gov.nationalarchives.droid.core.SignatureParseException;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultCollection;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.resource.FileSystemIdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class MXFFileFormats {
    private static MXFFileFormats instance = null;
    BinarySignatureIdentifier droid;
    private static String droidSignatureFileResources = "resources/DROID_SignatureFile_V95.xml";
    private List<String> fileFormats = new ArrayList<String>();

    public static MXFFileFormats getInstance() throws Exception {
        if (instance == null) {
            instance = new MXFFileFormats();
        }
        return instance;
    }

    private MXFFileFormats() throws Exception {
        this.initDroid();
    }

    public List<String> getFileFormats() {
        return this.fileFormats;
    }

    private void initDroid() throws Exception {
        Path tempPath = Files.createTempFile("droidSignatureFile", ".xml", new FileAttribute[0]);
        try (InputStream in = Project.class.getClassLoader().getResourceAsStream(droidSignatureFileResources);){
            Files.copy(in, tempPath, StandardCopyOption.REPLACE_EXISTING);
            in.close();
        }
        this.droid = new BinarySignatureIdentifier();
        try {
            this.droid.setSignatureFile(tempPath.toString());
            this.droid.init();
        }
        catch (SignatureParseException x) {
            System.out.println("Signature parse error");
            throw new Exception("Invalid signature file");
        }
    }

    public List<String> getFormatMatches(String filename) throws Exception {
        Path file = Paths.get(filename, new String[0]);
        URI resourceUri = file.toUri();
        RequestMetaData metaData = new RequestMetaData(Long.valueOf(Files.size(file)), Long.valueOf(Files.getLastModifiedTime(file, new LinkOption[0]).toMillis()), filename);
        RequestIdentifier identifier = new RequestIdentifier(resourceUri);
        identifier.setParentId(Long.valueOf(1L));
        FileSystemIdentificationRequest request = new FileSystemIdentificationRequest(metaData, identifier);
        request.open((Object)file);
        IdentificationResultCollection resultsCollection = this.droid.matchBinarySignatures((IdentificationRequest)request);
        List results = resultsCollection.getResults();
        ArrayList<String> formats = new ArrayList<String>();
        for (IdentificationResult result : results) {
            System.out.println(result.getPuid());
            formats.add(result.getPuid());
        }
        request.close();
        return formats;
    }
}

