/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.mxf;

import com.portalmedia.embarc.gui.AccessibleAlertHelper;
import com.portalmedia.embarc.gui.Main;
import com.portalmedia.embarc.gui.helper.MXFFileList;
import com.portalmedia.embarc.gui.mxf.ControllerMediatorMXF;
import com.portalmedia.embarc.gui.mxf.CoreMXFController;
import com.portalmedia.embarc.gui.mxf.DescriptorMXFController;
import com.portalmedia.embarc.gui.mxf.FileInfoController;
import com.portalmedia.embarc.gui.mxf.TDBDController;
import com.portalmedia.embarc.gui.mxf.WriteFilesModalControllerMXF;
import com.portalmedia.embarc.gui.mxf.WriteMXFController;
import com.portalmedia.embarc.parser.SectionDef;
import com.portalmedia.embarc.parser.mxf.MXFSection;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Window;

public class EditAreaMXFController
implements Initializable {
    @FXML
    private AnchorPane editAreaAnchorPane;
    @FXML
    private AnchorPane editAreaContainer;
    @FXML
    private ScrollPane mxfEditScrollPane;
    @FXML
    private Button writeMXFFilesButton;
    @FXML
    private ImageView fadgiLogoImageView;
    CoreMXFController coreView;
    WriteMXFController writeViewMXF;
    DescriptorMXFController descriptorMXF;
    TDBDController tdbdView;
    FileInfoController fileInfoView;

    public void initialize(URL location, ResourceBundle resources) {
        ControllerMediatorMXF.getInstance().registerEditAreaController(this);
        this.fadgiLogoImageView.setFocusTraversable(true);
        this.fadgiLogoImageView.setAccessibleText("FADGI logo. F A D G I stands for Federal Agencies Digital Guidelines Initiative.");
        this.writeMXFFilesButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(this){

            public void handle(ActionEvent e) {
                WriteFilesModalControllerMXF.getInstance().showWriteFilesDialog();
            }
        });
        this.writeMXFFilesButton.setGraphicTextGap(20.0);
        ControllerMediatorMXF.getInstance().isEditingProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> o, Boolean ov, Boolean nv) {
                if (EditAreaMXFController.this.writeViewMXF == null) {
                    return;
                }
                EditAreaMXFController.this.setWriteFilesButtonsDisabled(nv);
            }
        });
        MXFFileList.getInstance().hasCoreRequiredFieldsErrorProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> o, Boolean ov, Boolean nv) {
                if (EditAreaMXFController.this.writeViewMXF == null) {
                    return;
                }
                if (nv.booleanValue()) {
                    EditAreaMXFController.this.writeMXFFilesButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(this){

                        public void handle(ActionEvent e) {
                            String message = "Fix missing required Core DMS fields marked with icon in Core DMS tab.";
                            Alert alert = AccessibleAlertHelper.CreateAccessibleAlert("Cannot Write Files", Alert.AlertType.NONE, "Fix missing required Core DMS fields marked with icon in Core DMS tab.", ButtonType.OK);
                            alert.initModality(Modality.APPLICATION_MODAL);
                            alert.initOwner((Window)Main.getPrimaryStage());
                            DialogPane dialogPane = alert.getDialogPane();
                            dialogPane.lookupButton(ButtonType.OK).setAccessibleHelp("Fix missing required Core DMS fields marked with icon in Core DMS tab.");
                            dialogPane.getStylesheets().add((Object)this.getClass().getResource("/com/portalmedia/embarc/gui/application.css").toExternalForm());
                            dialogPane.getStyleClass().add((Object)"alertDialog");
                            alert.showAndWait();
                            if (alert.getResult() == ButtonType.OK) {
                                alert.close();
                            }
                        }
                    });
                } else {
                    EditAreaMXFController.this.writeMXFFilesButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(this){

                        public void handle(ActionEvent e) {
                            WriteFilesModalControllerMXF.getInstance().showWriteFilesDialog();
                        }
                    });
                }
            }
        });
    }

    private void setWriteFilesButtonsDisabled(boolean isDisabled) {
        this.writeMXFFilesButton.setDisable(isDisabled);
        ((MenuItem)((Menu)Main.getMXFMenuBar().getMenus().get(0)).getItems().get(2)).setDisable(isDisabled);
    }

    public void resetEditArea() {
        this.editAreaContainer.getChildren().removeAll((Collection)this.editAreaContainer.getChildren());
    }

    public void setWriteControl() {
        this.writeViewMXF = new WriteMXFController();
        this.writeViewMXF.setContent();
        AnchorPane.setTopAnchor((Node)this.writeViewMXF, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.writeViewMXF, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.writeViewMXF, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.writeViewMXF, (Double)0.0);
        this.editAreaContainer.getChildren().setAll((Object[])new Node[]{this.writeViewMXF});
    }

    public void setCoreControl() {
        this.coreView = new CoreMXFController();
        if (this.fileInfoView != null) {
            this.fileInfoView.setVisible(false);
        }
        this.coreView.setVisible(true);
        if (this.editAreaContainer.getChildren().size() > 0) {
            this.editAreaContainer.getChildren().removeAll((Collection)this.editAreaContainer.getChildren());
        }
        this.coreView.setSection(false);
        this.coreView.setTitle("Core DMS");
        AnchorPane.setTopAnchor((Node)this.coreView, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.coreView, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.coreView, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.coreView, (Double)0.0);
        this.editAreaContainer.getChildren().setAll((Object[])new Node[]{this.coreView});
    }

    public void setTDBDControl(SectionDef section) {
        if (section != MXFSection.TD && section != MXFSection.BD) {
            return;
        }
        this.tdbdView = new TDBDController();
        this.tdbdView.setContent(section);
        AnchorPane.setTopAnchor((Node)this.tdbdView, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.tdbdView, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.tdbdView, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.tdbdView, (Double)0.0);
        this.editAreaContainer.getChildren().setAll((Object[])new Node[]{this.tdbdView});
    }

    public void setFileInfoControl() {
        this.fileInfoView = new FileInfoController();
        this.fileInfoView.setContent();
        AnchorPane.setTopAnchor((Node)this.fileInfoView, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.fileInfoView, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.fileInfoView, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.fileInfoView, (Double)0.0);
        this.editAreaContainer.getChildren().setAll((Object[])new Node[]{this.fileInfoView});
    }

    public void setDescriptorControl() {
        this.descriptorMXF = new DescriptorMXFController();
        this.descriptorMXF.setVisible(true);
        if (this.coreView != null) {
            this.coreView.setVisible(false);
        }
        if (this.editAreaContainer.getChildren().size() > 0) {
            this.editAreaContainer.getChildren().removeAll((Collection)this.editAreaContainer.getChildren());
        }
        this.descriptorMXF.setTitle("Descriptors");
        AnchorPane.setTopAnchor((Node)this.descriptorMXF, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.descriptorMXF, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.descriptorMXF, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.descriptorMXF, (Double)0.0);
        this.editAreaContainer.getChildren().setAll((Object[])new Node[]{this.descriptorMXF});
    }
}

