/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.helper;

import com.portalmedia.embarc.gui.Main;
import com.portalmedia.embarc.gui.model.MXFFileInformationViewModel;
import com.portalmedia.embarc.parser.FileInformation;
import com.portalmedia.embarc.parser.MetadataColumnDef;
import com.portalmedia.embarc.parser.mxf.MXFColumn;
import com.portalmedia.embarc.parser.mxf.MXFMetadata;
import com.portalmedia.embarc.parser.mxf.MXFServiceImpl;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import tv.amwa.maj.exception.PropertyNotPresentException;

public class MXFFileList {
    private static final Logger LOGGER = Logger.getLogger(Main.class.getClass().getName());
    private static List<FileInformation<MXFMetadata>> fileList;
    private static BooleanProperty hasCoreRequiredFieldsError;
    private int maxTD = 0;
    private int maxBD = 0;

    public static MXFFileList getInstance() {
        return MXFFileListHolder.INSTANCE;
    }

    public MXFFileList() {
        fileList = new ArrayList<FileInformation<MXFMetadata>>();
    }

    public static List<FileInformation<MXFMetadata>> getList() {
        return fileList;
    }

    public void clearList() {
        fileList.clear();
    }

    public ObservableList<MXFFileInformationViewModel> getObservableList() {
        ArrayList<MXFFileInformationViewModel> list = new ArrayList<MXFFileInformationViewModel>();
        for (FileInformation<MXFMetadata> f : fileList) {
            MXFFileInformationViewModel vm = new MXFFileInformationViewModel(f.getName(), f.getPath(), f.getUUID());
            vm.setCoreData(f.getFileData().getCoreColumns());
            vm.setProp("version", f.getFileData().getVersion());
            vm.setProp("format", f.getFileData().getFormat());
            vm.setProp("profile", f.getFileData().getProfile());
            vm.setProp("size", Long.toString(f.getFileData().getFileSize()));
            vm.setProp("soundTrackCount", Integer.toString(f.getFileData().getSoundTrackCount()));
            vm.setProp("pictureTrackCount", Integer.toString(f.getFileData().getPictureTrackCount()));
            vm.setProp("otherTrackCount", Integer.toString(f.getFileData().getOtherTrackCount()));
            vm.setProp("tdTrackCount", Integer.toString(f.getFileData().getTDCount()));
            vm.setProp("bdTrackCount", Integer.toString(f.getFileData().getBDCount()));
            vm.setProp("hasAS07CoreDMSFramework", f.getFileData().getHasAS07CoreDMSFramework() ? "true" : "false");
            HashMap<String, LinkedHashMap<MXFColumn, MetadataColumnDef>> td = f.getFileData().getTDColumns();
            for (String y : td.keySet()) {
                LinkedHashMap<MXFColumn, MetadataColumnDef> m = td.get(y);
                vm.setTDElement(y, m);
            }
            HashMap<String, LinkedHashMap<MXFColumn, MetadataColumnDef>> bd = f.getFileData().getBDColumns();
            for (String y : bd.keySet()) {
                LinkedHashMap<MXFColumn, MetadataColumnDef> m = bd.get(y);
                vm.setBDElement(y, m);
            }
            if (vm.getTDElementCount() > this.maxTD) {
                this.maxTD = vm.getTDElementCount();
            }
            if (vm.getBDElementCount() > this.maxBD) {
                this.maxBD = vm.getBDElementCount();
            }
            vm.setFileDescriptors(f.getFileData().getFileDescriptors());
            list.add(vm);
        }
        return FXCollections.observableArrayList(list);
    }

    public boolean addFileToList(FileInformation<MXFMetadata> fileInfo) {
        if (fileInfo == null) {
            return false;
        }
        fileList.add(fileInfo);
        return true;
    }

    public boolean addFileToList(String filePath) {
        LOGGER.info("Adding file to list: " + filePath);
        FileInformation<MXFMetadata> fileInfo = this.getFileInfo(filePath);
        if (fileInfo == null) {
            return false;
        }
        this.addFileToList(fileInfo);
        MXFFileList.checkRequiredCoreDMSFields();
        return true;
    }

    public FileInformation<MXFMetadata> getFileInfo(String filePath) {
        FileInformation<MXFMetadata> fileInfo = null;
        try {
            MXFServiceImpl service = new MXFServiceImpl(filePath);
            fileInfo = service.getMetadata();
        }
        catch (PropertyNotPresentException pnpe) {
            LOGGER.log(Level.SEVERE, pnpe.toString(), pnpe);
            System.out.println("property not present exception: " + String.valueOf((Object)pnpe));
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
            System.out.println("File not found exception in getFileInfo");
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.toString(), ex);
            System.out.println("mxf file info exception: " + String.valueOf(ex));
        }
        return fileInfo;
    }

    public int getMaxTD() {
        return this.maxTD;
    }

    public int getMaxBD() {
        return this.maxBD;
    }

    public static void updateValues(HashMap<MXFColumn, MetadataColumnDef> changedValues, MXFFileInformationViewModel fivm) {
        for (MXFColumn mXFColumn : changedValues.keySet()) {
            fivm.getCoreData().put(mXFColumn, changedValues.get(mXFColumn));
            fivm.setProp(mXFColumn.getDisplayName(), changedValues.get(mXFColumn).getCurrentValue());
        }
        fivm.setEdited(true);
        for (FileInformation fileInformation : fileList) {
            if (!fileInformation.getPath().equals(fivm.getProp("path"))) continue;
            ((MXFMetadata)fileInformation.getFileData()).setCoreColumns(fivm.getCoreData());
            fileInformation.setEdited(true);
            fileInformation.setFileShouldBeWritten(true);
        }
        MXFFileList.checkRequiredCoreDMSFields();
    }

    public static void deleteSelectedRows(List<MXFFileInformationViewModel> selectedRows) {
        for (MXFFileInformationViewModel fivm : selectedRows) {
            fileList.removeIf(file -> file.getPath().equals(fivm.getProp("path")));
        }
        MXFFileList.checkRequiredCoreDMSFields();
    }

    public static void checkRequiredCoreDMSFields() {
        boolean hasAtLeastOneError = false;
        hasCoreRequiredFieldsError.set(hasAtLeastOneError);
        for (FileInformation<MXFMetadata> file : fileList) {
            HashMap<MXFColumn, MetadataColumnDef> coreData = file.getFileData().getCoreColumns();
            for (MXFColumn col : coreData.keySet()) {
                String val = coreData.get(col).getCurrentValue();
                if (!col.isRequired() || val != null && !val.equals("")) continue;
                hasAtLeastOneError = true;
            }
        }
        hasCoreRequiredFieldsError.set(hasAtLeastOneError);
    }

    public BooleanProperty hasCoreRequiredFieldsErrorProperty() {
        return hasCoreRequiredFieldsError;
    }

    static {
        hasCoreRequiredFieldsError = new SimpleBooleanProperty();
    }

    private static class MXFFileListHolder {
        private static final MXFFileList INSTANCE = new MXFFileList();

        private MXFFileListHolder() {
        }
    }
}

