/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.dpx;

import com.portalmedia.embarc.gui.ValidationWarningHelper;
import com.portalmedia.embarc.gui.dpx.ControllerMediatorDPX;
import com.portalmedia.embarc.gui.model.DPXFileInformationViewModel;
import com.portalmedia.embarc.gui.model.DPXMetadataColumnViewModel;
import com.portalmedia.embarc.validation.IValidationRule;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class ValidationCellFactory
extends TableCell<DPXFileInformationViewModel, String> {
    private TableColumn<DPXFileInformationViewModel, String> columnData;

    public ValidationCellFactory(TableColumn<DPXFileInformationViewModel, String> column) {
        this.columnData = column;
    }

    protected void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        this.setStyle(null);
        if (empty || item == null) {
            this.setGraphic(null);
            this.setText(null);
        } else {
            DPXMetadataColumnViewModel mdvm = (DPXMetadataColumnViewModel)this.columnData.getUserData();
            if (mdvm != null) {
                HashMap<ValidationRuleSetEnum, List<IValidationRule>> ruleViolations;
                DPXFileInformationViewModel fivm;
                HashSet<ValidationRuleSetEnum> brokenRules = new HashSet<ValidationRuleSetEnum>();
                TableRow row = this.getTableRow();
                if (row != null && (fivm = (DPXFileInformationViewModel)row.getItem()) != null && (ruleViolations = fivm.getInvalidRuleSets(mdvm.getColumn())) != null) {
                    for (ValidationRuleSetEnum rule : ControllerMediatorDPX.getInstance().getCurrentRuleSets()) {
                        if (!ruleViolations.containsKey((Object)rule)) continue;
                        brokenRules.add(rule);
                    }
                }
                if (brokenRules.size() > 0) {
                    HBox icons = new HBox();
                    ValidationWarningHelper.getInvalidRuleSetsAndUpdateErrorIcons(icons, brokenRules, mdvm.getColumn());
                    VBox iconsBox = new VBox(new Node[]{icons});
                    iconsBox.setAlignment(Pos.CENTER_RIGHT);
                    Label valueLabel = new Label();
                    valueLabel.setText(item);
                    VBox valueLabelBox = new VBox(new Node[]{valueLabel});
                    valueLabelBox.setAlignment(Pos.CENTER_LEFT);
                    valueLabelBox.setFillWidth(true);
                    HBox box = new HBox(new Node[]{valueLabelBox, iconsBox});
                    HBox.setHgrow((Node)iconsBox, (Priority)Priority.SOMETIMES);
                    HBox.setHgrow((Node)valueLabelBox, (Priority)Priority.ALWAYS);
                    this.setText(null);
                    this.setGraphic((Node)box);
                } else {
                    this.setGraphic(null);
                    this.setText(item);
                }
            } else {
                this.setText(item);
                this.setGraphic(null);
            }
        }
    }
}

