/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.dpx;

import com.portalmedia.embarc.cli.CsvWriterDpx;
import com.portalmedia.embarc.gui.dpx.ControllerMediatorDPX;
import com.portalmedia.embarc.gui.helper.DPXFileListHelper;
import com.portalmedia.embarc.gui.model.DPXFileInformationViewModel;
import com.portalmedia.embarc.parser.dpx.DPXBatchProcessor;
import com.portalmedia.embarc.parser.dpx.DPXSequenceError;
import com.portalmedia.embarc.report.DPXReportService;
import com.portalmedia.embarc.report.DPXSequenceAnalysisReportCSVWriter;
import com.portalmedia.embarc.system.UserPreferencesService;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.layout.AnchorPane;
import javafx.stage.FileChooser;

public class MainViewController
implements Initializable {
    @FXML
    private AnchorPane mainViewPane;

    public void initialize(URL location, ResourceBundle resources) {
        ControllerMediatorDPX.getInstance().registerMainViewController(this);
    }

    public void createImageChecksumReport() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Select a file");
        UserPreferencesService userPreferences = new UserPreferencesService();
        String initialDirectory = userPreferences.getImageChecksumReportPath();
        if (initialDirectory != null && !initialDirectory.isEmpty()) {
            fileChooser.setInitialDirectory(new File(initialDirectory));
        }
        fileChooser.setInitialFileName("ImageDataChecksumReport_" + new SimpleDateFormat("yyyyMMddHHmm").format(new Date()) + ".csv");
        File file = fileChooser.showSaveDialog(this.mainViewPane.getScene().getWindow());
        try {
            if (file != null) {
                DPXReportService.WriteImageHashCsv(ControllerMediatorDPX.getInstance().getTable(), file.getAbsolutePath());
                userPreferences.setImageChecksumReportPath(file.getParent());
            }
        }
        catch (IOException e) {
            System.out.println("Error creating checksum report");
        }
    }

    public void createValidationReport() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Select a file");
        UserPreferencesService userPreferences = new UserPreferencesService();
        String initialDirectory = userPreferences.getValidationReportPath();
        if (initialDirectory != null && !initialDirectory.isEmpty()) {
            fileChooser.setInitialDirectory(new File(initialDirectory));
        }
        fileChooser.setInitialFileName("DPXValidationReport_" + new SimpleDateFormat("yyyyMMddHHmm").format(new Date()) + ".csv");
        File file = fileChooser.showSaveDialog(this.mainViewPane.getScene().getWindow());
        try {
            if (file != null) {
                DPXReportService.WriteValidationCsv(ControllerMediatorDPX.getInstance().getTable(), file.getAbsolutePath());
                userPreferences.setValidationReportPath(file.getParent());
            }
        }
        catch (IOException e) {
            System.out.println("Error creating validation report");
        }
    }

    public void createCSVMetadataExport() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Select a file");
        fileChooser.setInitialFileName("DPXMetadata_" + new SimpleDateFormat("yyyyMMddHHmm").format(new Date()) + ".csv");
        File file = fileChooser.showSaveDialog(this.mainViewPane.getScene().getWindow());
        try {
            if (file != null) {
                ObservableList allDPXFileInfoVMs = ControllerMediatorDPX.getInstance().getTable().getItems();
                CsvWriterDpx.writeCsvDPXFilesFromViewModel(file.getAbsolutePath(), (ObservableList<DPXFileInformationViewModel>)allDPXFileInfoVMs);
            }
        }
        catch (IOException e) {
            System.out.println("Error creating validation report");
        }
    }

    public void deleteSelectedFiles() {
        ObservableList<DPXFileInformationViewModel> toDelete = ControllerMediatorDPX.getInstance().getSelectedFileList();
        DPXFileListHelper.deleteSelectedRows(toDelete);
        LinkedList<DPXFileInformationViewModel> newList = new LinkedList<DPXFileInformationViewModel>();
        for (DPXFileInformationViewModel m : toDelete) {
            newList.add(m);
        }
        for (DPXFileInformationViewModel m : newList) {
            DPXFileListHelper.deleteFileFromDB(m.getId());
        }
    }

    public void createSequenceGapAnalysisReport(boolean verboseOutput) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Select a file");
        UserPreferencesService userPreferences = new UserPreferencesService();
        String initialDirectory = userPreferences.getImageChecksumReportPath();
        if (initialDirectory != null && !initialDirectory.isEmpty()) {
            fileChooser.setInitialDirectory(new File(initialDirectory));
        }
        String simpleOrVerbose = "Simple";
        if (verboseOutput) {
            simpleOrVerbose = "Verbose";
        }
        fileChooser.setInitialFileName("SequenceGapAnalysisReport" + simpleOrVerbose + "_" + new SimpleDateFormat("yyyyMMddHHmm").format(new Date()) + ".csv");
        File file = fileChooser.showSaveDialog(this.mainViewPane.getScene().getWindow());
        if (file != null) {
            List<DPXSequenceError> sequenceErrors = DPXBatchProcessor.getSequenceErrorList((ObservableList<DPXFileInformationViewModel>)ControllerMediatorDPX.getInstance().getTable().getItems(), verboseOutput);
            try {
                DPXSequenceAnalysisReportCSVWriter.writeSequenceAnalysisReportCSV(file.getAbsolutePath(), sequenceErrors);
            }
            catch (IOException e) {
                System.out.println("Error creating sequence gap analysis report");
            }
        }
    }
}

