/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.dpx;

import com.portalmedia.embarc.gui.Main;
import com.portalmedia.embarc.gui.dpx.CenterPaneController;
import com.portalmedia.embarc.gui.dpx.EditorForm;
import com.portalmedia.embarc.gui.dpx.IMediateControllers;
import com.portalmedia.embarc.gui.dpx.MainViewController;
import com.portalmedia.embarc.gui.dpx.MetadataEditorController;
import com.portalmedia.embarc.gui.dpx.WorkingSummaryController;
import com.portalmedia.embarc.gui.dpx.WriteFilesView;
import com.portalmedia.embarc.gui.model.DPXFileInformationViewModel;
import com.portalmedia.embarc.gui.model.SelectedFilesSummary;
import com.portalmedia.embarc.parser.SectionDef;
import com.portalmedia.embarc.parser.dpx.DPXColumn;
import com.portalmedia.embarc.system.UserPreferencesService;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.scene.control.TableView;

public class ControllerMediatorDPX
implements IMediateControllers {
    private MainViewController mainViewController;
    private CenterPaneController centerPaneController;
    private MetadataEditorController metadataEditorController;
    private WorkingSummaryController workingSummaryController;
    private EditorForm editorForm;
    private WriteFilesView writeFilesView;
    private HashSet<ValidationRuleSetEnum> validationRulesSelected;
    private final BooleanProperty isEditing = new SimpleBooleanProperty();

    public static ControllerMediatorDPX getInstance() {
        return ControllerMediatorHolder.INSTANCE;
    }

    private ControllerMediatorDPX() {
        this.initUserPreferences();
    }

    public void createImageChecksumReport() {
        this.mainViewController.createImageChecksumReport();
    }

    public void createSequenceGapAnalysisReport(boolean verboseOutput) {
        this.mainViewController.createSequenceGapAnalysisReport(verboseOutput);
    }

    public void createReport() {
        this.mainViewController.createValidationReport();
    }

    public void createCSVMetadataExport() {
        this.mainViewController.createCSVMetadataExport();
    }

    @Override
    public void deleteSelectedFiles() {
        this.centerPaneController.deleteSelectedFiles();
    }

    @Override
    public void deselectAllFiles() {
        this.centerPaneController.deselectAllFiles();
    }

    @Override
    public int getCurrentFileCount() {
        return this.centerPaneController.getTableSize();
    }

    public HashSet<ValidationRuleSetEnum> getCurrentRuleSets() {
        this.initUserPreferences();
        return this.validationRulesSelected;
    }

    public int getEditedFieldsCount() {
        return this.editorForm.getEditedFieldsCount();
    }

    public ObservableList<DPXFileInformationViewModel> getSelectedFileList() {
        return this.centerPaneController.getSelectedFiles();
    }

    public SelectedFilesSummary getSelectedFilesSummary() {
        return this.centerPaneController.getSelectedFilesSummary();
    }

    public TableView<DPXFileInformationViewModel> getTable() {
        return this.centerPaneController.getTable();
    }

    private void initUserPreferences() {
        UserPreferencesService userPreferences = new UserPreferencesService();
        if (this.validationRulesSelected == null) {
            this.validationRulesSelected = new HashSet();
            List<ValidationRuleSetEnum> selectedRules = userPreferences.getRuleSets();
            for (ValidationRuleSetEnum rule : selectedRules) {
                this.validationRulesSelected.add(rule);
            }
        }
    }

    public BooleanProperty isEditingProperty() {
        return this.isEditing;
    }

    public void notifyColumnsSet() {
    }

    @Override
    public void refetchFileList() {
        this.setFileList();
        this.centerPaneController.setSelectedRuleSets(this.getCurrentRuleSets());
        this.centerPaneController.setTabWarnings();
        this.centerPaneController.refreshEditor(true);
    }

    @Override
    public void registerCenterPaneController(CenterPaneController controller) {
        this.centerPaneController = controller;
    }

    @Override
    public void registerEditorForm(EditorForm controller) {
        this.editorForm = controller;
    }

    @Override
    public void registerMainViewController(MainViewController controller) {
        this.mainViewController = controller;
    }

    @Override
    public void registerMetadataEditorController(MetadataEditorController controller) {
        this.metadataEditorController = controller;
    }

    @Override
    public void registerWorkingSummaryController(WorkingSummaryController controller) {
        this.workingSummaryController = controller;
    }

    @Override
    public void registerWriteFilesView(WriteFilesView controller) {
        this.writeFilesView = controller;
    }

    public void resetEditor(SectionDef section) {
        this.metadataEditorController.resetEditControl(section);
    }

    public void resetValidationRuleIndicators() {
        this.writeFilesView.resetValidationRuleIndicators();
    }

    @Override
    public void selectAllFiles() {
        this.centerPaneController.selectAllFiles();
    }

    public void setEditedFieldsCount(int count) {
        if (this.editorForm != null) {
            this.editorForm.setEditedFieldsCount(count);
        }
    }

    public void setEditor(SectionDef section) {
        this.metadataEditorController.setEditControl(section);
    }

    @Override
    public void setFileList() {
        this.centerPaneController.setFiles();
        this.workingSummaryController.setFiles();
    }

    @Override
    public void setFiles() {
        this.workingSummaryController.setFiles();
    }

    public void setGeneralEditor() {
        this.metadataEditorController.setGeneralControl();
    }

    @Override
    public void setSelectedFileList(ObservableList<DPXFileInformationViewModel> list) {
        this.workingSummaryController.setSelectedFileList(list);
    }

    public void showColumnVisibilityDialogue() {
        this.centerPaneController.showColumnVisibilityDialogue();
    }

    public void refreshDataTemplateList() {
        System.out.println("TODO: Refresh data template list");
        Main.setMenuBarDPX(true);
    }

    public int toggleErrorsOnlyFilter(Boolean isChecked) {
        if (isChecked.booleanValue()) {
            int numWithViolations = this.centerPaneController.filterByViolations();
            return numWithViolations;
        }
        this.centerPaneController.clearFilterByViolations();
        return 0;
    }

    public void toggleRuleSet(ValidationRuleSetEnum ruleSet) {
        this.initUserPreferences();
        UserPreferencesService userPreferences = new UserPreferencesService();
        if (this.validationRulesSelected.contains((Object)ruleSet)) {
            this.validationRulesSelected.remove((Object)ruleSet);
            userPreferences.removeRuleSet(ruleSet);
        } else {
            this.validationRulesSelected.add(ruleSet);
            userPreferences.addRuleSet(ruleSet);
        }
        this.centerPaneController.setSelectedRuleSets(this.validationRulesSelected);
        this.centerPaneController.refreshValidation();
        this.metadataEditorController.refreshValidation();
        this.workingSummaryController.resetErrorCount();
    }

    public void updateChangedValues(HashMap<DPXColumn, String> changedValues) {
        this.centerPaneController.updateChangedValues(changedValues);
    }

    public void updateChangedValuesAllFiles(HashMap<DPXColumn, String> changedValues) {
        this.centerPaneController.updateChangedValuesAllFiles(changedValues);
    }

    private static class ControllerMediatorHolder {
        private static final ControllerMediatorDPX INSTANCE = new ControllerMediatorDPX();

        private ControllerMediatorHolder() {
        }
    }
}

