/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui;

import com.portalmedia.embarc.parser.ColumnDef;
import com.portalmedia.embarc.validation.DPXColumnValidationRules;
import com.portalmedia.embarc.validation.IValidationRule;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.fontawesome5.FontAwesomeSolid;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;

public class ValidationWarningIcons
extends AnchorPane {
    @FXML
    private HBox warningIcons;

    public ValidationWarningIcons() {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("ValidationWarningIcons.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setRoot((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setInvalidRuleSets(Set<ValidationRuleSetEnum> invalidRuleSet) {
        if (invalidRuleSet == null) {
            return;
        }
        for (ValidationRuleSetEnum rule : invalidRuleSet) {
            FontIcon icon;
            if (rule == ValidationRuleSetEnum.FADGI_O) {
                icon = new FontIcon((Ikon)MaterialDesign.MDI_ALERT_CIRCLE);
                icon.getStyleClass().add((Object)"fadgi-o-warning");
                icon.setIconSize(18);
                this.warningIcons.getChildren().add((Object)icon);
                continue;
            }
            if (rule == ValidationRuleSetEnum.FADGI_R) {
                icon = new FontIcon((Ikon)FontAwesomeSolid.EXCLAMATION_TRIANGLE);
                icon.getStyleClass().add((Object)"fadgi-r-warning");
                icon.setIconSize(16);
                this.warningIcons.getChildren().add((Object)icon);
                continue;
            }
            if (rule == ValidationRuleSetEnum.FADGI_SR) {
                icon = new FontIcon((Ikon)MaterialDesign.MDI_ALERT_OCTAGON);
                icon.getStyleClass().add((Object)"fadgi-sr-warning");
                icon.setIconSize(18);
                this.warningIcons.getChildren().add((Object)icon);
                continue;
            }
            if (rule != ValidationRuleSetEnum.SMPTE_C) continue;
            icon = new FontIcon((Ikon)MaterialDesign.MDI_ALERT_BOX);
            icon.getStyleClass().add((Object)"smpte-c-warning");
            icon.setIconSize(18);
            this.warningIcons.getChildren().add((Object)icon);
        }
    }

    public void setInvalidRuleSets(Set<ValidationRuleSetEnum> invalidRuleSet, ColumnDef fieldName) {
        HashMap<ValidationRuleSetEnum, List<IValidationRule>> validationRuleSet = DPXColumnValidationRules.getInstance().getRuleSet(fieldName);
        String ruleText = "No rule set";
        for (ValidationRuleSetEnum rule : invalidRuleSet) {
            Tooltip tt;
            Object icon;
            if (rule == ValidationRuleSetEnum.FADGI_O) {
                for (ValidationRuleSetEnum key : validationRuleSet.keySet()) {
                    if (key != rule) continue;
                    for (IValidationRule vRule : validationRuleSet.get((Object)key)) {
                        ruleText = vRule.getRule();
                    }
                }
                icon = new FontIcon((Ikon)MaterialDesign.MDI_ALERT_CIRCLE);
                icon.setAccessibleText(ruleText);
                icon.getStyleClass().add((Object)"fadgi-o-warning");
                tt = new Tooltip(ruleText);
                tt.setStyle("-fx-text-fill: white; -fx-font-size: 12px");
                Tooltip.install((Node)icon, (Tooltip)tt);
                this.warningIcons.getChildren().add(icon);
                continue;
            }
            if (rule == ValidationRuleSetEnum.FADGI_R) {
                for (ValidationRuleSetEnum key : validationRuleSet.keySet()) {
                    if (key != rule) continue;
                    for (IValidationRule vRule : validationRuleSet.get((Object)key)) {
                        ruleText = vRule.getRule();
                    }
                }
                icon = new FontIcon((Ikon)FontAwesomeSolid.EXCLAMATION_TRIANGLE);
                icon.setAccessibleText(ruleText);
                icon.getStyleClass().add((Object)"fadgi-r-warning");
                tt = new Tooltip(ruleText);
                tt.setStyle("-fx-text-fill: white;");
                Tooltip.install((Node)icon, (Tooltip)tt);
                this.warningIcons.getChildren().add(icon);
                continue;
            }
            if (rule == ValidationRuleSetEnum.FADGI_SR) {
                for (ValidationRuleSetEnum key : validationRuleSet.keySet()) {
                    if (key != rule) continue;
                    for (IValidationRule vRule : validationRuleSet.get((Object)key)) {
                        ruleText = vRule.getRule();
                    }
                }
                icon = new FontIcon((Ikon)MaterialDesign.MDI_ALERT_OCTAGON);
                icon.setAccessibleText(ruleText);
                icon.getStyleClass().add((Object)"fadgi-sr-warning");
                tt = new Tooltip(ruleText);
                tt.setStyle("-fx-text-fill: white;");
                Tooltip.install((Node)icon, (Tooltip)tt);
                this.warningIcons.getChildren().add(icon);
                continue;
            }
            if (rule != ValidationRuleSetEnum.SMPTE_C) continue;
            for (ValidationRuleSetEnum key : validationRuleSet.keySet()) {
                if (key != rule) continue;
                for (IValidationRule vRule : validationRuleSet.get((Object)key)) {
                    ruleText = vRule.getRule();
                }
            }
            icon = new FontIcon((Ikon)MaterialDesign.MDI_ALERT_BOX);
            icon.setAccessibleText(ruleText);
            icon.getStyleClass().add((Object)"smpte-c-warning");
            tt = new Tooltip(ruleText);
            tt.setStyle("-fx-text-fill: white;");
            Tooltip.install((Node)icon, (Tooltip)tt);
            this.warningIcons.getChildren().add(icon);
        }
    }
}

