/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.parser.mxf;

import com.portalmedia.embarc.gui.model.AS07TimecodeLabelSubdescriptor;
import com.portalmedia.embarc.gui.mxf.MXFPictureEncodingMap;
import com.portalmedia.embarc.gui.mxf.MXFSoundEncodingMap;
import com.portalmedia.embarc.parser.mxf.MXFFileDescriptorResult;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import tv.amwa.maj.model.AAFFileDescriptor;
import tv.amwa.maj.model.InterchangeObject;
import tv.amwa.maj.model.SubDescriptor;
import tv.amwa.maj.model.impl.AS07DateTimeDescriptorImpl;
import tv.amwa.maj.model.impl.AncillaryPacketsDescriptorImpl;
import tv.amwa.maj.model.impl.CDCIDescriptorImpl;
import tv.amwa.maj.model.impl.TimedTextDescriptorImpl;
import tv.amwa.maj.model.impl.WAVEPCMDescriptorImpl;
import tv.amwa.maj.record.Rational;

public class DescriptorHelper {
    public ArrayList<LinkedHashMap<String, String>> getPictureDescriptors(MXFFileDescriptorResult descriptors) {
        List<CDCIDescriptorImpl> cdciDescriptors = descriptors.getCDCIDescriptor();
        ArrayList<LinkedHashMap<String, String>> parsedDescriptors = new ArrayList<LinkedHashMap<String, String>>();
        if (cdciDescriptors.size() > 0) {
            for (CDCIDescriptorImpl cdci : cdciDescriptors) {
                parsedDescriptors.add(this.getCDCIProperties(cdci));
            }
        }
        return parsedDescriptors;
    }

    public ArrayList<LinkedHashMap<String, String>> getSoundDescriptors(MXFFileDescriptorResult descriptors) {
        List<WAVEPCMDescriptorImpl> wavePCMDescriptors = descriptors.getWavePCMDescriptors();
        ArrayList<LinkedHashMap<String, String>> parsedDescriptors = new ArrayList<LinkedHashMap<String, String>>();
        if (wavePCMDescriptors.size() > 0) {
            for (WAVEPCMDescriptorImpl wave : wavePCMDescriptors) {
                parsedDescriptors.add(this.getWaveProperties(wave));
            }
        }
        return parsedDescriptors;
    }

    public ArrayList<LinkedHashMap<String, String>> getOtherDescriptors(MXFFileDescriptorResult descriptors) {
        List<AncillaryPacketsDescriptorImpl> ancillaryDescriptors = descriptors.getAncillaryPacketsDescriptors();
        List<TimedTextDescriptorImpl> timedTextDescriptors = descriptors.getTimedTextDescriptor();
        List<AS07DateTimeDescriptorImpl> dateTimeDescriptors = descriptors.getAS07DateTimeDescriptor();
        ArrayList<LinkedHashMap<String, String>> parsedDescriptors = new ArrayList<LinkedHashMap<String, String>>();
        if (ancillaryDescriptors.size() > 0) {
            for (AncillaryPacketsDescriptorImpl ancillary : ancillaryDescriptors) {
                parsedDescriptors.add(this.getAncillaryProperties(ancillary));
            }
        }
        if (timedTextDescriptors.size() > 0) {
            for (TimedTextDescriptorImpl timedText : timedTextDescriptors) {
                parsedDescriptors.add(this.getTimedTextProperties(timedText));
            }
        }
        if (dateTimeDescriptors.size() > 0) {
            for (AS07DateTimeDescriptorImpl dateTime : dateTimeDescriptors) {
                parsedDescriptors.add(this.getDateTimeProperties(dateTime));
            }
        }
        return parsedDescriptors;
    }

    private LinkedHashMap<String, String> getCDCIProperties(CDCIDescriptorImpl cdci) {
        LinkedHashMap<String, String> cdciProps = new LinkedHashMap<String, String>();
        cdciProps.put("\nCDCI Descriptor", "");
        LinkedHashMap<String, String> fileDescriptors = this.getFileDescriptors((InterchangeObject)cdci, (AAFFileDescriptor)cdci);
        cdciProps.putAll(fileDescriptors);
        String signalStandard = "";
        Object pictureEncoding = "";
        Object storedHeight = "";
        Object storedWidth = "";
        Object sampledHeight = "";
        Object sampledWidth = "";
        Object sampledXOffset = "";
        Object sampledYOffset = "";
        Object displayHeight = "";
        Object displayWidth = "";
        Object displayXOffset = "";
        Object displayYOffset = "";
        Object frameLayout = "";
        String videoLineMap = "";
        Object imageAspectRatio = "";
        Object alphaTransparency = "";
        Object imageAlignmentOffset = "";
        Object imageStartOffset = "";
        Object imageEndOffset = "";
        Object fieldDominance = "";
        Object displayF2Offset = "";
        Object storedF2Offset = "";
        try {
            signalStandard = cdci.getSignalStandard().toString();
        }
        catch (Exception e) {
            signalStandard = "PROPERTY NOT PRESENT";
        }
        try {
            String picEncodingStr = cdci.getPictureCompression().toString();
            String stripped = picEncodingStr.replace("urn:smpte:ul:", "").toUpperCase();
            HashMap<String, String> picEncodingMap = new MXFPictureEncodingMap().getMap();
            String value = picEncodingMap.get(stripped);
            pictureEncoding = value == null || "".equals(value) ? picEncodingStr : value + " (" + stripped + ")";
        }
        catch (Exception e) {
            pictureEncoding = "PROPERTY NOT PRESENT";
        }
        try {
            storedHeight = "" + cdci.getStoredHeight();
        }
        catch (Exception e) {
            storedHeight = "PROPERTY NOT PRESENT";
        }
        try {
            storedWidth = "" + cdci.getStoredWidth();
        }
        catch (Exception e) {
            // empty catch block
        }
        storedWidth = "PROPERTY NOT PRESENT";
        try {
            sampledHeight = "" + cdci.getSampledHeight();
        }
        catch (Exception e) {
            sampledHeight = "PROPERTY NOT PRESENT";
        }
        try {
            sampledWidth = "" + cdci.getSampledWidth();
        }
        catch (Exception e) {
            sampledWidth = "PROPERTY NOT PRESENT";
        }
        try {
            sampledXOffset = "" + cdci.getSampledXOffset();
        }
        catch (Exception e) {
            sampledXOffset = "PROPERTY NOT PRESENT";
        }
        try {
            sampledYOffset = "" + cdci.getSampledYOffset();
        }
        catch (Exception e) {
            sampledYOffset = "PROPERTY NOT PRESENT";
        }
        try {
            displayHeight = "" + cdci.getDisplayHeight();
        }
        catch (Exception e) {
            displayHeight = "PROPERTY NOT PRESENT";
        }
        try {
            displayWidth = "" + cdci.getDisplayWidth();
        }
        catch (Exception e) {
            displayWidth = "PROPERTY NOT PRESENT";
        }
        try {
            displayXOffset = "" + cdci.getDisplayXOffset();
        }
        catch (Exception e) {
            displayXOffset = "PROPERTY NOT PRESENT";
        }
        try {
            displayYOffset = "" + cdci.getDisplayYOffset();
        }
        catch (Exception e) {
            displayYOffset = "PROPERTY NOT PRESENT";
        }
        try {
            frameLayout = String.valueOf(cdci.getFrameLayout());
        }
        catch (Exception e) {
            frameLayout = "PROPERTY NOT PRESENT";
        }
        try {
            Object vlm = "";
            int[] arr = cdci.getVideoLineMap();
            if (arr != null && arr.length > 0) {
                for (int i = 0; i < arr.length; ++i) {
                    vlm = (String)vlm + arr[i];
                    if (i >= arr.length - 1) continue;
                    vlm = (String)vlm + ", ";
                }
            }
            videoLineMap = vlm;
        }
        catch (Exception e) {
            videoLineMap = "PROPERTY NOT PRESENT";
        }
        try {
            imageAspectRatio = String.valueOf(cdci.getImageAspectRatio());
        }
        catch (Exception e) {
            imageAspectRatio = "PROPERTY NOT PRESENT";
        }
        try {
            alphaTransparency = String.valueOf(cdci.getAlphaTransparency());
        }
        catch (Exception e) {
            alphaTransparency = "PROPERTY NOT PRESENT";
        }
        try {
            imageAlignmentOffset = "" + cdci.getImageAlignmentFactor();
        }
        catch (Exception e) {
            imageAlignmentOffset = "PROPERTY NOT PRESENT";
        }
        try {
            imageStartOffset = "" + cdci.getImageStartOffset();
        }
        catch (Exception e) {
            imageStartOffset = "PROPERTY NOT PRESENT";
        }
        try {
            imageEndOffset = "" + cdci.getImageEndOffset();
        }
        catch (Exception e) {
            imageEndOffset = "PROPERTY NOT PRESENT";
        }
        try {
            fieldDominance = "" + cdci.getFieldDominance().value();
        }
        catch (Exception e) {
            fieldDominance = "PROPERTY NOT PRESENT";
        }
        try {
            displayF2Offset = "" + cdci.getDisplayF2Offset();
        }
        catch (Exception e) {
            displayF2Offset = "PROPERTY NOT PRESENT";
        }
        try {
            storedF2Offset = "" + cdci.getStoredF2Offset();
        }
        catch (Exception e) {
            storedF2Offset = "PROPERTY NOT PRESENT";
        }
        cdciProps.put("--- Picture Essence Descriptors ---", "");
        cdciProps.put("Signal Standard", signalStandard);
        cdciProps.put("Picture Encoding", (String)pictureEncoding);
        cdciProps.put("Stored Height", (String)storedHeight);
        cdciProps.put("Stored Width", (String)storedWidth);
        cdciProps.put("Sampled Height", (String)sampledHeight);
        cdciProps.put("Sampled Width", (String)sampledWidth);
        cdciProps.put("Sampled X Offset", (String)sampledXOffset);
        cdciProps.put("Sampled Y Offset", (String)sampledYOffset);
        cdciProps.put("Display Height", (String)displayHeight);
        cdciProps.put("Display Width", (String)displayWidth);
        cdciProps.put("Display X Offset", (String)displayXOffset);
        cdciProps.put("Display Y Offset", (String)displayYOffset);
        cdciProps.put("Frame Layout", (String)frameLayout);
        cdciProps.put("Video Line Map", videoLineMap);
        cdciProps.put("Image Aspect Ratio", (String)imageAspectRatio);
        cdciProps.put("Alpha Transparency", (String)alphaTransparency);
        cdciProps.put("Image Alignment Offset", (String)imageAlignmentOffset);
        cdciProps.put("Image Start Offset", (String)imageStartOffset);
        cdciProps.put("Image End Offset", (String)imageEndOffset);
        cdciProps.put("Field Dominance", (String)fieldDominance);
        cdciProps.put("Display F2 Offset", (String)displayF2Offset);
        cdciProps.put("Stored F2 Offset", (String)storedF2Offset);
        Object activeFormat = "";
        Object alphaSampleDepth = "";
        Object blackRefLevel = "";
        Object colorRange = "";
        Object colorSiting = "";
        Object componentDepth = "";
        Object horizontalSubsampling = "";
        Object paddingBits = "";
        Object reversedByteOrder = "";
        Object verticalSubsampling = "";
        Object whiteRefLevel = "";
        try {
            activeFormat = "" + cdci.getActiveFormatDescriptor();
        }
        catch (Exception ex) {
            activeFormat = "PROPERTY NOT PRESENT";
        }
        try {
            alphaSampleDepth = "" + cdci.getAlphaSampleDepth();
        }
        catch (Exception ex) {
            alphaSampleDepth = "PROPERTY NOT PRESENT";
        }
        try {
            blackRefLevel = "" + cdci.getBlackRefLevel();
        }
        catch (Exception ex) {
            blackRefLevel = "PROPERTY NOT PRESENT";
        }
        try {
            colorRange = "" + cdci.getColorRange();
        }
        catch (Exception ex) {
            colorRange = "PROPERTY NOT PRESENT";
        }
        try {
            colorSiting = String.valueOf(cdci.getColorSiting());
        }
        catch (Exception ex) {
            colorSiting = "PROPERTY NOT PRESENT";
        }
        try {
            componentDepth = "" + cdci.getComponentDepth();
        }
        catch (Exception ex) {
            componentDepth = "PROPERTY NOT PRESENT";
        }
        try {
            horizontalSubsampling = "" + cdci.getHorizontalSubsampling();
        }
        catch (Exception ex) {
            horizontalSubsampling = "PROPERTY NOT PRESENT";
        }
        try {
            paddingBits = "" + cdci.getPaddingBits();
        }
        catch (Exception ex) {
            paddingBits = "PROPERTY NOT PRESENT";
        }
        try {
            reversedByteOrder = "" + cdci.getReversedByteOrder();
        }
        catch (Exception ex) {
            reversedByteOrder = "PROPERTY NOT PRESENT";
        }
        try {
            verticalSubsampling = "" + cdci.getVerticalSubsampling();
        }
        catch (Exception ex) {
            verticalSubsampling = "PROPERTY NOT PRESENT";
        }
        try {
            whiteRefLevel = "" + cdci.getWhiteRefLevel();
        }
        catch (Exception ex) {
            whiteRefLevel = "PROPERTY NOT PRESENT";
        }
        cdciProps.put("--- CDCI Descriptors ---", "");
        cdciProps.put("Active Format", (String)activeFormat);
        cdciProps.put("Alpha Sample Depth", (String)alphaSampleDepth);
        cdciProps.put("Black Ref Level", (String)blackRefLevel);
        cdciProps.put("Color Range", (String)colorRange);
        cdciProps.put("Color Siting", (String)colorSiting);
        cdciProps.put("Component Depth", (String)componentDepth);
        cdciProps.put("Horizontal Subsampling", (String)horizontalSubsampling);
        cdciProps.put("Padding Bits", (String)paddingBits);
        cdciProps.put("Reversed Byte Order", (String)reversedByteOrder);
        cdciProps.put("Vertical Subsampling", (String)verticalSubsampling);
        cdciProps.put("White Reference Level", (String)whiteRefLevel);
        Object duration = "";
        Object samplesPerSecond = "";
        try {
            long el = cdci.getEssenceLength();
            Rational sr = cdci.getSampleRate();
            duration = "" + (double)el / sr.doubleValue();
        }
        catch (Exception ex) {
            duration = "N/A";
        }
        try {
            samplesPerSecond = "" + cdci.getSampleRate().doubleValue();
        }
        catch (Exception ex) {
            samplesPerSecond = "N/A";
        }
        cdciProps.put("--- Calculated Values ---", "");
        cdciProps.put("Duration", (String)duration);
        cdciProps.put("Samples Per Second", (String)samplesPerSecond);
        return cdciProps;
    }

    private LinkedHashMap<String, String> getWaveProperties(WAVEPCMDescriptorImpl wave) {
        LinkedHashMap<String, String> waveProps = new LinkedHashMap<String, String>();
        waveProps.put("\nWAVE Descriptor", "");
        LinkedHashMap<String, String> fileDescriptors = this.getFileDescriptors((InterchangeObject)wave, (AAFFileDescriptor)wave);
        waveProps.putAll(fileDescriptors);
        String audioSampleRate = "";
        Object channelCount = "";
        Object soundEncoding = "";
        Object bitDepth = "";
        Object locked = "";
        Object audioRefLevel = "";
        Object electroForm = "";
        Object dialNorm = "";
        try {
            audioSampleRate = wave.getAudioSampleRateString();
        }
        catch (Exception e) {
            audioSampleRate = "PROPERTY NOT PRESENT";
        }
        try {
            channelCount = "" + wave.getChannelCount();
        }
        catch (Exception e) {
            channelCount = "PROPERTY NOT PRESENT";
        }
        try {
            String soundEncodingStr = wave.getSoundCompression().toString();
            String stripped = soundEncodingStr.replace("urn:smpte:ul:", "").toUpperCase();
            HashMap<String, String> soundEncodingMap = new MXFSoundEncodingMap().getMap();
            String value = soundEncodingMap.get(stripped);
            soundEncoding = value == null || "".equals(value) ? soundEncodingStr : value + " (" + stripped + ")";
        }
        catch (Exception e) {
            soundEncoding = "PROPERTY NOT PRESENT";
        }
        try {
            bitDepth = "" + wave.getQuantizationBits();
        }
        catch (Exception e) {
            bitDepth = "PROPERTY NOT PRESENT";
        }
        try {
            locked = "" + wave.getLocked();
        }
        catch (Exception e) {
            locked = "PROPERTY NOT PRESENT";
        }
        try {
            audioRefLevel = "" + wave.getAudioReferenceLevel();
        }
        catch (Exception e) {
            audioRefLevel = "PROPERTY NOT PRESENT";
        }
        try {
            electroForm = String.valueOf(wave.getElectrospatialFormulation());
        }
        catch (Exception e) {
            electroForm = "PROPERTY NOT PRESENT";
        }
        try {
            dialNorm = "" + wave.getDialNorm();
        }
        catch (Exception e) {
            dialNorm = "PROPERTY NOT PRESENT";
        }
        waveProps.put("--- Sound Descriptors ---", "");
        waveProps.put("Audio Sample Rate", audioSampleRate);
        waveProps.put("Channel Count", (String)channelCount);
        waveProps.put("Sound Encoding", (String)soundEncoding);
        waveProps.put("Bit Depth", (String)bitDepth);
        waveProps.put("Locked", (String)locked);
        waveProps.put("Audio Reference Level", (String)audioRefLevel);
        waveProps.put("Electro-Spatial Formulation", (String)electroForm);
        waveProps.put("Dial Norm", (String)dialNorm);
        Object averageBytesPerSecond = "";
        Object blockAlign = "";
        try {
            averageBytesPerSecond = "" + wave.getAverageBytesPerSecond();
        }
        catch (Exception e) {
            averageBytesPerSecond = "PROPERTY NOT PRESENT";
        }
        try {
            blockAlign = "" + wave.getBlockAlign();
        }
        catch (Exception e) {
            blockAlign = "PROPERTY NOT PRESENT";
        }
        waveProps.put("--- WAVE Descriptors ---", "");
        waveProps.put("Average Bytes Per Second", (String)averageBytesPerSecond);
        waveProps.put("Block Align", (String)blockAlign);
        return waveProps;
    }

    private LinkedHashMap<String, String> getAncillaryProperties(AncillaryPacketsDescriptorImpl ancillary) {
        LinkedHashMap<String, String> ancillaryProps = new LinkedHashMap<String, String>();
        ancillaryProps.put("\nAncillary Descriptor", "");
        LinkedHashMap<String, String> fileDescriptors = this.getFileDescriptors((InterchangeObject)ancillary, (AAFFileDescriptor)ancillary);
        ancillaryProps.putAll(fileDescriptors);
        String dataEssenceCoding = "";
        ancillaryProps.put("--- Generic Data Essence Descriptor ---", "");
        ancillaryProps.put("Data Essence Coding", dataEssenceCoding);
        return ancillaryProps;
    }

    private LinkedHashMap<String, String> getTimedTextProperties(TimedTextDescriptorImpl timedText) {
        LinkedHashMap<String, String> timedTextProps = new LinkedHashMap<String, String>();
        timedTextProps.put("\nTimed Text Descriptor", "");
        LinkedHashMap<String, String> fileDescriptors = this.getFileDescriptors((InterchangeObject)timedText, (AAFFileDescriptor)timedText);
        timedTextProps.putAll(fileDescriptors);
        Object textEncodingFormat = "";
        Object namespaceUri = "";
        Object resourceId = "";
        try {
            textEncodingFormat = timedText.getUcsEncoding();
        }
        catch (Exception e) {
            textEncodingFormat = "PROPERTY NOT PRESENT";
        }
        try {
            namespaceUri = timedText.getNamespaceURI();
        }
        catch (Exception e) {
            namespaceUri = "PROPERTY NOT PRESENT";
        }
        try {
            resourceId = String.valueOf(timedText.getResourceId());
        }
        catch (Exception e) {
            resourceId = "PROPERTY NOT PRESENT";
        }
        timedTextProps.put("--- Timed Text Descriptors ---", "");
        timedTextProps.put("Text Encoding Format", (String)textEncodingFormat);
        timedTextProps.put("Namespace URI", (String)namespaceUri);
        timedTextProps.put("Resource ID", (String)resourceId);
        return timedTextProps;
    }

    private LinkedHashMap<String, String> getDateTimeProperties(AS07DateTimeDescriptorImpl dateTime) {
        LinkedHashMap<String, String> dateTimeProps = new LinkedHashMap<String, String>();
        dateTimeProps.put("\nAS07 DateTime Descriptor", "");
        LinkedHashMap<String, String> fileDescriptors = this.getFileDescriptors((InterchangeObject)dateTime, (AAFFileDescriptor)dateTime);
        dateTimeProps.putAll(fileDescriptors);
        Object dateTimeRate = "";
        Object dateTimeDropFrame = "";
        Object dateTimeEmbedded = "";
        Object dateTimeKind = "";
        try {
            dateTimeRate = String.valueOf(dateTime.getDateTimeRate());
        }
        catch (Exception e) {
            dateTimeRate = "PROPERTY NOT PRESENT";
        }
        try {
            dateTimeDropFrame = "" + dateTime.getDateTimeDropFrame();
        }
        catch (Exception e) {
            dateTimeDropFrame = "PROPERTY NOT PRESENT";
        }
        try {
            dateTimeEmbedded = "" + dateTime.getDateTimeEmbedded();
        }
        catch (Exception e) {
            dateTimeEmbedded = "PROPERTY NOT PRESENT";
        }
        try {
            dateTimeKind = String.valueOf(dateTime.getDateTimeKind());
        }
        catch (Exception e) {
            dateTimeKind = "PROPERTY NOT PRESENT";
        }
        dateTimeProps.put("--- DateTime Descriptors ---", "");
        dateTimeProps.put("DateTime Rate", (String)dateTimeRate);
        dateTimeProps.put("DateTime Drop Frame", (String)dateTimeDropFrame);
        dateTimeProps.put("DateTime Embedded", (String)dateTimeEmbedded);
        dateTimeProps.put("DateTime Kind", (String)dateTimeKind);
        for (SubDescriptor sub : dateTime.getSubDescriptors()) {
            AS07TimecodeLabelSubdescriptor parsedSub = this.parseDateTimeSubDescriptor(sub.toString());
            Object dateTimeSymbol = "";
            Object dateTimeEssenceTrackID = "";
            try {
                dateTimeSymbol = parsedSub.getDateTimeSymbol();
            }
            catch (Exception e) {
                dateTimeSymbol = "PROPERTY NOT PRESENT";
            }
            try {
                dateTimeEssenceTrackID = "" + dateTime.getDateTimeDropFrame();
            }
            catch (Exception e) {
                dateTimeEssenceTrackID = "PROPERTY NOT PRESENT";
            }
            dateTimeProps.put("--- DateTime Subdescriptor ---", "");
            dateTimeProps.put("DateTime Symbol", (String)dateTimeSymbol);
            dateTimeProps.put("DateTime Essence Track ID", (String)dateTimeEssenceTrackID);
        }
        return dateTimeProps;
    }

    private LinkedHashMap<String, String> getFileDescriptors(InterchangeObject interchangeObj, AAFFileDescriptor aafFileDescriptor) {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        Object instanceUID = "";
        Object generation = "";
        Object linkedTrackID = "";
        Object sampleRate = "";
        Object essenceLength = "";
        Object containerFormat = "";
        String locators = "";
        try {
            instanceUID = String.valueOf(interchangeObj.getOriginalAUID());
        }
        catch (Exception e) {
            instanceUID = "PROPERTY NOT PRESENT";
        }
        try {
            generation = String.valueOf(interchangeObj.getLinkedGenerationID());
        }
        catch (Exception e) {
            generation = "PROPERTY NOT PRESENT";
        }
        try {
            linkedTrackID = "" + aafFileDescriptor.getLinkedTrackID();
        }
        catch (Exception e) {
            linkedTrackID = "PROPERTY NOT PRESENT";
        }
        try {
            sampleRate = String.valueOf(aafFileDescriptor.getSampleRate());
        }
        catch (Exception e) {
            sampleRate = "PROPERTY NOT PRESENT";
        }
        try {
            essenceLength = "" + aafFileDescriptor.getEssenceLength();
        }
        catch (Exception e) {
            essenceLength = "PROPERTY NOT PRESENT";
        }
        try {
            containerFormat = aafFileDescriptor.getContainerFormat().getDescription();
        }
        catch (Exception e) {
            containerFormat = "PROPERTY NOT PRESENT";
        }
        try {
            Object locString = "";
            List locs = aafFileDescriptor.getLocators();
            if (locs.size() > 0) {
                for (int i = 0; i < locs.size(); ++i) {
                    locString = (String)locString + String.valueOf(locs.get(i));
                    if (i >= locs.size() - 1) continue;
                    locString = (String)locString + ", ";
                }
            }
            locators = locString;
        }
        catch (Exception e) {
            locators = "PROPERTY NOT PRESENT";
        }
        props.put("--- File Descriptors ---", "");
        props.put("Instance UID", (String)instanceUID);
        props.put("Generation UID", (String)generation);
        props.put("Linked Track ID", (String)linkedTrackID);
        props.put("Sample Rate", (String)sampleRate);
        props.put("Container Duration", (String)essenceLength);
        props.put("Codec", (String)containerFormat);
        props.put("Locators", locators);
        return props;
    }

    private AS07TimecodeLabelSubdescriptor parseDateTimeSubDescriptor(String sub) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AS07TimecodeLabelSubdescriptor.class});
            Unmarshaller u = jaxbContext.createUnmarshaller();
            String d = sub.replace("aaf:", "");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(new InputSource(new StringReader(d)));
            AS07TimecodeLabelSubdescriptor subdescriptor = (AS07TimecodeLabelSubdescriptor)u.unmarshal((Node)document);
            return subdescriptor;
        }
        catch (JAXBException e) {
            System.out.println("Error parsing date time subdescriptor");
        }
        catch (ParserConfigurationException e) {
            System.out.println("Error parsing date time subdescriptor");
        }
        catch (SAXException e) {
            System.out.println("Error parsing date time subdescriptor");
        }
        catch (IOException e) {
            System.out.println("Error parsing date time subdescriptor");
        }
        return null;
    }
}

