/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.mxf;

import com.portalmedia.embarc.gui.model.MXFFileInformationViewModel;
import com.portalmedia.embarc.gui.model.MXFSelectedFilesSummary;
import com.portalmedia.embarc.gui.mxf.CoreMXFController;
import com.portalmedia.embarc.gui.mxf.DescriptorMXFController;
import com.portalmedia.embarc.gui.mxf.EditAreaMXFController;
import com.portalmedia.embarc.gui.mxf.FileInfoController;
import com.portalmedia.embarc.gui.mxf.SessionSummaryController;
import com.portalmedia.embarc.gui.mxf.TDBDController;
import com.portalmedia.embarc.gui.mxf.TabAreaMXFController;
import com.portalmedia.embarc.gui.mxf.WriteMXFController;
import com.portalmedia.embarc.parser.MetadataColumnDef;
import com.portalmedia.embarc.parser.SectionDef;
import com.portalmedia.embarc.parser.mxf.MXFColumn;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;

public class ControllerMediatorMXF {
    private TabAreaMXFController tabAreaMXFController;
    private EditAreaMXFController editAreaMXFController;
    private SessionSummaryController sessionSummaryController;
    private CoreMXFController coreMXFController;
    private WriteMXFController writeMXFController;
    private DescriptorMXFController descriptorMXFController;
    private TDBDController tdbdController;
    private FileInfoController fileInfoController;
    private final BooleanProperty isEditing = new SimpleBooleanProperty();

    public static ControllerMediatorMXF getInstance() {
        return ControllerMediatorHolder.INSTANCE;
    }

    private ControllerMediatorMXF() {
    }

    public void registerTabAreaController(TabAreaMXFController controller) {
        this.tabAreaMXFController = controller;
    }

    public void registerEditAreaController(EditAreaMXFController controller) {
        this.editAreaMXFController = controller;
    }

    public void registerSessionSummaryController(SessionSummaryController controller) {
        this.sessionSummaryController = controller;
    }

    public void registerCoreMXFController(CoreMXFController controller) {
        this.coreMXFController = controller;
    }

    public void registerWriteMXFController(WriteMXFController controller) {
        this.writeMXFController = controller;
    }

    public void registerDescriptorMXFController(DescriptorMXFController controller) {
        this.descriptorMXFController = controller;
    }

    public void registerTDBDController(TDBDController controller) {
        this.tdbdController = controller;
    }

    public void registerFileInfoController(FileInfoController controller) {
        this.fileInfoController = controller;
    }

    public void setCore() {
        this.editAreaMXFController.setCoreControl();
    }

    public void setDescriptor() {
        this.editAreaMXFController.setDescriptorControl();
    }

    public void setWriter() {
        this.editAreaMXFController.setWriteControl();
    }

    public void setTDBD(SectionDef section) {
        this.editAreaMXFController.setTDBDControl(section);
    }

    public void setFileInfo() {
        this.editAreaMXFController.setFileInfoControl();
    }

    public void resetEditArea() {
        this.editAreaMXFController.resetEditArea();
    }

    public void setFileList() {
        this.tabAreaMXFController.setFiles();
        this.sessionSummaryController.setFiles();
    }

    public ObservableList<MXFFileInformationViewModel> getSelectedFileList() {
        return this.tabAreaMXFController.getSelectedFiles();
    }

    public void setSelectedFileList(MXFSelectedFilesSummary list) {
        this.sessionSummaryController.setSelectedFileList(list);
    }

    public BooleanProperty isEditingProperty() {
        return this.isEditing;
    }

    public void deleteSelectedFiles() {
        this.tabAreaMXFController.deleteSelectedFiles();
    }

    public void selectAllFiles() {
        this.tabAreaMXFController.selectAllFiles();
    }

    public void deselectAllFiles() {
        this.tabAreaMXFController.deselectAllFiles();
    }

    public MXFSelectedFilesSummary getSelectedFilesSummary() {
        return this.tabAreaMXFController.getSelectedFilesSummary();
    }

    public void updateChangedValues(HashMap<MXFColumn, MetadataColumnDef> changedValues) {
        this.tabAreaMXFController.updateChangedValues(changedValues);
    }

    private static class ControllerMediatorHolder {
        private static final ControllerMediatorMXF INSTANCE = new ControllerMediatorMXF();

        private ControllerMediatorHolder() {
        }
    }
}

