/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.model;

import com.portalmedia.embarc.gui.model.DPXFileInformationViewModel;
import com.portalmedia.embarc.parser.ColumnDef;
import com.portalmedia.embarc.parser.dpx.DPXColumn;
import com.portalmedia.embarc.validation.IValidationRule;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SelectedFilesSummary {
    private static SelectedFilesSummary summary;
    HashMap<DPXColumn, String> columnDisplayValues;
    HashMap<DPXColumn, HashMap<ValidationRuleSetEnum, List<IValidationRule>>> ruleViolations;
    HashSet<DPXColumn> possibleColumns = new HashSet();
    HashSet<String> possibleTextColumns = new HashSet();
    int fileCount = 0;
    HashSet<ValidationRuleSetEnum> validRuleSets;
    String fileName;
    String filePath;

    public SelectedFilesSummary() {
        this.columnDisplayValues = new HashMap();
        this.validRuleSets = new HashSet();
        this.ruleViolations = new HashMap();
        this.possibleTextColumns.add("fileName");
        this.possibleTextColumns.add("filePath");
        for (DPXColumn c : DPXColumn.values()) {
            this.possibleColumns.add(c);
        }
    }

    public static SelectedFilesSummary append(DPXFileInformationViewModel fivm) {
        summary.setFileCount(summary.getFileCount() + 1);
        summary.setFileName(fivm.getProp("name"));
        summary.setFilePath(fivm.getProp("path"));
        HashSet columnsLeft = (HashSet)summary.getPossibleColumnsLeft().clone();
        for (DPXColumn column : columnsLeft) {
            String value = fivm.getProp(column);
            if (value == null) {
                value = "";
            }
            summary.setDisplayValue(column, value);
            HashMap<ValidationRuleSetEnum, List<IValidationRule>> ruleViolations = fivm.getRuleViolations(column);
            if (ruleViolations == null) continue;
            for (ValidationRuleSetEnum ruleSet : ruleViolations.keySet()) {
                summary.addRuleViolation(column, ruleSet, ruleViolations.get((Object)ruleSet));
            }
        }
        return summary;
    }

    public static SelectedFilesSummary create(List<DPXFileInformationViewModel> files) {
        summary = new SelectedFilesSummary();
        summary.setFileCount(files.size());
        if (files == null || files.size() == 0) {
            return summary;
        }
        for (DPXFileInformationViewModel fivm : files) {
            summary.setFileName(fivm.getProp("name"));
            summary.setFilePath(fivm.getProp("path"));
            HashSet columnsLeft = (HashSet)summary.getPossibleColumnsLeft().clone();
            for (DPXColumn column : columnsLeft) {
                String value = fivm.getProp(column);
                if (value == null) {
                    value = "";
                }
                summary.setDisplayValue(column, value);
                HashMap<ValidationRuleSetEnum, List<IValidationRule>> ruleViolations = fivm.getRuleViolations(column);
                if (ruleViolations == null) continue;
                for (ValidationRuleSetEnum ruleSet : ruleViolations.keySet()) {
                    summary.addRuleViolation(column, ruleSet, ruleViolations.get((Object)ruleSet));
                }
            }
            if (summary.hasPossibleColumnsLeft()) continue;
            break;
        }
        System.currentTimeMillis();
        return summary;
    }

    public void addRuleViolation(DPXColumn column, ValidationRuleSetEnum ruleSet, List<IValidationRule> rules) {
        if (rules == null || rules.size() == 0) {
            return;
        }
        HashMap<ValidationRuleSetEnum, List<IValidationRule>> violations = !this.ruleViolations.containsKey(column) ? new HashMap<ValidationRuleSetEnum, List<IValidationRule>>() : this.ruleViolations.get(column);
        violations.put(ruleSet, rules);
        this.ruleViolations.put(column, violations);
    }

    public String getDisplayValues(ColumnDef column) {
        return this.columnDisplayValues.get(column);
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public HashSet<DPXColumn> getPossibleColumnsLeft() {
        return this.possibleColumns;
    }

    public Set<ValidationRuleSetEnum> getRuleSetViolations(ColumnDef column) {
        HashMap<ValidationRuleSetEnum, List<IValidationRule>> ruleSetViolations = this.ruleViolations.get(column);
        HashSet<ValidationRuleSetEnum> toReturn = new HashSet<ValidationRuleSetEnum>();
        if (ruleSetViolations == null) {
            return new HashSet<ValidationRuleSetEnum>();
        }
        for (ValidationRuleSetEnum selectedRule : this.validRuleSets) {
            if (!ruleSetViolations.containsKey((Object)selectedRule)) continue;
            toReturn.add(selectedRule);
        }
        return toReturn;
    }

    public boolean hasPossibleColumnsLeft() {
        return this.possibleColumns.size() > 0 || this.possibleTextColumns.size() > 0;
    }

    public void setDisplayValue(DPXColumn column, String value) {
        if (value == null) {
            value = "";
        }
        if (this.columnDisplayValues.containsKey(column) && !this.columnDisplayValues.get(column).equals(value)) {
            this.columnDisplayValues.put(column, "{multiple values}");
            this.possibleColumns.remove(column);
        } else {
            this.columnDisplayValues.put(column, value);
        }
    }

    public void setFileCount(int fileCount) {
        this.fileCount = fileCount;
    }

    public void setFileName(String fileName) {
        if (this.fileName == null || this.fileName.isEmpty() || this.fileName.equals(fileName)) {
            this.fileName = fileName;
        } else {
            this.fileName = "{multiple values}";
            this.possibleTextColumns.remove("fileName");
        }
    }

    public void setFilePath(String filePath) {
        if (this.filePath == null || this.filePath.isEmpty() || this.filePath.equals(filePath)) {
            this.filePath = filePath;
        } else {
            this.filePath = "{multiple values}";
            this.possibleTextColumns.remove("filePath");
        }
    }

    public void setValidRuleSets(HashSet<ValidationRuleSetEnum> selectedRuleSets) {
        this.validRuleSets = selectedRuleSets;
    }
}

