/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.validation;

import com.portalmedia.embarc.validation.IValidationRule;
import com.portalmedia.embarc.validation.ValidationRuleBase;
import org.dizitart.no2.Document;
import org.dizitart.no2.mapper.Mappable;
import org.dizitart.no2.mapper.NitriteMapper;

public class IsValidShortRangeRule
extends ValidationRuleBase
implements IValidationRule,
Mappable {
    private static final long serialVersionUID = 1L;
    String rule = "Generic Short Range Rule";
    short min;
    short max;

    public IsValidShortRangeRule(short min, short max) {
        this.min = min;
        this.max = max;
    }

    public short getMax() {
        return this.max;
    }

    public short getMin() {
        return this.min;
    }

    @Override
    public boolean isValid(String value) {
        try {
            short v = Short.parseShort(value);
            if (v >= this.min && v <= this.max) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void read(NitriteMapper mapper, Document document) {
        if (document != null) {
            this.setRule((String)document.get("rule"));
            this.setMin((Short)document.get("min"));
            this.setMax((Short)document.get("max"));
        }
    }

    public void setMax(short max) {
        this.max = max;
    }

    public void setMin(short min) {
        this.min = min;
    }

    @Override
    public Document write(NitriteMapper mapper) {
        Document document = new Document();
        document.put("rule", (Object)this.getRule());
        document.put("min", (Object)this.getMin());
        document.put("max", (Object)this.getMax());
        return document;
    }
}

