---
layout: post
title: Artifacts
---

# Common DV Artifacts

### Dropout

__What does it look like?__

Dropout appears as pixels of missing data in the image, which may be substituted with video information from nearby frames during playback.

<img alt="dropout example" src="{{ site.baseurl }}/images/dropOut.png">

__What is it?__

As with analog dropout, DV dropout in source signals results from a loss of information recorded or read from the tape by the VTR playback heads. It might be due to tape wrinkling, creasing or other tape damage, manufacturing defects, environmental dirt, or transport shock during recording. Severe and consistent dropout may indicate clogged heads in a playback machine or significant damage/deterioration to the source media.

__Can it be fixed?__

Maybe. If the tape is damaged and that video information is missing, then you cannot recover the image.
If it was an error on part of the deck, then you might be able to reduce the dropout by cleaning the deck and/or tape. This is a good way to determine if the dropout is the result of a headclog or damage to tape/deck

### Scratch

__What does it look like?__

<img alt="scratch example" src="{{ site.baseurl }}/images/dv-scratch.png">


A scratch can be identified by either opening the cassette door and checking for damage or by jagged vertical lines (similar to dropout) that travel fluidly along the playback image.

__What is it?__

As with analog tape scratches, DV scratches result from the tape being damaged by an outside source (either within the camcorder, deck, person or debris) causing a horizontal ridge along the tape, making it difficult for the deck to read and removing information from the tape. 

__Can it be fixed?__


No, the damage cannot be reversed.

### Record Head Clog

__What does it look like?__

<img alt="record head clog example" src="{{ site.baseurl }}/images/recordClog.png">

Some blocks of a previous recording will show up with the old footage, while other parts of the playback image will present the most recently recorded material.

__What is it?__


This is an error during original recording. The artifact may be the result of a clogged record head when taping over a recycled piece of tape. Even a small piece of debris might reduce head-to-tape contact during recording, causing signal dropout (if using virgin stock) or an artifact like the one shown here. If there is a previous program recorded, it will remain on the section of tape that passed through the transport during the occurrence of the head clog.

__Can it be fixed?__

There is no remedy for this artifact, as it is recorded into the original tape media.

### Playback Head Clog

__What does it look like?__

<img alt="playback head clog example" src="{{ site.baseurl }}/images/headClog.png">


Typically, a head clog will appear as wide alternating lines of frozen video or an alternating pattern of color indicating a loss of read/write capability at the video head. Two head clogs cause loss of picture altogether or a freeze-frame of the last decodable frame.

__What is it?__

MiniDV and DVCAM record ten bands of video per frame using two video heads (five per head). If dirt or debris clogs one of the heads, the signal cannot be read from tape in its entirety. If a head is damaged, this type of banding may occur with all record and playback functions of the failing VTR.

__Can it be fixed?__

You can fix a headclog by cleaning the deck you are using to transfer the tape manually or with a cleaning tape (depending on how you feel about that). If this doesn’t resolve the issue, your head may be damaged or the artifact might be missing information from the tape see [Record Head Clog](#record-head-clog)